/*
 * NodeIndexedFaceSet.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_INDEXEDFACESET_H
#define _NODE_INDEXEDFACESET_H

#ifndef _MESH_BASED_NODE_H
#include "MeshBasedNode.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#ifndef _MESH_H
#include "Mesh.h"
#endif
 
#include "SFMFTypes.h"

class ProtoIndexedFaceSet : public Proto {
public:
		    ProtoIndexedFaceSet(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex color;
    FieldIndex coord;
    FieldIndex normal;
    FieldIndex texCoord;
    FieldIndex ccw;
    FieldIndex colorIndex;
    FieldIndex colorPerVertex;
    FieldIndex convex;
    FieldIndex coordIndex;
    FieldIndex creaseAngle;
    FieldIndex normalIndex;
    FieldIndex normalPerVertex;
    FieldIndex solid;
    FieldIndex texCoordIndex;
};

class NodeIndexedFaceSet : public MeshBasedNode {
public:
		    NodeIndexedFaceSet(Scene *scene, Proto *proto);

protected:
    virtual	   ~NodeIndexedFaceSet();

public:
    virtual int	    getType() const { return NODE_INDEXED_FACE_SET; }
    virtual void    setField(int index, FieldValue *value);
    virtual Node   *copy() const { return new NodeIndexedFaceSet(*this); }
    virtual int	    getNodeClass() const { return GEOMETRY_NODE; }

    virtual bool    canConvertToIndexedFaceSet(void) { return false; }
    virtual void    flip(int index);

    MFVec3f        *getCoordinates();
    MFInt32        *getColorIndex();
    MFInt32        *getCoordIndex();
    MFInt32        *getNormalIndex();
    MFVec2f        *getTextureCoordinates();
    MFInt32        *getTexCoordIndex();       

    Node           *toIndexedLineSet(void);

    MFVec3f        *getSmoothNormals(void);
    MFInt32        *getSmoothNormalIndex(void);

    fieldMacros(SFNode, color, ProtoIndexedFaceSet)
    fieldMacros(SFNode, coord, ProtoIndexedFaceSet)
    fieldMacros(SFNode, normal, ProtoIndexedFaceSet)
    fieldMacros(SFNode, texCoord, ProtoIndexedFaceSet)
    fieldMacros(SFBool, ccw, ProtoIndexedFaceSet)
    fieldMacros(MFInt32, colorIndex, ProtoIndexedFaceSet)
    fieldMacros(SFBool, colorPerVertex, ProtoIndexedFaceSet)
    fieldMacros(SFBool, convex, ProtoIndexedFaceSet)
    fieldMacros(MFInt32, coordIndex, ProtoIndexedFaceSet)
    fieldMacros(SFFloat, creaseAngle, ProtoIndexedFaceSet)
    fieldMacros(MFInt32, normalIndex, ProtoIndexedFaceSet)
    fieldMacros(SFBool,  normalPerVertex, ProtoIndexedFaceSet)
    fieldMacros(SFBool,  solid, ProtoIndexedFaceSet)
    fieldMacros(MFInt32, texCoordIndex, ProtoIndexedFaceSet)

protected:
    void	    createMesh();
};

#endif // _NODE_INDEXEDFACESET_H
