/*
 * NodeMaterial.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeMaterial.h"
#include "Proto.h"
#include "FieldValue.h"
#include "ExposedField.h"
#include "SFFloat.h"
#include "SFColor.h"
#include "Field.h"
#include "ExposedField.h"
#include "Util.h"

ProtoMaterial::ProtoMaterial(Scene *scene)
  : Proto(scene, "Material")
{
    ambientIntensity.set(
          addExposedField(SFFLOAT, "ambientIntensity", new SFFloat(0.2f), 
    		          new SFFloat(0.0f), new SFFloat(1.0f)));

    ExposedField* diffuse = new ExposedField(SFCOLOR, "diffuseColor", 
                                             new SFColor(0.8f, 0.8f, 0.8f));
    diffuse->setFlags(EIF_RECOMMENDED);
    diffuseColor.set(addExposedField(diffuse));

    emissiveColor.set(
          addExposedField(SFCOLOR, "emissiveColor", 
                          new SFColor(0.0f, 0.0f, 0.0f)));
    shininess.set(
          addExposedField(SFFLOAT, "shininess", new SFFloat(0.2f),
		          new SFFloat(0.0f), new SFFloat(1.0f)));
    specularColor.set(
          addExposedField(SFCOLOR, "specularColor", 
                          new SFColor(0.0f, 0.0f, 0.0f)));

    ExposedField* trans = new ExposedField(SFFLOAT, "transparency", 
                                           new SFFloat(0.0f),
                                           new SFFloat(0.0f), 
                                           new SFFloat(1.0f));
    trans->setFlags(EIF_RECOMMENDED);
    transparency.set(addExposedField(trans));
}

Node *
ProtoMaterial::create(Scene *scene)
{ 
    return new NodeMaterial(scene, this);
}

NodeMaterial::NodeMaterial(Scene *scene, Proto *def)
  : Node(scene, def)
{
}


void NodeMaterial::bind()
{
    float ambientColor[4], dc[4], ec[4];

    for (int i = 0; i < 3; i++) {
	ec[i] = emissiveColor()->getValue()[i];
	dc[i] = diffuseColor()->getValue()[i];
	ambientColor[i] = diffuseColor()->getValue()[i] * 
                          ambientIntensity()->getValue();
    }
    ambientColor[3] = 1.0f;
    ec[3] = dc[3] = 1.0f - transparency()->getValue();

    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, ambientColor);
    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, dc);
    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, ec);
    glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 128.0f * 
                                                 shininess()->getValue());
    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specularColor()->getValue());

    if (transparency()->getValue() > 0.0f) {
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
    }
}

void NodeMaterial::unbind()
{
    float ambientColor[4];

    for (int i = 0; i < 3; i++) {
	ambientColor[i] = diffuseColor()->getValue()[i] * 
                          ambientIntensity()->getValue();
    }
    ambientColor[3] = 1.0f;

    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, ambientColor);
    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, diffuseColor()->getValue());
    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, emissiveColor()->getValue());
    glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess()->getValue());
    Util::myGlMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specularColor()->getValue());

    glDisable(GL_BLEND);
}

void
NodeMaterial::emissive2diffuse(void)
{
    diffuseColor(new SFColor(emissiveColor()->getValue(0),
                             emissiveColor()->getValue(1),
                             emissiveColor()->getValue(2)));
    emissiveColor(new SFColor(0, 0, 0));
}

void
NodeMaterial::diffuse2emissive(void)
{
    emissiveColor(new SFColor(diffuseColor()->getValue(0),
                              diffuseColor()->getValue(1),
                              diffuseColor()->getValue(2)));
}
