/*
 * Commandline.cpp 
 *
 * Copyright (C) 1999 Stephen F. White, 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include "config.h" 
#include "TheApp.h" 

#define errorprintf fprintf

bool parseCommandlineArgumentInputDevice(int & i,int argc, char** argv)
{
    bool found=true;
    if (0 == 1) {
#ifdef LINUX_JOYSTICK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-joystick")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new linux_joystick(argv[i]));
#endif
#ifdef WINDOWS_JOYSTICK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-joystick")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new windows_joystick(argv[i]));
#endif
#ifdef HAVE_SDL_JOYSTICK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-SDLjoystick")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new SDL_joystick(argv[i]));
#endif
#ifdef HAVE_LIBSBALL
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-spaceball")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new spaceball(argv[i]));
#endif
#ifdef HAVE_WINDOWS_SPACEBALL
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-spaceball")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new windowsspaceball(argv[i]));
#endif
#ifdef HAVE_WINDOWS_P5
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-p5")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new windowsp5(argv[i]));
#endif
#ifdef HAVE_XINPUT
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-xinput")==0) {
       if (i++>=argc) return found;
       TheApp->setInputDevice(new xinput(argv[i]));
    } else if (strcmp(argv[i],"-xinputlist")==0) {
       swListXinputDevice();
       exit(0);
#endif
#ifdef HAVE_AFLOCK
# define HAS_INPUT_DEVICE 1
    } else if (strcmp(argv[i],"-aflock")==0) {
       if (i++>=argc) return found;
       TheApp->setAflockDevice(new AflockDevice(argv[i]));
    // zillions of flock of birds parameter
    } else if (strcmp(argv[i],"-baud")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setBaud(argv[i]);

    } else if (strcmp(argv[i],"-sync")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setSync(argv[i]);

    } else if (strcmp(argv[i],"-block")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setBlock(argv[i]);

    } else if (strcmp(argv[i],"-numbirds")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setNumBrds(argv[i]);


    } else if (strcmp(argv[i],"-master")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setTransmit(argv[i]);

    } else if (strcmp(argv[i],"-hemisphere")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setHemi(argv[i]);

    } else if (strcmp(argv[i],"-filter")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setFilt(argv[i]);

    } else if (strcmp(argv[i],"-suddenchangelock")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setSuddenChangeLock(argv[i]);

    } else if (strcmp(argv[i],"-report")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setReport(argv[i]);
    } else if (strcmp(argv[i],"-calfile")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()!=0)
          TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1)->
                  setCalfile(argv[i]);

    } else if (strcmp(argv[i],"-wand")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()==0)
          errorprintf(stderr,"no -aflock option found\n"); 
       else
          TheApp->setInputDevice(new aflock(
                TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1),
                argv[i],false));

    } else if (strcmp(argv[i],"-tracker")==0) {

       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()==0)
          errorprintf(stderr,"no -aflock option found\n"); 
       else
          TheApp->setInputDevice(new aflock(
                TheApp->getAflockDevice(TheApp->getNumberAflockDevices()-1),
                argv[i],true));

    } else if (stringncmp(argv[i],"-headnavigation")==0) {
       if (TheApp->getNumberInputDevices()!=0)
          TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                                 setHeadNavigation();
    } else if (stringncmp(argv[i],"-ignoresize")==0) {
       if (i++>=argc) return found;
       if (TheApp->getNumberAflockDevices()==0)
          errorprintf(stderr,"no -aflock option found\n"); 
       else
          if (TheApp->getNumberInputDevices()!=0)
              ((aflock *)TheApp->getInputDevice(TheApp->
                   getNumberInputDevices()-1))->
                   setIgnoreSize(argv[i]);
#endif
#ifdef HAS_INPUT_DEVICE 
    } else if ((stringncmp(argv[i],"-x")==0) ||
               (stringncmp(argv[i],"-y")==0) ||
               (stringncmp(argv[i],"-z")==0) ||
               (stringncmp(argv[i],"-all")==0) ||
               (stringncmp(argv[i],"-none")==0)) {
           if (TheApp->getNumberInputDevices()!=0)
              TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                      SetAxisInformation(argv[i]);
    } else if (stringncmp(argv[i],"-axes")==0) {
           if (TheApp->getNumberInputDevices()!=0)
              TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                      SetNumberAxes(argv[i]);
    } else if (stringncmp(argv[i],"-sendalways")==0) {
           if (TheApp->getNumberInputDevices()!=0)
              TheApp->getInputDevice(TheApp->getNumberInputDevices()-1)->
                      SetSendAlways(true);
    } else if (stringncmp(argv[i],"-dontcarefocus")==0) {
           TheApp->setDontCareFocus();
#endif
#ifdef MACOSX
    } else if (stringncmp(argv[i],"-psn_")==0) {
           // parse special MacOSX commandline parameters
#endif
    } else
       found=false;
    return found;    
}

bool parseCommandlineArgument(int & i,int argc, char** argv)
{
    bool found = parseCommandlineArgumentStereoView(i, argc, argv);
    if (found)
       return true;
    else if (strcmp(argv[i],"-4kids")==0) {
       TheApp->set4Kids();
    } else if (strcmp(argv[i],"-proto")==0) {
       if (i++>=argc) return found;
       char *category = argv[i];
       if (i++>=argc) return found;          
       TheApp->addToProtoLibrary(category, argv[i]);
       TheApp->SavePreferences();
       exit(0);
    } else if (strcmp(argv[i],"-fieldofview")==0) {
       float fov;
       if (i++>=argc) return found;
       if (sscanf(argv[i],"%f",&fov)==1)
          TheApp->setFixFieldOfView(fov);
    } else if (stringncmp(argv[i],"-stereo")==0) {
       // parse special commandline parameters
    } else if (strcmp(argv[i],"--copyrightdetails")==0) {
       printf("License for most parts of this program:\n");
       printf("\n");
       printf("Copyright (C) 1999-2004 Stephen F. White and others\n");
       printf("\n");
       printf("This program is free software; you can redistribute it and/or modify\n");
       printf("it under the terms of the GNU General Public License as published by\n");
       printf("the Free Software Foundation; either version 2 of the License, or\n");
       printf("(at your option) any later version.\n");
       printf("\n");
       printf("This program is distributed in the hope that it will be useful,\n");
       printf("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
       printf("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
       printf("GNU General Public License for more details.\n");
       printf("\n");
       printf("You should have received a copy of the GNU General Public License\n");
       printf("along with this program (see the file \"COPYING\" for details); if \n");
       printf("not, write to the Free Software Foundation, Inc., 675 Mass Ave, \n");
       printf("Cambridge, MA 02139, USA.\n");

       printf("\n");
       printf("***********************************************************\n");
       printf("\n");

       printf("code of pngLoad.c based on a similar file in OpenVRML\n");
       printf("\n");
       printf("Copyright (C) 1998  Chris Morley\n");
       printf("\n");
       printf("This library is free software; you can redistribute it and/or\n");
       printf("modify it under the terms of the GNU Lesser General Public\n");
       printf("License as published by the Free Software Foundation; either\n");
       printf("version 2.1 of the License, or (at your option) any later version.\n");
       printf("\n");
       printf("This library is distributed in the hope that it will be useful,\n");
       printf("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
       printf("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n");
       printf("Lesser General Public License for more details.\n");
       printf("\n");
       printf("You should have received a copy of the GNU Lesser General Public\n");
       printf("License along with this library; if not, write to the Free Software\n");
       printf("Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n");

       printf("\n");
       printf("***********************************************************\n");
       printf("\n");

       printf("code of generateTextureCoordinates() in Mesh.cpp \n");
       printf("based on Polyrep.c of FreeWRL\n");
       printf("setColor(), drawQuad(), drawSky() and drawGround() in NodeBackground.cpp\n");
       printf("based on render_Background() in Bindable.c of FreeWRL\n");
       printf("\n");
       printf("Copyright (C) 1998 Tuomas J. Lukka\n");
       printf("Copyright (C) 2002 John Stewart, CRC Canada.\n");
       printf("DISTRIBUTED WITH NO WARRANTY, EXPRESS OR IMPLIED.\n");
       printf("See the GNU Library General Public License (file COPYING in the distribution)\n");
       printf("for conditions of use and redistribution.\n");

       printf("\n");
       printf("***********************************************************\n");
       printf("\n");

       printf("code of Aflock.h/cpp based on similar files in VR Juggler\n");
       printf("\n");
       printf("VR Juggler is (C) Copyright 1998, 1999, 2000 by Iowa State University\n");
       printf("\n");
       printf("Original Authors:\n");
       printf("  Allen Bierbaum, Christopher Just,\n");
       printf("  Patrick Hartling, Kevin Meinert,\n");
       printf("  Carolina Cruz-Neira, Albert Baker\n");
       printf("\n");
       printf("This library is free software; you can redistribute it and/or\n");
       printf("modify it under the terms of the GNU Library General Public\n");
       printf("License as published by the Free Software Foundation; either\n");
       printf("version 2 of the License, or (at your option) any later version.\n");
       printf("\n");
       printf("This library is distributed in the hope that it will be useful,\n");
       printf("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
       printf("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n");
       printf("Library General Public License for more details.\n");
       printf("\n");
       printf("You should have received a copy of the GNU Library General Public\n");
       printf("License along with this library; if not, write to the\n");
       printf("Free Software Foundation, Inc., 59 Temple Place - Suite 330,\n");
       printf("Boston, MA 02111-1307, USA.\n");

       printf("\n");
       printf("***********************************************************\n");
       printf("\n");

       printf("code of createMesh() in NodeExtrusion.cpp\n");
       printf("    based on ExtrusionNode.cpp of \"CyberX3D for C++\"\n");
       printf("code of VectorNormalize(), VectorGetDirection(), VectorGetCross() and\n");
       printf("    GetNormalFromVertices in NodeExtrusion.cpp based on \n");
       printf("    MathUtill.cpp of \"CyberX3D for C++\"\n");
       printf("\n");
       printf("  Copyright (C) 2002-2003 Satoshi Konno\n");
       printf("  All rights reserved.\n");
       printf("\n");
       printf("  Redistribution and use in source and binary forms, with or without \n");
       printf("  modification, are permitted provided that the following conditions are met:\n");
       printf("\n");
       printf("  1. Redistributions of source code must retain the above copyright notice, \n");
       printf("     this list of conditions and the following disclaimer. \n");
       printf("\n");
       printf("  2. Redistributions in binary form must reproduce the above copyright notice, \n");
       printf("     this list of conditions and the following disclaimer in the documentation \n");
       printf("     and/or other materials provided with the distribution. \n");
       printf("\n");
       printf("  3. The name of the author may not be used to endorse or promote products \n");
       printf("     derived from this software without specific prior written permission. \n");
       printf("\n");
       printf("  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED\n");
       printf("  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \n");
       printf("  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO \n");
       printf("  EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, \n");
       printf("  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n");
       printf("  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; \n");
       printf("  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \n");
       printf("  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR \n");
       printf("  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF \n");
       printf("  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
       printf("\n");
       printf("***********************************************************\n");
       printf("\n");
       printf("code of EulerAngle.cpp/EulerAngle.h\n");
       printf("http://www1.acm.org/pubs/tog/GraphicsGems/gemsiv/euler_angle/\n");
       printf("\n");
       printf("from http://www1.acm.org/pubs/tog/GraphicsGems/index.html\n");
       printf("\n");
       printf("This is the official on-line repository for the code from the \n");
       printf("Graphics Gems series of books (from Academic Press). This series\n");
       printf("focusses on short to medium length pieces of code which perform a \n");
       printf("wide variety of computer graphics related tasks. All code\n");
       printf("here can be used without restrictions. The code distributions here \n");
       printf("contain all known bug fixes and enhancements. We also\n");
       printf("provide errata listings for the text of each book. Please report any \n");
       printf("new errata or bugs to Eric Haines (erich@acm.org).\n");
       exit(0);
#ifdef WIN32
    } else if (stringncmp(argv[i],"-8bit")==0) {
       // parse special WIN32 commandline parameters
#endif
#ifdef MACOSX
    } else if (strcmp(argv[i],"-startX11aqua")==0) {
       // parse special MacOSX commandline parameters
    } else if (stringncmp(argv[i],"-psn_")==0) {
       // parse special MacOSX commandline parameters
#endif
    } else
       return parseCommandlineArgumentInputDevice(i, argc, argv);
    return true;    
}


