use strict;

my $html = <<'HTML_TEMPLATE';
 <HTML>
	<HEAD>
		<TITLE>
			When
		</TITLE>
		<LINK rel="stylesheet" href="../lightandmatter.css" type="text/css">
		<META NAME="description" content="When">
		<META NAME="keywords" content="calendar,software">
	</HEAD>
	<a name="top"></a>
	<BODY bgcolor="white">
	<img src="../banner.jpg" width="580" height="97"><br><!-- area1sales doesn't use this -->

	
	<table border=0 width="580" cellspacing="0" cellpadding="0">
	<!-- ==============Menu of main areas=============== -->
	<!-- ==============below the banner etc.=============== -->
    <tr><td>

		<!-- goes inside the table row -->
	

	<h1>When</h2>
<p>When is an extremely simple personal calendar program, aimed at the Unix
geek who wants something minimalistic. It can keep track of
things you need to do on particular dates. There are a lot of calendar
and "personal information manager" programs out there, so what reasons
are there to use When?</p>

<ul>
  <li> It's a very short and simple program, so you can easily tinker with it
    yourself.</li>
  <li> It doesn't depend on any libraries, so it's easy to install. You should
    be able to install it on any system where Perl is available, even if you
    don't have privileges for installing libraries.</li>
  <li> Its file format is a simple text file, which you can edit in your favorite
    editor.</li>
</ul>

  <p>Joe Barr has written <a href="http://enterprise.linux.com/article.pl?sid=06/03/27/2040218&tid=13&tid=89">a nice intro</a> to the program
    in his column at linux.com.</p>

	<p>
        The current version of When is VERSION.</p>

<h3>generic instructions for installing When</h3>
        <p>Source code: <a href="when.tar.gz">when.tar.gz</a></p>

<p>No libraries are required. Download the source code, and then do this:
<pre>
  tar -zxvf when.tar.gz
  cd when_dist
  make install
</pre>
The program's man page is reproduced on this web page.
        </p> 
        <h3>Ubuntu</h3>
        <p> You can install the program simply by doing an "apt-get install when". </p>
        <h3>generic Debian</h3>
        <p>Here are the Debian <a href="when_VERSION-1_all.deb">package</a> and
           <a href="when_VERSION-debian-source.tar.gz">source package</a>.</p>
        <h3>Gentoo package</h3>
          <p> <a href="http://packages.gentoo.org/packages/?category=app-misc;name=when">app-misc/when</a></p>
        <h3>FreeBSD port</h3>
        <p><a href="http://www.freshports.org/deskutils/when/">deskutils/when</a></p>
        <h3>Red Hat</h3>
        <p>I've tested the script on Fedora Core 3, and it works fine. However, I've had reports from users running Red Hat 9.0
            that it doesn't work on their systems,  giving the message "Syntax error in calendar." This appears to be a problem
            with the way Red Hat 9.0 and Perl 5.8.0 interact with respect to UTF8 and internationalization, and can probably be solved by
            upgrading to a more recent version of Perl.</p>

<h2>how to help</h2>
<p>
Any of the following contributions would be gratefully accepted:
<ul>
<li> Translate When into more languages.
<li> Test my suggested workaround (upgrading Perl) for the problem with Red Hat 9.0.
<li> Write external programs to convert to and from iCalendar and vCalendar formats.
</ul>
</p>
	</td></tr>
</table>

<h2>man page</h2>
<pre>
MANPAGE
</pre>
	
		<!-- ==============Footer=============== -->

	<table border=0 width="580" cellspacing="0" cellpadding="0" bgcolor="#eeeeee">
	<tr><td colspan="4">
	<hr>
	<center>[<a href="../index.html">Home</a>
				| <a href="../index.html#outline">Site Map</a>
				| <a href="../area4privacy.html">Privacy</a>
				| <a href="../area4author.html">Contact</a> ]</center>
	<p>
	<font face="Times New Roman,Times" color="gray" size="2">
	(c) Copyright 2003 Benjamin Crowell. All rights reserved.</font>
	</td>
	</tr>


	</table>
	</align>
	</BODY>
 </HTML>

HTML_TEMPLATE

my $man = `nroff -man when.1`;
$man =~ s/(.)\x{08}./$1/g;
$man =~ s/[^ \w,.\-:;'"()[]{}<>+=|\\`~!?\/@#$%^&*_]//g;

my $version = `perl when --bare_version`;
$version =~ m/((\d+\.)+\d+)/;
$version = $1;
# ... same logic as in Makefile

$html =~ s/VERSION/$version/g;
$html =~ s/MANPAGE/$man/g;

print $html;
