/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_PORT_RANGE_H
#define _WF_PORT_RANGE_H

#include "wfport_base.h"
#include "wfport.h"

/**
 * port_range
 */
class wf_port_range : public wf_port_base {
 public:
  wf_port_range();
  wf_port_range(uint16_t min_port, uint16_t max_port);
  wf_port_range(const wf_port& min_port, const wf_port& max_port);
  virtual ~wf_port_range() {}
  // wf_port_range(const wf_port_range&) {} implicit copy constructor
  virtual wf_port_base* VClone() const;

  bool set(uint16_t min_port, uint16_t max_port);
  bool set(const wf_port& min_port, const wf_port& max_port);
  uint16_t min_port_get() const;
  uint16_t max_port_get() const;

  string tostr() const;
  bool belong(uint16_t port) const;
  bool belong(const wf_port& port) const;
  
  virtual enum metaport_elem_type gettype() const { return WF_METAPORT_PORT_RANGE; }
  virtual ostream& print(ostream& os) const;
  virtual ostream& output_xml(ostream& os, unsigned int indent_level = 0) const;

  friend ostream& operator<<(ostream& os, const wf_port_range& port);

 private:
  wf_port _min_port;
  wf_port _max_port;
};

inline wf_port_base*
wf_port_range::VClone() const {
  return new wf_port_range(*this);
}

#endif
