#include <stdlib.h>
#include <stdint.h>
#include "wayland-util.h"

extern const struct wl_interface text_model_interface;
extern const struct wl_interface wl_surface_interface;

static const struct wl_interface *types[] = {
	NULL,
	NULL,
	NULL,
	NULL,
	&text_model_interface,
	&wl_surface_interface,
};

static const struct wl_message text_model_requests[] = {
	{ "set_surrounding_text", "s", types + 0 },
	{ "set_cursor_index", "u", types + 0 },
	{ "activate", "", types + 0 },
	{ "deactivate", "", types + 0 },
	{ "set_selected_text", "si", types + 0 },
	{ "set_micro_focus", "iiii", types + 0 },
	{ "set_preedit", "", types + 0 },
	{ "set_content_type", "", types + 0 },
};

static const struct wl_message text_model_events[] = {
	{ "commit_string", "su", types + 0 },
	{ "preedit_string", "su", types + 0 },
	{ "preedit_styling", "", types + 0 },
	{ "key", "", types + 0 },
	{ "selection_replacement", "", types + 0 },
	{ "direction", "", types + 0 },
	{ "locale", "", types + 0 },
};

WL_EXPORT const struct wl_interface text_model_interface = {
	"text_model", 1,
	ARRAY_LENGTH(text_model_requests), text_model_requests,
	ARRAY_LENGTH(text_model_events), text_model_events,
};

static const struct wl_message text_model_manager_requests[] = {
	{ "create_text_model", "no", types + 4 },
};

WL_EXPORT const struct wl_interface text_model_manager_interface = {
	"text_model_manager", 1,
	ARRAY_LENGTH(text_model_manager_requests), text_model_manager_requests,
	0, NULL,
};

static const struct wl_message input_method_requests[] = {
	{ "commit_string", "su", types + 0 },
};

WL_EXPORT const struct wl_interface input_method_interface = {
	"input_method", 1,
	ARRAY_LENGTH(input_method_requests), input_method_requests,
	0, NULL,
};

