/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "statusbar.h"

#include "iconloader.h"

#include <QLabel>

using namespace WebIssues;

StatusBar::StatusBar( QWidget* parent ) : QStatusBar( parent ),
    m_summaryPixmap( NULL ),
    m_summaryLabel( NULL )
{
    setStyleSheet( "QStatusBar::item { border-style: none }" );

    m_pixmap = new QLabel( this );
    m_label = new QLabel( this );
    m_summaryPixmap = new QLabel( this );
    m_summaryLabel = new QLabel( this );

    m_pixmap->setFixedSize( 16, 16 );
    m_summaryPixmap->setFixedSize( 16, 16 );

    m_label->setSizePolicy( QSizePolicy::Ignored, QSizePolicy::Preferred );

    addWidget( m_pixmap, 0 );
    addWidget( m_label, 1 );
    addWidget( m_summaryPixmap, 0 );
    addWidget( m_summaryLabel, 0 );
}

StatusBar::~StatusBar()
{
}

void StatusBar::showInfo( const QString& text )
{
    m_pixmap->setPixmap( IconLoader::pixmap( "status-info" ) );
    m_label->setText( text );
}

void StatusBar::showWarning( const QString& text )
{
    m_pixmap->setPixmap( IconLoader::pixmap( "status-warning" ) );
    m_label->setText( text );
}

void StatusBar::showBusy( const QString& text )
{
    m_pixmap->setPixmap( IconLoader::pixmap( "status-busy" ) );
    m_label->setText( text );
}

void StatusBar::showSummary( const QPixmap& pixmap, const QString& text )
{
    if ( !pixmap.isNull() ) {
        m_summaryPixmap->setPixmap( pixmap );
        m_summaryPixmap->show();
    } else {
        m_summaryPixmap->hide();
    }

    if ( !text.isEmpty() ) {
        m_summaryLabel->setText( text );
        m_summaryLabel->show();
    } else {
        m_summaryLabel->hide();
    }
}

#include "statusbar.moc"
