/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "htmlhistorywriter.h"

#include <QTextBrowser>

#include "linklocator.h"

using namespace WebIssues;

HTMLHistoryWriter::HTMLHistoryWriter( QTextBrowser* browser ) :
    m_browser( browser )
{
}

HTMLHistoryWriter::~HTMLHistoryWriter()
{
}

void HTMLHistoryWriter::begin()
{
    m_html += "<html><body><table width=\"100%\" cellpadding=\"3\" cellspacing=\"5\">";
}

void HTMLHistoryWriter::end()
{
    m_html += "</table></body></html>";

    m_browser->setHtml( m_html );
}

void HTMLHistoryWriter::writeChanges( const QString& header, const QStringList& items )
{
    QString block;
    block += "<tr><td bgcolor=\"#ccccff\">";
    block += header;
    block += "</td></tr><tr><td><ul><li>";
    block += items.join( "</li><li>" );
    block += "</li></ul></td></tr>";

    m_html += block;
}

void HTMLHistoryWriter::writeComment( const QString& header, const QString& text, int commentId )
{
    QString block;
    block += QString( "<a name=\"id%1\"></a>" ).arg( commentId );
    block += "<tr><td bgcolor=\"#ffff88\">";
    block += header;
    block += "</td></tr><tr><td><pre style=\"white-space: pre-wrap\">";
    block += LinkLocator::convertToHtml( text, 0 );
    block += "</pre></td></tr>";

    m_html += block;
}

void HTMLHistoryWriter::writeAttachment( const QString& header, const QString& item, int attachmentId )
{
    QString block;
    block += QString( "<a name=\"id%1\"></a>" ).arg( attachmentId );
    block += "<tr><td bgcolor=\"#99ff99\">";
    block += header;
    block += "</td></tr><tr><td><ul><li>";
    block += item;
    block += "</li></ul></td></tr>";

    m_html += block ;
}

QString HTMLHistoryWriter::attachment( int attachmentId, const QString& name )
{
    return QString( "<a href=\"attachment://%1\">" ).arg( attachmentId ) + LinkLocator::escape( name ) + "</a>";
}

QString HTMLHistoryWriter::name( const QString& text )
{
    return "<strong>" + LinkLocator::escape( text ) + "</strong>";
}

QString HTMLHistoryWriter::date( const QString& text )
{
    return "<strong>" + text + "</strong>";
}

QString HTMLHistoryWriter::value( const QString& text )
{
    return LinkLocator::convertToHtml( text, 0 );
}

QString HTMLHistoryWriter::description( const QString& text )
{
    return LinkLocator::convertToHtml( text, 0 );
}
