/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import us.k5n.webcalendar.EventDisplayer;
import us.k5n.webcalendar.EventList;
import us.k5n.webcalendar.EventLoader;
import us.k5n.webcalendar.MessageDisplayer;
import us.k5n.webcalendar.Reminder;
import us.k5n.webcalendar.ReminderDisplayer;
import us.k5n.webcalendar.ReminderLoader;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarClient;

public class SampleApp
implements MessageDisplayer,
EventDisplayer,
ActionListener {
    String appName = "WebCalendar Client";
    EventLoader eloader = null;
    EventList events = null;
    JFrame startupStatusFrame = null;
    JFrame toplevel = null;
    JTextArea workArea = null;
    JLabel dateRange = null;
    JLabel statusMessage = null;
    Calendar startDate = null;
    Calendar endDate = null;

    public void showReminder(Reminder reminder) {
        JOptionPane.showMessageDialog(null, reminder.toString());
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(null, string);
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(null, string, this.appName + " Error", 2);
    }

    public void storeEvents(EventList eventList) {
        this.events = eventList;
        if (this.startupStatusFrame != null) {
            this.startupStatusFrame.dispose();
            this.startupStatusFrame = null;
        }
        if (this.toplevel == null) {
            this.createWindow();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < eventList.size(); ++i) {
            stringBuffer.append(eventList.eventAt(i).toString() + "\n");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("No events");
        }
        this.workArea.setText(stringBuffer.toString());
        this.dateRange.setText("Date range: " + (this.startDate.get(2) + 1) + '/' + this.startDate.get(5) + '/' + this.startDate.get(1) + " - " + (this.endDate.get(2) + 1) + '/' + this.endDate.get(5) + '/' + this.endDate.get(1));
    }

    public void createWindow() {
        this.toplevel = new JFrame(this.appName);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        this.toplevel.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open WebCalendar URL...");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("not yet implemented");
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Go to");
        jMenu.setMnemonic(71);
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Today");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Next Day");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Previous Day");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("This Week");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Next Week");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Previous Week");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.dateRange = new JLabel();
        jPanel.add((Component)this.dateRange, "North");
        this.statusMessage = new JLabel("Welcome to " + this.appName);
        jPanel.add((Component)this.statusMessage, "South");
        this.workArea = new JTextArea(20, 50);
        this.workArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.workArea);
        jPanel.add((Component)jScrollPane, "Center");
        Container container = this.toplevel.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        container.add(jPanel);
        this.toplevel.setDefaultCloseOperation(3);
        this.toplevel.pack();
        this.toplevel.setVisible(true);
    }

    private void reloadEvents() {
        this.eloader.setStartDate(this.startDate);
        this.eloader.setEndDate(this.endDate);
        this.eloader.interrupt();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Exit".equals(actionEvent.getActionCommand())) {
            System.exit(0);
        } else if ("Today".equals(actionEvent.getActionCommand())) {
            this.startDate = Calendar.getInstance();
            this.endDate = Calendar.getInstance();
            this.reloadEvents();
        } else if ("Next Day".equals(actionEvent.getActionCommand())) {
            this.startDate.add(5, 1);
            this.endDate = (Calendar)this.startDate.clone();
            this.reloadEvents();
        } else if ("Previous Day".equals(actionEvent.getActionCommand())) {
            this.startDate.add(5, -1);
            this.endDate = (Calendar)this.startDate.clone();
            this.reloadEvents();
        } else if ("This Week".equals(actionEvent.getActionCommand())) {
            this.startDate = Calendar.getInstance();
            this.startDate = Utils.startOfWeek(this.startDate, false);
            this.endDate = Utils.endOfWeek(this.startDate, false);
            this.reloadEvents();
        } else if ("Next Week".equals(actionEvent.getActionCommand())) {
            this.startDate.add(5, 7);
            this.startDate = Utils.startOfWeek(this.startDate, false);
            this.endDate = Utils.endOfWeek(this.startDate, false);
            this.reloadEvents();
        } else if ("Previous Week".equals(actionEvent.getActionCommand())) {
            this.startDate.add(5, -7);
            this.startDate = Utils.startOfWeek(this.startDate, false);
            this.endDate = Utils.endOfWeek(this.startDate, false);
            this.reloadEvents();
        } else {
            System.out.println("action command: " + actionEvent.getActionCommand());
            System.out.println("paramString: " + actionEvent.paramString());
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        Object var2_2 = null;
        Object var3_3 = null;
        int n = 15;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        WebCalendarClient webCalendarClient = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-url=")) {
                string = stringArray[i].substring(5);
                continue;
            }
            if (stringArray[i].startsWith("-user=")) {
                string2 = stringArray[i].substring(6);
                continue;
            }
            if (stringArray[i].startsWith("-username=")) {
                string2 = stringArray[i].substring(10);
                continue;
            }
            if (stringArray[i].startsWith("-password=")) {
                string3 = stringArray[i].substring(10);
                continue;
            }
            if (stringArray[i].startsWith("-passwd=")) {
                string3 = stringArray[i].substring(8);
                continue;
            }
            if (stringArray[i].startsWith("-httpuser=")) {
                string4 = stringArray[i].substring(10);
                continue;
            }
            if (stringArray[i].startsWith("-httpusername=")) {
                string4 = stringArray[i].substring(14);
                continue;
            }
            if (stringArray[i].startsWith("-httppasswd=")) {
                string5 = stringArray[i].substring(12);
                continue;
            }
            if (stringArray[i].startsWith("-httppassword=")) {
                string5 = stringArray[i].substring(14);
                continue;
            }
            System.err.println("Invalid argument '" + stringArray[i] + "'");
            System.err.println("Usage: java SampleApp [options]");
            System.err.println("  options:");
            System.err.println("    -username=XXX");
            System.err.println("    -passwd=XXX");
            System.err.println("    -httpusername=XXX");
            System.err.println("    -httppasswd=XXX");
            System.exit(1);
        }
        if (string == null) {
            System.err.println("No URL specified.");
            System.exit(1);
        }
        if (!string.endsWith("/")) {
            System.err.println("Invalid WebCalendar URL.");
            System.err.println("Should be base URL (ends with '/')");
            System.exit(1);
        }
        try {
            object = new URL(string);
            webCalendarClient = new WebCalendarClient((URL)object);
        }
        catch (Exception exception) {
            System.err.println("Invalid URL: " + string);
            System.exit(1);
        }
        object = new SampleApp();
        webCalendarClient.setMessageDisplayer((MessageDisplayer)object);
        ((SampleApp)object).startupStatusFrame = new JFrame(((SampleApp)object).appName);
        JLabel jLabel = new JLabel("Connecting to WebCalendar server...");
        ((SampleApp)object).startupStatusFrame.getContentPane().add(jLabel);
        ((SampleApp)object).startupStatusFrame.setDefaultCloseOperation(3);
        ((SampleApp)object).startupStatusFrame.pack();
        ((SampleApp)object).startupStatusFrame.setLocation(300, 300);
        ((SampleApp)object).startupStatusFrame.setVisible(true);
        ((SampleApp)object).startupStatusFrame.toFront();
        if (string4 != null) {
            webCalendarClient.setHttpAuthentication(string4, string5);
        }
        if (string2 != null) {
            webCalendarClient.setWebAuthentication(string2, string3);
            try {
                jLabel.setText("Logging in to server...");
                if (!webCalendarClient.login()) {
                    System.err.println("Invalid WebCalendar login '" + string2 + "'");
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                System.err.println("Error on WebCalendar login: " + exception.toString());
                System.exit(1);
            }
        }
        ReminderDisplayer reminderDisplayer = new ReminderDisplayer(webCalendarClient);
        ReminderLoader reminderLoader = new ReminderLoader(webCalendarClient, reminderDisplayer, n);
        reminderLoader.start();
        jLabel.setText("Loading events...");
        ((SampleApp)object).eloader = new EventLoader(webCalendarClient, (EventDisplayer)object);
        Calendar calendar = Calendar.getInstance();
        ((SampleApp)object).startDate = Utils.startOfWeek(calendar, true);
        ((SampleApp)object).eloader.setStartDate(((SampleApp)object).startDate);
        ((SampleApp)object).endDate = Utils.endOfWeek(calendar, true);
        ((SampleApp)object).eloader.setEndDate(((SampleApp)object).endDate);
        ((SampleApp)object).eloader.start();
    }
}

