/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;
import us.k5n.webcalendar.Event;
import us.k5n.webcalendar.MessageDisplayer;
import us.k5n.webcalendar.Participant;
import us.k5n.webcalendar.Reminder;
import us.k5n.webcalendar.User;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarClientListener;
import us.k5n.webcalendar.WebCalendarErrorException;
import us.k5n.webcalendar.WebCalendarParseException;

public class WebCalendarClient
implements MessageDisplayer {
    private URL url;
    private String httpUsername = null;
    private String httpPassword = null;
    private String webcalUsername = null;
    private String webcalPassword = null;
    private static final String GET_REMINDERS = "get_reminders.php";
    private MessageDisplayer messageDisplayer = null;
    private String loginCookieName = null;
    private String loginCookieValue = null;
    private String calendarName = "WebCalendar";
    private String appName = "WebCalendar (Unknown Version)";
    private String appVersion = "Unknown Version";
    private String appDate = "Unknown Date";
    private boolean isAdmin = false;
    private boolean debugEnabled = true;
    private static final String LOGIN_REQUEST = "ws/login.php";
    private static final String EVENTS_REQUEST = "ws/get_events.php";
    private static final String REMINDER_REQUEST = "ws/get_reminders.php";
    private Vector listeners;

    public WebCalendarClient(URL uRL) {
        this.url = uRL;
        this.messageDisplayer = this;
        this.listeners = new Vector();
    }

    public URL getURL() {
        return this.url;
    }

    public void setHttpAuthentication(String string, String string2) {
        this.httpUsername = string;
        this.httpPassword = string2;
    }

    public void setWebAuthentication(String string, String string2) {
        this.webcalUsername = string;
        this.webcalPassword = string2;
    }

    public void setMessageDisplayer(MessageDisplayer messageDisplayer) {
        this.messageDisplayer = messageDisplayer;
    }

    public MessageDisplayer getMessageDisplayer() {
        return this.messageDisplayer;
    }

    public boolean login() throws MalformedURLException, IOException {
        this.debug("Login to WebCalendar server...");
        this.loginCookieValue = null;
        this.loginCookieName = null;
        try {
            String string;
            URLConnection uRLConnection = this.openConnection("ws/login.php?login=" + this.webcalUsername + "&password=" + this.webcalPassword);
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            bufferedReader.close();
            String string2 = stringBuffer.toString();
            this.debug("Content:\n" + string2);
            if (string2.indexOf("<login>") >= 0) {
                this.parseLoginContent(string2);
                return this.loginCookieValue != null;
            }
            this.messageDisplayer.showError("Invalid data returned from server:\n\n" + string2);
        }
        catch (WebCalendarParseException webCalendarParseException) {
            this.messageDisplayer.showError("WebCalendar XML Error:\n" + webCalendarParseException.toString());
        }
        catch (WebCalendarErrorException webCalendarErrorException) {
            this.messageDisplayer.showError("WebCalendar Error:\n" + webCalendarErrorException.getMessage());
        }
        return false;
    }

    private void parseLoginContent(String string) throws WebCalendarParseException, WebCalendarErrorException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            Document document = documentBuilder.parse(stringBufferInputStream);
            this.domToSession(document);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            throw new WebCalendarParseException("Error parsing XML from WebCalendar server: " + exception.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new WebCalendarParseException("I/O Error parsing XML from WebCalendar server: " + iOException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new WebCalendarParseException("Parser Config Error parsing XML from WebCalendar server: " + parserConfigurationException.toString());
        }
    }

    private void domToSession(Document document) throws WebCalendarParseException, WebCalendarErrorException {
        String string = Utils.getError(document);
        if (string != null) {
            throw new WebCalendarErrorException(string);
        }
        NodeList nodeList = document.getElementsByTagName("login");
        if (nodeList.getLength() != 1) {
            System.err.println("Wrong number of <login> tags found");
            throw new WebCalendarParseException("Wrong number of <login> tags found");
        }
        Node node = nodeList.item(0);
        nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if ("cookieName".equals(node2.getNodeName())) {
                this.loginCookieName = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("cookieValue".equals(node2.getNodeName())) {
                this.loginCookieValue = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("admin".equals(node2.getNodeName())) {
                String string2 = Utils.xmlNodeGetValue(node2);
                if (!string2.equals("1") && !string2.startsWith("Y") && !string2.startsWith("y")) continue;
                this.isAdmin = true;
                continue;
            }
            if ("calendarName".equals(node2.getNodeName())) {
                this.calendarName = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("appName".equals(node2.getNodeName())) {
                this.appName = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("appVersion".equals(node2.getNodeName())) {
                this.appVersion = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("appDate".equals(node2.getNodeName())) {
                this.appDate = Utils.xmlNodeGetValue(node2);
                continue;
            }
            System.err.println("Not sure what to do with <" + node2.getNodeName() + "> tag (expecting <cookieName>... ignoring)");
        }
    }

    public URLConnection openConnection(String string) throws MalformedURLException, IOException {
        URL uRL = new URL(this.url, string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(true);
        if (this.httpUsername != null && this.httpPassword != null) {
            this.debug("Setting http authentication");
            String string2 = this.httpUsername + ":" + this.httpPassword;
            String string3 = new BASE64Encoder().encode(string2.getBytes());
            uRLConnection.setRequestProperty("Authorization", "Basic " + string3);
        } else {
            this.debug("no http authentication");
        }
        if (this.loginCookieName != null && this.loginCookieValue != null) {
            this.debug("Setting web authentication (session=" + this.loginCookieValue + ")");
            uRLConnection.setRequestProperty("Cookie", this.loginCookieName + "=" + this.loginCookieValue);
        } else {
            this.debug("no web authentication (yet)");
        }
        return uRLConnection;
    }

    public String getCalendarName() {
        return this.calendarName;
    }

    public String getServerName() {
        return this.appName;
    }

    public String getServerVersion() {
        return this.appVersion;
    }

    public String getServerVersionDate() {
        return this.appDate;
    }

    public String getReminders() throws MalformedURLException, IOException {
        this.debug("Getting reminders...");
        return this.query(REMINDER_REQUEST);
    }

    public String getEvents(Calendar calendar, Calendar calendar2) throws MalformedURLException, IOException {
        String string = Utils.CalendarToYYYYMMDD(calendar);
        String string2 = Utils.CalendarToYYYYMMDD(calendar2);
        this.debug("Getting events for " + string + " to " + string2);
        return this.query("ws/get_events.php?startdate=" + string + "&enddate=" + string2);
    }

    public String query(String string) throws MalformedURLException, IOException {
        String string2;
        Object object;
        for (int i = 0; i < this.listeners.size(); ++i) {
            object = (WebCalendarClientListener)this.listeners.elementAt(i);
            object.outgoingRequest(string);
        }
        URLConnection uRLConnection = this.openConnection(string);
        object = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append("\n");
        }
        bufferedReader.close();
        String string3 = ((StringBuffer)object).toString();
        for (int i = 0; i < this.listeners.size(); ++i) {
            WebCalendarClientListener webCalendarClientListener = (WebCalendarClientListener)this.listeners.elementAt(i);
            webCalendarClientListener.incomingResult(string3);
        }
        return string3;
    }

    public boolean addUser(User user) {
        try {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("ws/user_mod.php?add=1&username=");
            stringBuffer.append(user.login);
            if (user.firstName != null && user.firstName.length() > 0) {
                stringBuffer.append("&firstname=");
                stringBuffer.append(URLEncoder.encode(user.firstName));
            }
            if (user.lastName != null && user.lastName.length() > 0) {
                stringBuffer.append("&lastname=");
                stringBuffer.append(URLEncoder.encode(user.lastName));
            }
            if (user.fullName != null && user.fullName.length() > 0) {
                stringBuffer.append("&fullname=");
                stringBuffer.append(URLEncoder.encode(user.fullName));
            }
            if (user.password != null && user.password.length() > 0) {
                stringBuffer.append("&password=");
                stringBuffer.append(URLEncoder.encode(user.password));
            }
            if (user.email != null && user.email.length() > 0) {
                stringBuffer.append("&email=");
                stringBuffer.append(URLEncoder.encode(user.email));
            }
            if (user.isAdmin) {
                stringBuffer.append("&admin=1");
            }
            this.debug("Request: " + stringBuffer.toString());
            String string = this.query(stringBuffer.toString());
            this.debug("Result:\n" + string);
            if (string.indexOf("success") >= 0) {
                return true;
            }
            int n = string.indexOf("<error>");
            int n2 = string.indexOf("</error>");
            String string2 = "Error adding user: " + string;
            if (n > 0 && n2 > 0) {
                string2 = string.substring(n + 7, n2);
            }
            this.messageDisplayer.showError(string2);
        }
        catch (Exception exception) {
            this.showError("Error adding user:\n\n" + exception.toString());
            exception.printStackTrace();
        }
        return false;
    }

    public boolean deleteUser(User user) {
        try {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("ws/user_mod.php?del=1&username=");
            stringBuffer.append(user.login);
            this.debug("Request: " + stringBuffer.toString());
            String string = this.query(stringBuffer.toString());
            this.debug("Result:\n" + string);
            if (string.indexOf("success") >= 0) {
                return true;
            }
            int n = string.indexOf("<error>");
            int n2 = string.indexOf("</error>");
            String string2 = "Error adding user: " + string;
            if (n > 0 && n2 > 0) {
                string2 = string.substring(n + 7, n2);
            }
            this.messageDisplayer.showError(string2);
        }
        catch (Exception exception) {
            this.showError("Error adding user:\n\n" + exception.toString());
            exception.printStackTrace();
        }
        return false;
    }

    public boolean updateUser(User user) {
        try {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("ws/user_mod.php?username=");
            stringBuffer.append(user.login);
            if (user.firstName != null && user.firstName.length() > 0) {
                stringBuffer.append("&firstname=");
                stringBuffer.append(URLEncoder.encode(user.firstName));
            }
            if (user.lastName != null && user.lastName.length() > 0) {
                stringBuffer.append("&lastname=");
                stringBuffer.append(URLEncoder.encode(user.lastName));
            }
            if (user.fullName != null && user.fullName.length() > 0) {
                stringBuffer.append("&fullname=");
                stringBuffer.append(URLEncoder.encode(user.fullName));
            }
            if (user.email != null && user.email.length() > 0) {
                stringBuffer.append("&email=");
                stringBuffer.append(URLEncoder.encode(user.email));
            }
            if (user.isAdmin) {
                stringBuffer.append("&admin=1");
            }
            this.debug("Request: " + stringBuffer.toString());
            String string = this.query(stringBuffer.toString());
            this.debug("Result:\n" + string);
            if (string.indexOf("success") >= 0) {
                return true;
            }
            int n = string.indexOf("<error>");
            int n2 = string.indexOf("</error>");
            String string2 = "Error adding user: " + string;
            if (n > 0 && n2 > 0) {
                string2 = string.substring(n + 7, n2);
            }
            this.messageDisplayer.showError(string2);
        }
        catch (Exception exception) {
            this.showError("Error updating user:\n\n" + exception.toString());
            exception.printStackTrace();
        }
        return false;
    }

    public boolean approveEvent(Event event, Participant participant) {
        return this.updateEventStatus(event, participant, "approve");
    }

    public boolean rejectEvent(Event event, Participant participant) {
        return this.updateEventStatus(event, participant, "reject");
    }

    public boolean deleteEvent(Event event, Participant participant) {
        return this.updateEventStatus(event, participant, "delete");
    }

    private boolean updateEventStatus(Event event, Participant participant, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("ws/event_mod.php?username=");
            stringBuffer.append(URLEncoder.encode(participant.getLogin()));
            stringBuffer.append("&id=");
            stringBuffer.append(event.getId());
            stringBuffer.append("&action=");
            stringBuffer.append(URLEncoder.encode(string));
            this.debug("Request: " + stringBuffer.toString());
            String string2 = this.query(stringBuffer.toString());
            this.debug("Result:\n" + string2);
            if (string2.indexOf("success") >= 0) {
                return true;
            }
            int n = string2.indexOf("<error>");
            int n2 = string2.indexOf("</error>");
            String string3 = "Error updating event status: " + string2;
            if (n > 0 && n2 > 0) {
                string3 = string2.substring(n + 7, n2);
            }
            this.messageDisplayer.showError(string3);
        }
        catch (Exception exception) {
            this.showError("Error updating user:\n\n" + exception.toString());
            exception.printStackTrace();
        }
        return false;
    }

    private void debug(String string) {
        if (this.debugEnabled) {
            System.out.println("[dbg] " + string);
        }
    }

    public void showReminder(Reminder reminder) {
        if (this.messageDisplayer != null) {
            this.messageDisplayer.showReminder(reminder);
        } else {
            System.err.println("Reminder: " + reminder.toString());
        }
    }

    public void showMessage(String string) {
        if (this.messageDisplayer != null) {
            this.messageDisplayer.showMessage(string);
        } else {
            System.err.println(string);
        }
    }

    public void showError(String string) {
        if (this.messageDisplayer != null) {
            this.messageDisplayer.showError(string);
        } else {
            System.err.println("Error: " + string);
        }
    }

    public void addListener(WebCalendarClientListener webCalendarClientListener) {
        this.listeners.addElement(webCalendarClientListener);
    }
}

