/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarErrorException;
import us.k5n.webcalendar.WebCalendarParseException;

public class LoginSession
extends Vector {
    String cookieName = null;
    String cookieValue = null;
    boolean admin = false;
    Document document;

    public LoginSession(String string) throws WebCalendarParseException, WebCalendarErrorException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            this.document = documentBuilder.parse(stringBufferInputStream);
            this.domToSession(this.document);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            throw new WebCalendarParseException("Error parsing XML from WebCalendar server: " + exception.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new WebCalendarParseException("I/O Error parsing XML from WebCalendar server: " + iOException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new WebCalendarParseException("Parser Config Error parsing XML from WebCalendar server: " + parserConfigurationException.toString());
        }
    }

    private void domToSession(Document document) throws WebCalendarParseException, WebCalendarErrorException {
        String string = Utils.getError(document);
        if (string != null) {
            throw new WebCalendarErrorException(string);
        }
        NodeList nodeList = document.getElementsByTagName("login");
        if (nodeList.getLength() != 1) {
            System.err.println("Wrong number of <login> tags found");
            throw new WebCalendarParseException("Wrong number of <login> tags found");
        }
        Node node = nodeList.item(0);
        nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if ("cookieName".equals(node2.getNodeName())) {
                this.cookieName = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("cookieValue".equals(node2.getNodeName())) {
                this.cookieValue = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("admin".equals(node2.getNodeName())) {
                String string2 = Utils.xmlNodeGetValue(node2);
                if (!string2.startsWith("1") && !string2.startsWith("Y") && !string2.startsWith("y")) continue;
                this.admin = true;
                continue;
            }
            System.err.println("Not sure what to do with <" + node2.getNodeName() + "> tag (expecting <cookieName>... ignoring)");
        }
    }
}

