import gc
import inspect

exclude = [
    "function",
    "type",
    "list",
    "dict",
    "tuple",
    "wrapper_descriptor",
    "module",
    "method_descriptor",
    "member_descriptor",
    "instancemethod",
    "builtin_function_or_method",
    "frame",
    "classmethod",
    "classmethod_descriptor",
    "_Environ",
    "MemoryError",
    "_Printer",
    "_Helper",
    "getset_descriptor",
    "weakref", "property", "cell", "staticmethod",
    "WidgetFlags", "staticmethod"
    ]

def dumpObjects():
    gc.collect()
    oo = gc.get_objects()
    for o in oo:
        if getattr(o, "__class__", None):
            name = o.__class__.__name__
            #print (name)
            #if name not in exclude:
            if name in ["WebBoard", "WebBoardConfig", "WebBoardHistory"]:
                filename = inspect.getabsfile(o.__class__)
                print "Object :", `o`, "..."
                print "Class  :", name, "..."
                print "defined:", filename, "\n"

