# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for attributes defined in draft-behera-ldap-password-policy

$Id: ppolicy.py,v 1.10 2012/05/26 14:58:42 michael Exp $
"""

import pyweblib.forms

from w2lapp.schema.syntaxes import SelectList,DynamicDNSelectList,syntax_registry
from w2lapp.schema.plugins.quirks import UserPassword


class PwdCheckQuality(SelectList):
  oid = 'PwdCheckQuality-oid'
  desc = 'Password quality checking enforced'
  attr_value_dict = {
    u'0':u'quality checking not be enforced',
    u'1':u'quality checking enforced, accepting un-checkable passwords',
    u'2':u'quality checking always enforced',
  }

syntax_registry.registerAttrType(
  PwdCheckQuality.oid,[
    '1.3.6.1.4.1.42.2.27.8.1.5', # pwdCheckQuality (see draft-behera-ldap-password-policy)
  ]
)


class PwdAttribute(SelectList):
  oid = 'PwdAttribute-oid'
  desc = 'Password attribute'
  attr_value_dict = {
    u'2.5.4.35':u'userPassword',
  }

  def _validate(self,attrValue):
    return not attrValue or attrValue in ('2.5.4.35','userPassword')

syntax_registry.registerAttrType(
  PwdAttribute.oid,[
    '1.3.6.1.4.1.42.2.27.8.1.1', # pwdAttribute (see draft-behera-ldap-password-policy)
  ]
)


class PwdPolicySubentry(DynamicDNSelectList):
  oid = 'PwdPolicySubentry-oid'
  desc = 'DN of the pwdPolicy entry to be used for a certain entry'
  ldap_url = 'ldap:///_??sub?(|(objectClass=pwdPolicy)(objectClass=ds-cfg-password-policy))'

syntax_registry.registerAttrType(
  PwdPolicySubentry.oid,[
    '1.3.6.1.4.1.42.2.27.8.1.23', # pwdPolicySubentry
  ]
)


syntax_registry.registerAttrType(
  UserPassword.oid,[
    '1.3.6.1.4.1.42.2.27.8.1.20', # pwdHistory
  ]
)


# Register all syntax classes in this module
for name in dir():
  syntax_registry.registerSyntaxClass(eval(name))

