# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for OpenSSH-LPK
(see http://code.google.com/p/openssh-lpk/)

$Id: opensshlpk.py,v 1.2 2012/05/02 18:27:11 michael Exp $
"""

import re


from w2lapp.schema.syntaxes import DirectoryString,syntax_registry

class SshPublicKey(DirectoryString):
  oid = 'SshPublicKey-oid'
  desc = 'SSH public key of a user'
  reObj = re.compile('^ssh-(rsa|dss) .+$')

  def sanitizeInput(self,inputValue):
    return inputValue.strip().replace('\r','').replace('\n','')

syntax_registry.registerAttrType(
  SshPublicKey.oid,[
    '1.3.6.1.4.1.24552.500.1.1.1.13', # sshPublicKey
  ]
)


# Register all syntax classes in this module
for symbol_name in dir():
  syntax_registry.registerSyntaxClass(eval(symbol_name))
