#ifndef WALLYPLUGIN_H
#define WALLYPLUGIN_H

#include <QPixmap>
#include <QWidget>
#include <QTimer>
#include <Plasma/Wallpaper>

#define LAST_WALLY_WALLPAPER "lastWallyWallpaper"

class WallyPlugin : public Plasma::Wallpaper
{
  Q_OBJECT

  bool timerStarted;
  QString wallpaper;
  QPixmap pixmap;
  QTimer *timer;

  void loadWallpaper();
  void setWallpaper(const QString &fileName);

private slots:
  void readWallpaperFromFileName();
  void reReadWallpaperFromFileName();

protected:
  void init(const KConfigGroup &config);

public:
  WallyPlugin(QObject *parent, const QVariantList &args);
  virtual ~WallyPlugin() { }

  void paint(QPainter *painter, const QRectF &exposedRect);
};

#endif
