//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        list.h
//
// Purpose:     Interface to class List
//
// Created:      8 Feb 1996  Georg Meszaros
//
// Modified:     
//
//
// Description:
//
// Definition of the container class List which holds pointers in its
// list.
//
//</file>


//<class>
//
// Name:    List
//
// Purpose: ....
//
//
// Public Interface:
//
// - List
//    
//
//
// Description:
//
// The ...
// 
//
//</class>



#include "lightlist.h"

#include "attributes.h"
#include <hyperg/utils/types.h>


LightList* LightList::head_;
LightList* LightList::tail_;


LightList::LightList()
{
  length_ = 0;
  element_ = nil;
  next_ = nil;
  prev_ = nil;
  head_ = nil;
  tail_ = nil;
}


LightList::~LightList()
{
  if (element_) delete element_;
  if (next_) delete next_;	  
}


void LightList::add(AnyLight* element) 
{
  LightList* l;
  l = new LightList;
  l->element_ = element;
  length_++;  

  if (!head_) head_ = tail_ = l;
  else
  { 
    tail_->next_ = l;         
    l->prev_ = tail_;
    l->next_ = nil;
    l->head_ = head_;
    head_->tail_ = l;
  } 
}


void LightList::print()
{
  LightList* l = head_;
  while (l) 
  {
    l->element_->print();
    l = l->next_;
  }
} 
