// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1995
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiosrc_a.h
// 
// Purpose:     
// 
// Created:     19 Mar 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tiosrc_a.h,v 1.2 1997/02/12 23:13:11 jfasch Exp $
// 
// $Log: tiosrc_a.h,v $
// Revision 1.2  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.1  1997/02/12 22:21:30  jfasch
// Initial revision
//
// Revision 1.3  1996/12/17 13:19:35  jfasch
// NT namespace pollutors
//
// Revision 1.2  1996/12/12 15:02:52  jfasch
// link time assertion
//
// Revision 1.1  1996/07/08  13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tiosrc_a_h
#define hg_dispatch_tiosrc_a_h

#include <hyperg/utils/smartptr.h>

class TIOSourceActive ;
class TransparentIOPtr ;

class TIOSourceActiveUser {
public:
   virtual void tioSrcAError (const TIOSourceActive*) = 0 ;
   virtual void tioSrcAReady (const TIOSourceActive*, const TransparentIOPtr&) = 0 ;
} ;

class TIOSourceActive : public RefCounted {
public:
   // return values of make() 
   enum Make {
     // cope with these name space pollutors (maily inside the
     // omnipresent shit called NT) and prepend "TIO" to them Makes
     TIOERROR = -1,
     TIOWAIT = 0,
     TIOREADY = 1
   } ;
   
   virtual ~TIOSourceActive() {}

   virtual Make make (TransparentIOPtr&, TIOSourceActiveUser*) = 0 ;
   virtual void cancel (const TIOSourceActiveUser*) = 0 ;

public:
   static const char* version1 ;
} ;
static const char* hg_dc_common_TIOSourceActive_version = TIOSourceActive::version1 ;

SmartPtrdeclare (TIOSourceActivePtr, TIOSourceActive) ;

#endif
