#include <string>
#include <map>
/* -- */
#include "trace/values/Value.hpp"
#include "trace/values/Color.hpp"
/* -- */
#include "common/Session.hpp"
/* -- */
#include "Palette.hpp"

Palette::Palette(const std::string &name) : _name(name) {
}

Palette::~Palette() {
    // Delete colors
    for(std::map<std::string, Color *>::iterator it = _pairs.begin() ;
        it != _pairs.end() ; ++ it) {
        Color *c = (*it).second;
        delete c;
    }
}


Color *Palette::get_color(const std::string &state_name) {
    if(_pairs.find(state_name) != _pairs.end())
        return _pairs[state_name];
    else
        return NULL;
}

void Palette::add_state(const std::string &state, Color &c) {
    if(_pairs.find(state) != _pairs.end()) {
        Color *tmp = _pairs[state];
        delete tmp;
    }
    _pairs[state] = new Color(c);
}

std::string Palette::get_name() const {
    return _name;
}

std::map<std::string, Color *> Palette::get_map() const {
    return _pairs;
}
