/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
#ifndef COLOR_HPP
#define COLOR_HPP

/*!
 *
 * \file Color.hpp
 *
 */

#include <sstream>
#include "Value.hpp"
#include "../../general/Tools.hpp"
/*!
 *
 * \class Color
 * \brief Store a color in the trace
 *
 */
class Color: public Value {
private :
    double _r;
    double _g;
    double _b;

public:
    /*!
     *
     * \brief Constructor
     *
     */
    Color();

    /*!
     *
     * \brief Constructor
     *
     */
    Color(double, double, double);

    /*!
     *
     * \fn instantiate(const std::string &in, Color &out)
     * \brief Convert a string to a Color
     * \param in String to convert
     * \param out Color to be initialized
     * \return true, if the conversion succeeded
     *
     */
    static bool instantiate(const std::string &in, Color &out);

    /*!
     *
     * \fn to_string() const
     * \return a string of the color in the format "r g b".
     *
     */
    std::string to_string() const;
    
    /*!
     *
     * \fn get_red() const
     * \return red value
     *
     */
    double get_red() const;
    
    /*!
     *
     * \fn get_green() const;
     * \return green value
     *
     */
    double get_green() const;
    
    /*!
     *
     * \fn get_blue() const;
     * \return blue value
     *
     */
    double get_blue() const;

};

#endif // COLOR_HPP
