/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
#include "ParserPaje.hpp"

using namespace std;

ParserPaje::ParserPaje(){
    _is_finished = false;
    _is_canceled = false;
}

void ParserPaje::parse(string filename, Trace &trace){

    set_file_to_parse(filename);

    const unsigned int position_of_dot = filename.find_last_of('.');
    if ((position_of_dot == (string::npos)) || (filename.substr(position_of_dot) != ".trace")){
        Error::set(Error::_BAD_FILE_EXTENSION, Error::_WARNING);
    }

    ParserDefinitionDecoder *parserdefinition = new ParserDefinitionDecoder();
    ParserEventDecoder *parserevent = new ParserEventDecoder();
    
    Line line(_file_to_parse);


    static const string PERCENT = "%";
    string event_identity_string;
    unsigned int event_identity;

    while(!(line.is_eof() || _is_canceled)) {
        
        line.newline();
    	if(line.starts_with(PERCENT)) {
            parserdefinition->store_definition(line);
        }
    	else if (!line.item(0, event_identity_string)) {
            continue; // We have \n 
    	}
    	else {
            // We check if we have an event identifier
            if(sscanf(event_identity_string.c_str(), "%u", &event_identity) != 1){
                Error::set(Error::_EXPECT_ID_DEF, line.get_line_count(), Error::_WARNING);
                continue;
            }
            Definition current_definition;
            try {
                current_definition = parserdefinition->get_definition(event_identity);
            }
            catch (unsigned int) {
                Error::set(Error::_UNKNOWN_ID_DEF + event_identity_string, line.get_line_count(), Error::_WARNING);
                continue;
            }
            parserevent->store_event(current_definition,
                                     line,
                                     trace);
        }
    }
    finish();
    trace.finish();

    delete parserdefinition;
    delete parserevent;
}


void ParserPaje::set_file_to_parse(const string filename){
    _file_to_parse = filename;
}


float ParserPaje::get_size_loaded() const{
    return (TokenSource::get_size_loaded());
}

void ParserPaje::reinit_cursor() {
    TokenSource::reinit_cursor();
}

bool ParserPaje::is_end_of_parsing() const{
    return _is_finished;
}

void ParserPaje::finish() {
    _is_finished = true;
}

void ParserPaje::set_canceled() {
    _is_canceled = true;
}
