/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file ParserEventDecoder.hpp
 *\brief This file contains the event decoder used by the ParserPaje.
 */

#ifndef PARSEREVENTDECODER_HPP
#define PARSEREVENTDECODER_HPP

#include <iostream>
#include <map>

#include "Definition.hpp"
#include "Line.hpp"

#ifndef VITE_DEBUG
  #include "../trace/Trace.hpp"
  #include "../message/Errors.hpp"
#else
// For debugging
  #include "../../tests/stubs/Trace.hpp"
  #include "../../tests/stubs/Errors.hpp"
#endif


/**
 * \class ParserEventDecoder
 * \brief Reads Hash Table to find fill the Str
 *
 */

class ParserEventDecoder{

public:
    ParserEventDecoder();

    /*!
     *  \fn store_event(const Definition &definition, Line &line, Trace &trace)
     *  \param definition the definition of the event.
     *  \param line the line containing the event.
     *  \param trace where we store the event.
     */
    void store_event(const Definition &definition, Line &line, Trace &trace);
};
#endif // PARSEREVENTDECODER_HPP
