AC_DEFUN_ONCE([VV_WITH_NETBEANS_PROFILER_ZIP],
[
  AC_MSG_CHECKING(for a NetBeans profiler zip)
  AC_ARG_WITH([netbeans-profiler-zip],
              [AS_HELP_STRING(--with-netbeans-profiler-zip,specify the location of the NetBeans profiler zip)],
  [
    ALT_NETBEANS_PROFILER_ZIP=${withval}
  ],
  [ 
    ALT_NETBEANS_PROFILER_ZIP="not specified"
  ])
  AC_MSG_RESULT(${ALT_NETBEANS_PROFILER_ZIP})
  AM_CONDITIONAL(USE_ALT_NETBEANS_PROFILER_ZIP, test "x$ALT_NETBEANS_PROFILER_ZIP" != "xnot specified")
  AC_SUBST(ALT_NETBEANS_PROFILER_ZIP)
])

AC_DEFUN_ONCE([VV_WITH_VISUALVM_ZIP],
[
  AC_MSG_CHECKING(for a VisualVM zip)
  AC_ARG_WITH([visualvm-zip],
              [AS_HELP_STRING(--with-visualvm-zip,specify the location of the VisualVM zip)],
  [
    ALT_VISUALVM_ZIP=${withval}
  ],
  [ 
    ALT_VISUALVM_ZIP="not specified"
  ])
  AC_MSG_RESULT(${ALT_VISUALVM_ZIP})
  AM_CONDITIONAL(USE_ALT_VISUALVM_ZIP, test "x$ALT_VISUALVM_ZIP" != "xnot specified")
  AC_SUBST(ALT_VISUALVM_ZIP)
])

AC_DEFUN_ONCE([IT_CHECK_FOR_JDK],
[
  AC_MSG_CHECKING([for a JDK home directory])
  AC_ARG_WITH([jdk-home],
	      [AS_HELP_STRING([--with-jdk-home],
                              [jdk home directory \
                               (default is first predefined JDK found)])],
              [
                if test "x${withval}" = xyes
                then
                  SYSTEM_JDK_DIR=
                elif test "x${withval}" = xno
                then
	          SYSTEM_JDK_DIR=
	        else
                  SYSTEM_JDK_DIR=${withval}
                fi
              ],
              [
	        SYSTEM_JDK_DIR=
              ])
  if test -z "${SYSTEM_JDK_DIR}"; then
    for dir in /usr/lib/jvm/java-openjdk /usr/lib/jvm/icedtea6 \
    	       /usr/lib/jvm/java-6-openjdk /usr/lib/jvm/openjdk \
	       /usr/lib/jvm/java-icedtea ; do
       if test -d $dir; then
         SYSTEM_JDK_DIR=$dir
	 break
       fi
    done
  fi
  AC_MSG_RESULT(${SYSTEM_JDK_DIR})
  if ! test -d "${SYSTEM_JDK_DIR}"; then
    AC_MSG_ERROR("A JDK JDK home directory could not be found.")
  fi
  AC_SUBST(SYSTEM_JDK_DIR)
])

AC_DEFUN([IT_FIND_TOOL],
[AC_PATH_TOOL([$1],[$2])
 if test x"$$1" = x ; then
   AC_MSG_ERROR([$2 program not found in PATH])
 fi
 AC_SUBST([$1])
])

AC_DEFUN_ONCE([VV_SET_ARCH_SETTINGS],
[
  AC_REQUIRE([AC_CANONICAL_HOST])
  case "${host_cpu}" in
    x86_64)
      ARCHFLAG="-m64"
      ;;
    i?86)
      ARCHFLAG="-m32"
      ;;
    powerpc)
      ARCHFLAG="-m32"
       ;;
    powerpc64)
      ARCHFLAG="-m64"
       ;;
    sparc)
      ARCHFLAG="-m32"
       ;;
    sparc64)
      ARCHFLAG="-m64"
       ;;
    s390)
      ARCHFLAG="-m31"
       ;;
    s390x)
      ARCHFLAG="-m64"
       ;;
  esac
  AC_SUBST(ARCHFLAG)
])

AC_DEFUN_ONCE([VV_CHECK_WITH_VISUALVM_VERSION],
[
  DEFAULT_VERSION="1.2.2"
  AC_MSG_CHECKING([which VisualVM version to build])
  AC_ARG_WITH([visualvm-version],
	      [AS_HELP_STRING(--with-visualvm-version,the VisualVM version to build (see Makefile.am))],
  [
    VVVERSION="${withval}"
  ],
  [ 
    VVVERSION="${DEFAULT_VERSION}"
  ])
  if test "x${VVVERSION}" = xyes; then
	VVVERSION="${DEFAULT_VERSION}"
  elif test "x${VVVERSION}" = xno; then
	VVVERSION="${DEFAULT_VERSION}"
  fi
  AC_MSG_RESULT([${VVVERSION}])
  AM_CONDITIONAL([VVVERSION_13], [test "$VVVERSION" = "1.3"])
  AM_CONDITIONAL([VVVERSION_131], [test "$VVVERSION" = "1.3.1"])
  AM_CONDITIONAL([VVVERSION_132], [test "$VVVERSION" = "1.3.2"])
])

AC_DEFUN_ONCE([VV_CHECK_FOR_NETBEANS],
[
AC_REQUIRE([VV_CHECK_WITH_VISUALVM_VERSION])
AC_MSG_CHECKING([for a NetBeans installation])
AC_ARG_WITH([netbeans-home],
           [AS_HELP_STRING([--with-netbeans-home],
                            [NetBeans home directory (default is /usr/share/netbeans)])],
            [
              if test "x${withval}" = x
              then
                SYSTEM_NETBEANS_DIR=/usr/share/netbeans
              else
                SYSTEM_NETBEANS_DIR=${withval}
              fi
            ],
            [
              SYSTEM_NETBEANS_DIR=/usr/share/netbeans
            ])
AC_MSG_RESULT([${SYSTEM_NETBEANS_DIR}])
AC_SUBST(SYSTEM_NETBEANS_DIR)
if test "$VVVERSION" = "1.3.2"; then
   NB_PLATFORM=platform12;
else if test "$VVVERSION" = "1.3.1"; then
   NB_PLATFORM=platform12;
else if test "$VVVERSION" = "1.3"; then
   NB_PLATFORM=platform12;
else
   NB_PLATFORM=platform11;
fi
fi
fi
if ! test -d ${SYSTEM_NETBEANS_DIR}/${NB_PLATFORM} ; then
  AC_MSG_ERROR([Couldn't find NetBeans platform directory: ${SYSTEM_NETBEANS_DIR}/${NB_PLATFORM}])
fi
AC_SUBST([NB_PLATFORM])
])

