/*
   Copyright (c) 2010 Sebastian Trueg <trueg@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _VIRTUOSO_CONVERTER_JOB_H_
#define _VIRTUOSO_CONVERTER_JOB_H_

#include <KJob>
#include <KTempDir>

namespace Soprano {
    class VirtuosoController;
}

class ConverterJob : public KJob
{
    Q_OBJECT

public:
    ConverterJob( QObject* parent );
    ~ConverterJob();

    void setBackup( bool backup );
    void setKeepDump( bool keep );

    void start();

private Q_SLOTS:
    void slotCreateDumpGraphsDone( bool success );
    void slotDumpGraphsDone( bool success );
    void slotFulltextIndexingStateUpdated( bool );
    void slotCreateLoadGraphsDone( bool success );
    void slotLoadGraphsDone( bool success );
    void slotDumpLoadGraphsDone( bool success );

private:
    bool startVirtuoso( int version );
    void cleanupAndEmitResult();
    void removeNepomukDb();
    void restoreBackup();

    static QString createDumpGraphs();
    static QString createLoadGraphs();

    Soprano::VirtuosoController* m_virtuosoController;
    KTempDir m_dumpTmpDir;
    QString m_backupPath;
    bool m_backup;
    bool m_keepDump;
};

#endif
