/** @file
 *
 * VBox frontends: Qt GUI ("VirtualBox"):
 * X11 keyboard driver definitions to use it outside wine
 *
 */

/*
 * Copyright (C) 2008 innotek GmbH
 *
 * This library is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This library is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation, in version 2.1 as it comes in the "COPYING.LIB" file of the
 * VirtualBox OSE distribution.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 */

#ifndef __H_KEYBOARD_OUTOFWINE
#define __H_KEYBOARD_OUTOFWINE

#include <X11/Xlib.h>

/** Our structure used to return keyboard event information */
typedef struct _WINEKEYBOARDINFO
{
    unsigned short wVk;
    unsigned short wScan;
    unsigned long dwFlags;
    unsigned long time;
} WINEKEYBOARDINFO;

/* Exported definitions */
#ifdef VBOX_HAVE_VISIBILITY_HIDDEN
extern __attribute__((visibility("default"))) void X11DRV_InitKeyboard(Display *dpy);
extern __attribute__((visibility("default"))) void X11DRV_KeyEvent(Display *dpy, XEvent *event,
                                                                   WINEKEYBOARDINFO *wKbInfo);
extern __attribute__((visibility("default"))) int X11DRV_GetKeysymsPerKeycode(void);
#else
extern void X11DRV_InitKeyboard(Display *dpy);
extern void X11DRV_KeyEvent(Display *dpy, XEvent *event,
                                                                   WINEKEYBOARDINFO *wKbInfo);
extern int X11DRV_GetKeysymsPerKeycode(void);
#endif

#endif /* __H_KEYBOARD_OUTOFWINE */
