/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <CLin.h>

#include <Strings.h>
#include <TwoPorts.h>

#include "../images/clin.xpm"

QPixmap* CLin::pixmap_ = 0;

//-----------------------------------------------------------------
CLin::CLin( const QPoint& center )
    : Component( center )
{}

//-----------------------------------------------------------------
CLin::~CLin()
{}

//-----------------------------------------------------------------
const QString& CLin::getCatagory() const
  {
    return Strings::TransmissionLineCatagory;
  }

//-----------------------------------------------------------------
const QString& CLin::getName() const
  {
    return Strings::CLinName;
  }

//-----------------------------------------------------------------
const QPixmap& CLin::getPixmap() const
  {
    if (!pixmap_)
      {
        pixmap_ = new QPixmap( clin_xpm );
      }
    return *pixmap_;
  }

//-----------------------------------------------------------------
void CLin::initComponent()
{
  boundingRect_ = QRect(-24, -16, 48, 32);
  addNode( -24, -8, FALSE, FALSE, TRUE );
  addNode( -24, +8, FALSE, FALSE, TRUE );
  addNode( +24, +8, FALSE, FALSE, TRUE );
  addNode( +24, -8, FALSE, FALSE, TRUE );
  addAttribute( Strings::AttrEvenModeImpedance, "Ze" );
  addAttribute( Strings::AttrOddModeImpedance, "Zo" );
  addAttribute( Strings::AttrElectricalLng, "E" );
  addAttribute( Strings::AttrElectricalLngFreq, "F" );
}

//-----------------------------------------------------------------
void CLin::drawSymbol(QPainter* p)
{
  p->drawRect(-24,-14,48,12);
  p->drawRect(-24, 2,48,12);
}

//-----------------------------------------------------------------
bool CLin::initSweep()
{
  bool changed = FALSE;
  TReal ze = ze_;
  TReal zo = zo_;
  TReal e = e_;
  TReal f = f_;
  ze_ = getAttributeValue( "Ze" );
  zo_ = getAttributeValue( "Zo" );
  e_ = getAttributeValue( "E" );
  f_ = getAttributeValue( "F" ) * getDimensionValue( Strings::FrequencyDim );
  if ( (ze!=ze_) || (zo!=zo_) || (e!=e_) || (f!=f_) )
    {
      changed = TRUE;
    }
  return changed;
}

//-----------------------------------------------------------------
void CLin::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  Matrix y;
  TwoPorts::getCLIN( freq, ze_, zo_, e_, f_, y );
  uint nodes [4];
  for ( uint i=0; i<4; i++ )
    {
      nodes[i] = node(i)->getNodeNumber();
    }
  yn->insertCoupledLine(y, nodes);
}
