#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is part of Videoporama but it comes from EKD
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2009  Olivier Ponchaut <opvg@edpnet.be>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


# script grandement inspiré du code c++ de http://doc.qtfr.org/public/2007/qt_mplayer.tar.gz
# merci à IrmatDen

import sys, os
from PyQt4.QtGui import *
from PyQt4.QtCore import *


def getParamVideo(cheminVideoEntre, parameter):
	"""Renvoie un ou plusieurs paramètres de la vidéo sous forme de flottant.
	La variable «cheminVideoEntre» est le chemin de la vidéo de type unicode.
	La variable «parameter» est un tuple de paramètres à renvoyer.
	La dernière variable renvoyée est un tuple des lignes de log"""
	
	cheminVideoEntre = cheminVideoEntre.encode("UTF8")
	
	# Condition pour détection windows
	if os.name == 'nt':
		recupDonneesVideo = os.popen('mplayer.exe -vo null -ao null -identify -frames 0 '+ "\"" + cheminVideoEntre + "\"").readlines()
	# Condition pour détection Linux ou MacOSX
	elif os.name in ['posix', 'mac']:
		recupDonneesVideo = os.popen('mplayer ' +"\""+ cheminVideoEntre +\
		"\" -vo null -ao null -frames 0 -identify '$@' 2>/dev/null").readlines()
	
	lstValeurs = []
	log = []
	
	for ligne in recupDonneesVideo:
		try:
			# On veut que les caractères non ASCII s'affichent correctement pour les noms de fichiers
			log.append(ligne.decode("UTF8"))
		except UnicodeDecodeError:
			print "Traitement d'exception unicode au niveau de getParamVideo() probablement dûe aux méta-données de la vidéo"
			log.append(ligne)
		for param in parameter:
			if param in ligne:
				ligne = ligne.replace(param, "")
				ligne = ligne.replace("=", "")
				ligne = ligne.replace("\n", "")
				ligne = ligne.replace(" ", "")
				lstValeurs.append(float(ligne))
	
	lstValeurs.append(log)
	
	return lstValeurs

def getVideoLength(cheminVideoEntre):
	"Retourne la durée de la vidéo. L'argument doit être de type unicode"
	return getParamVideo(cheminVideoEntre, ["ID_LENGTH"])

def getVideoSize(cheminVideoEntre):
	"Retourne la taille de la vidéo. L'argument doit être de type unicode"
	return getParamVideo(cheminVideoEntre, ["ID_VIDEO_WIDTH", "ID_VIDEO_HEIGHT"])

def getVideoFPS(cheminVideoEntre):
	"Retourne le nombre de trames par seconde de la vidéo. L'argument doit être de type unicode"
	return getParamVideo(cheminVideoEntre, ["ID_VIDEO_FPS"])

def getVideoRatio(cheminVideoEntre):
	"Retourne l'aspect ratio de la vidéo. L'argument doit être de type unicode"
	return getParamVideo(cheminVideoEntre, ["ID_VIDEO_ASPECT"])


class TracerChrono(QWidget):
	"""On trace le temps car il ne s'affiche pas bien autrement pour certaines configurations"""
	TAILLE = "0:00:00:000"
	def __init__(self):
		# parent nous permettra d'accéder à la valeur du curseur
		QWidget.__init__(self)
		self.setSizePolicy(QSizePolicy.Preferred, QSizePolicy.MinimumExpanding)
		self.raz()
		######################################################################################
	
	def paintEvent(self, event):
		paint = QPainter()
		paint.begin(self)
		paint.drawText(event.rect(), Qt.AlignCenter, self.num)
		paint.end()
	
	def minimumSizeHint(self):
		"Pour être sûr que le texte du chrono ne soit pas tronqué"
		font = QFont(self.font())
		font.setPointSize(font.pointSize() - 1)
		fm = QFontMetricsF(font)
		## Modifié le 28/05/2009 : on ajoute de la précision dans la lecture #################
		##l = fm.width(TracerChrono.TAILLE) + 6.
		l = fm.width(TracerChrono.TAILLE*2) # + 10.
		L = fm.height() + 2.
		return QSize(l, L)
		######################################################################################
		
	def raz(self):
		'''Ajouté le 28/05/2009 : On évite d'avoir à parcourir le code à la recherche de 00:00:00....'''
		self.num = TracerChrono.TAILLE

class DisplayVid(QWidget) :

	def resizeEvent(self,event) :
		QWidget.resizeEvent(self,event)
		self.emit(SIGNAL("changeSize"))

class Mplayer(QDialog):
	
	REVENIR, PAS_PRECEDENT_SUIVANT, PRECEDENT_SUIVANT, CURSEUR_SUR_UNE_LIGNE,\
		CURSEUR_A_PART, PARCOURIR, PAS_PARCOURIR = range(7)
	
	HAUTEUR, LARGEUR = range(2)
	
	def __init__(self, cheminVideo=[], taille=(250,225),
			choixWidget=(REVENIR, PAS_PRECEDENT_SUIVANT,CURSEUR_SUR_UNE_LIGNE,PAS_PARCOURIR),
			debutFin=(0,0), cheminMPlayer=None, barreTaches=None, facteurLimitant=HAUTEUR,
			cheminParcourir=None, parent=None):
		
		"""widget mplayer"""
		QDialog.__init__(self, parent)
		
		#=== Paramètres généraux ===#
		self.setAttribute(Qt.WA_DeleteOnClose)
		
		self.systeme = os.name
		
		# système d'exploitation
		if self.systeme in ['posix', 'mac'] and not cheminMPlayer:
			self.cheminMPlayer="mplayer"	# moteur de lecture mplayer
		elif cheminMPlayer: # windows à priori
			self.cheminMPlayer=cheminMPlayer # avec le *.exe
		
		# liste de chemins vidéos
		self.listeVideos=cheminVideo
		
		# est-ce que la vidéo est lue?
		self.estLue=False
		
		# est-ce que la vidéo est en pause?
		self.estEnPause=False
		
		self.debutFin = debutFin
		
		# Nom du fichier courant (le self n'est pas encore utile)
		txtParDefaut = u"Pas de fichier lu"
		if self.listeVideos.__len__()!=0:
			self.fichierCourant =  [txtParDefaut, self.listeVideos[0]]
		else: self.fichierCourant = [txtParDefaut, ""]
		
		# Barre des tâches de la fenêtre
		self.barreTaches = barreTaches
		
		# Taille de la vidéo
		self.tailleLargeur=taille[0]
		self.tailleHauteur=taille[1]
		
		# Drapeau pour afficher plus de boutons
		plusBoutons = choixWidget[0]
		
		# Drapeau pour mettre le curseur à part
		curseurAPart = choixWidget[1]
		
		# paramètres des boutons-icones
		iconTaille=22
		flat=1
		
		# Pour récupérer le temps courant depuis certains cadre
		self.temps = 0

		self.dureeTimer = 10 # temps en ms
		###############################################################################################################################
		
		## Ajouté le 28/05/2009 : Pour être plus précis lors de la lecture, on prend comme unité la miliseconde. ######################
		## Il faut donc utiliser une echelle 1000 fois plus grande pour les unités du slider
		self.echelle=1000
		###############################################################################################################################
		
		# Permet de récupérer la durée de la vidéo depuis une instance de la classe
		# Sert dans certains cadres
		self.dureeVideo = 0
		
		# Chemin sur lequel peut s'ouvrir la boite de dialogue de fichier
		# associée au bouton parcourir
		self.cheminPourBoutonParcourir = cheminParcourir
		
		self.taille = taille

		print "self.taille avant lecture :", self.taille, type(self.taille)
		
		#=== Widgets ===#
		
		self.icone_lire=QIcon("icons" + os.sep + "player_play.png")
		self.icone_pause=QIcon("icons" + os.sep + "player_pause.png")
		self.icone_arret=QIcon("icons" + os.sep + "player_stop.png")
		
		###### Rajouté le 31/03/09 ################################################################
		if Mplayer.REVENIR in choixWidget:
			self.bout_revenir = QPushButton(u"Revenir")
			self.bout_revenir.setIcon(QIcon("Icones" + os.sep + "revenir.png"))
		###########################################################################################
		
		if Mplayer.PARCOURIR in choixWidget:
			self.bout_ouvVideo = QPushButton(u"Parcourir...")
			
		if Mplayer.PRECEDENT_SUIVANT in choixWidget:
			self.bout_prec = QPushButton(QIcon("Icones" + os.sep + "player_rew.png"),"")
			self.bout_prec.setIconSize(QSize(iconTaille, iconTaille))
			self.bout_prec.setFlat(flat)
			self.bout_suivant = QPushButton(QIcon("Icones" + os.sep + "player_fwd.png"),"")
			self.bout_suivant.setIconSize(QSize(iconTaille, iconTaille))
			self.bout_suivant.setFlat(flat)
		
		self.bout_LectPause = QPushButton(self.icone_lire,"")
		self.bout_LectPause.setIconSize(QSize(iconTaille, iconTaille))
		self.bout_LectPause.setFlat(flat)
		
		self.bout_Arret = QPushButton(self.icone_arret,"")
		self.bout_Arret.setIconSize(QSize(iconTaille, iconTaille))
		self.bout_Arret.setFlat(flat)
		
		# widget qui contiendra la vidéo
		self.cibleVideo = DisplayVid(self)
		# par défaut le widget-cible est noir
		color = QColor(0, 0, 0)
		self.cibleVideo.setAutoFillBackground(True)
		self.cibleVideo.setPalette(QPalette(color))
		self.cibleVideo.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
		self.cibleVideo.setFixedHeight(self.taille[1])
		self.cibleVideo.setToolTip(self.fichierCourant[0])

		#Choix de l'aspect ratio de la vidéo
		self.conf = QGroupBox()
		sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
		sizePolicy.setHorizontalStretch(0)
		sizePolicy.setVerticalStretch(0)
		sizePolicy.setHeightForWidth(self.conf.sizePolicy().hasHeightForWidth())
		self.conf.setSizePolicy(sizePolicy)
		self.conf.setMinimumSize(QSize(70, 0))
		self.conf.setMaximumSize(QSize(70, 16777215))
		self.conf.setObjectName("conf")
		self.verticalLayout = QVBoxLayout(self.conf)
		self.verticalLayout.setObjectName("verticalLayout")
		self.choicenorm = QRadioButton(self.conf)
		self.choicenorm.setObjectName("choicenorm")
		self.verticalLayout.addWidget(self.choicenorm)
		self.choicewide = QRadioButton(self.conf)
		self.choicewide.setObjectName("choicewide")
		self.verticalLayout.addWidget(self.choicewide)
		self.choiceone = QRadioButton(self.conf)
		self.choiceone.setObjectName("choiceone")
		self.verticalLayout.addWidget(self.choiceone)
		spacerItem = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
		self.verticalLayout.addItem(spacerItem)
		self.choicenorm.setText("4:3")
		self.choicewide.setText("16:9")
		self.choiceone.setText("w:h")
		# Checked le ratio de la vidéo
		if self.listeVideos.__len__()!=0:
			self.changeRatio(self.listeVideos[0])
		else :
			self.setRatio(4.0/3.0)
			self.choicenorm.setChecked(True)

		self.slider = QSlider(Qt.Horizontal)
		# Modifié le 27/05/2009 : qualification du bug en question
		#self.slider.setEnabled(False) # évite un bogue
		self.slider.setEnabled(True)
		#self.slider.setSingleStep(self.echelle)
		
		self.mplayerProcess = QProcess(self)
		
		self.timer = QTimer(self)
		
		self.tempsChrono = TracerChrono()
		
		#=== mise-en-page/plan ===#
		mhbox = QHBoxLayout()
		vbox = QVBoxLayout()
		vbox.addWidget(self.cibleVideo)
		hbox = QHBoxLayout()
		if Mplayer.REVENIR in choixWidget:
			hbox.addWidget(self.bout_revenir)
		if Mplayer.PARCOURIR in choixWidget:
			hbox.addWidget(self.bout_ouvVideo)
		hbox.addWidget(self.bout_LectPause)
		hbox.addWidget(self.bout_Arret)
		if Mplayer.PRECEDENT_SUIVANT in choixWidget:
			hbox.addWidget(self.bout_prec)
			hbox.addWidget(self.bout_suivant)
		hbox.addWidget(self.tempsChrono)
		if Mplayer.CURSEUR_A_PART not in choixWidget:
			hbox.addWidget(self.slider)
		vbox.addLayout(hbox)
		if Mplayer.CURSEUR_A_PART in choixWidget:
			hbox.setAlignment(Qt.AlignLeft)
			hbox = QHBoxLayout()
			hbox.addWidget(self.slider)
			vbox.addLayout(hbox)
		mhbox.addLayout(vbox)
		mhbox.addWidget(self.conf)
		self.setLayout(mhbox)
		
		#=== connexion des widgets à des fonctions ===#
		
		if Mplayer.REVENIR in choixWidget:
			self.connect(self.bout_revenir, SIGNAL('clicked()'), SLOT('close()'))
		if Mplayer.PARCOURIR in choixWidget:
			self.connect(self.bout_ouvVideo, SIGNAL('clicked()'), self.ouvrirVideo)
		if Mplayer.PRECEDENT_SUIVANT in choixWidget:
			self.connect(self.bout_prec, SIGNAL('clicked()'), self.precedent)
			self.connect(self.bout_suivant, SIGNAL('clicked()'), self.suivant)
		self.connect(self.bout_LectPause, SIGNAL('clicked()'), self.lectPause)
		self.connect(self.bout_Arret, SIGNAL('clicked()'), self.arretMPlayer)
		self.connect(self.mplayerProcess, SIGNAL('readyReadStandardOutput()'), self.recupSortie)
		self.connect(self.mplayerProcess, SIGNAL('finished(int,QProcess::ExitStatus)'), self.finVideo)
		self.connect(self.timer, SIGNAL('timeout()'), self.sonderTempsActuel)
		self.connect(self.slider, SIGNAL('sliderMoved(int)'), self.changerTempsCurseur)
		self.connect(self.cibleVideo, SIGNAL('changeSize'), self.sizeMplayer)
		self.connect(self.choicenorm, SIGNAL("clicked(bool)"), self.defRatio)
		self.connect(self.choicewide, SIGNAL("clicked(bool)"), self.defRatio)
		self.connect(self.choiceone, SIGNAL("clicked(bool)"), self.defRatio)	

	def defRatio(self, state=0) :
		if state :
			if self.choicenorm.isChecked() :
				self.setRatio(4.0/3.0)
			if self.choicewide.isChecked() :
				self.setRatio(16.0/9.0)
			if self.choiceone.isChecked() :
				dim=getVideoSize(unicode(self.listeVideos[0]))
				self.setRatio(dim[0]/dim[1])
			self.defRatio()
		else :
			self.adjustSize()

	def setRatio(self,ratio) :
		self.ratio = ratio
		self.sizeMplayer()
		
	def changeRatio(self,video) :
		rv = getVideoRatio(video)
		if rv[0]==0.0 and type(rv[1])==float :
			rat = rv[1]
		else :
			rat = rv[0]

		if rat > 1.7 :
			self.choicewide.setChecked(True)
			self.setRatio(16.0/9.0)
		elif rat > 1.3 and rat <= 1.7 :
			self.choicenorm.setChecked(True)
			self.setRatio(4.0/3.0)
		elif rat < 1.3 and rat != 0.0 :
			self.choiceone.setChecked(True)
			dim=getVideoSize(video)
			self.setRatio(dim[0]/dim[1])
		else :
			self.choicenorm.setChecked(True)
			self.setRatio(4.0/3.0)
			
	def sizeMplayer(self) :
		self.cibleVideo.setFixedHeight(int(self.cibleVideo.width()/self.ratio))

	def ouvrirVideo(self):
		"""Ouverture de la boîte de dialogue de fichiers"""
		txt = u"Fichiers vidéo"
		if self.cheminPourBoutonParcourir: 
			chemin = self.cheminPourBoutonParcourir

		else:
			chemin = os.path.expanduser('~')

		liste=QFileDialog.getOpenFileNames(None, u"Ouvrir", chemin, "%s (*.avi *.mpg *.mpeg *.mjpeg *.flv *.mp4 *.ogg)\n*" %txt)
		if not liste: return
		self.listeVideos = liste
		self.changeRatio(unicode(self.listeVideos[0]))

		chemin = unicode(self.listeVideos[0])

	
	def demarrerMPlayer(self):
		"""démarrage de mplayer avec les arguments choisis"""
		if self.estLue:
			return True
		
		args = QStringList()	# Liste Qt qui contiendra les options de mplayer
					# Ajout d'options à liste: args << "-option"
		
		# mplayer fonctionnera comme un terminal dans ce script
		args << "-slave"
		# on ne veut pas avoir des commentaires sans grand intérêt
		args << "-quiet"

		# Sous linux, aucun driver n'a été nécessaire et pas de manip pour Wid :)
		if self.systeme=='posix':
			# try - except?
			# la fenêtre de mplayer restera attaché à la fenêtre
			# wid prend en valeur le nombre identifiant le widget (celui qui contiendra la vidéo)
			args << "-wid" << QString.number(self.cibleVideo.winId()) # Objet QString car args est une liste de ch de caractères
			settings = QSettings()
			videoOutput = settings.value("vo", QVariant('')).toString()
			if videoOutput:
				args << '-vo' << videoOutput
			
		# Sous windows
		else:
			# reinterpret_cast<qlonglong> obligatoire, winId() ne se laissant pas convertir gentiment ;)
			args << "-wid" << self.cibleVideo.winId().__hex__()
			args << "-vo" << "directx:noaccel"
			#args << "-vo" << "gl" # alternative

		# chemin de la vidéo
		args << self.listeVideos
		
		if PYQT_VERSION_STR >= "4.1.0":
			# mode de canal: on fusionne le canal de sortie normal (stdout) et celui des erreurs (stderr)
			self.mplayerProcess.setProcessChannelMode(QProcess.MergedChannels)
		# démarrage de mplayer (en tenant compte des arguments définis ci-dessus) 
		# comme un nouveau processus
		self.mplayerProcess.start(self.cheminMPlayer, args)
		# au cas où mplayer ne démarrerait pas au bout de 3 sec (ex. problème de codec)
		if not self.mplayerProcess.waitForStarted(3000):
			QMessageBox.critical(self, u"Avertissement", u"Bogue au lancement de la vidéo avec mplayer")
			return False
		
		# donne le temps toutes les x secondes
		self.timer.start(self.dureeTimer)
		
		self.estLue = True
		
		return True
	
	def recupSortie(self):
		"""récupère les lignes d'information émises par QProcess (mplayerProcess) et en tire les conséquences"""
		while self.mplayerProcess.canReadLine(): # renvoie True si une ligne complète peut être lue à partir du système
			# stocker l'ensemble des bits d'une ligne
			tampon=QByteArray(self.mplayerProcess.readLine()) # readline: lit une ligne ascii à partir du système
			
			#print "tampon :", tampon
			
			# On vérifie si on a eu des réponses
			if tampon.startsWith("Playing"):
				# On récupère les infos de base ('$ mplayer -input cmdlist' pour avoir la liste complète - file:///usr/share/doc/mplayer-doc/tech/slave.txt.gz pour plus de détails)
				self.mplayerProcess.write("get_video_resolution\n") # récupère la résolution de la vidéo
				self.mplayerProcess.write("get_time_length\n")
				# Nouveau fichier chargé -> on récupère son nom
				ind = tampon.length() - 2 # suppression du '.' à la fin
				tampon.remove(ind,ind)
				tampon.remove(0, 8) # vire Playing
				tampon.replace(QByteArray("\n"), QByteArray(""))
				tampon.replace(QByteArray("\r"), QByteArray(""))
				try:
					# Tour de passe-passe pour ne pas avoir de problème d'accents
					
					# Condition pour détection windows
					if os.name == 'nt': 
						self.fichierCourant[1]=unicode(QString(tampon))
					# Condition pour détection Linux ou MacOSX
					elif os.name in ['posix', 'mac']:
						self.fichierCourant[1]=unicode(QString(tampon)).encode("Latin1").decode("UTF8")
				except UnicodeEncodeError, e:
					print e
					self.fichierCourant[1]="?"
				self.cibleVideo.setToolTip(self.fichierCourant[1])
				if self.barreTaches is not None:
					self.barreTaches.showMessage(self.fichierCourant[1])
			
			# réponse à get_video_resolution : ANS_VIDEO_RESOLUTION='<width> x <height>'
			if tampon.startsWith("ANS_VIDEO_RESOLUTION"): # retourne True si l'ensemble de bits démarre avec "..."
				print "tampon :",tampon # ex. -> ANS_VIDEO_RESOLUTION='352 x 288'
				tampon.remove(0, 21) # suppression des 21 1er caract -> '352 x 288'
				tampon.replace(QByteArray("'"), QByteArray("")) # -> 352 x 288
				tampon.replace(QByteArray(" "), QByteArray("")) # -> 352x288
				tampon.replace(QByteArray("\n"), QByteArray("")) # -> 352x288 # retour chariot unix
				tampon.replace(QByteArray("\r"), QByteArray("")) # -> 352x288 # retour chariot windows
				#print "-----tampon.indexOf('x') :", tampon.indexOf('x'), type(tampon.indexOf('x'))
				sepIndex = tampon.indexOf('x') # récupère la position de 'x' # 3 <type 'int'>
				#print "-----tampon.left(sepIndex).toInt():", tampon.left(sepIndex).toInt(), type(tampon.left(sepIndex).toInt())
				resX = tampon.left(sepIndex).toInt()[0] # -> 352 # (352, True) <type 'tuple'>
				#print "-----tampon.mid(sepIndex+1).toInt() :", tampon.mid(sepIndex+1).toInt(), type(tampon.mid(sepIndex+1).toInt())
				resY = tampon.mid(sepIndex+1).toInt()[0] # -> 288 # (288, True) <type 'tuple'>
				
				# on définit les nouvelles dimensions de l'image du widget-mplayer.
				# try pour éviter les bogues sur les fichiers audio (sans dimension d'image)!!!
				#try:
				if resX!=0 or resY!=0:
					print "ratio :", self.ratio, type(self.ratio)
				else:
					print "fichier audio"
			
			# réponse à get_time_length : ANS_LENGTH=xx.yy
			elif tampon.startsWith("ANS_LENGTH"):
				print "tampon :",tampon # -> ANS_LENGTH=279.38
				tampon.remove(0, 11) # vire ANS_LENGTH=
				tampon.replace(QByteArray("'"), QByteArray(""))
				tampon.replace(QByteArray(" "), QByteArray(""))
				tampon.replace(QByteArray("\n"), QByteArray(""))
				tampon.replace(QByteArray("\r"), QByteArray("")) # -> 279.38
				#print "-----tampon.toFloat() :", tampon.toFloat(), type(tampon.toFloat())
				tempsMax = tampon.toFloat()[0] # (279.3800048828125, True) <type 'tuple'>
				self.dureeVideo = tempsMax
				## Modifié le 28/05/2009 : On augmente la précision du slider
				#self.slider.setMaximum(tempsMax) # déf du domaine de valeur du curseur
				self.slider.setMaximum(tempsMax*self.echelle)
				
				# ATTENTION J'AI COMMENTE CETTE LIGNE !!!
				#self.slider.setMaximum(tempsMax)
			
			# réponse à get_time_pos : ANS_TIME_POSITION=xx.y
			elif tampon.startsWith("ANS_TIME_POSITION"):
				#print "tampon :",tampon # -> ANS_TIME_POSITION=1.4 (temps courant)
				tampon.remove(0, 18) # vire ANS_TIME_POSITION=
				tampon.replace(QByteArray("'"), QByteArray(""))
				tampon.replace(QByteArray(" "), QByteArray(""))
				tampon.replace(QByteArray("\n"), QByteArray(""))
				tampon.replace(QByteArray("\r"), QByteArray(""))
				#print "-----tampon.toFloat() :", tampon.toFloat(), type(tampon.toFloat())
				tempsCourant = tampon.toFloat()[0] # (1.3999999761581421, True) <type 'tuple'>
				# récupération du temps courant: utile dans certains cadres
				self.temps = tempsCourant
				# Programmer un arrêt. Utile pour les aperçus
				#print "self.temps", self.temps, type(self.temps)
				#print "self.debutFin", self.debutFin[1], type(self.debutFin[1])
				temps = float("%.1f" %self.temps)
				#print "temps", temps, type(temps), '\n'
				if self.debutFin!=(0,0) and self.debutFin[1]==temps:
					self.arretMPlayer()
					return
				## Modifié le 28/05/2009 : On augmente la précision du slider ###############
				#self.slider.setValue(tempsCourant) # aller au temps courant
				self.slider.setValue(tempsCourant*self.echelle)
				#############################################################################
				self.changerTempsChrono(tempsCourant) # modifier le chrono du bouton
	
	
	def sonderTempsActuel(self):
		"""envoie le temps correspondant à la position de la vidéo dans le tampon"""
		self.mplayerProcess.write("get_time_pos\n")
	
	def changerTempsCurseur(self, pos):
		"""change la partie de la vidéo qui sera lue"""
		# on arrête le temps pendant le changement de position de la vidéo 
		# sinon le curseur ne bouge plus
		self.timer.stop()
		self.mplayerProcess.write("seek " + str(pos/self.echelle) + " 2\n") 

		#self.mplayerProcess.write(QString("seek " + QString.number(pos) + " 2\n").toUtf8()) # anciennement
		self.timer.start()
		self.estLue, self.estEnPause = True, False
		self.bout_LectPause.setIcon(self.icone_pause)
		
	
	def changerTempsChrono(self,nvTemps):
		"""affichage du temps sous la forme h:mm:ss:ms dans un bouton"""
		temps0 = QTime(0, 0, 0)
		## Modifié le 28/05/2009 : On augemente la précision, on ajoute les milisecondes au lieu des secondes #####
		#temps = temps0.addSecs(nvTemps)
		temps = temps0.addMSecs(nvTemps*self.echelle)
		###########################################################################################################
		mn = str(temps.minute()).zfill(2)
		s = str(temps.second()).zfill(2)
		ms = str(temps.msec()).zfill(3)
		chrono = str(temps.hour())+':'+mn+':'+s+':'+ms
		self.tempsChrono.num = chrono
		self.tempsChrono.repaint()
		###########################################################################################################
	
	
	def precedent(self):
		"""affiche la vidéo précédente"""
		if self.estLue:
			self.mplayerProcess.write("pt_step -1\n")
			self.estEnPause = False
			self.bout_LectPause.setIcon(self.icone_pause)
	
	
	def suivant(self):
		"""affiche la vidéo suivante"""
		if self.estLue:
			self.mplayerProcess.write("pt_step 1\n")
			self.estEnPause = False
			self.bout_LectPause.setIcon(self.icone_pause)
	
	
	def lectPause(self):
		"""lecture/pause de la vidéo avec mplayer"""
		if not self.estLue:
			if not self.demarrerMPlayer(): # lecture de la vidéo
				return # au cas où mplayer ne démarrerait pas au bout de 3 sec (ex. problème de codec)
			self.estLue, self.estEnPause = True, False
			self.bout_LectPause.setIcon(self.icone_pause)
			self.slider.setEnabled(True) # évite un bogue
			if self.debutFin!=(0,0) and self.debutFin[0]!= 0:
				self.mplayerProcess.write("seek " + str(self.debutFin[0]) + " 2\n")
		elif self.estLue and not self.estEnPause: # lecture -> pause
			self.mplayerProcess.write("pause\n")
			self.timer.stop()
			self.bout_LectPause.setIcon(self.icone_lire)
			self.slider.setEnabled(True) # évite un bogue
			self.estLue, self.estEnPause = True, True
		elif self.estLue and self.estEnPause: # pause -> lecture
			# prévoir le cas où mplayer ne se mettrait pas en pause au bout de 3 sec
			self.timer.start()
			self.bout_LectPause.setIcon(self.icone_pause)
			self.slider.setEnabled(True) # évite un bogue
			self.estLue, self.estEnPause = True, False
	
	
	def arretMPlayer(self):
		""""Arrete la lecture de la vidéo et réinitialise les icones et variables"""
		if self.mplayerProcess.state() == QProcess.NotRunning: # ajouté pour ne pas avoir de bogue à la fin de la lecture de la vidéo.
    			return True
		
		self.mplayerProcess.write("quit\n") # arrêt de la vidéo
		
		# au cas où mplayer ne s'arrêterait pas au bout de 3 sec
		if not self.mplayerProcess.waitForFinished(3000):
			QMessageBox.critical(self, u"Avertissement", u"Bogue à la tentative d'arrêt de la vidéo avec mplayer")
			return False
		
		self.slider.setEnabled(False) # évite un bogue
		#self.slider.setEnabled(True)
		
		#self.tempsChrono.num = "0:00:00"
		self.tempsChrono.raz()

		self.tempsChrono.repaint()
		self.slider.setValue(0)
		self.estLue, self.estEnPause = False, False
		self.bout_LectPause.setIcon(self.icone_lire)
		return True
	
	def finVideo(self, statutDeSortie, codeSortie):
		"""On change certaines variables à la fin de vidéo"""
		# d'après ce que j'ai compris: récupération du statut de sortie (0: normal ; 1: crash)
		#  pas de récupération du code de sortie (de toute façon je vois pas trop à quoi il servirait)
		if statutDeSortie==1:
			print "Crash de mplayer lors de la fin de la lecture de la vidéo"
		self.estLue, self.estEnPause = False, False
		self.bout_LectPause.setIcon(self.icone_lire)
		self.timer.stop()
		self.slider.setEnabled(False) # évite un bogue
		#self.slider.setEnabled(True)
		self.cibleVideo.setToolTip(self.fichierCourant[0])
		if self.barreTaches is not None:
			self.barreTaches.clearMessage()


