/*
		       Texture Browser Callbacks
 */

#ifndef TEXBROWSERCB_H
#define TEXBROWSERCB_H

#include <sys/types.h>
#include <gtk/gtk.h>


extern gbool TexBrowserMatchParmFromLine(const char *line, const char *parm);

extern void TexBrowserListFetch(
	ma_texture_browser_struct *tb,
	void *editor
);
extern int TexBrowserListDoFind( 
	ma_texture_browser_struct *tb,
	const char *string,
	const char *type,
	gbool find_exact,
	gbool find_casesensitive
);
extern void TexBrowserListDeleteAll(ma_texture_browser_struct *tb);

extern void TexBrowserRecordPositionsCB(ma_texture_browser_struct *tb);

extern gint TexBrowserEventCB(GtkWidget *widget, gpointer event, gpointer data);
extern gint TexBrowserPreviewEventCB(
	GtkWidget *widget, gpointer event, gpointer data
);
extern void TexBrowserPreviewScrollCB(GtkAdjustment *adj, gpointer data);
extern void TexBrowserPreviewScrollCB(GtkAdjustment *adj, gpointer data);
extern void TexBrowserZoomInPressedCB(GtkWidget *widget, gpointer data);
extern void TexBrowserZoomInReleasedCB(GtkWidget *widget, gpointer data);
extern void TexBrowserZoomOutPressedCB(GtkWidget *widget, gpointer data);
extern void TexBrowserZoomOutReleasedCB(GtkWidget *widget, gpointer data);
extern gint TexBrowserZoomInTimeOutCB(gpointer data);
extern gint TexBrowserZoomOutTimeOutCB(gpointer data);
extern void TexBrowserZoomOneToOneCB(GtkWidget *widget, gpointer data);
extern void TexBrowserZoomToFitCB(GtkWidget *widget, gpointer data);

extern void TexBrowserDestroyCB(GtkObject *object, gpointer data);
extern gint TexBrowserCloseCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void TexBrowserCloseMCB(GtkWidget *widget, gpointer data);
extern void TexBrowserBrowseBaseDirCB(GtkWidget *widget, gpointer data);
extern void TexBrowserOverrideCheckCB(GtkWidget *widget, gpointer data);
extern void TexBrowserReloadCB(GtkWidget *widget, gpointer data);
extern void TexBrowserEnterCB(GtkWidget *widget, gpointer data);

extern void TexBrowserSortMCB(GtkWidget *widget, gpointer data);

extern void TexBrowserSelectAllCB(GtkWidget *widget, gpointer data);
extern void TexBrowserUnselectAllCB(GtkWidget *widget, gpointer data);
extern void TexBrowserListSelectCB(
	GtkWidget *widget,
	gint row,
	gint column,
	GdkEventButton *event,
	gpointer data
);
extern void TexBrowserListUnselectCB(
	GtkWidget *widget,
	gint row,
	gint column,
	GdkEventButton *event,
	gpointer data
);
extern void TexBrowserListColumClickCB(
	GtkWidget *widget,
	gint column,
	gpointer data
);
extern gint TexBrowserMenuMapCB(
	GtkWidget *widget, gpointer event, gpointer data
);
extern void TexBrowserCloseOnSelectCheckCB(GtkWidget *widget, gpointer data);

extern void TexBrowserAddTextureCB(GtkWidget *widget, gpointer data);
extern void TexBrowserRemoveTextureCB(GtkWidget *widget, gpointer data);
extern void TexBrowserEditPropertiesCB(GtkWidget *widget, gpointer data);
extern void TexBrowserSelectTextureCB(GtkWidget *widget, gpointer data);


#endif	/* TEXBROWSERCB_H */
