/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.util;

import fr.jayasoft.ivy.util.MessageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Message {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static MessageImpl _impl = null;
    private static StringBuffer _problems = new StringBuffer();
    private static boolean _showProgress = true;
    private static boolean _showedInfo = false;

    public static void init(MessageImpl impl) {
        _impl = impl;
        Message.showInfo();
    }

    public static boolean isInitialised() {
        return _impl != null;
    }

    private static void showInfo() {
        if (!_showedInfo) {
            Properties props = new Properties();
            InputStream module = Message.class.getResourceAsStream("/module.properties");
            if (module != null) {
                try {
                    props.load(module);
                    Message.info(":: Ivy " + props.getProperty("version") + " - " + props.getProperty("date") + " :: http://ivy.jayasoft.org/ ::");
                }
                catch (IOException e) {
                    Message.info(":: Ivy non official version :: http://ivy.jayasoft.org/ ::");
                }
            } else {
                Message.info(":: Ivy non official version :: http://ivy.jayasoft.org/ ::");
            }
            _showedInfo = true;
        }
    }

    public static void debug(String msg) {
        if (_impl != null) {
            _impl.log(msg, 4);
        } else {
            System.err.println(msg);
        }
    }

    public static void verbose(String msg) {
        if (_impl != null) {
            _impl.log(msg, 3);
        } else {
            System.err.println(msg);
        }
    }

    public static void info(String msg) {
        if (_impl != null) {
            _impl.log(msg, 2);
        } else {
            System.err.println(msg);
        }
    }

    public static void warn(String msg) {
        if (_impl != null) {
            _impl.log("WARN: " + msg, 3);
        } else {
            System.err.println(msg);
        }
        _problems.append("\tWARN:  " + msg).append("\n");
    }

    public static void error(String msg) {
        if (_impl != null) {
            _impl.log("ERROR: " + msg, 3);
        } else {
            System.err.println(msg);
        }
        _problems.append("\tERROR: " + msg).append("\n");
    }

    public static void sumupProblems() {
        if (_problems.length() > 0) {
            Message.info("\n:: problems summary ::");
            Message.info(_problems.toString());
            Message.info("\t--- USE VERBOSE OR DEBUG MESSAGE LEVEL FOR MORE DETAILS ---");
            _problems = new StringBuffer();
        }
    }

    public static void progress() {
        if (_showProgress) {
            if (_impl != null) {
                _impl.progress();
            } else {
                System.out.println(".");
            }
        }
    }

    public static void endProgress() {
        Message.endProgress("");
    }

    public static void endProgress(String msg) {
        if (_showProgress && _impl != null) {
            _impl.endProgress(msg);
        }
    }

    public static boolean isShowProgress() {
        return _showProgress;
    }

    public static void setShowProgress(boolean progress) {
        _showProgress = progress;
    }

    public static void uninit() {
        _impl = null;
    }
}

