/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.xml.XmlReportParser;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;

public class IvyArtifactProperty
extends IvyTask {
    private String _conf;
    private String _name;
    private String _value;
    private String _organisation;
    private String _module;
    private boolean _haltOnFailure = true;
    private File _cache;

    public String getConf() {
        return this._conf;
    }

    public void setConf(String conf) {
        this._conf = conf;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public boolean isHaltonfailure() {
        return this._haltOnFailure;
    }

    public void setHaltonfailure(boolean haltOnFailure) {
        this._haltOnFailure = haltOnFailure;
    }

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public void execute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        this.ensureResolved(this.isHaltonfailure(), this.getOrganisation(), this.getModule());
        this._conf = this.getProperty(this._conf, ivy, "ivy.resolved.configurations");
        if ("*".equals(this._conf)) {
            this._conf = this.getProperty(ivy, "ivy.resolved.configurations");
            if (this._conf == null) {
                throw new BuildException("bad provided for ivy artifactproperty: * can only be used with a prior call to <resolve/>");
            }
        }
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy artifactproperty: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy artifactproperty: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this._conf == null) {
            throw new BuildException("no conf provided for ivy artifactproperty: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        try {
            XmlReportParser parser = new XmlReportParser();
            String[] confs = this.splitConfs(this._conf);
            HashSet<Artifact> all = new HashSet<Artifact>();
            for (int i = 0; i < confs.length; ++i) {
                Artifact[] artifacts = parser.getArtifacts(new ModuleId(this._organisation, this._module), confs[i], this._cache);
                all.addAll(Arrays.asList(artifacts));
            }
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                String name = IvyPatternHelper.substitute(ivy.substitute(this.getName()), artifact);
                String value = IvyPatternHelper.substitute(ivy.substitute(this.getValue()), artifact);
                this.getProject().setProperty(name, value);
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to add artifact properties: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

