/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.mif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.dom.svg.SVGArea;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.mif.MIFDocument;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.mif.FontSetup;

public class MIFRenderer
implements Renderer {
    private String currentFontName;
    private String currentFontSize;
    private int pageHeight;
    private int pageWidth;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;
    protected MIFDocument mifDoc = new MIFDocument();
    private boolean inTable = false;

    private void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        ColorType colorType = area.getBackgroundColor();
        n -= area.getPaddingLeft();
        n4 += area.getPaddingTop();
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        n2 = n2 + area.borderWidthLeft + area.borderWidthRight;
        n3 = n3 + area.borderWidthTop + area.borderWidthBottom;
        this.mifDoc.setTextRectProp(n -= area.borderWidthLeft, this.pageHeight - (n4 += area.borderWidthTop), n2, n3);
    }

    public void render(AreaTree areaTree, OutputStream outputStream) throws IOException, FOPException {
        MessageHandler.logln("rendering areas to MIF");
        Enumeration enumeration = areaTree.getPages().elements();
        while (enumeration.hasMoreElements()) {
            this.renderPage((Page)enumeration.nextElement());
        }
        this.mifDoc.output(outputStream);
        outputStream.close();
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        int n;
        int n2;
        if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table") {
            this.mifDoc.createTable();
            this.inTable = true;
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-body") {
            this.mifDoc.setCurrent("fo:table-body");
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-column") {
            n2 = ((TableColumn)areaContainer.foCreator).getColumnWidth();
            this.mifDoc.setColumnProp(n2);
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-row") {
            this.mifDoc.startRow();
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-cell") {
            n2 = ((TableCell)areaContainer.foCreator).getNumRowsSpanned();
            n = ((TableCell)areaContainer.foCreator).getNumColumnsSpanned();
            this.mifDoc.startCell(n2, n);
        } else if (this.inTable) {
            this.inTable = false;
            this.mifDoc.endTable();
        }
        n2 = this.currentYPosition;
        n = this.currentAreaContainerXPosition;
        if (areaContainer.getPosition() == 3) {
            this.currentYPosition = areaContainer.getYPosition() - 2 * areaContainer.getPaddingTop() - 2 * areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition = areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 2) {
            this.currentYPosition -= areaContainer.getYPosition();
            this.currentAreaContainerXPosition += areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 1) {
            this.currentYPosition -= areaContainer.getPaddingTop() + areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition += areaContainer.getPaddingLeft() + areaContainer.borderWidthLeft;
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        this.doFrame(areaContainer);
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (areaContainer.getPosition() != 1) {
            this.currentYPosition = n2;
            this.currentAreaContainerXPosition = n;
        } else {
            this.currentYPosition -= areaContainer.getHeight();
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.mifDoc.setBlockProp(blockArea.getStartIndent(), blockArea.getEndIndent());
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderBodyAreaContainer(BodyAreaContainer bodyAreaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (bodyAreaContainer.getPosition() == 3) {
            this.currentYPosition = bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition = bodyAreaContainer.getXPosition();
        } else if (bodyAreaContainer.getPosition() == 2) {
            this.currentYPosition -= bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition += bodyAreaContainer.getXPosition();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        int n3 = this.currentAreaContainerXPosition;
        int n4 = bodyAreaContainer.getContentWidth();
        int n5 = bodyAreaContainer.getContentHeight();
        int n6 = this.currentYPosition;
        ColorType colorType = bodyAreaContainer.getBackgroundColor();
        Enumeration enumeration = bodyAreaContainer.getMainReferenceArea().getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (bodyAreaContainer.getPosition() != 1) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= bodyAreaContainer.getHeight();
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage instanceof SVGImage) {
            MessageHandler.logln("Warning: SVG images not supported in this version");
        } else {
            String string = fopImage.getURL();
            this.mifDoc.addImage(string, n, this.pageHeight - n2, n3, n4);
        }
    }

    public void renderInlineArea(InlineArea inlineArea) {
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        String string = " ";
        this.mifDoc.addToStream(string);
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        this.mifDoc.startLine();
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            this.currentYPosition = n2 - lineArea.getPlacementOffset();
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
        this.currentXPosition = n;
    }

    public void renderPage(Page page) {
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = "0";
        this.pageHeight = page.getHeight();
        this.pageWidth = page.getWidth();
        this.mifDoc.setDocumentHeightWidth(this.pageHeight, this.pageWidth);
        this.mifDoc.createPage();
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.mifDoc.createTextRect(1);
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.mifDoc.createTextRect(1);
            this.renderAreaContainer(areaContainer2);
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
    }

    public void renderSpanArea(SpanArea spanArea) {
        this.mifDoc.createTextRect(spanArea.getColumnCount());
        Enumeration enumeration = spanArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderWordArea(WordArea wordArea) {
        String string = wordArea.getText();
        this.mifDoc.addToStream(string);
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setProducer(String string) {
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
    }
}

