/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import org.apache.fop.pdf.PDFFilter;

public class ASCII85Filter
extends PDFFilter {
    private static final char ASCII85_ZERO = 'z';
    private static final char ASCII85_START = '!';
    private static final String ASCII85_EOD = "~>";
    private static final long base85_4 = 85L;
    private static final long base85_3 = 7225L;
    private static final long base85_2 = 614125L;
    private static final long base85_1 = 52200625L;

    private byte[] convertWord(long l) {
        if ((l &= 0xFFFFFFFFFFFFFFFFL) < 0L) {
            l = -l;
        }
        if (l == 0L) {
            byte[] byArray = new byte[]{122};
            return byArray;
        }
        byte by = (byte)(l / 52200625L & 0xFFL);
        byte by2 = (byte)((l - (long)by * 52200625L) / 614125L & 0xFFL);
        byte by3 = (byte)((l - (long)by * 52200625L - (long)by2 * 614125L) / 7225L & 0xFFL);
        byte by4 = (byte)((l - (long)by * 52200625L - (long)by2 * 614125L - (long)by3 * 7225L) / 85L & 0xFFL);
        byte by5 = (byte)(l - (long)by * 52200625L - (long)by2 * 614125L - (long)by3 * 7225L - (long)by4 * 85L & 0xFFL);
        byte[] byArray = new byte[]{(byte)(by + 33), (byte)(by2 + 33), (byte)(by3 + 33), (byte)(by4 + 33), (byte)(by5 + 33)};
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] < 33 || byArray[n] > 117) {
                System.out.println("illegal char value " + new Integer(byArray[n]));
            }
            ++n;
        }
        return byArray;
    }

    public byte[] encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n + 3 < byArray.length) {
            long l = ((long)(byArray[n] << 24) & 0xFF000000L) + ((long)(byArray[n + 1] << 16) & 0xFF0000L) + ((long)(byArray[n + 2] << 8) & 0xFF00L) + ((long)byArray[n + 3] & 0xFFL);
            byte[] byArray2 = this.convertWord(l);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            n += 4;
        }
        if (n < byArray.length) {
            int n2 = byArray.length - n;
            byte[] byArray3 = new byte[4];
            int n3 = 0;
            while (n3 < 4) {
                byArray3[n3] = n3 < n2 ? byArray[n++] : (byte)0;
                ++n3;
            }
            long l = ((long)(byArray3[0] << 24) & 0xFF000000L) + ((long)(byArray3[1] << 16) & 0xFF0000L) + ((long)(byArray3[2] << 8) & 0xFF00L) + ((long)byArray3[3] & 0xFFL);
            byte[] byArray4 = this.convertWord(l);
            if (l == 0L) {
                byArray4 = new byte[5];
                int n4 = 0;
                while (n4 < 5) {
                    byArray4[n4] = 33;
                    ++n4;
                }
            }
            byteArrayOutputStream.write(byArray4, 0, n2 + 1);
        }
        byteArrayOutputStream.write(ASCII85_EOD.getBytes(), 0, ASCII85_EOD.getBytes().length);
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        return byArray5;
    }

    public String getDecodeParms() {
        return null;
    }

    public String getName() {
        return "/ASCII85Decode";
    }
}

