/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.image.analyser.ImageReaderFactory;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFFilter;

public abstract class AbstractFopImage
implements FopImage {
    protected int m_width = 0;
    protected int m_height = 0;
    protected URL m_href = null;
    protected ImageReader m_imageReader = null;
    protected ColorSpace m_colorSpace = null;
    protected int m_bitsPerPixel = 0;
    protected byte[] m_bitmaps = null;
    protected int m_bitmapsSize = 0;
    protected boolean m_isTransparent = false;
    protected PDFColor m_transparentColor = null;

    public AbstractFopImage(URL uRL) throws FopImageException {
        this.m_href = uRL;
        try {
            this.m_imageReader = ImageReaderFactory.Make(this.m_href.openStream());
        }
        catch (Exception exception) {
            throw new FopImageException(exception.getMessage());
        }
        this.m_width = this.m_imageReader.getWidth();
        this.m_height = this.m_imageReader.getHeight();
    }

    public AbstractFopImage(URL uRL, ImageReader imageReader) throws FopImageException {
        this.m_href = uRL;
        this.m_imageReader = imageReader;
        this.m_width = this.m_imageReader.getWidth();
        this.m_height = this.m_imageReader.getHeight();
    }

    public void close() {
        this.m_bitmaps = null;
        this.m_bitmapsSize = 0;
    }

    public byte[] getBitmaps() throws FopImageException {
        if (this.m_bitmaps == null) {
            this.loadImage();
        }
        return this.m_bitmaps;
    }

    public int getBitmapsSize() throws FopImageException {
        if (this.m_bitmapsSize == 0) {
            this.loadImage();
        }
        return this.m_bitmapsSize;
    }

    public int getBitsPerPixel() throws FopImageException {
        if (this.m_bitsPerPixel == 0) {
            this.loadImage();
        }
        return this.m_bitsPerPixel;
    }

    public ColorSpace getColorSpace() throws FopImageException {
        if (this.m_colorSpace == null) {
            this.loadImage();
        }
        return this.m_colorSpace;
    }

    public int getHeight() throws FopImageException {
        if (this.m_height == 0) {
            this.loadImage();
        }
        return this.m_height;
    }

    public PDFFilter getPDFFilter() throws FopImageException {
        return null;
    }

    public byte[] getRessourceBytes() throws FopImageException {
        return null;
    }

    public int getRessourceBytesSize() throws FopImageException {
        return 0;
    }

    public PDFColor getTransparentColor() throws FopImageException {
        return this.m_transparentColor;
    }

    public String getURL() {
        return this.m_href.toString();
    }

    public int getWidth() throws FopImageException {
        if (this.m_width == 0) {
            this.loadImage();
        }
        return this.m_width;
    }

    public boolean isTransparent() throws FopImageException {
        return this.m_isTransparent;
    }

    protected abstract void loadImage() throws FopImageException;
}

