;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: vcs-tree-system -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:    vcs-tree.asd
;;;; Purpose: ASDF file for vcs-tree to create executable
;;;; Author:  Kevin M. Rosenberg
;;;; Created: Sep 2003
;;;;
;;;; $Id$
;;;; *************************************************************************

(in-package cl-user)
(defpackage vcs-tree-system
  (:use #:cl #:asdf)
  (:export save-executable))
(in-package vcs-tree-system)

(defun save-executable (&optional (fname "_vcs-tree"))
  (setq cl:*print-pretty* nil)
  (sb-ext:save-lisp-and-die
   fname
   :executable t
   :toplevel (lambda ()
               (handler-case
                   (funcall (intern (symbol-name '#:main)
                                    (find-package (symbol-name '#:vcs-tree)))
                            (list* "vcs-tree" (cdr sb-ext:*posix-argv*)))
                 (error (c)
                   (format *error-output* "vcs-tree failed due to error:~%  ~A~%" c)
                   (sb-ext:quit :unix-status 1)))
               (sb-ext:quit :unix-status 0))))

(defsystem vcs-tree
  :version "0.3"
  :components ((:file "package")
	       (:file "kmrcl-excerpt" :depends-on ("package"))
	       (:file "getopt-excerpt" :depends-on ("package"))
	       (:file "main" :depends-on ("kmrcl-excerpt" "getopt-excerpt"))))

