/* vtgsourcebookmarks.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgsourcebookmarks.vala, do not modify */

/*
 *  vtgsourcebookmarks.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <gedit/gedit-document.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-tab.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#define VTG_TYPE_SOURCE_BOOKMARKS (vtg_source_bookmarks_get_type ())
#define VTG_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarks))
#define VTG_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))
#define VTG_IS_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_IS_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_SOURCE_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))

typedef struct _VtgSourceBookmarks VtgSourceBookmarks;
typedef struct _VtgSourceBookmarksClass VtgSourceBookmarksClass;
typedef struct _VtgSourceBookmarksPrivate VtgSourceBookmarksPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_SOURCE_BOOKMARK (vtg_source_bookmark_get_type ())
#define VTG_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmark))
#define VTG_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))
#define VTG_IS_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_IS_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_SOURCE_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))

typedef struct _VtgSourceBookmark VtgSourceBookmark;
typedef struct _VtgSourceBookmarkClass VtgSourceBookmarkClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _VtgSourceBookmarkPrivate VtgSourceBookmarkPrivate;
#define _vtg_source_bookmark_unref0(var) ((var == NULL) ? NULL : (var = (vtg_source_bookmark_unref (var), NULL)))

struct _VtgSourceBookmarks {
	GObject parent_instance;
	VtgSourceBookmarksPrivate * priv;
};

struct _VtgSourceBookmarksClass {
	GObjectClass parent_class;
};

struct _VtgSourceBookmarksPrivate {
	VtgPluginInstance* _plugin_instance;
	gulong signal_id;
	ValaList* _bookmarks;
	gint _current_bookmark_index;
	gboolean _in_move;
	GeditDocument* _idle_add_doc;
};

struct _VtgSourceBookmark {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VtgSourceBookmarkPrivate * priv;
	char* uri;
	gint line;
	gint column;
};

struct _VtgSourceBookmarkClass {
	GTypeClass parent_class;
	void (*finalize) (VtgSourceBookmark *self);
};


static gpointer vtg_source_bookmarks_parent_class = NULL;
static GType vtg_source_bookmarks_type_id = 0;

GType vtg_source_bookmarks_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmarks_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
gpointer vtg_source_bookmark_ref (gpointer instance);
void vtg_source_bookmark_unref (gpointer instance);
GParamSpec* vtg_param_spec_source_bookmark (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vtg_value_set_source_bookmark (GValue* value, gpointer v_object);
void vtg_value_take_source_bookmark (GValue* value, gpointer v_object);
gpointer vtg_value_get_source_bookmark (const GValue* value);
GType vtg_source_bookmark_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmark_register_type (GTypeModule * module);
#define VTG_SOURCE_BOOKMARKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksPrivate))
enum  {
	VTG_SOURCE_BOOKMARKS_DUMMY_PROPERTY,
	VTG_SOURCE_BOOKMARKS_PLUGIN_INSTANCE,
	VTG_SOURCE_BOOKMARKS_IS_EMPTY
};
#define VTG_SOURCE_BOOKMARKS_MAX_BOOKMARKS 20
VtgSourceBookmarks* vtg_source_bookmarks_new (VtgPluginInstance* plugin_instance);
VtgSourceBookmarks* vtg_source_bookmarks_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void vtg_source_bookmarks_on_tab_changed (GeditWindow* sender, GeditTab* tab, VtgSourceBookmarks* instance);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
gboolean vtg_project_manager_contains_vala_source_file (VtgProjectManager* self, const char* uri);
gboolean vtg_source_bookmarks_on_idle_bookmark_add (VtgSourceBookmarks* self);
static gboolean _vtg_source_bookmarks_on_idle_bookmark_add_gsource_func (gpointer self);
VtgSourceBookmark* vtg_source_bookmark_new (void);
VtgSourceBookmark* vtg_source_bookmark_construct (GType object_type);
void vtg_source_bookmarks_add_bookmark (VtgSourceBookmarks* self, VtgSourceBookmark* item, gboolean _auto_);
gboolean vtg_source_bookmarks_get_is_empty (VtgSourceBookmarks* self);
VtgSourceBookmark* vtg_source_bookmarks_get_current_bookmark (VtgSourceBookmarks* self);
void vtg_source_bookmarks_move_next (VtgSourceBookmarks* self);
void vtg_source_bookmarks_move_previous (VtgSourceBookmarks* self);
VtgPluginInstance* vtg_source_bookmarks_get_plugin_instance (VtgSourceBookmarks* self);
static void vtg_source_bookmarks_set_plugin_instance (VtgSourceBookmarks* self, VtgPluginInstance* value);
static void vtg_source_bookmarks_finalize (GObject* obj);
static void vtg_source_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_source_bookmarks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


VtgSourceBookmarks* vtg_source_bookmarks_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgSourceBookmarks * self;
	GeditWindow* window;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgSourceBookmarks*) g_object_new (object_type, "plugin-instance", plugin_instance, NULL);
	window = _g_object_ref0 (vtg_plugin_instance_get_window (self->priv->_plugin_instance));
	self->priv->signal_id = g_signal_connect (window, "active_tab_changed", (GCallback) vtg_source_bookmarks_on_tab_changed, self);
	_g_object_unref0 (window);
	return self;
}


VtgSourceBookmarks* vtg_source_bookmarks_new (VtgPluginInstance* plugin_instance) {
	return vtg_source_bookmarks_construct (VTG_TYPE_SOURCE_BOOKMARKS, plugin_instance);
}


static gboolean _vtg_source_bookmarks_on_idle_bookmark_add_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_source_bookmarks_on_idle_bookmark_add (self);
	return result;
}


static void vtg_source_bookmarks_on_tab_changed (GeditWindow* sender, GeditTab* tab, VtgSourceBookmarks* instance) {
	GeditDocument* doc;
	char* uri;
	VtgProjectManager* prj;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (tab != NULL);
	g_return_if_fail (instance != NULL);
	doc = _g_object_ref0 (gedit_tab_get_document (tab));
	uri = g_strdup (gedit_document_get_uri (doc));
	prj = _g_object_ref0 (vtg_project_view_get_current_project (vtg_plugin_instance_get_project_view (instance->priv->_plugin_instance)));
	if (prj != NULL) {
		_tmp0_ = vtg_project_manager_contains_vala_source_file (prj, uri);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeditDocument* _tmp1_;
		instance->priv->_idle_add_doc = (_tmp1_ = _g_object_ref0 (doc), _g_object_unref0 (instance->priv->_idle_add_doc), _tmp1_);
		g_idle_add_full (G_PRIORITY_LOW, _vtg_source_bookmarks_on_idle_bookmark_add_gsource_func, g_object_ref (instance), g_object_unref);
	} else {
		GeditDocument* _tmp2_;
		instance->priv->_idle_add_doc = (_tmp2_ = NULL, _g_object_unref0 (instance->priv->_idle_add_doc), _tmp2_);
	}
	_g_object_unref0 (prj);
	_g_free0 (uri);
	_g_object_unref0 (doc);
}


gboolean vtg_source_bookmarks_on_idle_bookmark_add (VtgSourceBookmarks* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_idle_add_doc != NULL) {
		char* uri;
		VtgProjectManager* prj;
		gboolean _tmp0_ = FALSE;
		uri = g_strdup (gedit_document_get_uri (self->priv->_idle_add_doc));
		prj = _g_object_ref0 (vtg_project_view_get_current_project (vtg_plugin_instance_get_project_view (self->priv->_plugin_instance)));
		if (prj != NULL) {
			_tmp0_ = vtg_project_manager_contains_vala_source_file (prj, uri);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GtkTextMark* mark;
			GtkTextIter start = {0};
			gint line;
			gint col;
			VtgSourceBookmark* book;
			char* _tmp1_;
			mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) self->priv->_idle_add_doc));
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_idle_add_doc, &start, mark);
			line = gtk_text_iter_get_line (&start);
			col = gtk_text_iter_get_line_offset (&start);
			book = vtg_source_bookmark_new ();
			book->uri = (_tmp1_ = g_strdup (uri), _g_free0 (book->uri), _tmp1_);
			book->line = line + 1;
			book->column = col + 1;
			vtg_source_bookmarks_add_bookmark (self, book, TRUE);
			_vtg_source_bookmark_unref0 (book);
		}
		_g_object_unref0 (prj);
		_g_free0 (uri);
	}
	result = FALSE;
	return result;
}


void vtg_source_bookmarks_add_bookmark (VtgSourceBookmarks* self, VtgSourceBookmark* item, gboolean _auto_) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (self->priv->_in_move) {
		return;
	}
	if (_auto_) {
		_tmp0_ = !vtg_source_bookmarks_get_is_empty (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint idx;
		idx = 0;
		{
			ValaIterator* _book_it;
			_book_it = vala_iterable_iterator ((ValaIterable*) self->priv->_bookmarks);
			while (TRUE) {
				VtgSourceBookmark* book;
				if (!vala_iterator_next (_book_it)) {
					break;
				}
				book = (VtgSourceBookmark*) vala_iterator_get (_book_it);
				if (_vala_strcmp0 (book->uri, item->uri) == 0) {
					self->priv->_current_bookmark_index = idx;
					book->line = item->line;
					book->column = item->column;
					_vtg_source_bookmark_unref0 (book);
					_vala_collection_object_unref0 (_book_it);
					return;
				}
				idx++;
				_vtg_source_bookmark_unref0 (book);
			}
			_vala_collection_object_unref0 (_book_it);
		}
	}
	if (self->priv->_current_bookmark_index >= (vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) - 1)) {
		if (vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) == VTG_SOURCE_BOOKMARKS_MAX_BOOKMARKS) {
			vala_list_remove_at (self->priv->_bookmarks, 0);
		}
		vala_collection_add ((ValaCollection*) self->priv->_bookmarks, item);
		self->priv->_current_bookmark_index = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) - 1;
	} else {
		self->priv->_current_bookmark_index++;
		if (vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) == VTG_SOURCE_BOOKMARKS_MAX_BOOKMARKS) {
			vala_list_remove_at (self->priv->_bookmarks, self->priv->_current_bookmark_index);
		}
		vala_list_insert (self->priv->_bookmarks, self->priv->_current_bookmark_index, item);
	}
}


VtgSourceBookmark* vtg_source_bookmarks_get_current_bookmark (VtgSourceBookmarks* self) {
	VtgSourceBookmark* result = NULL;
	VtgSourceBookmark* item;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	item = NULL;
	if (vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) > 0) {
		_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) > self->priv->_current_bookmark_index;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		VtgSourceBookmark* _tmp1_;
		item = (_tmp1_ = (VtgSourceBookmark*) vala_list_get (self->priv->_bookmarks, self->priv->_current_bookmark_index), _vtg_source_bookmark_unref0 (item), _tmp1_);
	}
	result = item;
	return result;
}


void vtg_source_bookmarks_move_next (VtgSourceBookmarks* self) {
	gboolean wrap;
	g_return_if_fail (self != NULL);
	wrap = FALSE;
	if (vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) == 0) {
		return;
	}
	if (self->priv->_current_bookmark_index < (vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) - 1)) {
		self->priv->_current_bookmark_index++;
	} else {
		self->priv->_current_bookmark_index = 0;
		wrap = TRUE;
	}
	self->priv->_in_move = TRUE;
	g_signal_emit_by_name (self, "current-bookmark-changed");
	if (wrap) {
		g_signal_emit_by_name (self, "move-wrapped");
	}
	self->priv->_in_move = FALSE;
}


void vtg_source_bookmarks_move_previous (VtgSourceBookmarks* self) {
	gboolean wrap;
	g_return_if_fail (self != NULL);
	wrap = FALSE;
	if (vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) == 0) {
		return;
	}
	if (self->priv->_current_bookmark_index > 0) {
		self->priv->_current_bookmark_index--;
	} else {
		self->priv->_current_bookmark_index = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) - 1;
		wrap = TRUE;
	}
	self->priv->_in_move = TRUE;
	g_signal_emit_by_name (self, "current-bookmark-changed");
	if (wrap) {
		g_signal_emit_by_name (self, "move-wrapped");
	}
	self->priv->_in_move = FALSE;
}


VtgPluginInstance* vtg_source_bookmarks_get_plugin_instance (VtgSourceBookmarks* self) {
	VtgPluginInstance* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_plugin_instance;
	return result;
}


static void vtg_source_bookmarks_set_plugin_instance (VtgSourceBookmarks* self, VtgPluginInstance* value) {
	g_return_if_fail (self != NULL);
	self->priv->_plugin_instance = value;
	g_object_notify ((GObject *) self, "plugin-instance");
}


gboolean vtg_source_bookmarks_get_is_empty (VtgSourceBookmarks* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks) == 0;
	return result;
}


static void vtg_source_bookmarks_class_init (VtgSourceBookmarksClass * klass) {
	vtg_source_bookmarks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgSourceBookmarksPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_source_bookmarks_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_source_bookmarks_set_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_source_bookmarks_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_BOOKMARKS_PLUGIN_INSTANCE, g_param_spec_object ("plugin-instance", "plugin-instance", "plugin-instance", VTG_TYPE_PLUGIN_INSTANCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_BOOKMARKS_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("current_bookmark_changed", VTG_TYPE_SOURCE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("move_wrapped", VTG_TYPE_SOURCE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vtg_source_bookmarks_instance_init (VtgSourceBookmarks * self) {
	self->priv = VTG_SOURCE_BOOKMARKS_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_bookmarks = (ValaList*) vala_array_list_new (VTG_TYPE_SOURCE_BOOKMARK, (GBoxedCopyFunc) vtg_source_bookmark_ref, vtg_source_bookmark_unref, g_direct_equal);
	self->priv->_current_bookmark_index = -1;
	self->priv->_in_move = FALSE;
	self->priv->_idle_add_doc = NULL;
}


static void vtg_source_bookmarks_finalize (GObject* obj) {
	VtgSourceBookmarks * self;
	self = VTG_SOURCE_BOOKMARKS (obj);
	{
		g_signal_handler_disconnect (self, self->priv->signal_id);
	}
	_vala_collection_object_unref0 (self->priv->_bookmarks);
	_g_object_unref0 (self->priv->_idle_add_doc);
	G_OBJECT_CLASS (vtg_source_bookmarks_parent_class)->finalize (obj);
}


GType vtg_source_bookmarks_get_type (void) {
	return vtg_source_bookmarks_type_id;
}


GType vtg_source_bookmarks_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgSourceBookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_source_bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgSourceBookmarks), 0, (GInstanceInitFunc) vtg_source_bookmarks_instance_init, NULL };
	vtg_source_bookmarks_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgSourceBookmarks", &g_define_type_info, 0);
	return vtg_source_bookmarks_type_id;
}


static void vtg_source_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgSourceBookmarks * self;
	self = VTG_SOURCE_BOOKMARKS (object);
	switch (property_id) {
		case VTG_SOURCE_BOOKMARKS_PLUGIN_INSTANCE:
		g_value_set_object (value, vtg_source_bookmarks_get_plugin_instance (self));
		break;
		case VTG_SOURCE_BOOKMARKS_IS_EMPTY:
		g_value_set_boolean (value, vtg_source_bookmarks_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_source_bookmarks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgSourceBookmarks * self;
	self = VTG_SOURCE_BOOKMARKS (object);
	switch (property_id) {
		case VTG_SOURCE_BOOKMARKS_PLUGIN_INSTANCE:
		vtg_source_bookmarks_set_plugin_instance (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




