/* vtgprojectview.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgprojectview.vala, do not modify */

/*
 *  vtgprojectmanagerview.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <vbf.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gedit/gedit-plugin.h>
#include <glib/gstdio.h>
#include <gedit/gedit-tab.h>
#include <gdk/gdk.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-document.h>
#include <gedit/gedit-panel.h>
#include <config.h>


#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;
typedef struct _VtgProjectViewPrivate VtgProjectViewPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))

#define VTG_TYPE_PROJECTS (vtg_projects_get_type ())
#define VTG_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECTS, VtgProjects))
#define VTG_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECTS, VtgProjectsClass))
#define VTG_IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECTS))
#define VTG_IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECTS))
#define VTG_PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECTS, VtgProjectsClass))

typedef struct _VtgProjects VtgProjects;
typedef struct _VtgProjectsClass VtgProjectsClass;

struct _VtgProjectView {
	GObject parent_instance;
	VtgProjectViewPrivate * priv;
};

struct _VtgProjectViewClass {
	GObjectClass parent_class;
};

struct _VtgProjectViewPrivate {
	VtgPluginInstance* _plugin_instance;
	GtkComboBox* _prjs_combo;
	GtkListStore* _prjs_model;
	GtkTreeView* _prj_view;
	gint _project_count;
	VbfGroup* _last_selected_group;
	GtkMenu* _popup_modules;
	guint _popup_modules_ui_id;
	char* _popup_modules_ui_def;
	GtkMenu* _popup_targets;
	guint _popup_targets_ui_id;
	char* _popup_targets_ui_def;
	GtkActionGroup* _actions;
	GtkVBox* _side_panel;
	VtgProjectManager* _current_project;
	GtkTreeModelFilter* _filtered_model;
	GtkCheckButton* _check_button_show_sources;
};


extern VtgPlugin* vtg_plugin_main_instance;
static gpointer vtg_project_view_parent_class = NULL;
static GType vtg_project_view_type_id = 0;

GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
#define VTG_PROJECT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_VIEW, VtgProjectViewPrivate))
enum  {
	VTG_PROJECT_VIEW_DUMMY_PROPERTY,
	VTG_PROJECT_VIEW_CURRENT_PROJECT,
	VTG_PROJECT_VIEW_PLUGIN_INSTANCE
};
static void vtg_project_view_on_packages_open_configure (VtgProjectView* self, GtkAction* action);
static void _vtg_project_view_on_packages_open_configure_gtk_action_callback (GtkAction* action, gpointer self);
static void vtg_project_view_on_target_open_makefile (VtgProjectView* self, GtkAction* action);
static void _vtg_project_view_on_target_open_makefile_gtk_action_callback (GtkAction* action, gpointer self);
VtgProjectView* vtg_project_view_new (VtgPluginInstance* plugin_instance);
VtgProjectView* vtg_project_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
static void vtg_project_view_update_project_treeview (VtgProjectView* self);
GtkTreeModel* vtg_project_manager_get_model (VtgProjectManager* self);
static gboolean vtg_project_view_filter_function (VtgProjectView* self, GtkTreeModel* sender, GtkTreeIter* iter);
static gboolean _vtg_project_view_filter_function_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static void vtg_project_view_on_show_data_dir_toggled (VtgProjectView* self, GtkWidget* sender);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
void vtg_configuration_set_project_only_show_sources (VtgConfiguration* self, gboolean value);
void vtg_project_view_add_project (VtgProjectView* self, VbfProject* project);
void vtg_project_view_remove_project (VtgProjectView* self, VbfProject* project);
static gboolean vtg_project_view_lookup_iter_for_project_name (VtgProjectView* self, const char* project_name, GtkTreeIter* combo_iter);
static void vtg_project_view_update_view (VtgProjectView* self, const char* project_name);
void vtg_project_view_on_project_view_row_activated (VtgProjectView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column);
GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const char* uri, gint line, gint col);
gboolean vtg_project_view_on_project_view_button_press (VtgProjectView* self, GtkWidget* sender, GdkEventButton* event);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
static void _g_list_free_gtk_tree_path_free (GList* self);
void vtg_project_view_on_project_combobox_changed (VtgProjectView* self, GtkWidget* sender);
GType vtg_projects_get_type (void) G_GNUC_CONST;
GType vtg_projects_register_type (GTypeModule * module);
VtgProjects* vtg_plugin_get_projects (VtgPlugin* self);
VtgProjectManager* vtg_projects_get_project_manager_for_project_name (VtgProjects* self, const char* project_name);
void vtg_project_view_set_current_project (VtgProjectView* self, VtgProjectManager* value);
static void vtg_project_view_on_current_project_updated (VtgProjectView* self, VtgProjectManager* sender);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document);
static void _vtg_project_view_on_current_project_updated_vtg_project_manager_updated (VtgProjectManager* _sender, gpointer self);
static void vtg_project_view_set_plugin_instance (VtgProjectView* self, VtgPluginInstance* value);
static void _vtg_project_view_on_project_combobox_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _vtg_project_view_on_project_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean _vtg_project_view_on_project_view_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
gboolean vtg_configuration_get_project_only_show_sources (VtgConfiguration* self);
static void _vtg_project_view_on_show_data_dir_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static GObject * vtg_project_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vtg_project_view_finalize (GObject* obj);
static void vtg_project_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_project_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkActionEntry VTG_PROJECT_VIEW__action_entries[2] = {{"packages-open-configure", GTK_STOCK_OPEN, N_ ("Open configure file..."), "<control><shift>C", N_ ("Open configure.ac file"), (GCallback) _vtg_project_view_on_packages_open_configure_gtk_action_callback}, {"target-open-makefile", GTK_STOCK_OPEN, N_ ("Open makefile"), "<control><shift>M", N_ ("Open makefile.am file"), (GCallback) _vtg_project_view_on_target_open_makefile_gtk_action_callback}};


static void _vtg_project_view_on_packages_open_configure_gtk_action_callback (GtkAction* action, gpointer self) {
	vtg_project_view_on_packages_open_configure (self, action);
}


static void _vtg_project_view_on_target_open_makefile_gtk_action_callback (GtkAction* action, gpointer self) {
	vtg_project_view_on_target_open_makefile (self, action);
}


VtgProjectView* vtg_project_view_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgProjectView * self;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgProjectView*) g_object_new (object_type, "plugin-instance", plugin_instance, NULL);
	return self;
}


VtgProjectView* vtg_project_view_new (VtgPluginInstance* plugin_instance) {
	return vtg_project_view_construct (VTG_TYPE_PROJECT_VIEW, plugin_instance);
}


static gboolean _vtg_project_view_filter_function_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = vtg_project_view_filter_function (self, model, iter);
	return result;
}


static void vtg_project_view_update_project_treeview (VtgProjectView* self) {
	GtkTreeModelFilter* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_filtered_model = (_tmp0_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new (vtg_project_manager_get_model (self->priv->_current_project), NULL), _g_object_unref0 (self->priv->_filtered_model), _tmp0_);
	gtk_tree_model_filter_set_visible_func (self->priv->_filtered_model, _vtg_project_view_filter_function_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	gtk_tree_view_set_model (self->priv->_prj_view, (GtkTreeModel*) self->priv->_filtered_model);
	gtk_tree_view_expand_all (self->priv->_prj_view);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean vtg_project_view_filter_function (VtgProjectView* self, GtkTreeModel* sender, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gboolean res;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	res = TRUE;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->_check_button_show_sources)) {
		GObject* obj;
		char* node_id;
		obj = NULL;
		node_id = NULL;
		gtk_tree_model_get (sender, iter, 2, &node_id, 3, &obj, -1);
		if (_vala_strcmp0 (node_id, "project-reference") == 0) {
			res = FALSE;
		} else {
			if (VBF_IS_GROUP (obj)) {
				VbfGroup* group;
				group = _g_object_ref0 (VBF_GROUP (obj));
				res = vbf_group_has_sources_of_type (group, VBF_FILE_TYPES_VALA_SOURCE);
				_g_object_unref0 (group);
			} else {
				if (VBF_IS_TARGET (obj)) {
					VbfTarget* target;
					target = _g_object_ref0 (VBF_TARGET (obj));
					res = vbf_target_has_sources_of_type (target, VBF_FILE_TYPES_VALA_SOURCE);
					_g_object_unref0 (target);
				}
			}
		}
		_g_free0 (node_id);
		_g_object_unref0 (obj);
	}
	result = res;
	return result;
}


static void vtg_project_view_on_show_data_dir_toggled (VtgProjectView* self, GtkWidget* sender) {
	GtkCheckButton* check;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	check = _g_object_ref0 (GTK_CHECK_BUTTON (sender));
	vtg_configuration_set_project_only_show_sources (vtg_plugin_get_config (vtg_plugin_main_instance), gtk_toggle_button_get_active ((GtkToggleButton*) check));
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
	_g_object_unref0 (check);
}


void vtg_project_view_add_project (VtgProjectView* self, VbfProject* project) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	gtk_list_store_append (self->priv->_prjs_model, &iter);
	gtk_list_store_set (self->priv->_prjs_model, &iter, 0, project->name, 1, project, -1);
	gtk_combo_box_set_active_iter (self->priv->_prjs_combo, &iter);
	self->priv->_project_count++;
}


void vtg_project_view_remove_project (VtgProjectView* self, VbfProject* project) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	if (vtg_project_view_lookup_iter_for_project_name (self, project->name, &iter)) {
		gtk_list_store_remove (self->priv->_prjs_model, &iter);
	}
	self->priv->_project_count--;
	if (self->priv->_project_count > 0) {
		gtk_combo_box_set_active (self->priv->_prjs_combo, 0);
		if (gtk_combo_box_get_active_iter (self->priv->_prjs_combo, &iter)) {
			VbfProject* selected_project;
			selected_project = NULL;
			gtk_tree_model_get ((GtkTreeModel*) self->priv->_prjs_model, &iter, 1, &selected_project, -1);
			vtg_project_view_update_view (self, selected_project->name);
			_g_object_unref0 (selected_project);
		}
	} else {
		vtg_project_view_update_view (self, NULL);
	}
}


static gboolean vtg_project_view_lookup_iter_for_project_name (VtgProjectView* self, const char* project_name, GtkTreeIter* combo_iter) {
	gboolean result = FALSE;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	gboolean valid;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_name != NULL, FALSE);
	model = _g_object_ref0 (gtk_combo_box_get_model (self->priv->_prjs_combo));
	valid = gtk_tree_model_get_iter_first (model, &iter);
	while (TRUE) {
		char* name;
		if (!valid) {
			break;
		}
		name = NULL;
		gtk_tree_model_get (model, &iter, 0, &name, -1);
		if (_vala_strcmp0 (name, project_name) == 0) {
			*combo_iter = iter;
			result = TRUE;
			_g_free0 (name);
			_g_object_unref0 (model);
			return result;
		}
		valid = gtk_tree_model_iter_next (model, &iter);
		_g_free0 (name);
	}
	result = FALSE;
	_g_object_unref0 (model);
	return result;
}


void vtg_project_view_on_project_view_row_activated (VtgProjectView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeView* tw;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	tw = _g_object_ref0 (GTK_TREE_VIEW (sender));
	model = _g_object_ref0 (gtk_tree_view_get_model (tw));
	if (gtk_tree_model_get_iter (model, &iter, path)) {
		char* name;
		char* id;
		name = NULL;
		id = NULL;
		gtk_tree_model_get (model, &iter, 1, &name, 2, &id, -1);
		{
			if (id != NULL) {
				char* file;
				gboolean _tmp0_ = FALSE;
				file = g_filename_from_uri (id, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch16_g_error;
				}
				if (name != NULL) {
					_tmp0_ = g_file_test (file, G_FILE_TEST_EXISTS);
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					GeditTab* _tmp1_;
					_tmp1_ = vtg_plugin_instance_activate_uri (self->priv->_plugin_instance, id, 0, 0);
					_g_object_unref0 (_tmp1_);
				}
				_g_free0 (file);
			}
		}
		goto __finally16;
		__catch16_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgprojectview.vala:278: on_project_view_row_activated error: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally16:
		if (_inner_error_ != NULL) {
			_g_free0 (id);
			_g_free0 (name);
			_g_object_unref0 (model);
			_g_object_unref0 (tw);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (id);
		_g_free0 (name);
	}
	_g_object_unref0 (model);
	_g_object_unref0 (tw);
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


gboolean vtg_project_view_on_project_view_button_press (VtgProjectView* self, GtkWidget* sender, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if ((*event).button == 3) {
		GtkTreeModel* model;
		GList* rows;
		model = NULL;
		rows = gtk_tree_selection_get_selected_rows (gtk_tree_view_get_selection (self->priv->_prj_view), &model);
		if (g_list_length (rows) == 1) {
			GtkTreeIter iter = {0};
			GObject* obj;
			GtkTreePath* path;
			char* id;
			obj = NULL;
			path = (GtkTreePath*) g_list_nth_data (rows, (guint) 0);
			id = NULL;
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (model, &iter, 2, &id, 3, &obj, -1);
			if (_vala_strcmp0 (id, "project-root") == 0) {
				char* file;
				file = g_build_filename (vtg_project_manager_get_project (vtg_project_view_get_current_project (self))->id, "configure.ac", NULL);
				if (g_file_test (file, G_FILE_TEST_EXISTS)) {
					gtk_menu_popup (self->priv->_popup_modules, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
				}
				_g_free0 (file);
			} else {
				if (VBF_IS_GROUP (obj)) {
					VbfGroup* _tmp0_;
					char* file;
					self->priv->_last_selected_group = (_tmp0_ = _g_object_ref0 (VBF_GROUP (obj)), _g_object_unref0 (self->priv->_last_selected_group), _tmp0_);
					file = g_build_filename (self->priv->_last_selected_group->id, "Makefile.am", NULL);
					if (g_file_test (file, G_FILE_TEST_EXISTS)) {
						gtk_menu_popup (self->priv->_popup_targets, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
					}
					_g_free0 (file);
				}
			}
			_g_free0 (id);
			_g_object_unref0 (obj);
		}
		__g_list_free_gtk_tree_path_free0 (rows);
	}
	result = FALSE;
	return result;
}


void vtg_project_view_on_project_combobox_changed (VtgProjectView* self, GtkWidget* sender) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (gtk_combo_box_get_active_iter (self->priv->_prjs_combo, &iter)) {
		VbfProject* project;
		project = NULL;
		gtk_tree_model_get ((GtkTreeModel*) self->priv->_prjs_model, &iter, 1, &project, -1);
		vtg_project_view_update_view (self, project->name);
		_g_object_unref0 (project);
	} else {
		vtg_project_view_update_view (self, NULL);
	}
}


static void vtg_project_view_update_view (VtgProjectView* self, const char* project_name) {
	VtgProjectManager* prj;
	gboolean _tmp0_ = FALSE;
	VtgProjectManager* _tmp1_;
	g_return_if_fail (self != NULL);
	prj = NULL;
	if (vtg_project_view_get_current_project (self) != NULL) {
		_tmp0_ = _vala_strcmp0 (vtg_project_manager_get_project (vtg_project_view_get_current_project (self))->name, project_name) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_g_object_unref0 (prj);
		return;
	}
	prj = (_tmp1_ = vtg_projects_get_project_manager_for_project_name (vtg_plugin_get_projects (vtg_plugin_main_instance), project_name), _g_object_unref0 (prj), _tmp1_);
	vtg_project_view_set_current_project (self, prj);
	_g_object_unref0 (prj);
}


static void vtg_project_view_on_current_project_updated (VtgProjectView* self, VtgProjectManager* sender) {
	GeditDocument* doc;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	vtg_project_view_update_project_treeview (self);
	doc = _g_object_ref0 (gedit_window_get_active_document (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	if (doc != NULL) {
		_tmp0_ = vtg_utils_is_vala_doc (doc);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		VtgProjectManager* new_project;
		new_project = vtg_projects_get_project_manager_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), doc);
		if (new_project != NULL) {
			vtg_project_view_set_current_project (self, new_project);
		}
		_g_object_unref0 (new_project);
	}
	_g_object_unref0 (doc);
}


static void vtg_project_view_on_packages_open_configure (VtgProjectView* self, GtkAction* action) {
	char* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (vtg_project_view_get_current_project (self) != NULL);
	file = g_build_filename (vtg_project_manager_get_project (vtg_project_view_get_current_project (self))->id, "configure.ac", NULL);
	if (g_file_test (file, G_FILE_TEST_EXISTS)) {
		{
			char* _tmp0_;
			char* _tmp1_;
			GeditTab* _tmp2_;
			_tmp0_ = g_filename_to_uri (file, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
			_tmp2_ = vtg_plugin_instance_activate_uri (self->priv->_plugin_instance, _tmp1_ = _tmp0_, 0, 0);
			_g_object_unref0 (_tmp2_);
			_g_free0 (_tmp1_);
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgprojectview.vala:362: error %s converting file %s to uri", e->message, file);
				_g_error_free0 (e);
			}
		}
		__finally17:
		if (_inner_error_ != NULL) {
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (file);
}


static void vtg_project_view_on_target_open_makefile (VtgProjectView* self, GtkAction* action) {
	char* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (self->priv->_last_selected_group != NULL);
	file = g_build_filename (self->priv->_last_selected_group->id, "Makefile.am", NULL);
	{
		if (g_file_test (file, G_FILE_TEST_EXISTS)) {
			char* _tmp0_;
			char* _tmp1_;
			GeditTab* _tmp2_;
			_tmp0_ = g_filename_to_uri (file, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch18_g_error;
			}
			_tmp2_ = vtg_plugin_instance_activate_uri (self->priv->_plugin_instance, _tmp1_ = _tmp0_, 0, 0);
			_g_object_unref0 (_tmp2_);
			_g_free0 (_tmp1_);
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgprojectview.vala:376: error %s converting file %s to uri", e->message, file);
			_g_error_free0 (e);
		}
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_g_free0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (file);
}


VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self) {
	VtgProjectManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_current_project;
	return result;
}


static void _vtg_project_view_on_current_project_updated_vtg_project_manager_updated (VtgProjectManager* _sender, gpointer self) {
	vtg_project_view_on_current_project_updated (self, _sender);
}


void vtg_project_view_set_current_project (VtgProjectView* self, VtgProjectManager* value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_current_project != value) {
		VtgProjectManager* _tmp1_;
		if (self->priv->_current_project != NULL) {
			guint _tmp0_;
			g_signal_parse_name ("updated", VTG_TYPE_PROJECT_MANAGER, &_tmp0_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (self->priv->_current_project, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vtg_project_view_on_current_project_updated_vtg_project_manager_updated, self);
		}
		self->priv->_current_project = (_tmp1_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_current_project), _tmp1_);
		if (self->priv->_current_project != NULL) {
			GtkTreeIter iter = {0};
			g_signal_connect_object (self->priv->_current_project, "updated", (GCallback) _vtg_project_view_on_current_project_updated_vtg_project_manager_updated, self, 0);
			if (vtg_project_manager_get_model (self->priv->_current_project) != NULL) {
				vtg_project_view_update_project_treeview (self);
			} else {
				gtk_tree_view_set_model (self->priv->_prj_view, NULL);
			}
			if (vtg_project_view_lookup_iter_for_project_name (self, vtg_project_manager_get_project (self->priv->_current_project)->name, &iter)) {
				gtk_combo_box_set_active_iter (self->priv->_prjs_combo, &iter);
			}
		} else {
			gtk_tree_view_set_model (self->priv->_prj_view, NULL);
		}
	}
	g_object_notify ((GObject *) self, "current-project");
}


static void vtg_project_view_set_plugin_instance (VtgProjectView* self, VtgPluginInstance* value) {
	VtgPluginInstance* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_plugin_instance = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_plugin_instance), _tmp0_);
	g_object_notify ((GObject *) self, "plugin-instance");
}


static void _vtg_project_view_on_project_combobox_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	vtg_project_view_on_project_combobox_changed (self, _sender);
}


static void _vtg_project_view_on_project_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	vtg_project_view_on_project_view_row_activated (self, _sender, path, column);
}


static gboolean _vtg_project_view_on_project_view_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = vtg_project_view_on_project_view_button_press (self, _sender, event);
	return result;
}


static void _vtg_project_view_on_show_data_dir_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	vtg_project_view_on_show_data_dir_toggled (self, _sender);
}


static GObject * vtg_project_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VtgProjectView * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (vtg_project_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VTG_PROJECT_VIEW (obj);
	_inner_error_ = NULL;
	{
		GtkListStore* _tmp0_;
		GeditPanel* panel;
		GtkVBox* _tmp1_;
		GtkComboBox* _tmp2_;
		GtkCellRenderer* renderer;
		GtkTreeView* _tmp3_;
		GtkCellRenderer* _tmp4_;
		GtkTreeViewColumn* column;
		GtkCellRenderer* _tmp5_;
		GtkScrolledWindow* scroll;
		GtkCheckButton* _tmp6_;
		GtkActionGroup* _tmp7_;
		GtkUIManager* manager;
		self->priv->_prjs_model = (_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, VBF_TYPE_PROJECT), _g_object_unref0 (self->priv->_prjs_model), _tmp0_);
		panel = _g_object_ref0 (gedit_window_get_side_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
		self->priv->_side_panel = (_tmp1_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 8)), _g_object_unref0 (self->priv->_side_panel), _tmp1_);
		self->priv->_prjs_combo = (_tmp2_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->_prjs_model)), _g_object_unref0 (self->priv->_prjs_combo), _tmp2_);
		renderer = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_prjs_combo, renderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_prjs_combo, renderer, "text", 0);
		g_signal_connect_object (self->priv->_prjs_combo, "changed", (GCallback) _vtg_project_view_on_project_combobox_changed_gtk_combo_box_changed, self, 0);
		self->priv->_prj_view = (_tmp3_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ()), _g_object_unref0 (self->priv->_prj_view), _tmp3_);
		renderer = (_tmp4_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), _g_object_unref0 (renderer), _tmp4_);
		column = g_object_ref_sink (gtk_tree_view_column_new ());
		gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "stock-id", 0);
		renderer = (_tmp5_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp5_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "text", 1);
		gtk_tree_view_append_column (self->priv->_prj_view, column);
		gtk_tree_view_set_headers_visible (self->priv->_prj_view, FALSE);
		g_signal_connect_object (self->priv->_prj_view, "row-activated", (GCallback) _vtg_project_view_on_project_view_row_activated_gtk_tree_view_row_activated, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->_prj_view, "button-press-event", (GCallback) _vtg_project_view_on_project_view_button_press_gtk_widget_button_press_event, self, 0);
		scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
		gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->_prj_view);
		self->priv->_check_button_show_sources = (_tmp6_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_label (_ ("Show only source files"))), _g_object_unref0 (self->priv->_check_button_show_sources), _tmp6_);
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->_check_button_show_sources, vtg_configuration_get_project_only_show_sources (vtg_plugin_get_config (vtg_plugin_main_instance)));
		g_signal_connect_object ((GtkToggleButton*) self->priv->_check_button_show_sources, "toggled", (GCallback) _vtg_project_view_on_show_data_dir_toggled_gtk_toggle_button_toggled, self, 0);
		gtk_box_pack_start ((GtkBox*) self->priv->_side_panel, (GtkWidget*) self->priv->_prjs_combo, FALSE, FALSE, (guint) 4);
		gtk_box_pack_start ((GtkBox*) self->priv->_side_panel, (GtkWidget*) scroll, TRUE, TRUE, (guint) 4);
		gtk_box_pack_start ((GtkBox*) self->priv->_side_panel, (GtkWidget*) self->priv->_check_button_show_sources, FALSE, FALSE, (guint) 4);
		gtk_widget_show_all ((GtkWidget*) self->priv->_side_panel);
		gedit_panel_add_item_with_stock_icon (panel, (GtkWidget*) self->priv->_side_panel, _ ("Projects"), GTK_STOCK_DIRECTORY);
		gedit_panel_activate_item (panel, (GtkWidget*) self->priv->_side_panel);
		self->priv->_project_count = 0;
		self->priv->_actions = (_tmp7_ = gtk_action_group_new ("ProjectManagerActionGroup"), _g_object_unref0 (self->priv->_actions), _tmp7_);
		gtk_action_group_set_translation_domain (self->priv->_actions, GETTEXT_PACKAGE);
		gtk_action_group_add_actions (self->priv->_actions, VTG_PROJECT_VIEW__action_entries, G_N_ELEMENTS (VTG_PROJECT_VIEW__action_entries), self);
		manager = _g_object_ref0 (gedit_window_get_ui_manager (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
		gtk_ui_manager_insert_action_group (manager, self->priv->_actions, -1);
		{
			guint _tmp8_;
			GtkMenu* _tmp9_;
			guint _tmp10_;
			GtkMenu* _tmp11_;
			_tmp8_ = gtk_ui_manager_add_ui_from_string (manager, self->priv->_popup_modules_ui_def, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
			self->priv->_popup_modules_ui_id = _tmp8_;
			self->priv->_popup_modules = (_tmp9_ = _g_object_ref0 (GTK_MENU (gtk_ui_manager_get_widget (manager, "/ProjectManagerPopupPackagesEdit"))), _g_object_unref0 (self->priv->_popup_modules), _tmp9_);
			g_assert (self->priv->_popup_modules != NULL);
			_tmp10_ = gtk_ui_manager_add_ui_from_string (manager, self->priv->_popup_targets_ui_def, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
			self->priv->_popup_targets_ui_id = _tmp10_;
			self->priv->_popup_targets = (_tmp11_ = _g_object_ref0 (GTK_MENU (gtk_ui_manager_get_widget (manager, "/ProjectManagerPopupTargets"))), _g_object_unref0 (self->priv->_popup_targets), _tmp11_);
			g_assert (self->priv->_popup_targets != NULL);
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgprojectview.vala:171: Error %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally19:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (manager);
			_g_object_unref0 (scroll);
			_g_object_unref0 (column);
			_g_object_unref0 (renderer);
			_g_object_unref0 (panel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (manager);
		_g_object_unref0 (scroll);
		_g_object_unref0 (column);
		_g_object_unref0 (renderer);
		_g_object_unref0 (panel);
	}
	return obj;
}


static void vtg_project_view_class_init (VtgProjectViewClass * klass) {
	vtg_project_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_project_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_project_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = vtg_project_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_VIEW_CURRENT_PROJECT, g_param_spec_object ("current-project", "current-project", "current-project", VTG_TYPE_PROJECT_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_VIEW_PLUGIN_INSTANCE, g_param_spec_object ("plugin-instance", "plugin-instance", "plugin-instance", VTG_TYPE_PLUGIN_INSTANCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vtg_project_view_instance_init (VtgProjectView * self) {
	self->priv = VTG_PROJECT_VIEW_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_project_count = 0;
	self->priv->_popup_modules_ui_def = g_strdup ("\n" \
"                                        <ui>\n" \
"                                        <popup name='ProjectManagerPop" \
"upPackagesEdit'>\n" \
"                                            <menuitem action='packages" \
"-open-configure'/>\n" \
"                                        </popup>\n" \
"                                        </ui>");
	self->priv->_popup_targets_ui_def = g_strdup ("\n" \
"                                        <ui>\n" \
"                                        <popup name='ProjectManagerPop" \
"upTargets'>\n" \
"                                            <menuitem action='target-o" \
"pen-makefile'/>\n" \
"                                        </popup>\n" \
"                                        </ui>");
	self->priv->_current_project = NULL;
	self->priv->_check_button_show_sources = NULL;
}


static void vtg_project_view_finalize (GObject* obj) {
	VtgProjectView * self;
	self = VTG_PROJECT_VIEW (obj);
	{
		GtkUIManager* manager;
		GeditPanel* panel;
		manager = _g_object_ref0 (gedit_window_get_ui_manager (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
		gtk_ui_manager_remove_action_group (manager, self->priv->_actions);
		panel = _g_object_ref0 (gedit_window_get_side_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
		gedit_panel_remove_item (panel, (GtkWidget*) self->priv->_side_panel);
		_g_object_unref0 (panel);
		_g_object_unref0 (manager);
	}
	_g_object_unref0 (self->priv->_plugin_instance);
	_g_object_unref0 (self->priv->_prjs_combo);
	_g_object_unref0 (self->priv->_prjs_model);
	_g_object_unref0 (self->priv->_prj_view);
	_g_object_unref0 (self->priv->_last_selected_group);
	_g_object_unref0 (self->priv->_popup_modules);
	_g_free0 (self->priv->_popup_modules_ui_def);
	_g_object_unref0 (self->priv->_popup_targets);
	_g_free0 (self->priv->_popup_targets_ui_def);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->_side_panel);
	_g_object_unref0 (self->priv->_current_project);
	_g_object_unref0 (self->priv->_filtered_model);
	_g_object_unref0 (self->priv->_check_button_show_sources);
	G_OBJECT_CLASS (vtg_project_view_parent_class)->finalize (obj);
}


GType vtg_project_view_get_type (void) {
	return vtg_project_view_type_id;
}


GType vtg_project_view_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectView), 0, (GInstanceInitFunc) vtg_project_view_instance_init, NULL };
	vtg_project_view_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectView", &g_define_type_info, 0);
	return vtg_project_view_type_id;
}


static void vtg_project_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectView * self;
	self = VTG_PROJECT_VIEW (object);
	switch (property_id) {
		case VTG_PROJECT_VIEW_CURRENT_PROJECT:
		g_value_set_object (value, vtg_project_view_get_current_project (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_project_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgProjectView * self;
	self = VTG_PROJECT_VIEW (object);
	switch (property_id) {
		case VTG_PROJECT_VIEW_CURRENT_PROJECT:
		vtg_project_view_set_current_project (self, g_value_get_object (value));
		break;
		case VTG_PROJECT_VIEW_PLUGIN_INSTANCE:
		vtg_project_view_set_plugin_instance (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




