/* vtgconfiguration.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgconfiguration.vala, do not modify */

/*
 *  vtgconfigurationdialog.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gconf/gconf-client.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf.h>
#include <glib/gi18n-lib.h>


#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
typedef struct _VtgConfigurationPrivate VtgConfigurationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gconf_schema_free0(var) ((var == NULL) ? NULL : (var = (gconf_schema_free (var), NULL)))
#define _gconf_value_free0(var) ((var == NULL) ? NULL : (var = (gconf_value_free (var), NULL)))

struct _VtgConfiguration {
	GObject parent_instance;
	VtgConfigurationPrivate * priv;
};

struct _VtgConfigurationClass {
	GObjectClass parent_class;
};

struct _VtgConfigurationPrivate {
	GConfClient* _gconf;
	GtkDialog* _dialog;
	gboolean _info_window_visible;
	gboolean _outliner_show_private_symbols;
	gboolean _outliner_show_public_symbols;
	gboolean _outliner_show_protected_symbols;
	gboolean _outliner_show_internal_symbols;
	gboolean _project_only_show_sources;
	gboolean _bracket_enabled;
	gboolean _symbol_enabled;
	gboolean _sourcecode_outliner_enabled;
	char* _author;
	char* _email_address;
};


static gpointer vtg_configuration_parent_class = NULL;
static GType vtg_configuration_type_id = 0;

GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
#define VTG_CONFIGURATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_CONFIGURATION, VtgConfigurationPrivate))
enum  {
	VTG_CONFIGURATION_DUMMY_PROPERTY,
	VTG_CONFIGURATION_BRACKET_ENABLED,
	VTG_CONFIGURATION_SYMBOL_ENABLED,
	VTG_CONFIGURATION_SOURCECODE_OUTLINER_ENABLED,
	VTG_CONFIGURATION_AUTHOR,
	VTG_CONFIGURATION_EMAIL_ADDRESS,
	VTG_CONFIGURATION_INFO_WINDOW_VISIBLE,
	VTG_CONFIGURATION_OUTLINER_SHOW_PRIVATE_SYMBOLS,
	VTG_CONFIGURATION_OUTLINER_SHOW_PUBLIC_SYMBOLS,
	VTG_CONFIGURATION_OUTLINER_SHOW_PROTECTED_SYMBOLS,
	VTG_CONFIGURATION_OUTLINER_SHOW_INTERNAL_SYMBOLS,
	VTG_CONFIGURATION_PROJECT_ONLY_SHOW_SOURCES,
	VTG_CONFIGURATION_SAVE_BEFORE_BUILD
};
#define VTG_CONFIGURATION_VTG_BASE_KEY "/apps/gedit-2/plugins/vtg"
#define VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY VTG_CONFIGURATION_VTG_BASE_KEY "/bracket_completion_enabled"
#define VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY VTG_CONFIGURATION_VTG_BASE_KEY "/symbol_completion_enabled"
#define VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY VTG_CONFIGURATION_VTG_BASE_KEY "/sourcecode_outliner_enabled"
#define VTG_CONFIGURATION_VTG_AUTHOR_KEY VTG_CONFIGURATION_VTG_BASE_KEY "/author"
#define VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY VTG_CONFIGURATION_VTG_BASE_KEY "/email_address"
#define VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE VTG_CONFIGURATION_VTG_BASE_KEY "/info_window_visible"
#define VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS VTG_CONFIGURATION_VTG_BASE_KEY "/outliner_show_private_symbols"
#define VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS VTG_CONFIGURATION_VTG_BASE_KEY "/outliner_show_public_symbols"
#define VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS VTG_CONFIGURATION_VTG_BASE_KEY "/outliner_show_protected_symbols"
#define VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS VTG_CONFIGURATION_VTG_BASE_KEY "/outliner_show_internal_symbols"
#define VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES VTG_CONFIGURATION_VTG_BASE_KEY "/project_view_only_show_sources"
GtkWidget* vtg_configuration_get_configuration_dialog (VtgConfiguration* self);
char* vtg_utils_get_ui_path (const char* id);
static void vtg_configuration_on_button_close_clicked (VtgConfiguration* self, GtkButton* sender);
static void _vtg_configuration_on_button_close_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void vtg_configuration_on_checkbutton_toggled (VtgConfiguration* self, GtkToggleButton* sender);
static void _vtg_configuration_on_checkbutton_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void vtg_configuration_on_text_changed (VtgConfiguration* self, GObject* sender, GParamSpec* pspec);
static void _vtg_configuration_on_text_changed_g_object_notify (GtkEntry* _sender, GParamSpec* pspec, gpointer self);
static void vtg_configuration_on_conf_value_changed (VtgConfiguration* self, GConfClient* sender, const char* key, void* value);
void vtg_configuration_set_bracket_enabled (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_symbol_enabled (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_sourcecode_outliner_enabled (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_author (VtgConfiguration* self, const char* value);
void vtg_configuration_set_email_address (VtgConfiguration* self, const char* value);
void vtg_configuration_set_outliner_show_private_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_public_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_protected_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_internal_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_project_only_show_sources (VtgConfiguration* self, gboolean value);
VtgConfiguration* vtg_configuration_new (void);
VtgConfiguration* vtg_configuration_construct (GType object_type);
gboolean vtg_configuration_get_bracket_enabled (VtgConfiguration* self);
gboolean vtg_configuration_get_symbol_enabled (VtgConfiguration* self);
gboolean vtg_configuration_get_sourcecode_outliner_enabled (VtgConfiguration* self);
const char* vtg_configuration_get_author (VtgConfiguration* self);
const char* vtg_configuration_get_email_address (VtgConfiguration* self);
gboolean vtg_configuration_get_info_window_visible (VtgConfiguration* self);
void vtg_configuration_set_info_window_visible (VtgConfiguration* self, gboolean value);
gboolean vtg_configuration_get_outliner_show_private_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_outliner_show_public_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_outliner_show_protected_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_outliner_show_internal_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_project_only_show_sources (VtgConfiguration* self);
gboolean vtg_configuration_get_save_before_build (VtgConfiguration* self);
static void _vtg_configuration_on_conf_value_changed_gconf_client_value_changed (GConfClient* _sender, const char* key, void* value, gpointer self);
static GObject * vtg_configuration_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vtg_configuration_finalize (GObject* obj);
static void vtg_configuration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_configuration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vtg_configuration_on_button_close_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	vtg_configuration_on_button_close_clicked (self, _sender);
}


static void _vtg_configuration_on_checkbutton_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	vtg_configuration_on_checkbutton_toggled (self, _sender);
}


static void _vtg_configuration_on_text_changed_g_object_notify (GtkEntry* _sender, GParamSpec* pspec, gpointer self) {
	vtg_configuration_on_text_changed (self, _sender, pspec);
}


GtkWidget* vtg_configuration_get_configuration_dialog (VtgConfiguration* self) {
	GtkWidget* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GtkBuilder* builder;
		char* _tmp0_;
		GtkDialog* _tmp1_;
		GtkButton* button;
		GtkCheckButton* check;
		GtkCheckButton* _tmp2_;
		GtkCheckButton* _tmp3_;
		GtkEntry* text;
		GtkEntry* _tmp4_;
		builder = gtk_builder_new ();
		gtk_builder_add_from_file (builder, _tmp0_ = vtg_utils_get_ui_path ("vtg.ui"), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			goto __catch41_g_error;
		}
		self->priv->_dialog = (_tmp1_ = _g_object_ref0 (GTK_DIALOG (gtk_builder_get_object (builder, "dialog-settings"))), _g_object_unref0 (self->priv->_dialog), _tmp1_);
		g_assert (self->priv->_dialog != NULL);
		button = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button-settings-close")));
		g_signal_connect_object (button, "clicked", (GCallback) _vtg_configuration_on_button_close_clicked_gtk_button_clicked, self, 0);
		check = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (builder, "checkbutton-settings-bracket-completion")));
		g_assert (check != NULL);
		gtk_toggle_button_set_active ((GtkToggleButton*) check, self->priv->_bracket_enabled);
		g_signal_connect_object ((GtkToggleButton*) check, "toggled", (GCallback) _vtg_configuration_on_checkbutton_toggled_gtk_toggle_button_toggled, self, 0);
		check = (_tmp2_ = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (builder, "checkbutton-settings-symbol-completion"))), _g_object_unref0 (check), _tmp2_);
		g_assert (check != NULL);
		gtk_toggle_button_set_active ((GtkToggleButton*) check, self->priv->_symbol_enabled);
		g_signal_connect_object ((GtkToggleButton*) check, "toggled", (GCallback) _vtg_configuration_on_checkbutton_toggled_gtk_toggle_button_toggled, self, 0);
		check = (_tmp3_ = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (builder, "checkbutton-settings-sourcecode-outliner"))), _g_object_unref0 (check), _tmp3_);
		g_assert (check != NULL);
		gtk_toggle_button_set_active ((GtkToggleButton*) check, self->priv->_sourcecode_outliner_enabled);
		g_signal_connect_object ((GtkToggleButton*) check, "toggled", (GCallback) _vtg_configuration_on_checkbutton_toggled_gtk_toggle_button_toggled, self, 0);
		text = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry-settings-author")));
		g_assert (text != NULL);
		gtk_entry_set_text (text, self->priv->_author);
		g_signal_connect_object ((GObject*) text, "notify::text", (GCallback) _vtg_configuration_on_text_changed_g_object_notify, self, 0);
		text = (_tmp4_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry-settings-email"))), _g_object_unref0 (text), _tmp4_);
		g_assert (text != NULL);
		gtk_entry_set_text (text, self->priv->_email_address);
		g_signal_connect_object ((GObject*) text, "notify::text", (GCallback) _vtg_configuration_on_text_changed_g_object_notify, self, 0);
		result = (GtkWidget*) self->priv->_dialog;
		_g_object_unref0 (text);
		_g_object_unref0 (check);
		_g_object_unref0 (button);
		_g_object_unref0 (builder);
		return result;
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgconfiguration.vala:363: (get_configuration_dialog): %s", err->message);
			result = NULL;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally41:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void vtg_configuration_on_button_close_clicked (VtgConfiguration* self, GtkButton* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (self->priv->_dialog != NULL);
	gtk_object_destroy ((GtkObject*) self->priv->_dialog);
}


static void vtg_configuration_on_conf_value_changed (VtgConfiguration* self, GConfClient* sender, const char* key, void* value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (key != NULL);
	{
		if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY) == 0) {
			gboolean new_val;
			new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch42_g_error;
			}
			if (self->priv->_bracket_enabled != new_val) {
				vtg_configuration_set_bracket_enabled (self, new_val);
			}
		} else {
			if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY) == 0) {
				gboolean new_val;
				new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch42_g_error;
				}
				if (self->priv->_symbol_enabled != new_val) {
					vtg_configuration_set_symbol_enabled (self, new_val);
				}
			} else {
				if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY) == 0) {
					gboolean new_val;
					new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch42_g_error;
					}
					if (self->priv->_sourcecode_outliner_enabled != new_val) {
						vtg_configuration_set_sourcecode_outliner_enabled (self, new_val);
					}
				} else {
					if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_AUTHOR_KEY) == 0) {
						char* new_val;
						new_val = gconf_client_get_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_AUTHOR_KEY, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch42_g_error;
						}
						if (_vala_strcmp0 (self->priv->_author, new_val) != 0) {
							vtg_configuration_set_author (self, new_val);
						}
						_g_free0 (new_val);
					} else {
						if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY) == 0) {
							char* new_val;
							new_val = gconf_client_get_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, &_inner_error_);
							if (_inner_error_ != NULL) {
								goto __catch42_g_error;
							}
							if (_vala_strcmp0 (self->priv->_email_address, new_val) != 0) {
								vtg_configuration_set_email_address (self, new_val);
							}
							_g_free0 (new_val);
						} else {
							if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS) == 0) {
								gboolean new_val;
								new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, &_inner_error_);
								if (_inner_error_ != NULL) {
									goto __catch42_g_error;
								}
								if (self->priv->_outliner_show_private_symbols != new_val) {
									vtg_configuration_set_outliner_show_private_symbols (self, new_val);
								}
							} else {
								if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS) == 0) {
									gboolean new_val;
									new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, &_inner_error_);
									if (_inner_error_ != NULL) {
										goto __catch42_g_error;
									}
									if (self->priv->_outliner_show_public_symbols != new_val) {
										vtg_configuration_set_outliner_show_public_symbols (self, new_val);
									}
								} else {
									if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS) == 0) {
										gboolean new_val;
										new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS, &_inner_error_);
										if (_inner_error_ != NULL) {
											goto __catch42_g_error;
										}
										if (self->priv->_outliner_show_protected_symbols != new_val) {
											vtg_configuration_set_outliner_show_protected_symbols (self, new_val);
										}
									} else {
										if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS) == 0) {
											gboolean new_val;
											new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, &_inner_error_);
											if (_inner_error_ != NULL) {
												goto __catch42_g_error;
											}
											if (self->priv->_outliner_show_internal_symbols != new_val) {
												vtg_configuration_set_outliner_show_internal_symbols (self, new_val);
											}
										} else {
											if (_vala_strcmp0 (key, VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES) == 0) {
												gboolean new_val;
												new_val = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, &_inner_error_);
												if (_inner_error_ != NULL) {
													goto __catch42_g_error;
												}
												if (self->priv->_project_only_show_sources != new_val) {
													vtg_configuration_set_project_only_show_sources (self, new_val);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgconfiguration.vala:429: (on_conf_value_changed): %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally42:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vtg_configuration_on_checkbutton_toggled (VtgConfiguration* self, GtkToggleButton* sender) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	{
		gboolean new_val;
		char* name;
		new_val = gtk_toggle_button_get_active (sender);
		name = g_strdup (gtk_buildable_get_name ((GtkBuildable*) sender));
		if (_vala_strcmp0 (name, "checkbutton-settings-bracket-completion") == 0) {
			gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, new_val, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (name);
				goto __catch43_g_error;
			}
		} else {
			if (_vala_strcmp0 (name, "checkbutton-settings-symbol-completion") == 0) {
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, new_val, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (name);
					goto __catch43_g_error;
				}
			} else {
				if (_vala_strcmp0 (name, "checkbutton-settings-sourcecode-outliner") == 0) {
					gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY, new_val, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (name);
						goto __catch43_g_error;
					}
				}
			}
		}
		_g_free0 (name);
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgconfiguration.vala:447: (on_checkbutton_toggled): %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vtg_configuration_on_text_changed (VtgConfiguration* self, GObject* sender, GParamSpec* pspec) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	{
		GtkEntry* entry;
		char* new_val;
		char* name;
		entry = _g_object_ref0 (GTK_ENTRY (sender));
		new_val = g_strdup (gtk_entry_get_text (entry));
		name = g_strdup (gtk_buildable_get_name ((GtkBuildable*) entry));
		if (_vala_strcmp0 (name, "entry-settings-author") == 0) {
			gconf_client_set_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_AUTHOR_KEY, new_val, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (name);
				_g_free0 (new_val);
				_g_object_unref0 (entry);
				goto __catch44_g_error;
			}
		} else {
			if (_vala_strcmp0 (name, "entry-settings-email") == 0) {
				gconf_client_set_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, new_val, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (name);
					_g_free0 (new_val);
					_g_object_unref0 (entry);
					goto __catch44_g_error;
				}
			}
		}
		_g_free0 (name);
		_g_free0 (new_val);
		_g_object_unref0 (entry);
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgconfiguration.vala:464: (on_text_changed): %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally44:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


VtgConfiguration* vtg_configuration_construct (GType object_type) {
	VtgConfiguration * self;
	self = (VtgConfiguration*) g_object_new (object_type, NULL);
	return self;
}


VtgConfiguration* vtg_configuration_new (void) {
	return vtg_configuration_construct (VTG_TYPE_CONFIGURATION);
}


gboolean vtg_configuration_get_bracket_enabled (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_bracket_enabled;
	return result;
}


void vtg_configuration_set_bracket_enabled (VtgConfiguration* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_bracket_enabled = value;
	g_object_notify ((GObject *) self, "bracket-enabled");
}


gboolean vtg_configuration_get_symbol_enabled (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_symbol_enabled;
	return result;
}


void vtg_configuration_set_symbol_enabled (VtgConfiguration* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_symbol_enabled = value;
	g_object_notify ((GObject *) self, "symbol-enabled");
}


gboolean vtg_configuration_get_sourcecode_outliner_enabled (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sourcecode_outliner_enabled;
	return result;
}


void vtg_configuration_set_sourcecode_outliner_enabled (VtgConfiguration* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_sourcecode_outliner_enabled = value;
	g_object_notify ((GObject *) self, "sourcecode-outliner-enabled");
}


const char* vtg_configuration_get_author (VtgConfiguration* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_author;
	return result;
}


void vtg_configuration_set_author (VtgConfiguration* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_author = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_author), _tmp0_);
	g_object_notify ((GObject *) self, "author");
}


const char* vtg_configuration_get_email_address (VtgConfiguration* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_email_address;
	return result;
}


void vtg_configuration_set_email_address (VtgConfiguration* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_email_address = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_email_address), _tmp0_);
	g_object_notify ((GObject *) self, "email-address");
}


gboolean vtg_configuration_get_info_window_visible (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_info_window_visible;
	return result;
}


void vtg_configuration_set_info_window_visible (VtgConfiguration* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_info_window_visible != value) {
		self->priv->_info_window_visible = value;
		{
			gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE, self->priv->_info_window_visible, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch45_g_error;
			}
		}
		goto __finally45;
		__catch45_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:75: Error settings info_window_visible: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally45:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "info-window-visible");
}


gboolean vtg_configuration_get_outliner_show_private_symbols (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_outliner_show_private_symbols;
	return result;
}


void vtg_configuration_set_outliner_show_private_symbols (VtgConfiguration* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_outliner_show_private_symbols != value) {
		self->priv->_outliner_show_private_symbols = value;
		{
			gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, self->priv->_outliner_show_private_symbols, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch46_g_error;
			}
		}
		goto __finally46;
		__catch46_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:92: Error settings outliner_show_private_symbols" \
": %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally46:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "outliner-show-private-symbols");
}


gboolean vtg_configuration_get_outliner_show_public_symbols (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_outliner_show_public_symbols;
	return result;
}


void vtg_configuration_set_outliner_show_public_symbols (VtgConfiguration* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_outliner_show_public_symbols != value) {
		self->priv->_outliner_show_public_symbols = value;
		{
			gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, self->priv->_outliner_show_public_symbols, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch47_g_error;
			}
		}
		goto __finally47;
		__catch47_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:109: Error settings outliner_show_public_symbols" \
": %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally47:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "outliner-show-public-symbols");
}


gboolean vtg_configuration_get_outliner_show_protected_symbols (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_outliner_show_protected_symbols;
	return result;
}


void vtg_configuration_set_outliner_show_protected_symbols (VtgConfiguration* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_outliner_show_protected_symbols != value) {
		self->priv->_outliner_show_protected_symbols = value;
		{
			gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS, self->priv->_outliner_show_protected_symbols, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch48_g_error;
			}
		}
		goto __finally48;
		__catch48_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:126: Error settings outliner_show_protected_symb" \
"ols: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally48:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "outliner-show-protected-symbols");
}


gboolean vtg_configuration_get_outliner_show_internal_symbols (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_outliner_show_internal_symbols;
	return result;
}


void vtg_configuration_set_outliner_show_internal_symbols (VtgConfiguration* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_outliner_show_internal_symbols != value) {
		self->priv->_outliner_show_internal_symbols = value;
		{
			gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, self->priv->_outliner_show_internal_symbols, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch49_g_error;
			}
		}
		goto __finally49;
		__catch49_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:143: Error settings outliner_show_internal_symbo" \
"ls: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally49:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "outliner-show-internal-symbols");
}


gboolean vtg_configuration_get_project_only_show_sources (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_project_only_show_sources;
	return result;
}


void vtg_configuration_set_project_only_show_sources (VtgConfiguration* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_project_only_show_sources != value) {
		self->priv->_project_only_show_sources = value;
		{
			gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, self->priv->_project_only_show_sources, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
		}
		goto __finally50;
		__catch50_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:160: Error settings project_only_show_sources: %" \
"s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally50:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "project-only-show-sources");
}


gboolean vtg_configuration_get_save_before_build (VtgConfiguration* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


static void _vtg_configuration_on_conf_value_changed_gconf_client_value_changed (GConfClient* _sender, const char* key, void* value, gpointer self) {
	vtg_configuration_on_conf_value_changed (self, _sender, key, value);
}


static GObject * vtg_configuration_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VtgConfiguration * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (vtg_configuration_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VTG_CONFIGURATION (obj);
	_inner_error_ = NULL;
	{
		{
			GConfClient* _tmp0_;
			gboolean exists_base;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp31_ = FALSE;
			gboolean _tmp34_;
			gboolean _tmp35_;
			gboolean _tmp36_;
			char* _tmp37_;
			char* _tmp38_;
			char* _tmp39_;
			char* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			gboolean _tmp43_;
			gboolean _tmp44_;
			gboolean _tmp45_;
			gboolean _tmp46_;
			self->priv->_gconf = (_tmp0_ = _g_object_ref0 (gconf_client_get_default ()), _g_object_unref0 (self->priv->_gconf), _tmp0_);
			exists_base = gconf_client_dir_exists (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_BASE_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			if (!exists_base) {
				_tmp1_ = TRUE;
			} else {
				GConfSchema* _tmp2_;
				GConfSchema* _tmp3_;
				_tmp2_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp1_ = (_tmp3_ = _tmp2_) == NULL;
				_gconf_schema_free0 (_tmp3_);
			}
			if (_tmp1_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Enable the symbol completion module"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp4_ = TRUE;
			} else {
				GConfSchema* _tmp5_;
				GConfSchema* _tmp6_;
				_tmp5_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp4_ = (_tmp6_ = _tmp5_) == NULL;
				_gconf_schema_free0 (_tmp6_);
			}
			if (_tmp4_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Enable the bracket completion module"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp7_ = TRUE;
			} else {
				GConfSchema* _tmp8_;
				GConfSchema* _tmp9_;
				_tmp8_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp7_ = (_tmp9_ = _tmp8_) == NULL;
				_gconf_schema_free0 (_tmp9_);
			}
			if (_tmp7_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Enable the source code outliner module"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp10_ = TRUE;
			} else {
				GConfSchema* _tmp11_;
				GConfSchema* _tmp12_;
				_tmp11_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_AUTHOR_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp10_ = (_tmp12_ = _tmp11_) == NULL;
				_gconf_schema_free0 (_tmp12_);
			}
			if (_tmp10_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Override the author name used in the ChangeLog entries"));
				gconf_schema_set_type (schema, GCONF_VALUE_STRING);
				def_value = gconf_value_new (GCONF_VALUE_STRING);
				gconf_value_set_string (def_value, "");
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_AUTHOR_KEY, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_AUTHOR_KEY, "", &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp13_ = TRUE;
			} else {
				GConfSchema* _tmp14_;
				GConfSchema* _tmp15_;
				_tmp14_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp13_ = (_tmp15_ = _tmp14_) == NULL;
				_gconf_schema_free0 (_tmp15_);
			}
			if (_tmp13_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Override the author name used in the ChangeLog entries"));
				gconf_schema_set_type (schema, GCONF_VALUE_STRING);
				def_value = gconf_value_new (GCONF_VALUE_STRING);
				gconf_value_set_string (def_value, "");
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, "", &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp16_ = TRUE;
			} else {
				GConfSchema* _tmp17_;
				GConfSchema* _tmp18_;
				_tmp17_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp16_ = (_tmp18_ = _tmp17_) == NULL;
				_gconf_schema_free0 (_tmp18_);
			}
			if (_tmp16_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Store the completion info window visible status"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE, FALSE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp19_ = TRUE;
			} else {
				GConfSchema* _tmp20_;
				GConfSchema* _tmp21_;
				_tmp20_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp19_ = (_tmp21_ = _tmp20_) == NULL;
				_gconf_schema_free0 (_tmp21_);
			}
			if (_tmp19_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Store the source outliner show private symbol check button status"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, FALSE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp22_ = TRUE;
			} else {
				GConfSchema* _tmp23_;
				GConfSchema* _tmp24_;
				_tmp23_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp22_ = (_tmp24_ = _tmp23_) == NULL;
				_gconf_schema_free0 (_tmp24_);
			}
			if (_tmp22_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Store the source outliner show public symbol check button status"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, FALSE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp25_ = TRUE;
			} else {
				GConfSchema* _tmp26_;
				GConfSchema* _tmp27_;
				_tmp26_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp25_ = (_tmp27_ = _tmp26_) == NULL;
				_gconf_schema_free0 (_tmp27_);
			}
			if (_tmp25_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Store the source outliner show protected symbol check button status"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS, FALSE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp28_ = TRUE;
			} else {
				GConfSchema* _tmp29_;
				GConfSchema* _tmp30_;
				_tmp29_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp28_ = (_tmp30_ = _tmp29_) == NULL;
				_gconf_schema_free0 (_tmp30_);
			}
			if (_tmp28_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Store the source outliner show internal symbol check button status"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, FALSE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			if (!exists_base) {
				_tmp31_ = TRUE;
			} else {
				GConfSchema* _tmp32_;
				GConfSchema* _tmp33_;
				_tmp32_ = gconf_client_get_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				_tmp31_ = (_tmp33_ = _tmp32_) == NULL;
				_gconf_schema_free0 (_tmp33_);
			}
			if (_tmp31_) {
				GConfSchema* schema;
				GConfValue* def_value;
				schema = gconf_schema_new ();
				gconf_schema_set_short_desc (schema, _ ("Store the project view show only sources check button status"));
				gconf_schema_set_type (schema, GCONF_VALUE_BOOL);
				def_value = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_bool (def_value, TRUE);
				gconf_schema_set_default_value (schema, def_value);
				gconf_client_set_schema (self->priv->_gconf, "/schemas" VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, schema, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				gconf_client_set_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_gconf_value_free0 (def_value);
					_gconf_schema_free0 (schema);
					goto __catch51_g_error;
				}
				_gconf_value_free0 (def_value);
				_gconf_schema_free0 (schema);
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY, "/schemas" VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_AUTHOR_KEY, "/schemas" VTG_CONFIGURATION_VTG_AUTHOR_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, "/schemas" VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE, "/schemas" VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, "/schemas" VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			gconf_engine_associate_schema (self->priv->_gconf->engine, VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, "/schemas" VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			_tmp34_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SYMBOL_COMPLETION_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_symbol_enabled = _tmp34_;
			_tmp35_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_BRACKET_COMPLETION_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_bracket_enabled = _tmp35_;
			_tmp36_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_ENABLE_SOURCECODE_OUTLINER_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_sourcecode_outliner_enabled = _tmp36_;
			_tmp37_ = gconf_client_get_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_AUTHOR_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_author = (_tmp38_ = _tmp37_, _g_free0 (self->priv->_author), _tmp38_);
			_tmp39_ = gconf_client_get_string (self->priv->_gconf, VTG_CONFIGURATION_VTG_EMAIL_ADDRESS_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_email_address = (_tmp40_ = _tmp39_, _g_free0 (self->priv->_email_address), _tmp40_);
			_tmp41_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_INFO_WINDOW_VISIBLE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_info_window_visible = _tmp41_;
			_tmp42_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PRIVATE_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_outliner_show_private_symbols = _tmp42_;
			_tmp43_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PUBLIC_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_outliner_show_public_symbols = _tmp43_;
			_tmp44_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_PROTECTED_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_outliner_show_protected_symbols = _tmp44_;
			_tmp45_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_OUTLINER_SHOW_INTERNAL_SYMBOLS, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_outliner_show_internal_symbols = _tmp45_;
			_tmp46_ = gconf_client_get_bool (self->priv->_gconf, VTG_CONFIGURATION_VTG_PROJECT_VIEW_ONLY_SHOW_SOURCES, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			self->priv->_project_only_show_sources = _tmp46_;
			gconf_client_add_dir (self->priv->_gconf, VTG_CONFIGURATION_VTG_BASE_KEY, GCONF_CLIENT_PRELOAD_ONELEVEL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			g_signal_connect_object (self->priv->_gconf, "value-changed", (GCallback) _vtg_configuration_on_conf_value_changed_gconf_client_value_changed, self, 0);
		}
		goto __finally51;
		__catch51_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:318: (configuration): %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally51:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void vtg_configuration_class_init (VtgConfigurationClass * klass) {
	vtg_configuration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgConfigurationPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_configuration_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_configuration_set_property;
	G_OBJECT_CLASS (klass)->constructor = vtg_configuration_constructor;
	G_OBJECT_CLASS (klass)->finalize = vtg_configuration_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_BRACKET_ENABLED, g_param_spec_boolean ("bracket-enabled", "bracket-enabled", "bracket-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_SYMBOL_ENABLED, g_param_spec_boolean ("symbol-enabled", "symbol-enabled", "symbol-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_SOURCECODE_OUTLINER_ENABLED, g_param_spec_boolean ("sourcecode-outliner-enabled", "sourcecode-outliner-enabled", "sourcecode-outliner-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_AUTHOR, g_param_spec_string ("author", "author", "author", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_EMAIL_ADDRESS, g_param_spec_string ("email-address", "email-address", "email-address", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_INFO_WINDOW_VISIBLE, g_param_spec_boolean ("info-window-visible", "info-window-visible", "info-window-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_OUTLINER_SHOW_PRIVATE_SYMBOLS, g_param_spec_boolean ("outliner-show-private-symbols", "outliner-show-private-symbols", "outliner-show-private-symbols", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_OUTLINER_SHOW_PUBLIC_SYMBOLS, g_param_spec_boolean ("outliner-show-public-symbols", "outliner-show-public-symbols", "outliner-show-public-symbols", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_OUTLINER_SHOW_PROTECTED_SYMBOLS, g_param_spec_boolean ("outliner-show-protected-symbols", "outliner-show-protected-symbols", "outliner-show-protected-symbols", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_OUTLINER_SHOW_INTERNAL_SYMBOLS, g_param_spec_boolean ("outliner-show-internal-symbols", "outliner-show-internal-symbols", "outliner-show-internal-symbols", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_PROJECT_ONLY_SHOW_SOURCES, g_param_spec_boolean ("project-only-show-sources", "project-only-show-sources", "project-only-show-sources", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CONFIGURATION_SAVE_BEFORE_BUILD, g_param_spec_boolean ("save-before-build", "save-before-build", "save-before-build", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vtg_configuration_instance_init (VtgConfiguration * self) {
	self->priv = VTG_CONFIGURATION_GET_PRIVATE (self);
	self->priv->_info_window_visible = FALSE;
	self->priv->_outliner_show_private_symbols = FALSE;
	self->priv->_outliner_show_public_symbols = FALSE;
	self->priv->_outliner_show_protected_symbols = FALSE;
	self->priv->_outliner_show_internal_symbols = FALSE;
	self->priv->_project_only_show_sources = TRUE;
}


static void vtg_configuration_finalize (GObject* obj) {
	VtgConfiguration * self;
	GError * _inner_error_;
	self = VTG_CONFIGURATION (obj);
	_inner_error_ = NULL;
	{
		{
			gconf_client_suggest_sync (self->priv->_gconf, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch52_g_error;
			}
		}
		goto __finally52;
		__catch52_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgconfiguration.vala:328: error %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally52:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (self->priv->_gconf);
	_g_object_unref0 (self->priv->_dialog);
	_g_free0 (self->priv->_author);
	_g_free0 (self->priv->_email_address);
	G_OBJECT_CLASS (vtg_configuration_parent_class)->finalize (obj);
}


GType vtg_configuration_get_type (void) {
	return vtg_configuration_type_id;
}


GType vtg_configuration_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgConfigurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_configuration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgConfiguration), 0, (GInstanceInitFunc) vtg_configuration_instance_init, NULL };
	vtg_configuration_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgConfiguration", &g_define_type_info, 0);
	return vtg_configuration_type_id;
}


static void vtg_configuration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgConfiguration * self;
	self = VTG_CONFIGURATION (object);
	switch (property_id) {
		case VTG_CONFIGURATION_BRACKET_ENABLED:
		g_value_set_boolean (value, vtg_configuration_get_bracket_enabled (self));
		break;
		case VTG_CONFIGURATION_SYMBOL_ENABLED:
		g_value_set_boolean (value, vtg_configuration_get_symbol_enabled (self));
		break;
		case VTG_CONFIGURATION_SOURCECODE_OUTLINER_ENABLED:
		g_value_set_boolean (value, vtg_configuration_get_sourcecode_outliner_enabled (self));
		break;
		case VTG_CONFIGURATION_AUTHOR:
		g_value_set_string (value, vtg_configuration_get_author (self));
		break;
		case VTG_CONFIGURATION_EMAIL_ADDRESS:
		g_value_set_string (value, vtg_configuration_get_email_address (self));
		break;
		case VTG_CONFIGURATION_INFO_WINDOW_VISIBLE:
		g_value_set_boolean (value, vtg_configuration_get_info_window_visible (self));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_PRIVATE_SYMBOLS:
		g_value_set_boolean (value, vtg_configuration_get_outliner_show_private_symbols (self));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_PUBLIC_SYMBOLS:
		g_value_set_boolean (value, vtg_configuration_get_outliner_show_public_symbols (self));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_PROTECTED_SYMBOLS:
		g_value_set_boolean (value, vtg_configuration_get_outliner_show_protected_symbols (self));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_INTERNAL_SYMBOLS:
		g_value_set_boolean (value, vtg_configuration_get_outliner_show_internal_symbols (self));
		break;
		case VTG_CONFIGURATION_PROJECT_ONLY_SHOW_SOURCES:
		g_value_set_boolean (value, vtg_configuration_get_project_only_show_sources (self));
		break;
		case VTG_CONFIGURATION_SAVE_BEFORE_BUILD:
		g_value_set_boolean (value, vtg_configuration_get_save_before_build (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_configuration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgConfiguration * self;
	self = VTG_CONFIGURATION (object);
	switch (property_id) {
		case VTG_CONFIGURATION_BRACKET_ENABLED:
		vtg_configuration_set_bracket_enabled (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_SYMBOL_ENABLED:
		vtg_configuration_set_symbol_enabled (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_SOURCECODE_OUTLINER_ENABLED:
		vtg_configuration_set_sourcecode_outliner_enabled (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_AUTHOR:
		vtg_configuration_set_author (self, g_value_get_string (value));
		break;
		case VTG_CONFIGURATION_EMAIL_ADDRESS:
		vtg_configuration_set_email_address (self, g_value_get_string (value));
		break;
		case VTG_CONFIGURATION_INFO_WINDOW_VISIBLE:
		vtg_configuration_set_info_window_visible (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_PRIVATE_SYMBOLS:
		vtg_configuration_set_outliner_show_private_symbols (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_PUBLIC_SYMBOLS:
		vtg_configuration_set_outliner_show_public_symbols (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_PROTECTED_SYMBOLS:
		vtg_configuration_set_outliner_show_protected_symbols (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_OUTLINER_SHOW_INTERNAL_SYMBOLS:
		vtg_configuration_set_outliner_show_internal_symbols (self, g_value_get_boolean (value));
		break;
		case VTG_CONFIGURATION_PROJECT_ONLY_SHOW_SOURCES:
		vtg_configuration_set_project_only_show_sources (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




