/* vtgbracketcompletion.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgbracketcompletion.vala, do not modify */

/*
 *  vtgbracketcompletion.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-view.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gdk/gdkkeysyms.h>
#include <float.h>
#include <math.h>
#include <gedit/gedit-prefs-manager.h>


#define VTG_TYPE_BRACKET_COMPLETION (vtg_bracket_completion_get_type ())
#define VTG_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletion))
#define VTG_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))
#define VTG_IS_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_IS_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_BRACKET_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))

typedef struct _VtgBracketCompletion VtgBracketCompletion;
typedef struct _VtgBracketCompletionClass VtgBracketCompletionClass;
typedef struct _VtgBracketCompletionPrivate VtgBracketCompletionPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _VtgBracketCompletion {
	GObject parent_instance;
	VtgBracketCompletionPrivate * priv;
};

struct _VtgBracketCompletionClass {
	GObjectClass parent_class;
};

struct _VtgBracketCompletionPrivate {
	VtgPluginInstance* _plugin_instance;
	GeditView* _view;
	char* tab_chars;
};


static gpointer vtg_bracket_completion_parent_class = NULL;
static GType vtg_bracket_completion_type_id = 0;

GType vtg_bracket_completion_get_type (void) G_GNUC_CONST;
GType vtg_bracket_completion_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
#define VTG_BRACKET_COMPLETION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionPrivate))
enum  {
	VTG_BRACKET_COMPLETION_DUMMY_PROPERTY,
	VTG_BRACKET_COMPLETION_PLUGIN_INSTANCE,
	VTG_BRACKET_COMPLETION_VIEW
};
VtgBracketCompletion* vtg_bracket_completion_new (VtgPluginInstance* plugin_instance, GeditView* view);
VtgBracketCompletion* vtg_bracket_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view);
void vtg_bracket_completion_deactivate (VtgBracketCompletion* self);
static void vtg_bracket_completion_disconnect_view (VtgBracketCompletion* self, GeditView* view);
static void vtg_bracket_completion_connect_view (VtgBracketCompletion* self, GeditView* view);
static gboolean vtg_bracket_completion_on_view_key_press (GeditView* sender, GdkEventKey* evt, VtgBracketCompletion* instance);
static gboolean vtg_bracket_completion_enclose_selection_with_delimiters (VtgBracketCompletion* self, GtkTextBuffer* src, const char* start_delimiter, const char* end_delimiter);
static void vtg_bracket_completion_insert_chars (VtgBracketCompletion* self, GtkTextBuffer* src, const char* chars);
static void vtg_bracket_completion_move_backwards (VtgBracketCompletion* self, GtkTextBuffer* src, gint count);
static char* vtg_bracket_completion_subtract_indentation (VtgBracketCompletion* self, const char* indentation, gint levels);
static const char* vtg_bracket_completion_current_indentation_text (VtgBracketCompletion* self, GtkTextBuffer* src);
static void vtg_bracket_completion_backward_skip_spaces (VtgBracketCompletion* self, GtkTextIter* start);
static gboolean vtg_bracket_completion_find_char (VtgBracketCompletion* self, GtkTextIter* start, gunichar char_to_find, gunichar complementary_char, gunichar* stop_to_chars, int stop_to_chars_length1);
gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos);
void vtg_utils_trace (const char* format, ...);
char* vtg_parser_utils_get_line_to_end (GtkTextIter* start);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
VtgPluginInstance* vtg_bracket_completion_get_plugin_instance (VtgBracketCompletion* self);
static void vtg_bracket_completion_set_plugin_instance (VtgBracketCompletion* self, VtgPluginInstance* value);
GeditView* vtg_bracket_completion_get_view (VtgBracketCompletion* self);
static void vtg_bracket_completion_set_view (VtgBracketCompletion* self, GeditView* value);
static GObject * vtg_bracket_completion_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vtg_bracket_completion_finalize (GObject* obj);
static void vtg_bracket_completion_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_bracket_completion_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



VtgBracketCompletion* vtg_bracket_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view) {
	VtgBracketCompletion * self;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	self = (VtgBracketCompletion*) g_object_new (object_type, "plugin-instance", plugin_instance, "view", view, NULL);
	return self;
}


VtgBracketCompletion* vtg_bracket_completion_new (VtgPluginInstance* plugin_instance, GeditView* view) {
	return vtg_bracket_completion_construct (VTG_TYPE_BRACKET_COMPLETION, plugin_instance, view);
}


void vtg_bracket_completion_deactivate (VtgBracketCompletion* self) {
	g_return_if_fail (self != NULL);
	vtg_bracket_completion_disconnect_view (self, self->priv->_view);
}


static void vtg_bracket_completion_connect_view (VtgBracketCompletion* self, GeditView* view) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_signal_connect (view, "key-press-event", (GCallback) vtg_bracket_completion_on_view_key_press, self);
}


static void vtg_bracket_completion_disconnect_view (VtgBracketCompletion* self, GeditView* view) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_signal_handlers_disconnect_by_func (view, (void*) vtg_bracket_completion_on_view_key_press, self);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static gboolean vtg_bracket_completion_enclose_selection_with_delimiters (VtgBracketCompletion* self, GtkTextBuffer* src, const char* start_delimiter, const char* end_delimiter) {
	gboolean result = FALSE;
	GtkTextIter sel_start = {0};
	GtkTextIter sel_end = {0};
	char* text;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (src != NULL, FALSE);
	g_return_val_if_fail (start_delimiter != NULL, FALSE);
	gtk_text_buffer_get_selection_bounds (src, &sel_start, &sel_end);
	text = g_strdup (gtk_text_buffer_get_text (src, &sel_start, &sel_end, TRUE));
	if (end_delimiter == NULL) {
		end_delimiter = start_delimiter;
	}
	if (g_str_has_prefix (text, start_delimiter) == FALSE) {
		_tmp0_ = g_str_has_suffix (text, end_delimiter) == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTextMark* mark;
		GtkTextIter pos = {0};
		char* _tmp1_;
		mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert (src));
		text = (_tmp1_ = g_strdup_printf ("%s%s%s", start_delimiter, text, end_delimiter), _g_free0 (text), _tmp1_);
		gtk_text_buffer_begin_user_action (src);
		gtk_text_buffer_delete_selection (src, TRUE, TRUE);
		gtk_text_buffer_get_iter_at_mark (src, &pos, mark);
		gtk_text_buffer_insert (src, &pos, text, (gint) string_get_length (text));
		gtk_text_buffer_end_user_action (src);
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	result = FALSE;
	_g_free0 (text);
	return result;
}


static void vtg_bracket_completion_insert_chars (VtgBracketCompletion* self, GtkTextBuffer* src, const char* chars) {
	GtkTextMark* mark;
	GtkTextIter pos = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (chars != NULL);
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert (src));
	gtk_text_buffer_get_iter_at_mark (src, &pos, mark);
	gtk_text_buffer_begin_user_action (src);
	gtk_text_buffer_insert (src, &pos, chars, (gint) string_get_length (chars));
	gtk_text_buffer_end_user_action (src);
}


static void vtg_bracket_completion_move_backwards (VtgBracketCompletion* self, GtkTextBuffer* src, gint count) {
	GtkTextMark* mark;
	GtkTextIter pos = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert (src));
	gtk_text_buffer_get_iter_at_mark (src, &pos, mark);
	gtk_text_iter_backward_chars (&pos, count);
	gtk_text_buffer_place_cursor (src, &pos);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* vtg_bracket_completion_subtract_indentation (VtgBracketCompletion* self, const char* indentation, gint levels) {
	char* result = NULL;
	char* current;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (indentation != NULL, NULL);
	current = g_strdup ("");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < levels)) {
					break;
				}
				current = (_tmp1_ = g_strconcat (current, self->priv->tab_chars, NULL), _g_free0 (current), _tmp1_);
			}
		}
	}
	if (string_get_length (indentation) < string_get_length (current)) {
		result = g_strdup ("");
		_g_free0 (current);
		return result;
	}
	result = (_tmp3_ = g_strdup_printf ("%s", _tmp2_ = string_substring (indentation, string_get_length (current), -1)), _g_free0 (_tmp2_), _tmp3_);
	_g_free0 (current);
	return result;
	_g_free0 (current);
}


static const char* vtg_bracket_completion_current_indentation_text (VtgBracketCompletion* self, GtkTextBuffer* src) {
	const char* result = NULL;
	GtkTextMark* mark;
	GtkTextIter end = {0};
	GtkTextIter start = {0};
	const char* text;
	gint col = 0;
	gint line = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert (src));
	text = "";
	gtk_text_buffer_get_iter_at_mark (src, &end, mark);
	col = gtk_text_iter_get_line_offset (&end);
	if (col > 0) {
		gunichar ch;
		line = gtk_text_iter_get_line (&end);
		gtk_text_iter_set_line_offset (&end, 0);
		start = end;
		ch = gtk_text_iter_get_char (&end);
		if (g_unichar_isspace (ch)) {
			while (TRUE) {
				if (!gtk_text_iter_forward_char (&end)) {
					break;
				}
				if (line != gtk_text_iter_get_line (&end)) {
					gtk_text_iter_backward_char (&end);
					break;
				} else {
					if (gtk_text_iter_starts_word (&end)) {
						break;
					} else {
						if (gtk_text_iter_get_line_offset (&end) >= col) {
							break;
						} else {
							ch = gtk_text_iter_get_char (&end);
							if (g_unichar_isspace (ch) == FALSE) {
								break;
							}
						}
					}
				}
			}
		}
		if (!gtk_text_iter_equal (&start, &end)) {
			text = gtk_text_iter_get_text (&start, &end);
		}
	}
	result = text;
	return result;
}


static void vtg_bracket_completion_backward_skip_spaces (VtgBracketCompletion* self, GtkTextIter* start) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		if (!gtk_text_iter_backward_char (start)) {
			break;
		}
		if (!g_unichar_isspace (gtk_text_iter_get_char (start))) {
			break;
		}
	}
}


static gboolean vtg_bracket_completion_find_char (VtgBracketCompletion* self, GtkTextIter* start, gunichar char_to_find, gunichar complementary_char, gunichar* stop_to_chars, int stop_to_chars_length1) {
	gboolean result = FALSE;
	gboolean _result_;
	gint level;
	GtkTextIter curr;
	g_return_val_if_fail (self != NULL, FALSE);
	_result_ = FALSE;
	level = 0;
	curr = *start;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			gunichar ch;
			gboolean stop_char_found;
			if (!_tmp0_) {
				if (!gtk_text_iter_forward_char (&curr)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			ch = gtk_text_iter_get_char (&curr);
			stop_char_found = FALSE;
			{
				gunichar* stop_to_char_collection;
				int stop_to_char_collection_length1;
				int stop_to_char_it;
				stop_to_char_collection = stop_to_chars;
				stop_to_char_collection_length1 = stop_to_chars_length1;
				for (stop_to_char_it = 0; stop_to_char_it < stop_to_chars_length1; stop_to_char_it = stop_to_char_it + 1) {
					gunichar stop_to_char;
					stop_to_char = stop_to_char_collection[stop_to_char_it];
					{
						if (ch == stop_to_char) {
							stop_char_found = TRUE;
							break;
						}
					}
				}
			}
			if (stop_char_found) {
				break;
			} else {
				if (ch == char_to_find) {
					if (level == 0) {
						_result_ = TRUE;
						break;
					} else {
						level--;
					}
				} else {
					if (ch == complementary_char) {
						level++;
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean vtg_bracket_completion_on_view_key_press (GeditView* sender, GdkEventKey* evt, VtgBracketCompletion* instance) {
	gboolean result = FALSE;
	gboolean _result_;
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (instance != NULL, FALSE);
	_result_ = FALSE;
	if (((*evt).state & GDK_MOD1_MASK) == 0) {
		GtkSourceBuffer* src;
		GtkTextMark* mark;
		GtkTextIter pos = {0};
		gunichar ch;
		gboolean _tmp0_ = FALSE;
		const char* indent;
		char* buffer;
		src = _g_object_ref0 (GTK_SOURCE_BUFFER (gtk_text_view_get_buffer ((GtkTextView*) sender)));
		mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) src));
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &pos, mark);
		ch = (gunichar) gdk_keyval_to_unicode ((*evt).keyval);
		if ((*evt).keyval != GDK_Return) {
			_tmp0_ = ((*evt).state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK)) == 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			if (vtg_utils_is_inside_comment_or_literal (src, &pos)) {
				result = _result_;
				_g_object_unref0 (src);
				return result;
			}
		}
		indent = NULL;
		buffer = NULL;
		if (ch == '(') {
			gboolean inside_block;
			GtkTextIter start;
			gboolean prev_char_is_parenthesis;
			gboolean line_has_semicolon;
			char* _tmp21_;
			inside_block = FALSE;
			start = pos;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				if (!gtk_text_iter_backward_char (&start)) {
					break;
				}
				ch = gtk_text_iter_get_char (&start);
				if (ch == ';') {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = ch == ')';
				}
				if (_tmp1_) {
					inside_block = TRUE;
					break;
				} else {
					if (ch == '{') {
						while (TRUE) {
							gboolean _tmp2_ = FALSE;
							gboolean _tmp3_ = FALSE;
							if (!inside_block) {
								_tmp2_ = gtk_text_iter_backward_char (&start);
							} else {
								_tmp2_ = FALSE;
							}
							if (!_tmp2_) {
								break;
							}
							ch = gtk_text_iter_get_char (&start);
							if (ch != ' ') {
								_tmp3_ = ch != '\t';
							} else {
								_tmp3_ = FALSE;
							}
							if (_tmp3_) {
								if (ch == ')') {
									inside_block = TRUE;
								} else {
									break;
								}
							}
						}
						break;
					} else {
						gboolean _tmp4_ = FALSE;
						gboolean _tmp5_ = FALSE;
						gboolean _tmp6_ = FALSE;
						if (ch == '}') {
							_tmp6_ = TRUE;
						} else {
							_tmp6_ = ch == '(';
						}
						if (_tmp6_) {
							_tmp5_ = TRUE;
						} else {
							_tmp5_ = ch == '|';
						}
						if (_tmp5_) {
							_tmp4_ = TRUE;
						} else {
							_tmp4_ = ch == '&';
						}
						if (_tmp4_) {
							inside_block = FALSE;
							break;
						}
					}
				}
			}
			if (inside_block) {
				start = pos;
				if (gtk_text_iter_backward_word_start (&start)) {
					char* _tmp7_;
					char* _tmp8_;
					char* _tmp9_;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					buffer = (_tmp7_ = g_strdup (gtk_text_iter_get_slice (&start, &pos)), _g_free0 (buffer), _tmp7_);
					buffer = (_tmp9_ = string_replace (_tmp8_ = string_replace (buffer, " ", ""), "\t", ""), _g_free0 (buffer), _tmp9_);
					_g_free0 (_tmp8_);
					if (_vala_strcmp0 (buffer, "if") == 0) {
						_tmp12_ = TRUE;
					} else {
						_tmp12_ = _vala_strcmp0 (buffer, "do") == 0;
					}
					if (_tmp12_) {
						_tmp11_ = TRUE;
					} else {
						_tmp11_ = _vala_strcmp0 (buffer, "while") == 0;
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						_tmp10_ = g_str_has_prefix (buffer, "for");
					}
					if (_tmp10_) {
						inside_block = FALSE;
					} else {
						while (TRUE) {
							gboolean _tmp13_ = FALSE;
							gboolean _tmp14_ = FALSE;
							gboolean _tmp15_ = FALSE;
							gboolean _tmp16_ = FALSE;
							if (!gtk_text_iter_backward_char (&start)) {
								break;
							}
							ch = gtk_text_iter_get_char (&start);
							if (ch == ';') {
								_tmp16_ = TRUE;
							} else {
								_tmp16_ = ch == '{';
							}
							if (_tmp16_) {
								_tmp15_ = TRUE;
							} else {
								_tmp15_ = ch == '=';
							}
							if (_tmp15_) {
								_tmp14_ = TRUE;
							} else {
								_tmp14_ = ch == '.';
							}
							if (_tmp14_) {
								_tmp13_ = TRUE;
							} else {
								_tmp13_ = ch == ')';
							}
							if (_tmp13_) {
								break;
							} else {
								gboolean _tmp17_ = FALSE;
								gboolean _tmp18_ = FALSE;
								gboolean _tmp19_ = FALSE;
								gboolean _tmp20_ = FALSE;
								if (ch != '\t') {
									_tmp20_ = ch != ' ';
								} else {
									_tmp20_ = FALSE;
								}
								if (_tmp20_) {
									_tmp19_ = ch != '\n';
								} else {
									_tmp19_ = FALSE;
								}
								if (_tmp19_) {
									_tmp18_ = ch != '\r';
								} else {
									_tmp18_ = FALSE;
								}
								if (_tmp18_) {
									_tmp17_ = !g_unichar_isalnum (ch);
								} else {
									_tmp17_ = FALSE;
								}
								if (_tmp17_) {
									vtg_utils_trace ("vtgbracketcompletion.vala:299: not a block %u", (guint) ch);
									inside_block = FALSE;
									break;
								}
							}
						}
					}
				}
			}
			prev_char_is_parenthesis = FALSE;
			line_has_semicolon = FALSE;
			start = pos;
			vtg_bracket_completion_backward_skip_spaces (instance, &start);
			prev_char_is_parenthesis = gtk_text_iter_get_char (&start) == '(';
			line_has_semicolon = g_strrstr (_tmp21_ = vtg_parser_utils_get_line_to_end (&pos), ";") != NULL;
			_g_free0 (_tmp21_);
			if (gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src)) {
				if (vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "(", ")")) {
					gboolean _tmp22_ = FALSE;
					if (inside_block) {
						_tmp22_ = !line_has_semicolon;
					} else {
						_tmp22_ = FALSE;
					}
					if (_tmp22_) {
						vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, ";");
					}
					gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &pos, mark);
					gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
					_result_ = TRUE;
				}
			} else {
				gboolean _tmp23_ = FALSE;
				if (prev_char_is_parenthesis) {
					_tmp23_ = TRUE;
				} else {
					gunichar* _tmp24_ = NULL;
					gunichar* _tmp25_;
					gint _tmp25__length1;
					_tmp23_ = !vtg_bracket_completion_find_char (instance, &pos, (gunichar) ')', (gunichar) '(', (_tmp25_ = (_tmp24_ = g_new0 (gunichar, 2), _tmp24_[0] = (gunichar) '}', _tmp24_[1] = (gunichar) ';', _tmp24_), _tmp25__length1 = 2, _tmp25_), 2);
					_tmp25_ = (g_free (_tmp25_), NULL);
				}
				if (_tmp23_) {
					gboolean _tmp26_ = FALSE;
					vtg_utils_trace ("vtgbracketcompletion.vala:327: inside %d next %d", (gint) inside_block, (gint) line_has_semicolon);
					if (inside_block) {
						_tmp26_ = !line_has_semicolon;
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, ");");
						vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 2);
					} else {
						vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, ")");
						vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 1);
					}
				}
			}
		} else {
			if (ch == '[') {
				gunichar* _tmp27_ = NULL;
				gunichar* _tmp28_;
				gint _tmp28__length1;
				gboolean _tmp29_;
				if ((_tmp29_ = !vtg_bracket_completion_find_char (instance, &pos, (gunichar) ']', (gunichar) '[', (_tmp28_ = (_tmp27_ = g_new0 (gunichar, 2), _tmp27_[0] = (gunichar) '}', _tmp27_[1] = (gunichar) ';', _tmp27_), _tmp28__length1 = 2, _tmp28_), 2), _tmp28_ = (g_free (_tmp28_), NULL), _tmp29_)) {
					vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, "]");
					vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 1);
				}
			} else {
				if (ch == '*') {
					indent = vtg_bracket_completion_current_indentation_text (instance, (GtkTextBuffer*) src);
					if (gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src)) {
						GtkTextIter sel_start = {0};
						GtkTextIter sel_end = {0};
						gboolean _tmp30_ = FALSE;
						gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) src, &sel_start, &sel_end);
						gtk_text_iter_backward_char (&sel_start);
						if (gtk_text_iter_get_char (&sel_start) == '/') {
							_tmp30_ = vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "*", "*/");
						} else {
							_tmp30_ = FALSE;
						}
						if (_tmp30_) {
							gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &pos, mark);
							gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
							_result_ = TRUE;
						}
					} else {
						gtk_text_iter_backward_char (&pos);
						if (gtk_text_iter_get_char (&pos) == '/') {
							char* _tmp31_;
							buffer = (_tmp31_ = g_strdup ("*  */"), _g_free0 (buffer), _tmp31_);
							vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
							gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (double) 0, FALSE, (double) 0, (double) 0);
							vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 3);
							_result_ = TRUE;
						}
					}
				} else {
					if (ch == '{') {
						indent = vtg_bracket_completion_current_indentation_text (instance, (GtkTextBuffer*) src);
						if (gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src)) {
							char* tmp;
							char* _tmp32_;
							gboolean _tmp33_;
							tmp = vtg_bracket_completion_subtract_indentation (instance, indent, 1);
							if ((_tmp33_ = vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "{", _tmp32_ = g_strdup_printf ("\n%s}\n", tmp)), _g_free0 (_tmp32_), _tmp33_)) {
								gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &pos, mark);
								gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
							}
							_result_ = TRUE;
							_g_free0 (tmp);
						} else {
							gboolean _tmp34_ = FALSE;
							ch = (gunichar) ' ';
							if (gtk_text_iter_backward_char (&pos)) {
								ch = gtk_text_iter_get_char (&pos);
							}
							if (ch != '\'') {
								_tmp34_ = ch != '\"';
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								char* _tmp35_;
								char* line;
								gboolean _tmp39_ = FALSE;
								gboolean _tmp40_ = FALSE;
								buffer = (_tmp35_ = g_strdup ("{"), _g_free0 (buffer), _tmp35_);
								line = NULL;
								if (gtk_text_iter_forward_line (&pos)) {
									GtkTextIter end;
									char* _tmp36_;
									char* _tmp37_;
									char* _tmp38_;
									end = pos;
									gtk_text_iter_forward_to_line_end (&end);
									line = (_tmp36_ = g_strdup (gtk_text_iter_get_slice (&pos, &end)), _g_free0 (line), _tmp36_);
									line = (_tmp38_ = string_replace (_tmp37_ = string_replace (line, " ", ""), "\t", ""), _g_free0 (line), _tmp38_);
									_g_free0 (_tmp37_);
								}
								if (vtg_string_utils_is_null_or_empty (line)) {
									_tmp40_ = TRUE;
								} else {
									_tmp40_ = g_str_has_prefix (line, "\n");
								}
								if (_tmp40_) {
									_tmp39_ = TRUE;
								} else {
									_tmp39_ = g_str_has_prefix (line, "}");
								}
								if (_tmp39_) {
									char* _tmp41_;
									buffer = (_tmp41_ = g_strdup_printf ("{\n%s%s\n%s}", indent, instance->priv->tab_chars, indent), _g_free0 (buffer), _tmp41_);
									vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (double) 0, FALSE, (double) 0, (double) 0);
									vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 2 + ((gint) string_get_length (indent)));
									_result_ = TRUE;
								}
								_g_free0 (line);
							}
						}
					} else {
						if ((*evt).keyval == GDK_Return) {
							indent = vtg_bracket_completion_current_indentation_text (instance, (GtkTextBuffer*) src);
							if (((*evt).state & GDK_SHIFT_MASK) != 0) {
								if (!gtk_text_iter_ends_line (&pos)) {
									gtk_text_iter_forward_to_line_end (&pos);
									gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
								}
								if (((*evt).state & GDK_CONTROL_MASK) == 0) {
									char* _tmp42_;
									GtkTextIter tmp;
									buffer = (_tmp42_ = g_strdup (";"), _g_free0 (buffer), _tmp42_);
									tmp = pos;
									while (TRUE) {
										if (!gtk_text_iter_backward_char (&pos)) {
											break;
										}
										ch = gtk_text_iter_get_char (&pos);
										if (!g_unichar_isspace (ch)) {
											if (ch == ';') {
												char* _tmp43_;
												buffer = (_tmp43_ = g_strdup (""), _g_free0 (buffer), _tmp43_);
											}
											gtk_text_iter_forward_char (&pos);
											break;
										}
									}
									if (gtk_text_iter_equal (&tmp, &pos)) {
										char* _tmp44_;
										vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, _tmp44_ = g_strdup_printf ("%s\n%s", buffer, indent));
										_g_free0 (_tmp44_);
									} else {
										char* _tmp45_;
										gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
										if (_vala_strcmp0 (buffer, "") != 0) {
											vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
										}
										gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &pos, mark);
										gtk_text_iter_forward_to_line_end (&pos);
										gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
										vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, _tmp45_ = g_strdup_printf ("\n%s", indent));
										_g_free0 (_tmp45_);
									}
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (double) 0, FALSE, (double) 0, (double) 0);
									gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &pos, mark);
									gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
								} else {
									char* _tmp46_;
									buffer = (_tmp46_ = g_strdup_printf ("\n%s{\n%s%s\n%s}", indent, indent, instance->priv->tab_chars, indent), _g_free0 (buffer), _tmp46_);
									vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, buffer);
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (double) 0, FALSE, (double) 0, (double) 0);
									vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 2 + ((gint) string_get_length (indent)));
								}
								_result_ = TRUE;
							} else {
								gboolean _tmp47_ = FALSE;
								if (indent != NULL) {
									_tmp47_ = _vala_strcmp0 (indent, "") != 0;
								} else {
									_tmp47_ = FALSE;
								}
								if (_tmp47_) {
									char* _tmp48_;
									vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, _tmp48_ = g_strdup_printf ("\n%s", indent));
									_g_free0 (_tmp48_);
									_result_ = TRUE;
									gtk_text_view_scroll_to_mark ((GtkTextView*) sender, mark, (double) 0, FALSE, (double) 0, (double) 0);
								}
							}
						} else {
							if (ch == '\"') {
								if (gtk_text_buffer_get_has_selection ((GtkTextBuffer*) src)) {
									if (vtg_bracket_completion_enclose_selection_with_delimiters (instance, (GtkTextBuffer*) src, "\"", NULL)) {
										gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &pos, mark);
										gtk_text_buffer_place_cursor ((GtkTextBuffer*) src, &pos);
										_result_ = TRUE;
									}
								} else {
									gunichar* _tmp49_ = NULL;
									gunichar* _tmp50_;
									gint _tmp50__length1;
									gboolean _tmp51_;
									if ((_tmp51_ = !vtg_bracket_completion_find_char (instance, &pos, (gunichar) '\"', (gunichar) '\"', (_tmp50_ = (_tmp49_ = g_new0 (gunichar, 2), _tmp49_[0] = (gunichar) '}', _tmp49_[1] = (gunichar) ';', _tmp49_), _tmp50__length1 = 2, _tmp50_), 2), _tmp50_ = (g_free (_tmp50_), NULL), _tmp51_)) {
										vtg_bracket_completion_insert_chars (instance, (GtkTextBuffer*) src, "\"");
										vtg_bracket_completion_move_backwards (instance, (GtkTextBuffer*) src, 1);
									}
								}
							}
						}
					}
				}
			}
		}
		_g_free0 (buffer);
		_g_object_unref0 (src);
	}
	result = _result_;
	return result;
}


VtgPluginInstance* vtg_bracket_completion_get_plugin_instance (VtgBracketCompletion* self) {
	VtgPluginInstance* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_plugin_instance;
	return result;
}


static void vtg_bracket_completion_set_plugin_instance (VtgBracketCompletion* self, VtgPluginInstance* value) {
	VtgPluginInstance* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_plugin_instance = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_plugin_instance), _tmp0_);
	g_object_notify ((GObject *) self, "plugin-instance");
}


GeditView* vtg_bracket_completion_get_view (VtgBracketCompletion* self) {
	GeditView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_view;
	return result;
}


static void vtg_bracket_completion_set_view (VtgBracketCompletion* self, GeditView* value) {
	GeditView* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_view = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_view), _tmp0_);
	g_object_notify ((GObject *) self, "view");
}


static GObject * vtg_bracket_completion_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VtgBracketCompletion * self;
	parent_class = G_OBJECT_CLASS (vtg_bracket_completion_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VTG_BRACKET_COMPLETION (obj);
	{
		if (gedit_prefs_manager_get_insert_spaces ()) {
			char* _tmp0_;
			self->priv->tab_chars = (_tmp0_ = g_strnfill ((gsize) gedit_prefs_manager_get_tabs_size (), ' '), _g_free0 (self->priv->tab_chars), _tmp0_);
		} else {
			char* _tmp1_;
			self->priv->tab_chars = (_tmp1_ = g_strdup ("\t"), _g_free0 (self->priv->tab_chars), _tmp1_);
		}
		vtg_bracket_completion_connect_view (self, self->priv->_view);
	}
	return obj;
}


static void vtg_bracket_completion_class_init (VtgBracketCompletionClass * klass) {
	vtg_bracket_completion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgBracketCompletionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_bracket_completion_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_bracket_completion_set_property;
	G_OBJECT_CLASS (klass)->constructor = vtg_bracket_completion_constructor;
	G_OBJECT_CLASS (klass)->finalize = vtg_bracket_completion_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_BRACKET_COMPLETION_PLUGIN_INSTANCE, g_param_spec_object ("plugin-instance", "plugin-instance", "plugin-instance", VTG_TYPE_PLUGIN_INSTANCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_BRACKET_COMPLETION_VIEW, g_param_spec_object ("view", "view", "view", GEDIT_TYPE_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vtg_bracket_completion_instance_init (VtgBracketCompletion * self) {
	self->priv = VTG_BRACKET_COMPLETION_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_view = NULL;
	self->priv->tab_chars = g_strdup ("");
}


static void vtg_bracket_completion_finalize (GObject* obj) {
	VtgBracketCompletion * self;
	self = VTG_BRACKET_COMPLETION (obj);
	_g_object_unref0 (self->priv->_plugin_instance);
	_g_object_unref0 (self->priv->_view);
	_g_free0 (self->priv->tab_chars);
	G_OBJECT_CLASS (vtg_bracket_completion_parent_class)->finalize (obj);
}


GType vtg_bracket_completion_get_type (void) {
	return vtg_bracket_completion_type_id;
}


GType vtg_bracket_completion_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgBracketCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_bracket_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgBracketCompletion), 0, (GInstanceInitFunc) vtg_bracket_completion_instance_init, NULL };
	vtg_bracket_completion_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgBracketCompletion", &g_define_type_info, 0);
	return vtg_bracket_completion_type_id;
}


static void vtg_bracket_completion_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgBracketCompletion * self;
	self = VTG_BRACKET_COMPLETION (object);
	switch (property_id) {
		case VTG_BRACKET_COMPLETION_PLUGIN_INSTANCE:
		g_value_set_object (value, vtg_bracket_completion_get_plugin_instance (self));
		break;
		case VTG_BRACKET_COMPLETION_VIEW:
		g_value_set_object (value, vtg_bracket_completion_get_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_bracket_completion_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgBracketCompletion * self;
	self = VTG_BRACKET_COMPLETION (object);
	switch (property_id) {
		case VTG_BRACKET_COMPLETION_PLUGIN_INSTANCE:
		vtg_bracket_completion_set_plugin_instance (self, g_value_get_object (value));
		break;
		case VTG_BRACKET_COMPLETION_VIEW:
		vtg_bracket_completion_set_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




