/* vbfutils.c generated by valac 0.10.0, the Vala compiler
 * generated from vbfutils.vala, do not modify */

/*
 *  vbfutils.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <glib/gstdio.h>
#include <config.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))



void vbf_utils_log_message (const char* log_domain, const char* format, va_list args);
void vbf_utils_trace (const char* format, ...);
gboolean vbf_utils_is_autotools_project (const char* path);
gboolean vbf_utils_is_waf_project (const char* path);
gboolean vbf_utils_is_cmake_project (const char* path);
gboolean vbf_utils_is_simple_make_project (const char* path);
char* vbf_utils_guess_package_vapi (const char* using_name, char** vapi_dirs, int vapi_dirs_length1);
gboolean vbf_utils_is_vala_source (const char* filename);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * This function shouldn't be used directly but just wrapped with a private one that
 * will specify the correct log domain. See the function trace (...) in this same source 
 */
inline void vbf_utils_log_message (const char* log_domain, const char* format, va_list args) {
	g_return_if_fail (log_domain != NULL);
	g_return_if_fail (format != NULL);
	g_logv (log_domain, G_LOG_LEVEL_INFO, format, args);
}


inline void vbf_utils_trace (const char* format, ...) {
	g_return_if_fail (format != NULL);
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


gboolean vbf_utils_is_autotools_project (const char* path) {
	gboolean result = FALSE;
	char* config_file;
	char* autogen_file;
	gboolean res;
	gboolean _tmp0_ = FALSE;
	char* _tmp1_;
	g_return_val_if_fail (path != NULL, FALSE);
	config_file = g_build_filename (path, "configure.ac", NULL);
	autogen_file = g_build_filename (path, "autogen.sh", NULL);
	res = FALSE;
	if (g_file_test (config_file, G_FILE_TEST_EXISTS)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_file_test (autogen_file, G_FILE_TEST_EXISTS);
	}
	if (_tmp0_) {
		char* file;
		file = g_build_filename (path, "Makefile.am", NULL);
		if (g_file_test (file, G_FILE_TEST_EXISTS)) {
			res = TRUE;
		}
		_g_free0 (file);
	}
	vbf_utils_trace ("vbfutils.vala:59: project at: %s is autotools %s", path, _tmp1_ = bool_to_string (res));
	_g_free0 (_tmp1_);
	result = res;
	_g_free0 (autogen_file);
	_g_free0 (config_file);
	return result;
}


gboolean vbf_utils_is_waf_project (const char* path) {
	gboolean result = FALSE;
	char* file;
	gboolean res;
	g_return_val_if_fail (path != NULL, FALSE);
	file = g_build_filename (path, "wscript", NULL);
	res = FALSE;
	if (g_file_test (file, G_FILE_TEST_EXISTS)) {
		res = TRUE;
	}
	result = res;
	_g_free0 (file);
	return result;
}


gboolean vbf_utils_is_cmake_project (const char* path) {
	gboolean result = FALSE;
	char* file;
	gboolean res;
	g_return_val_if_fail (path != NULL, FALSE);
	file = g_build_filename (path, "CMakeLists.txt", NULL);
	res = FALSE;
	if (g_file_test (file, G_FILE_TEST_EXISTS)) {
		res = TRUE;
	}
	result = res;
	_g_free0 (file);
	return result;
}


gboolean vbf_utils_is_simple_make_project (const char* path) {
	gboolean result = FALSE;
	char* file;
	gboolean res;
	g_return_val_if_fail (path != NULL, FALSE);
	file = g_build_filename (path, "Makefile", NULL);
	res = FALSE;
	if (g_file_test (file, G_FILE_TEST_EXISTS)) {
		res = TRUE;
	}
	result = res;
	_g_free0 (file);
	return result;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


char* vbf_utils_guess_package_vapi (const char* using_name, char** vapi_dirs, int vapi_dirs_length1) {
	char* result = NULL;
	gint real_using_names_length1;
	gint _real_using_names_size_;
	char** real_using_names;
	char* vapi_file;
	gboolean _tmp0_ = FALSE;
	char* curr;
	gint dirs_length1;
	gint _dirs_size_;
	char** dirs;
	gint dir_count;
	char* _tmp6_;
	char* _tmp7_;
	char* thirdy_party_vapi_dir;
	gboolean thirdy_party_vapi_dir_bool;
	char** _tmp8_;
	char* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (using_name != NULL, NULL);
	real_using_names = (real_using_names_length1 = 0, NULL);
	vapi_file = NULL;
	if (_vala_strcmp0 (using_name, "Gtk") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (using_name, "Gtk+") == 0;
	}
	if (_tmp0_) {
		char** _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		real_using_names = (_tmp1_ = g_new0 (char*, 2 + 1), real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL), real_using_names_length1 = 2, _real_using_names_size_ = real_using_names_length1, _tmp1_);
		real_using_names[0] = (_tmp2_ = g_strdup ("gtk+-2.0"), _g_free0 (real_using_names[0]), _tmp2_);
		real_using_names[1] = (_tmp3_ = g_strdup ("gtk+"), _g_free0 (real_using_names[1]), _tmp3_);
	} else {
		char** _tmp4_;
		char* _tmp5_;
		real_using_names = (_tmp4_ = g_new0 (char*, 1 + 1), real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL), real_using_names_length1 = 1, _real_using_names_size_ = real_using_names_length1, _tmp4_);
		real_using_names[0] = (_tmp5_ = g_strdup (using_name), _g_free0 (real_using_names[0]), _tmp5_);
	}
	curr = NULL;
	dirs = (dirs_length1 = 0, NULL);
	dir_count = 1;
	if (vapi_dirs != NULL) {
		dir_count = dir_count + vapi_dirs_length1;
	}
	thirdy_party_vapi_dir = (_tmp7_ = string_replace (VALA_VAPIDIR, _tmp6_ = g_strdup_printf ("vala-%s", VALA_VERSION), "vala"), _g_free0 (_tmp6_), _tmp7_);
	thirdy_party_vapi_dir_bool = g_file_test (thirdy_party_vapi_dir, G_FILE_TEST_IS_DIR);
	if (thirdy_party_vapi_dir_bool) {
		dir_count++;
	}
	dirs = (_tmp8_ = g_new0 (char*, dir_count + 1), dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL), dirs_length1 = dir_count, _dirs_size_ = dirs_length1, _tmp8_);
	dirs[0] = (_tmp9_ = g_strdup (VALA_VAPIDIR), _g_free0 (dirs[0]), _tmp9_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				char* _tmp11_;
				if (!_tmp10_) {
					i++;
				}
				_tmp10_ = FALSE;
				if (!(i < vapi_dirs_length1)) {
					break;
				}
				dirs[i + 1] = (_tmp11_ = g_strdup (vapi_dirs[i]), _g_free0 (dirs[i + 1]), _tmp11_);
			}
		}
	}
	if (thirdy_party_vapi_dir_bool) {
		char* _tmp12_;
		dirs[dirs_length1 - 1] = (_tmp12_ = g_strdup (thirdy_party_vapi_dir), _g_free0 (dirs[dirs_length1 - 1]), _tmp12_);
	}
	{
		{
			char** real_using_name_collection;
			int real_using_name_collection_length1;
			int real_using_name_it;
			real_using_name_collection = real_using_names;
			real_using_name_collection_length1 = real_using_names_length1;
			for (real_using_name_it = 0; real_using_name_it < real_using_names_length1; real_using_name_it = real_using_name_it + 1) {
				char* real_using_name;
				real_using_name = g_strdup (real_using_name_collection[real_using_name_it]);
				{
					char* filename;
					char* lowercase_filename;
					char* lowercase_using_name;
					char* lib_filename;
					char* lib_lowercase_filename;
					char* lib_lowercase_using_name;
					filename = g_strconcat (real_using_name, ".vapi", NULL);
					lowercase_filename = g_utf8_strdown (filename, -1);
					lowercase_using_name = g_utf8_strdown (real_using_name, -1);
					lib_filename = g_strconcat ("lib", filename, NULL);
					lib_lowercase_filename = g_strconcat ("lib", lowercase_filename, NULL);
					lib_lowercase_using_name = g_strconcat ("lib", lowercase_using_name, NULL);
					{
						char** vapi_dir_collection;
						int vapi_dir_collection_length1;
						int vapi_dir_it;
						vapi_dir_collection = dirs;
						vapi_dir_collection_length1 = dirs_length1;
						for (vapi_dir_it = 0; vapi_dir_it < dirs_length1; vapi_dir_it = vapi_dir_it + 1) {
							char* vapi_dir;
							vapi_dir = g_strdup (vapi_dir_collection[vapi_dir_it]);
							{
								GDir* dir;
								dir = g_dir_open (vapi_dir, 0, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_free0 (vapi_dir);
									_g_free0 (lib_lowercase_using_name);
									_g_free0 (lib_lowercase_filename);
									_g_free0 (lib_filename);
									_g_free0 (lowercase_using_name);
									_g_free0 (lowercase_filename);
									_g_free0 (filename);
									_g_free0 (real_using_name);
									goto __catch4_g_error;
								}
								while (TRUE) {
									char* _tmp13_;
									char* curr_file;
									gboolean _tmp14_ = FALSE;
									gboolean _tmp15_ = FALSE;
									gboolean _tmp16_ = FALSE;
									gboolean _tmp17_ = FALSE;
									gboolean _tmp18_ = FALSE;
									if (!((curr = (_tmp13_ = g_strdup (g_dir_read_name (dir)), _g_free0 (curr), _tmp13_)) != NULL)) {
										break;
									}
									curr_file = g_locale_to_utf8 (curr, (gssize) (-1), NULL, NULL, NULL);
									if (_vala_strcmp0 (curr_file, filename) == 0) {
										_tmp18_ = TRUE;
									} else {
										_tmp18_ = _vala_strcmp0 (curr_file, lib_filename) == 0;
									}
									if (_tmp18_) {
										_tmp17_ = TRUE;
									} else {
										_tmp17_ = _vala_strcmp0 (curr_file, lowercase_filename) == 0;
									}
									if (_tmp17_) {
										_tmp16_ = TRUE;
									} else {
										_tmp16_ = _vala_strcmp0 (curr_file, lib_lowercase_filename) == 0;
									}
									if (_tmp16_) {
										_tmp15_ = TRUE;
									} else {
										_tmp15_ = g_str_has_prefix (curr_file, lowercase_using_name);
									}
									if (_tmp15_) {
										_tmp14_ = TRUE;
									} else {
										_tmp14_ = g_str_has_prefix (curr_file, lib_lowercase_using_name);
									}
									if (_tmp14_) {
										gboolean _tmp19_ = FALSE;
										if (vapi_file == NULL) {
											_tmp19_ = TRUE;
										} else {
											_tmp19_ = string_get_length (vapi_file) > (string_get_length (curr) - 5);
										}
										if (_tmp19_) {
											char* _tmp20_;
											vapi_file = (_tmp20_ = string_substring (curr, (glong) 0, string_get_length (curr) - 5), _g_free0 (vapi_file), _tmp20_);
										}
									} else {
										if (string_contains (curr, "-")) {
											char* _tmp21_;
											gboolean _tmp22_ = FALSE;
											gboolean _tmp23_ = FALSE;
											gboolean _tmp24_ = FALSE;
											gboolean _tmp25_ = FALSE;
											gboolean _tmp26_ = FALSE;
											curr_file = (_tmp21_ = string_replace (curr_file, "-", ""), _g_free0 (curr_file), _tmp21_);
											if (_vala_strcmp0 (curr_file, filename) == 0) {
												_tmp26_ = TRUE;
											} else {
												_tmp26_ = _vala_strcmp0 (curr_file, lib_filename) == 0;
											}
											if (_tmp26_) {
												_tmp25_ = TRUE;
											} else {
												_tmp25_ = _vala_strcmp0 (curr_file, lowercase_filename) == 0;
											}
											if (_tmp25_) {
												_tmp24_ = TRUE;
											} else {
												_tmp24_ = _vala_strcmp0 (curr_file, lib_lowercase_filename) == 0;
											}
											if (_tmp24_) {
												_tmp23_ = TRUE;
											} else {
												_tmp23_ = g_str_has_prefix (curr_file, lowercase_using_name);
											}
											if (_tmp23_) {
												_tmp22_ = TRUE;
											} else {
												_tmp22_ = g_str_has_prefix (curr_file, lib_lowercase_using_name);
											}
											if (_tmp22_) {
												gboolean _tmp27_ = FALSE;
												if (vapi_file == NULL) {
													_tmp27_ = TRUE;
												} else {
													_tmp27_ = string_get_length (vapi_file) > (string_get_length (curr) - 5);
												}
												if (_tmp27_) {
													char* _tmp28_;
													vapi_file = (_tmp28_ = string_substring (curr, (glong) 0, string_get_length (curr) - 5), _g_free0 (vapi_file), _tmp28_);
												}
											}
										}
									}
									_g_free0 (curr_file);
								}
								_g_dir_close0 (dir);
								_g_free0 (vapi_dir);
							}
						}
					}
					_g_free0 (lib_lowercase_using_name);
					_g_free0 (lib_lowercase_filename);
					_g_free0 (lib_filename);
					_g_free0 (lowercase_using_name);
					_g_free0 (lowercase_filename);
					_g_free0 (filename);
					_g_free0 (real_using_name);
				}
			}
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vbfutils.vala:175: error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (thirdy_party_vapi_dir);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (curr);
		_g_free0 (vapi_file);
		real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = vapi_file;
	_g_free0 (thirdy_party_vapi_dir);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (curr);
	real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gboolean vbf_utils_is_vala_source (const char* filename) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (filename != NULL, FALSE);
	if (g_str_has_suffix (filename, ".vala")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_str_has_suffix (filename, ".vapi");
	}
	result = _tmp0_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




