/* vbfautotools.c generated by valac 0.10.0, the Vala compiler
 * generated from vbfautotools.vala, do not modify */

/*
 *  vbfautotools.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define VBF_TYPE_IPROJECT_BACKEND (vbf_iproject_backend_get_type ())
#define VBF_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackend))
#define VBF_IS_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_IPROJECT_BACKEND))
#define VBF_IPROJECT_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackendIface))

typedef struct _VbfIProjectBackend VbfIProjectBackend;
typedef struct _VbfIProjectBackendIface VbfIProjectBackendIface;

#define VBF_TYPE_CONFIG_NODE (vbf_config_node_get_type ())
#define VBF_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNode))
#define VBF_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))
#define VBF_IS_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE))
#define VBF_IS_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE))
#define VBF_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))

typedef struct _VbfConfigNode VbfConfigNode;
typedef struct _VbfConfigNodeClass VbfConfigNodeClass;

#define VBF_TYPE_PROJECT (vbf_project_get_type ())
#define VBF_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PROJECT, VbfProject))
#define VBF_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PROJECT, VbfProjectClass))
#define VBF_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PROJECT))
#define VBF_IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PROJECT))
#define VBF_PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PROJECT, VbfProjectClass))

typedef struct _VbfProject VbfProject;
typedef struct _VbfProjectClass VbfProjectClass;

#define VBF_BACKENDS_TYPE_AUTOTOOLS (vbf_backends_autotools_get_type ())
#define VBF_BACKENDS_AUTOTOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotools))
#define VBF_BACKENDS_AUTOTOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotoolsClass))
#define VBF_BACKENDS_IS_AUTOTOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_BACKENDS_TYPE_AUTOTOOLS))
#define VBF_BACKENDS_IS_AUTOTOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_BACKENDS_TYPE_AUTOTOOLS))
#define VBF_BACKENDS_AUTOTOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotoolsClass))

typedef struct _VbfBackendsAutotools VbfBackendsAutotools;
typedef struct _VbfBackendsAutotoolsClass VbfBackendsAutotoolsClass;
typedef struct _VbfBackendsAutotoolsPrivate VbfBackendsAutotoolsPrivate;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
typedef struct _VbfConfigNodePrivate VbfConfigNodePrivate;
typedef struct _VbfProjectPrivate VbfProjectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define VBF_TYPE_GROUP (vbf_group_get_type ())
#define VBF_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_GROUP, VbfGroup))
#define VBF_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_GROUP, VbfGroupClass))
#define VBF_IS_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_GROUP))
#define VBF_IS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_GROUP))
#define VBF_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_GROUP, VbfGroupClass))

typedef struct _VbfGroup VbfGroup;
typedef struct _VbfGroupClass VbfGroupClass;

#define VBF_TYPE_VARIABLE (vbf_variable_get_type ())
#define VBF_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_VARIABLE, VbfVariable))
#define VBF_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_VARIABLE, VbfVariableClass))
#define VBF_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_VARIABLE))
#define VBF_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_VARIABLE))
#define VBF_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_VARIABLE, VbfVariableClass))

typedef struct _VbfVariable VbfVariable;
typedef struct _VbfVariableClass VbfVariableClass;

#define VBF_TYPE_MODULE (vbf_module_get_type ())
#define VBF_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_MODULE, VbfModule))
#define VBF_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_MODULE, VbfModuleClass))
#define VBF_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_MODULE))
#define VBF_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_MODULE))
#define VBF_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_MODULE, VbfModuleClass))

typedef struct _VbfModule VbfModule;
typedef struct _VbfModuleClass VbfModuleClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VBF_TYPE_PACKAGE (vbf_package_get_type ())
#define VBF_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PACKAGE, VbfPackage))
#define VBF_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PACKAGE, VbfPackageClass))
#define VBF_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PACKAGE))
#define VBF_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PACKAGE))
#define VBF_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PACKAGE, VbfPackageClass))

typedef struct _VbfPackage VbfPackage;
typedef struct _VbfPackageClass VbfPackageClass;
typedef struct _VbfPackagePrivate VbfPackagePrivate;

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;

#define VBF_TYPE_UNRESOLVED_CONFIG_NODE (vbf_unresolved_config_node_get_type ())
#define VBF_UNRESOLVED_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_UNRESOLVED_CONFIG_NODE, VbfUnresolvedConfigNode))
#define VBF_UNRESOLVED_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_UNRESOLVED_CONFIG_NODE, VbfUnresolvedConfigNodeClass))
#define VBF_IS_UNRESOLVED_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_UNRESOLVED_CONFIG_NODE))
#define VBF_IS_UNRESOLVED_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_UNRESOLVED_CONFIG_NODE))
#define VBF_UNRESOLVED_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_UNRESOLVED_CONFIG_NODE, VbfUnresolvedConfigNodeClass))

typedef struct _VbfUnresolvedConfigNode VbfUnresolvedConfigNode;
typedef struct _VbfUnresolvedConfigNodeClass VbfUnresolvedConfigNodeClass;

#define VBF_TYPE_STRING_LITERAL (vbf_string_literal_get_type ())
#define VBF_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_STRING_LITERAL, VbfStringLiteral))
#define VBF_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_STRING_LITERAL, VbfStringLiteralClass))
#define VBF_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_STRING_LITERAL))
#define VBF_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_STRING_LITERAL))
#define VBF_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_STRING_LITERAL, VbfStringLiteralClass))

typedef struct _VbfStringLiteral VbfStringLiteral;
typedef struct _VbfStringLiteralClass VbfStringLiteralClass;

#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())
typedef struct _VbfGroupPrivate VbfGroupPrivate;
typedef struct _VbfStringLiteralPrivate VbfStringLiteralPrivate;

#define VBF_TYPE_FILE (vbf_file_get_type ())
#define VBF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_FILE, VbfFile))
#define VBF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_FILE, VbfFileClass))
#define VBF_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_FILE))
#define VBF_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_FILE))
#define VBF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_FILE, VbfFileClass))

typedef struct _VbfFile VbfFile;
typedef struct _VbfFileClass VbfFileClass;

#define VBF_TYPE_SOURCE (vbf_source_get_type ())
#define VBF_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_SOURCE, VbfSource))
#define VBF_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_SOURCE, VbfSourceClass))
#define VBF_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_SOURCE))
#define VBF_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_SOURCE))
#define VBF_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_SOURCE, VbfSourceClass))

typedef struct _VbfSource VbfSource;
typedef struct _VbfSourceClass VbfSourceClass;

#define VBF_TYPE_CONFIG_NODE_LIST (vbf_config_node_list_get_type ())
#define VBF_CONFIG_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE_LIST, VbfConfigNodeList))
#define VBF_CONFIG_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE_LIST, VbfConfigNodeListClass))
#define VBF_IS_CONFIG_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE_LIST))
#define VBF_IS_CONFIG_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE_LIST))
#define VBF_CONFIG_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE_LIST, VbfConfigNodeListClass))

typedef struct _VbfConfigNodeList VbfConfigNodeList;
typedef struct _VbfConfigNodeListClass VbfConfigNodeListClass;
typedef struct _VbfTargetPrivate VbfTargetPrivate;

#define VBF_TYPE_TARGET_TYPES (vbf_target_types_get_type ())
typedef struct _VbfVariablePrivate VbfVariablePrivate;
typedef struct _VbfUnresolvedConfigNodePrivate VbfUnresolvedConfigNodePrivate;

#define VBF_TYPE_CONFIG_NODE_PAIR (vbf_config_node_pair_get_type ())
#define VBF_CONFIG_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE_PAIR, VbfConfigNodePair))
#define VBF_CONFIG_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE_PAIR, VbfConfigNodePairClass))
#define VBF_IS_CONFIG_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE_PAIR))
#define VBF_IS_CONFIG_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE_PAIR))
#define VBF_CONFIG_NODE_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE_PAIR, VbfConfigNodePairClass))

typedef struct _VbfConfigNodePair VbfConfigNodePair;
typedef struct _VbfConfigNodePairClass VbfConfigNodePairClass;
typedef struct _VbfConfigNodePairPrivate VbfConfigNodePairPrivate;

struct _VbfIProjectBackendIface {
	GTypeInterface parent_iface;
	gboolean (*probe) (VbfIProjectBackend* self, const char* project_file);
	VbfProject* (*open) (VbfIProjectBackend* self, const char* project_file);
	void (*refresh) (VbfIProjectBackend* self, VbfProject* project);
	char* (*get_configure_command) (VbfIProjectBackend* self);
	char* (*get_build_command) (VbfIProjectBackend* self);
	char* (*get_clean_command) (VbfIProjectBackend* self);
};

struct _VbfBackendsAutotools {
	GObject parent_instance;
	VbfBackendsAutotoolsPrivate * priv;
};

struct _VbfBackendsAutotoolsClass {
	GObjectClass parent_class;
};

struct _VbfBackendsAutotoolsPrivate {
	VbfProject* _project;
	ValaList* file_mons;
};

struct _VbfConfigNode {
	GObject parent_instance;
	VbfConfigNodePrivate * priv;
	VbfConfigNode* parent;
};

struct _VbfConfigNodeClass {
	GObjectClass parent_class;
	char* (*to_string) (VbfConfigNode* self);
};

struct _VbfProject {
	VbfConfigNode parent_instance;
	VbfProjectPrivate * priv;
	char* id;
	char* name;
	char* url;
	char* version;
	char* working_dir;
	VbfIProjectBackend* backend;
};

struct _VbfProjectClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfPackage {
	GObject parent_instance;
	VbfPackagePrivate * priv;
	char* id;
	char* name;
	char* constraint;
	VbfConfigNode* version;
	VbfTarget* parent_target;
	VbfGroup* parent_group;
	VbfModule* parent_module;
};

struct _VbfPackageClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;

struct _VbfGroup {
	GObject parent_instance;
	VbfGroupPrivate * priv;
	char* name;
	char* id;
	VbfProject* project;
};

struct _VbfGroupClass {
	GObjectClass parent_class;
};

struct _VbfStringLiteral {
	VbfConfigNode parent_instance;
	VbfStringLiteralPrivate * priv;
	char* data;
};

struct _VbfStringLiteralClass {
	VbfConfigNodeClass parent_class;
};

typedef enum  {
	VBF_TARGET_TYPES_PROGRAM,
	VBF_TARGET_TYPES_LIBRARY,
	VBF_TARGET_TYPES_DATA,
	VBF_TARGET_TYPES_BUILT_SOURCES
} VbfTargetTypes;

struct _VbfTarget {
	GObject parent_instance;
	VbfTargetPrivate * priv;
	char* id;
	char* name;
	VbfTargetTypes type;
	gboolean no_install;
	VbfGroup* group;
};

struct _VbfTargetClass {
	GObjectClass parent_class;
};

struct _VbfVariable {
	VbfConfigNode parent_instance;
	VbfVariablePrivate * priv;
	char* name;
	VbfConfigNode* data;
};

struct _VbfVariableClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfUnresolvedConfigNode {
	VbfConfigNode parent_instance;
	VbfUnresolvedConfigNodePrivate * priv;
	char* name;
};

struct _VbfUnresolvedConfigNodeClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfConfigNodePair {
	GObject parent_instance;
	VbfConfigNodePairPrivate * priv;
	VbfConfigNode* source;
	VbfConfigNode* destination;
};

struct _VbfConfigNodePairClass {
	GObjectClass parent_class;
};


static gpointer vbf_backends_autotools_parent_class = NULL;
static VbfIProjectBackendIface* vbf_backends_autotools_vbf_iproject_backend_parent_iface = NULL;

GType vbf_config_node_get_type (void) G_GNUC_CONST;
GType vbf_project_get_type (void) G_GNUC_CONST;
GType vbf_iproject_backend_get_type (void) G_GNUC_CONST;
GType vbf_backends_autotools_get_type (void) G_GNUC_CONST;
#define VBF_BACKENDS_AUTOTOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotoolsPrivate))
enum  {
	VBF_BACKENDS_AUTOTOOLS_DUMMY_PROPERTY,
	VBF_BACKENDS_AUTOTOOLS_CONFIGURE_COMMAND,
	VBF_BACKENDS_AUTOTOOLS_BUILD_COMMAND,
	VBF_BACKENDS_AUTOTOOLS_CLEAN_COMMAND
};
static gboolean vbf_backends_autotools_real_probe (VbfIProjectBackend* base, const char* project_file);
gboolean vbf_utils_is_autotools_project (const char* path);
static VbfProject* vbf_backends_autotools_real_open (VbfIProjectBackend* base, const char* project_file);
VbfProject* vbf_project_new (const char* id);
VbfProject* vbf_project_construct (GType object_type, const char* id);
void vbf_iproject_backend_refresh (VbfIProjectBackend* self, VbfProject* project);
static void vbf_backends_autotools_real_refresh (VbfIProjectBackend* base, VbfProject* project);
static void vbf_backends_autotools_cleanup_file_monitors (VbfBackendsAutotools* self);
void vbf_project_clear (VbfProject* self);
static char* vbf_backends_autotools_normalize_string (VbfBackendsAutotools* self, const char* data);
GType vbf_group_get_type (void) G_GNUC_CONST;
static void vbf_backends_autotools_parse_variables (VbfBackendsAutotools* self, VbfProject* project, const char* buffer, VbfGroup* group, GError** error);
GType vbf_variable_get_type (void) G_GNUC_CONST;
static void vbf_backends_autotools_resolve_variables (VbfBackendsAutotools* self, VbfProject* project, ValaList* variables);
ValaList* vbf_project_get_variables (VbfProject* self);
VbfModule* vbf_module_new (VbfProject* project, const char* id);
VbfModule* vbf_module_construct (GType object_type, VbfProject* project, const char* id);
GType vbf_module_get_type (void) G_GNUC_CONST;
void vbf_project_add_module (VbfProject* self, VbfModule* module);
void vbf_utils_trace (const char* format, ...);
static VbfVariable* vbf_backends_autotools_resolve_variable (VbfBackendsAutotools* self, const char* variable_name, ValaList* variables);
VbfConfigNode* vbf_variable_get_value (VbfVariable* self);
char* vbf_config_node_to_string (VbfConfigNode* self);
VbfPackage* vbf_package_new (const char* id);
VbfPackage* vbf_package_construct (GType object_type, const char* id);
GType vbf_package_get_type (void) G_GNUC_CONST;
void vbf_module_add_package (VbfModule* self, VbfPackage* package);
GType vbf_target_get_type (void) G_GNUC_CONST;
VbfUnresolvedConfigNode* vbf_unresolved_config_node_new (const char* name);
VbfUnresolvedConfigNode* vbf_unresolved_config_node_construct (GType object_type, const char* name);
GType vbf_unresolved_config_node_get_type (void) G_GNUC_CONST;
VbfStringLiteral* vbf_string_literal_new (const char* data);
VbfStringLiteral* vbf_string_literal_construct (GType object_type, const char* data);
GType vbf_string_literal_get_type (void) G_GNUC_CONST;
static void vbf_backends_autotools_resolve_package_variables (VbfBackendsAutotools* self, VbfProject* project);
static void vbf_backends_autotools_parse_makefile (VbfBackendsAutotools* self, VbfProject* project, const char* project_file, const char* makefile, GError** error);
static void vbf_backends_autotools_setup_file_monitors (VbfBackendsAutotools* self, VbfProject* project);
GType vbf_file_types_get_type (void) G_GNUC_CONST;
static VbfFileTypes vbf_backends_autotools_source_file_type (VbfBackendsAutotools* self, const char* name);
static void vbf_backends_autotools_add_source (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* source);
VbfSource* vbf_source_new_with_type (VbfTarget* target, const char* filename, VbfFileTypes type);
VbfSource* vbf_source_construct_with_type (GType object_type, VbfTarget* target, const char* filename, VbfFileTypes type);
GType vbf_file_get_type (void) G_GNUC_CONST;
GType vbf_source_get_type (void) G_GNUC_CONST;
void vbf_target_add_source (VbfTarget* self, VbfSource* source);
GType vbf_config_node_list_get_type (void) G_GNUC_CONST;
ValaList* vbf_config_node_list_get_values (VbfConfigNodeList* self);
static void vbf_backends_autotools_add_vala_sources (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target);
static char* vbf_backends_autotools_convert_to_primary_name (VbfBackendsAutotools* self, const char* data);
GType vbf_target_types_get_type (void) G_GNUC_CONST;
ValaList* vbf_group_get_variables (VbfGroup* self);
static void vbf_backends_autotools_add_target (VbfBackendsAutotools* self, VbfGroup* group, VbfTargetTypes type, const char* target_name);
VbfTarget* vbf_target_new (VbfGroup* group, VbfTargetTypes type, const char* id);
VbfTarget* vbf_target_construct (GType object_type, VbfGroup* group, VbfTargetTypes type, const char* id);
void vbf_group_add_target (VbfGroup* self, VbfTarget* target);
static void vbf_backends_autotools_add_targets (VbfBackendsAutotools* self, VbfGroup* group, VbfConfigNode* node, VbfTargetTypes type);
static void vbf_backends_autotools_add_data_files (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* file);
VbfFile* vbf_file_new_with_type (VbfTarget* target, const char* filename, VbfFileTypes type);
VbfFile* vbf_file_construct_with_type (GType object_type, VbfTarget* target, const char* filename, VbfFileTypes type);
void vbf_target_add_file (VbfTarget* self, VbfFile* file);
static void vbf_backends_autotools_parse_targets (VbfBackendsAutotools* self, VbfGroup* group);
VbfVariable* vbf_variable_new (const char* name, VbfConfigNode* parent);
VbfVariable* vbf_variable_construct (GType object_type, const char* name, VbfConfigNode* parent);
VbfConfigNodeList* vbf_config_node_list_new (void);
VbfConfigNodeList* vbf_config_node_list_construct (GType object_type);
void vbf_config_node_list_add_value (VbfConfigNodeList* self, VbfConfigNode* val);
void vbf_group_add_variable (VbfGroup* self, VbfVariable* variable);
void vbf_project_add_variable (VbfProject* self, VbfVariable* variable);
ValaList* vbf_project_get_modules (VbfProject* self);
ValaList* vbf_module_get_packages (VbfModule* self);
void vbf_variable_add_child (VbfVariable* self, VbfVariable* variable);
GType vbf_config_node_pair_get_type (void) G_GNUC_CONST;
VbfConfigNodePair* vbf_config_node_pair_new (VbfConfigNode* source, VbfConfigNode* destination);
VbfConfigNodePair* vbf_config_node_pair_construct (GType object_type, VbfConfigNode* source, VbfConfigNode* destination);
void vbf_config_node_list_replace_config_node (VbfConfigNodeList* self, VbfConfigNode* source, VbfConfigNode* target);
static char* vbf_backends_autotools_process_include_directives (VbfBackendsAutotools* self, const char* makefile, const char* buffer, GError** error);
VbfGroup* vbf_group_new (VbfProject* project, const char* id);
VbfGroup* vbf_group_construct (GType object_type, VbfProject* project, const char* id);
void vbf_project_add_group (VbfProject* self, VbfGroup* group);
static void vbf_backends_autotools_parse_group_extended_info (VbfBackendsAutotools* self, VbfGroup* group, const char* buffer);
ValaList* vbf_group_get_targets (VbfGroup* self);
VbfTarget* vbf_group_get_target_for_id (VbfGroup* self, const char* id);
void vbf_target_add_include_dir (VbfTarget* self, const char* dir);
void vbf_group_add_include_dir (VbfGroup* self, const char* dir);
void vbf_target_add_package (VbfTarget* self, VbfPackage* package);
void vbf_group_add_package (VbfGroup* self, VbfPackage* package);
void vbf_target_add_built_library (VbfTarget* self, const char* dir);
void vbf_group_add_built_library (VbfGroup* self, const char* dir);
ValaList* vbf_project_get_groups (VbfProject* self);
static void vbf_backends_autotools_on_project_file_changed (VbfBackendsAutotools* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
void vbf_project_update (VbfProject* self);
VbfBackendsAutotools* vbf_backends_autotools_new (void);
VbfBackendsAutotools* vbf_backends_autotools_construct (GType object_type);
static void vbf_backends_autotools_finalize (GObject* obj);
char* vbf_iproject_backend_get_configure_command (VbfIProjectBackend* self);
char* vbf_iproject_backend_get_build_command (VbfIProjectBackend* self);
char* vbf_iproject_backend_get_clean_command (VbfIProjectBackend* self);
static void vbf_backends_autotools_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean vbf_backends_autotools_real_probe (VbfIProjectBackend* base, const char* project_file) {
	VbfBackendsAutotools * self;
	gboolean result = FALSE;
	self = (VbfBackendsAutotools*) base;
	g_return_val_if_fail (project_file != NULL, FALSE);
	result = vbf_utils_is_autotools_project (project_file);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static VbfProject* vbf_backends_autotools_real_open (VbfIProjectBackend* base, const char* project_file) {
	VbfBackendsAutotools * self;
	VbfProject* result = NULL;
	VbfProject* project;
	self = (VbfBackendsAutotools*) base;
	g_return_val_if_fail (project_file != NULL, NULL);
	project = vbf_project_new (project_file);
	vbf_iproject_backend_refresh ((VbfIProjectBackend*) self, project);
	if (project->name == NULL) {
		result = NULL;
		_g_object_unref0 (project);
		return result;
	} else {
		VbfIProjectBackend* _tmp0_;
		self->priv->_project = project;
		project->backend = (_tmp0_ = _g_object_ref0 ((VbfIProjectBackend*) self), _g_object_unref0 (project->backend), _tmp0_);
		result = project;
		return result;
	}
	_g_object_unref0 (project);
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vbf_backends_autotools_real_refresh (VbfIProjectBackend* base, VbfProject* project) {
	VbfBackendsAutotools * self;
	GError * _inner_error_ = NULL;
	self = (VbfBackendsAutotools*) base;
	g_return_if_fail (project != NULL);
	vbf_backends_autotools_cleanup_file_monitors (self);
	{
		char* file;
		char* buffer;
		gulong length = 0UL;
		char* _tmp0_ = NULL;
		gboolean _tmp1_;
		char* _tmp2_;
		gboolean _tmp3_;
		GRegex* reg;
		GMatchInfo* match;
		char* name;
		char* version;
		char* url;
		GMatchInfo* _tmp4_ = NULL;
		gboolean _tmp5_;
		GMatchInfo* _tmp6_;
		char* _tmp31_;
		char* _tmp32_;
		char* _tmp33_;
		char* _tmp34_;
		ValaList* _tmp35_;
		GRegex* _tmp36_;
		GRegex* _tmp37_;
		GMatchInfo* _tmp38_ = NULL;
		gboolean _tmp39_;
		GMatchInfo* _tmp40_;
		GRegex* _tmp74_;
		GRegex* _tmp75_;
		GMatchInfo* _tmp76_ = NULL;
		gboolean _tmp77_;
		GMatchInfo* _tmp78_;
		gboolean res;
		file = g_build_filename (project->id, "configure.ac", NULL);
		buffer = NULL;
		_tmp3_ = (_tmp1_ = g_file_get_contents (file, &_tmp0_, &length, &_inner_error_), buffer = (_tmp2_ = _tmp0_, _g_free0 (buffer), _tmp2_), _tmp1_);
		if (_inner_error_ != NULL) {
			_g_free0 (buffer);
			_g_free0 (file);
			goto __catch5_g_error;
		}
		if (!_tmp3_) {
			_g_free0 (buffer);
			_g_free0 (file);
			return;
		}
		reg = g_regex_new ("AC_INIT\\(([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (buffer);
			_g_free0 (file);
			goto __catch5_g_error;
		}
		match = NULL;
		name = NULL;
		version = NULL;
		url = NULL;
		if ((_tmp5_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp4_), match = (_tmp6_ = _tmp4_, _g_match_info_free0 (match), _tmp6_), _tmp5_)) {
			char* _tmp7_;
			name = (_tmp7_ = g_match_info_fetch (match, 1), _g_free0 (name), _tmp7_);
		} else {
			GRegex* _tmp8_;
			GRegex* _tmp9_;
			GMatchInfo* _tmp10_ = NULL;
			gboolean _tmp11_;
			GMatchInfo* _tmp12_;
			_tmp8_ = g_regex_new ("AC_INIT\\(([^\\,\\)]+),([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (url);
				_g_free0 (version);
				_g_free0 (name);
				_g_match_info_free0 (match);
				_g_regex_unref0 (reg);
				_g_free0 (buffer);
				_g_free0 (file);
				goto __catch5_g_error;
			}
			reg = (_tmp9_ = _tmp8_, _g_regex_unref0 (reg), _tmp9_);
			if ((_tmp11_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp10_), match = (_tmp12_ = _tmp10_, _g_match_info_free0 (match), _tmp12_), _tmp11_)) {
				char* _tmp13_;
				char* _tmp14_;
				name = (_tmp13_ = g_match_info_fetch (match, 1), _g_free0 (name), _tmp13_);
				version = (_tmp14_ = g_match_info_fetch (match, 2), _g_free0 (version), _tmp14_);
			} else {
				GRegex* _tmp15_;
				GRegex* _tmp16_;
				GMatchInfo* _tmp17_ = NULL;
				gboolean _tmp18_;
				GMatchInfo* _tmp19_;
				_tmp15_ = g_regex_new ("AC_INIT\\(([^\\,\\)]+),([^\\,\\)]+),([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (url);
					_g_free0 (version);
					_g_free0 (name);
					_g_match_info_free0 (match);
					_g_regex_unref0 (reg);
					_g_free0 (buffer);
					_g_free0 (file);
					goto __catch5_g_error;
				}
				reg = (_tmp16_ = _tmp15_, _g_regex_unref0 (reg), _tmp16_);
				if ((_tmp18_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp17_), match = (_tmp19_ = _tmp17_, _g_match_info_free0 (match), _tmp19_), _tmp18_)) {
					char* _tmp20_;
					char* _tmp21_;
					char* _tmp22_;
					name = (_tmp20_ = g_match_info_fetch (match, 1), _g_free0 (name), _tmp20_);
					version = (_tmp21_ = g_match_info_fetch (match, 2), _g_free0 (version), _tmp21_);
					url = (_tmp22_ = g_match_info_fetch (match, 3), _g_free0 (url), _tmp22_);
				} else {
					GRegex* _tmp23_;
					GRegex* _tmp24_;
					GMatchInfo* _tmp25_ = NULL;
					gboolean _tmp26_;
					GMatchInfo* _tmp27_;
					_tmp23_ = g_regex_new ("AC_INIT\\(([^\\,\\)]+),([^\\,\\)]+),([^\\,\\)]+),([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (url);
						_g_free0 (version);
						_g_free0 (name);
						_g_match_info_free0 (match);
						_g_regex_unref0 (reg);
						_g_free0 (buffer);
						_g_free0 (file);
						goto __catch5_g_error;
					}
					reg = (_tmp24_ = _tmp23_, _g_regex_unref0 (reg), _tmp24_);
					if ((_tmp26_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp25_), match = (_tmp27_ = _tmp25_, _g_match_info_free0 (match), _tmp27_), _tmp26_)) {
						char* _tmp28_;
						char* _tmp29_;
						char* _tmp30_;
						name = (_tmp28_ = g_match_info_fetch (match, 1), _g_free0 (name), _tmp28_);
						version = (_tmp29_ = g_match_info_fetch (match, 2), _g_free0 (version), _tmp29_);
						url = (_tmp30_ = g_match_info_fetch (match, 3), _g_free0 (url), _tmp30_);
					}
				}
			}
		}
		vbf_project_clear (project);
		project->name = (_tmp31_ = vbf_backends_autotools_normalize_string (self, name), _g_free0 (project->name), _tmp31_);
		project->version = (_tmp32_ = vbf_backends_autotools_normalize_string (self, version), _g_free0 (project->version), _tmp32_);
		project->url = (_tmp33_ = vbf_backends_autotools_normalize_string (self, url), _g_free0 (project->url), _tmp33_);
		project->working_dir = (_tmp34_ = g_strdup (project->id), _g_free0 (project->working_dir), _tmp34_);
		vbf_backends_autotools_parse_variables (self, project, buffer, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (url);
			_g_free0 (version);
			_g_free0 (name);
			_g_match_info_free0 (match);
			_g_regex_unref0 (reg);
			_g_free0 (buffer);
			_g_free0 (file);
			goto __catch5_g_error;
		}
		vbf_backends_autotools_resolve_variables (self, project, _tmp35_ = vbf_project_get_variables (project));
		_vala_collection_object_unref0 (_tmp35_);
		_tmp36_ = g_regex_new ("PKG_CHECK_MODULES\\([\\s\\[]*([^\\,\\)\\]]+)[\\s\\]]*\\,(.+?)\\)", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (url);
			_g_free0 (version);
			_g_free0 (name);
			_g_match_info_free0 (match);
			_g_regex_unref0 (reg);
			_g_free0 (buffer);
			_g_free0 (file);
			goto __catch5_g_error;
		}
		reg = (_tmp37_ = _tmp36_, _g_regex_unref0 (reg), _tmp37_);
		if ((_tmp39_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_CR, &_tmp38_), match = (_tmp40_ = _tmp38_, _g_match_info_free0 (match), _tmp40_), _tmp39_)) {
			while (TRUE) {
				char* mod_name;
				char* pacs;
				char* line;
				GRegex* mod;
				GMatchInfo* pac;
				GMatchInfo* _tmp41_ = NULL;
				gboolean _tmp42_;
				GMatchInfo* _tmp43_;
				VbfModule* module;
				if (!g_match_info_matches (match)) {
					break;
				}
				mod_name = g_match_info_fetch (match, 1);
				pacs = g_strdup ("");
				line = g_match_info_fetch (match, 2);
				mod = g_regex_new ("^[\\s\\]]*([^\\,\\]]+)[\\s\\]]*,([^\\,]+),([^\\,]+)$", 0, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (line);
					_g_free0 (pacs);
					_g_free0 (mod_name);
					_g_free0 (url);
					_g_free0 (version);
					_g_free0 (name);
					_g_match_info_free0 (match);
					_g_regex_unref0 (reg);
					_g_free0 (buffer);
					_g_free0 (file);
					goto __catch5_g_error;
				}
				pac = NULL;
				if ((_tmp42_ = g_regex_match (mod, line, G_REGEX_MATCH_NEWLINE_CR, &_tmp41_), pac = (_tmp43_ = _tmp41_, _g_match_info_free0 (pac), _tmp43_), _tmp42_)) {
					char* _tmp44_;
					pacs = (_tmp44_ = g_match_info_fetch (pac, 1), _g_free0 (pacs), _tmp44_);
				} else {
					GRegex* _tmp45_;
					GRegex* _tmp46_;
					GMatchInfo* _tmp47_ = NULL;
					gboolean _tmp48_;
					GMatchInfo* _tmp49_;
					_tmp45_ = g_regex_new ("^[\\s\\]]*([^\\,\\]]+)[\\s\\]]*,([^\\,]+)$", 0, 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_match_info_free0 (pac);
						_g_regex_unref0 (mod);
						_g_free0 (line);
						_g_free0 (pacs);
						_g_free0 (mod_name);
						_g_free0 (url);
						_g_free0 (version);
						_g_free0 (name);
						_g_match_info_free0 (match);
						_g_regex_unref0 (reg);
						_g_free0 (buffer);
						_g_free0 (file);
						goto __catch5_g_error;
					}
					mod = (_tmp46_ = _tmp45_, _g_regex_unref0 (mod), _tmp46_);
					if ((_tmp48_ = g_regex_match (mod, line, G_REGEX_MATCH_NEWLINE_CR, &_tmp47_), pac = (_tmp49_ = _tmp47_, _g_match_info_free0 (pac), _tmp49_), _tmp48_)) {
						char* _tmp50_;
						pacs = (_tmp50_ = g_match_info_fetch (pac, 1), _g_free0 (pacs), _tmp50_);
					} else {
						char* _tmp51_;
						pacs = (_tmp51_ = g_strdup (line), _g_free0 (pacs), _tmp51_);
					}
				}
				module = vbf_module_new (project, mod_name);
				vbf_project_add_module (project, module);
				if (_vala_strcmp0 (pacs, "") != 0) {
					gint pkgs_length1;
					gint _pkgs_size_;
					char** _tmp55_;
					char* _tmp52_;
					char** _tmp53_;
					char** _tmp54_;
					char** pkgs;
					gint idx;
					pkgs = (_tmp55_ = (_tmp54_ = _tmp53_ = g_strsplit (_tmp52_ = vbf_backends_autotools_normalize_string (self, pacs), " ", 0), _g_free0 (_tmp52_), _tmp54_), pkgs_length1 = _vala_array_length (_tmp53_), _pkgs_size_ = pkgs_length1, _tmp55_);
					idx = 0;
					while (TRUE) {
						char* pkg;
						char* variable;
						VbfPackage* package;
						gboolean _tmp66_ = FALSE;
						gboolean _tmp67_ = FALSE;
						if (!(pkgs[idx] != NULL)) {
							break;
						}
						pkg = g_strdup (pkgs[idx]);
						variable = g_strdup (strstr (pkg, "$"));
						if (variable != NULL) {
							char* _tmp56_;
							char* _tmp57_;
							char* _tmp58_;
							char* var_name;
							ValaList* _tmp59_;
							VbfVariable* _tmp60_;
							VbfVariable* res;
							var_name = (_tmp58_ = string_substring (_tmp57_ = string_replace (_tmp56_ = string_replace (variable, "(", ""), ")", ""), (glong) 1, -1), _g_free0 (_tmp57_), _g_free0 (_tmp56_), _tmp58_);
							vbf_utils_trace ("vbfautotools.vala:166: Resoving variables: %s", var_name);
							res = (_tmp60_ = vbf_backends_autotools_resolve_variable (self, var_name, _tmp59_ = vbf_project_get_variables (project)), _vala_collection_object_unref0 (_tmp59_), _tmp60_);
							if (res != NULL) {
								VbfConfigNode* _tmp61_;
								char* _tmp62_;
								VbfConfigNode* _tmp63_;
								char* _tmp64_;
								char* _tmp65_;
								vbf_utils_trace ("vbfautotools.vala:169: resolved: %s", _tmp62_ = vbf_config_node_to_string (_tmp61_ = vbf_variable_get_value (res)));
								_g_free0 (_tmp62_);
								_g_object_unref0 (_tmp61_);
								pkg = (_tmp65_ = string_replace (pkg, variable, _tmp64_ = vbf_config_node_to_string (_tmp63_ = vbf_variable_get_value (res))), _g_free0 (pkg), _tmp65_);
								_g_free0 (_tmp64_);
								_g_object_unref0 (_tmp63_);
							}
							_g_object_unref0 (res);
							_g_free0 (var_name);
						}
						package = vbf_package_new (pkg);
						vbf_module_add_package (module, package);
						idx++;
						if (_vala_strcmp0 (pkgs[idx], ">=") == 0) {
							_tmp67_ = TRUE;
						} else {
							_tmp67_ = _vala_strcmp0 (pkgs[idx], ">") == 0;
						}
						if (_tmp67_) {
							_tmp66_ = TRUE;
						} else {
							_tmp66_ = _vala_strcmp0 (pkgs[idx], "=") == 0;
						}
						if (_tmp66_) {
							char* _tmp68_;
							VbfConfigNode* node;
							char* val;
							VbfConfigNode* _tmp73_;
							package->constraint = (_tmp68_ = g_strdup (pkgs[idx]), _g_free0 (package->constraint), _tmp68_);
							idx++;
							node = NULL;
							val = g_strdup (pkgs[idx]);
							if (g_str_has_prefix (val, "$")) {
								char* _tmp69_;
								VbfConfigNode* _tmp70_;
								node = (_tmp70_ = (VbfConfigNode*) vbf_unresolved_config_node_new (_tmp69_ = string_substring (pkgs[idx], (glong) 1, string_get_length (pkgs[idx]) - 1)), _g_object_unref0 (node), _tmp70_);
								_g_free0 (_tmp69_);
							} else {
								if (val != NULL) {
									VbfConfigNode* _tmp71_;
									node = (_tmp71_ = (VbfConfigNode*) vbf_string_literal_new (pkgs[idx]), _g_object_unref0 (node), _tmp71_);
								} else {
									VbfConfigNode* _tmp72_;
									node = (_tmp72_ = (VbfConfigNode*) vbf_string_literal_new (""), _g_object_unref0 (node), _tmp72_);
								}
							}
							package->version = (_tmp73_ = _g_object_ref0 (node), _g_object_unref0 (package->version), _tmp73_);
							idx++;
							_g_free0 (val);
							_g_object_unref0 (node);
						}
						_g_object_unref0 (package);
						_g_free0 (variable);
						_g_free0 (pkg);
					}
					pkgs = (_vala_array_free (pkgs, pkgs_length1, (GDestroyNotify) g_free), NULL);
				}
				g_match_info_next (match, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (module);
					_g_match_info_free0 (pac);
					_g_regex_unref0 (mod);
					_g_free0 (line);
					_g_free0 (pacs);
					_g_free0 (mod_name);
					_g_free0 (url);
					_g_free0 (version);
					_g_free0 (name);
					_g_match_info_free0 (match);
					_g_regex_unref0 (reg);
					_g_free0 (buffer);
					_g_free0 (file);
					goto __catch5_g_error;
				}
				_g_object_unref0 (module);
				_g_match_info_free0 (pac);
				_g_regex_unref0 (mod);
				_g_free0 (line);
				_g_free0 (pacs);
				_g_free0 (mod_name);
			}
		}
		vbf_backends_autotools_resolve_package_variables (self, project);
		_tmp74_ = g_regex_new ("AC_CONFIG_FILES\\(\\[(.*)\\]\\)", G_REGEX_MULTILINE, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (url);
			_g_free0 (version);
			_g_free0 (name);
			_g_match_info_free0 (match);
			_g_regex_unref0 (reg);
			_g_free0 (buffer);
			_g_free0 (file);
			goto __catch5_g_error;
		}
		reg = (_tmp75_ = _tmp74_, _g_regex_unref0 (reg), _tmp75_);
		res = (_tmp77_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_CR, &_tmp76_), match = (_tmp78_ = _tmp76_, _g_match_info_free0 (match), _tmp78_), _tmp77_);
		if (!res) {
			GRegex* _tmp79_;
			GRegex* _tmp80_;
			GMatchInfo* _tmp81_ = NULL;
			gboolean _tmp82_;
			GMatchInfo* _tmp83_;
			_tmp79_ = g_regex_new ("AC_OUTPUT\\(\\[(.*)\\]\\)", G_REGEX_MULTILINE, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (url);
				_g_free0 (version);
				_g_free0 (name);
				_g_match_info_free0 (match);
				_g_regex_unref0 (reg);
				_g_free0 (buffer);
				_g_free0 (file);
				goto __catch5_g_error;
			}
			reg = (_tmp80_ = _tmp79_, _g_regex_unref0 (reg), _tmp80_);
			res = (_tmp82_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_CR, &_tmp81_), match = (_tmp83_ = _tmp81_, _g_match_info_free0 (match), _tmp83_), _tmp82_);
		}
		if (res) {
			char* _tmp84_;
			char* _tmp85_;
			char* tmp;
			gint makefiles_length1;
			gint _makefiles_size_;
			char** _tmp87_;
			char** _tmp86_;
			char** makefiles;
			tmp = (_tmp85_ = vbf_backends_autotools_normalize_string (self, _tmp84_ = g_match_info_fetch (match, 1)), _g_free0 (_tmp84_), _tmp85_);
			makefiles = (_tmp87_ = _tmp86_ = g_strsplit (tmp, " ", 0), makefiles_length1 = _vala_array_length (_tmp86_), _makefiles_size_ = makefiles_length1, _tmp87_);
			{
				char** makefile_collection;
				int makefile_collection_length1;
				int makefile_it;
				makefile_collection = makefiles;
				makefile_collection_length1 = makefiles_length1;
				for (makefile_it = 0; makefile_it < makefiles_length1; makefile_it = makefile_it + 1) {
					char* makefile;
					makefile = g_strdup (makefile_collection[makefile_it]);
					{
						vbf_backends_autotools_parse_makefile (self, project, project->id, makefile, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_free0 (makefile);
							makefiles = (_vala_array_free (makefiles, makefiles_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (tmp);
							_g_free0 (url);
							_g_free0 (version);
							_g_free0 (name);
							_g_match_info_free0 (match);
							_g_regex_unref0 (reg);
							_g_free0 (buffer);
							_g_free0 (file);
							goto __catch5_g_error;
						}
						_g_free0 (makefile);
					}
				}
			}
			makefiles = (_vala_array_free (makefiles, makefiles_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (tmp);
		}
		if (project->name != NULL) {
			vbf_backends_autotools_setup_file_monitors (self, project);
		}
		_g_free0 (url);
		_g_free0 (version);
		_g_free0 (name);
		_g_match_info_free0 (match);
		_g_regex_unref0 (reg);
		_g_free0 (buffer);
		_g_free0 (file);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vbfautotools.vala:221: open: %s", err->message);
			_g_error_free0 (err);
			return;
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static VbfFileTypes vbf_backends_autotools_source_file_type (VbfBackendsAutotools* self, const char* name) {
	VbfFileTypes result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	if (g_str_has_suffix (name, ".vala")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_str_has_suffix (name, ".vapi");
	}
	if (_tmp0_) {
		result = VBF_FILE_TYPES_VALA_SOURCE;
		return result;
	} else {
		result = VBF_FILE_TYPES_OTHER_SOURCE;
		return result;
	}
}


static void vbf_backends_autotools_add_source (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* source) {
	char* src_name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (source != NULL);
	src_name = NULL;
	if (VBF_IS_STRING_LITERAL (source)) {
		char* _tmp0_;
		VbfSource* src;
		src_name = (_tmp0_ = g_build_filename (group->id, VBF_STRING_LITERAL (source)->data, NULL), _g_free0 (src_name), _tmp0_);
		src = vbf_source_new_with_type (target, src_name, vbf_backends_autotools_source_file_type (self, src_name));
		vbf_target_add_source (target, src);
		_g_object_unref0 (src);
	} else {
		if (VBF_IS_VARIABLE (source)) {
			VbfConfigNode* _tmp1_;
			vbf_backends_autotools_add_source (self, group, target, _tmp1_ = vbf_variable_get_value (VBF_VARIABLE (source)));
			_g_object_unref0 (_tmp1_);
		} else {
			if (VBF_IS_CONFIG_NODE_LIST (source)) {
				{
					ValaList* _tmp2_;
					ValaIterator* _tmp3_;
					ValaIterator* _item_it;
					_item_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_config_node_list_get_values (VBF_CONFIG_NODE_LIST (source)))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
					while (TRUE) {
						VbfConfigNode* item;
						if (!vala_iterator_next (_item_it)) {
							break;
						}
						item = (VbfConfigNode*) vala_iterator_get (_item_it);
						if (VBF_IS_STRING_LITERAL (item)) {
							char* _tmp4_;
							VbfSource* src;
							src_name = (_tmp4_ = g_build_filename (group->id, VBF_STRING_LITERAL (item)->data, NULL), _g_free0 (src_name), _tmp4_);
							src = vbf_source_new_with_type (target, src_name, vbf_backends_autotools_source_file_type (self, src_name));
							vbf_target_add_source (target, src);
							_g_object_unref0 (src);
						} else {
							if (VBF_IS_VARIABLE (item)) {
								VbfConfigNode* _tmp5_;
								vbf_backends_autotools_add_source (self, group, target, _tmp5_ = vbf_variable_get_value (VBF_VARIABLE (item)));
								_g_object_unref0 (_tmp5_);
							} else {
								if (VBF_IS_CONFIG_NODE_LIST (item)) {
									vbf_backends_autotools_add_source (self, group, target, item);
								}
							}
						}
						_g_object_unref0 (item);
					}
					_vala_collection_object_unref0 (_item_it);
				}
			} else {
				g_warning ("vbfautotools.vala:256: add_vala_source: unsupported source type %s", g_type_name (G_TYPE_FROM_INSTANCE (source)));
			}
		}
	}
	_g_free0 (src_name);
}


static void vbf_backends_autotools_add_vala_sources (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target) {
	char* _tmp0_;
	char* _tmp1_;
	char* source_primary_name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target != NULL);
	source_primary_name = (_tmp1_ = g_strdup_printf ("%s_SOURCES", _tmp0_ = vbf_backends_autotools_convert_to_primary_name (self, target->id)), _g_free0 (_tmp0_), _tmp1_);
	{
		ValaList* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _variable_it;
		_variable_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_group_get_variables (group))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
		while (TRUE) {
			VbfVariable* variable;
			gboolean _tmp4_ = FALSE;
			if (!vala_iterator_next (_variable_it)) {
				break;
			}
			variable = (VbfVariable*) vala_iterator_get (_variable_it);
			if (_vala_strcmp0 (variable->name, target->id) == 0) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = _vala_strcmp0 (variable->name, source_primary_name) == 0;
			}
			if (_tmp4_) {
				VbfConfigNode* val;
				val = vbf_variable_get_value (variable);
				vbf_backends_autotools_add_source (self, group, target, val);
				_g_object_unref0 (val);
				_g_object_unref0 (variable);
				break;
			}
			_g_object_unref0 (variable);
		}
		_vala_collection_object_unref0 (_variable_it);
	}
	_g_free0 (source_primary_name);
}


static void vbf_backends_autotools_add_target (VbfBackendsAutotools* self, VbfGroup* group, VbfTargetTypes type, const char* target_name) {
	VbfTarget* target;
	VbfTarget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target_name != NULL);
	target = NULL;
	target = (_tmp0_ = vbf_target_new (group, type, target_name), _g_object_unref0 (target), _tmp0_);
	vbf_group_add_target (group, target);
	vbf_backends_autotools_add_vala_sources (self, group, target);
	_g_object_unref0 (target);
}


static void vbf_backends_autotools_add_targets (VbfBackendsAutotools* self, VbfGroup* group, VbfConfigNode* node, VbfTargetTypes type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (node != NULL);
	if (VBF_IS_STRING_LITERAL (node)) {
		vbf_backends_autotools_add_target (self, group, type, VBF_STRING_LITERAL (node)->data);
	} else {
		{
			ValaList* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _item_it;
			_item_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_config_node_list_get_values (VBF_CONFIG_NODE_LIST (node)))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				VbfConfigNode* item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (VbfConfigNode*) vala_iterator_get (_item_it);
				if (VBF_IS_STRING_LITERAL (item)) {
					vbf_backends_autotools_add_target (self, group, type, VBF_STRING_LITERAL (item)->data);
				} else {
					if (VBF_IS_CONFIG_NODE_LIST (item)) {
						vbf_backends_autotools_add_targets (self, group, item, type);
					}
				}
				_g_object_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
}


static void vbf_backends_autotools_add_data_files (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* file) {
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (file != NULL);
	name = NULL;
	if (VBF_IS_STRING_LITERAL (file)) {
		char* _tmp0_;
		VbfFile* f;
		name = (_tmp0_ = g_build_filename (group->id, VBF_STRING_LITERAL (file)->data, NULL), _g_free0 (name), _tmp0_);
		f = vbf_file_new_with_type (target, name, VBF_FILE_TYPES_DATA);
		vbf_target_add_file (target, f);
		_g_object_unref0 (f);
	} else {
		if (VBF_IS_VARIABLE (file)) {
			VbfConfigNode* _tmp1_;
			vbf_backends_autotools_add_data_files (self, group, target, _tmp1_ = vbf_variable_get_value (VBF_VARIABLE (file)));
			_g_object_unref0 (_tmp1_);
		} else {
			if (VBF_IS_CONFIG_NODE_LIST (file)) {
				{
					ValaList* _tmp2_;
					ValaIterator* _tmp3_;
					ValaIterator* _item_it;
					_item_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_config_node_list_get_values (VBF_CONFIG_NODE_LIST (file)))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
					while (TRUE) {
						VbfConfigNode* item;
						if (!vala_iterator_next (_item_it)) {
							break;
						}
						item = (VbfConfigNode*) vala_iterator_get (_item_it);
						if (VBF_IS_STRING_LITERAL (item)) {
							char* _tmp4_;
							VbfFile* f;
							name = (_tmp4_ = g_build_filename (group->id, VBF_STRING_LITERAL (item)->data, NULL), _g_free0 (name), _tmp4_);
							f = vbf_file_new_with_type (target, name, VBF_FILE_TYPES_DATA);
							vbf_target_add_file (target, f);
							_g_object_unref0 (f);
						} else {
							if (VBF_IS_VARIABLE (item)) {
								VbfConfigNode* _tmp5_;
								vbf_backends_autotools_add_data_files (self, group, target, _tmp5_ = vbf_variable_get_value (VBF_VARIABLE (item)));
								_g_object_unref0 (_tmp5_);
							} else {
								if (VBF_IS_CONFIG_NODE_LIST (item)) {
									vbf_backends_autotools_add_data_files (self, group, target, item);
								}
							}
						}
						_g_object_unref0 (item);
					}
					_vala_collection_object_unref0 (_item_it);
				}
			} else {
				g_warning ("vbfautotools.vala:318: add_vala_source: unsupported source type");
			}
		}
	}
	_g_free0 (name);
}


static void vbf_backends_autotools_parse_targets (VbfBackendsAutotools* self, VbfGroup* group) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _variable_it;
		_variable_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_group_get_variables (group))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			VbfVariable* variable;
			if (!vala_iterator_next (_variable_it)) {
				break;
			}
			variable = (VbfVariable*) vala_iterator_get (_variable_it);
			if (g_str_has_suffix (variable->name, "_PROGRAMS")) {
				VbfConfigNode* _tmp2_;
				vbf_backends_autotools_add_targets (self, group, _tmp2_ = vbf_variable_get_value (variable), VBF_TARGET_TYPES_PROGRAM);
				_g_object_unref0 (_tmp2_);
			} else {
				gboolean _tmp3_ = FALSE;
				if (g_str_has_suffix (variable->name, "_LTLIBRARIES")) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = g_str_has_suffix (variable->name, "_LIBRARIES");
				}
				if (_tmp3_) {
					VbfConfigNode* _tmp4_;
					vbf_backends_autotools_add_targets (self, group, _tmp4_ = vbf_variable_get_value (variable), VBF_TARGET_TYPES_LIBRARY);
					_g_object_unref0 (_tmp4_);
				} else {
					if (g_str_has_suffix (variable->name, "_DATA")) {
						VbfTarget* target;
						VbfConfigNode* _tmp5_;
						target = vbf_target_new (group, VBF_TARGET_TYPES_DATA, "data");
						vbf_backends_autotools_add_data_files (self, group, target, _tmp5_ = vbf_variable_get_value (variable));
						_g_object_unref0 (_tmp5_);
						vbf_group_add_target (group, target);
						_g_object_unref0 (target);
					} else {
						if (_vala_strcmp0 (variable->name, "BUILT_SOURCES") == 0) {
							VbfConfigNode* _tmp6_;
							vbf_backends_autotools_add_targets (self, group, _tmp6_ = vbf_variable_get_value (variable), VBF_TARGET_TYPES_BUILT_SOURCES);
							_g_object_unref0 (_tmp6_);
						}
					}
				}
			}
			_g_object_unref0 (variable);
		}
		_vala_collection_object_unref0 (_variable_it);
	}
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void vbf_backends_autotools_parse_variables (VbfBackendsAutotools* self, VbfProject* project, const char* buffer, VbfGroup* group, GError** error) {
	gint lines_length1;
	gint _lines_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** lines;
	char* tmp;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (buffer != NULL);
	lines = (_tmp1_ = _tmp0_ = g_strsplit (buffer, "\n", 0), lines_length1 = _vala_array_length (_tmp0_), _lines_size_ = lines_length1, _tmp1_);
	tmp = NULL;
	{
		char** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			char* line;
			line = g_strdup (line_collection[line_it]);
			{
				gboolean _tmp7_ = FALSE;
				gboolean append;
				gint toks_length1;
				gint _toks_size_;
				char** _tmp10_;
				char** _tmp9_;
				char** toks;
				gint lhs_length1;
				gint _lhs_size_;
				char** _tmp16_;
				char** _tmp15_;
				char** lhs;
				gint rhs_length1;
				gint _rhs_size_;
				char** _tmp18_;
				char** _tmp17_;
				char** rhs;
				char* _tmp36_;
				if (tmp == NULL) {
					char* _tmp2_;
					tmp = (_tmp2_ = vbf_backends_autotools_normalize_string (self, line), _g_free0 (tmp), _tmp2_);
				} else {
					char* _tmp3_;
					char* _tmp4_;
					char* _tmp5_;
					tmp = (_tmp5_ = g_strconcat (tmp, _tmp4_ = g_strconcat (" ", _tmp3_ = vbf_backends_autotools_normalize_string (self, line), NULL), NULL), _g_free0 (tmp), _tmp5_);
					_g_free0 (_tmp4_);
					_g_free0 (_tmp3_);
				}
				if (g_str_has_suffix (tmp, "\\")) {
					char* _tmp6_;
					tmp = (_tmp6_ = string_substring (tmp, (glong) 0, string_get_length (tmp) - 1), _g_free0 (tmp), _tmp6_);
					_g_free0 (line);
					continue;
				}
				if (g_str_has_prefix (tmp, "#")) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = _vala_strcmp0 (tmp, "") == 0;
				}
				if (_tmp7_) {
					char* _tmp8_;
					tmp = (_tmp8_ = NULL, _g_free0 (tmp), _tmp8_);
					_g_free0 (line);
					continue;
				}
				append = FALSE;
				toks = (_tmp10_ = _tmp9_ = g_strsplit (tmp, "=", 2), toks_length1 = _vala_array_length (_tmp9_), _toks_size_ = toks_length1, _tmp10_);
				if (toks[1] == NULL) {
					char** _tmp11_;
					char** _tmp12_;
					toks = (_tmp12_ = _tmp11_ = g_strsplit (tmp, ":", 2), toks = (_vala_array_free (toks, toks_length1, (GDestroyNotify) g_free), NULL), toks_length1 = _vala_array_length (_tmp11_), _toks_size_ = toks_length1, _tmp12_);
				}
				if (toks[1] == NULL) {
					char* _tmp13_;
					tmp = (_tmp13_ = NULL, _g_free0 (tmp), _tmp13_);
					toks = (_vala_array_free (toks, toks_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				if (g_str_has_suffix (toks[0], "+")) {
					char* _tmp14_;
					append = TRUE;
					toks[0] = (_tmp14_ = string_substring (toks[0], (glong) 0, string_get_length (toks[0]) - 1), _g_free0 (toks[0]), _tmp14_);
				}
				lhs = (_tmp16_ = _tmp15_ = g_strsplit (toks[0], " ", 0), lhs_length1 = _vala_array_length (_tmp15_), _lhs_size_ = lhs_length1, _tmp16_);
				rhs = (_tmp18_ = _tmp17_ = g_strsplit (toks[1], " ", 0), rhs_length1 = _vala_array_length (_tmp17_), _rhs_size_ = rhs_length1, _tmp18_);
				{
					char** lh_collection;
					int lh_collection_length1;
					int lh_it;
					lh_collection = lhs;
					lh_collection_length1 = lhs_length1;
					for (lh_it = 0; lh_it < lhs_length1; lh_it = lh_it + 1) {
						char* lh;
						lh = g_strdup (lh_collection[lh_it]);
						{
							gboolean _tmp19_ = FALSE;
							char* name;
							VbfVariable* variable;
							VbfConfigNode* data;
							VbfConfigNode* _tmp35_;
							if (lh == NULL) {
								_tmp19_ = TRUE;
							} else {
								_tmp19_ = _vala_strcmp0 (lh, "") == 0;
							}
							if (_tmp19_) {
								_g_free0 (lh);
								continue;
							}
							name = string_strip (lh);
							variable = vbf_variable_new (name, (VbfConfigNode*) project);
							data = NULL;
							if (rhs[1] == NULL) {
								char* val;
								val = string_strip (rhs[0]);
								if (g_str_has_prefix (val, "$")) {
									char* _tmp20_;
									char* _tmp21_;
									char* _tmp22_;
									VbfConfigNode* _tmp23_;
									val = (_tmp20_ = string_substring (val, (glong) 1, string_get_length (val) - 1), _g_free0 (val), _tmp20_);
									val = (_tmp22_ = string_replace (_tmp21_ = string_replace (val, "(", ""), ")", ""), _g_free0 (val), _tmp22_);
									_g_free0 (_tmp21_);
									data = (_tmp23_ = (VbfConfigNode*) vbf_unresolved_config_node_new (val), _g_object_unref0 (data), _tmp23_);
								} else {
									if (val != NULL) {
										VbfConfigNode* _tmp24_;
										data = (_tmp24_ = (VbfConfigNode*) vbf_string_literal_new (val), _g_object_unref0 (data), _tmp24_);
									} else {
										VbfConfigNode* _tmp25_;
										data = (_tmp25_ = (VbfConfigNode*) vbf_string_literal_new (""), _g_object_unref0 (data), _tmp25_);
									}
								}
								_g_free0 (val);
							} else {
								VbfConfigNodeList* items;
								VbfConfigNode* _tmp34_;
								items = vbf_config_node_list_new ();
								{
									char** rh_collection;
									int rh_collection_length1;
									int rh_it;
									rh_collection = rhs;
									rh_collection_length1 = rhs_length1;
									for (rh_it = 0; rh_it < rhs_length1; rh_it = rh_it + 1) {
										char* rh;
										rh = g_strdup (rh_collection[rh_it]);
										{
											gboolean _tmp26_ = FALSE;
											if (rh != NULL) {
												char* _tmp27_;
												_tmp26_ = _vala_strcmp0 (_tmp27_ = string_strip (rh), "") != 0;
												_g_free0 (_tmp27_);
											} else {
												_tmp26_ = FALSE;
											}
											if (_tmp26_) {
												VbfConfigNode* node;
												char* val;
												node = NULL;
												val = string_strip (rh);
												if (g_str_has_prefix (val, "$")) {
													char* _tmp28_;
													char* _tmp29_;
													char* _tmp30_;
													VbfConfigNode* _tmp31_;
													val = (_tmp28_ = string_substring (val, (glong) 1, string_get_length (val) - 1), _g_free0 (val), _tmp28_);
													val = (_tmp30_ = string_replace (_tmp29_ = string_replace (val, "(", ""), ")", ""), _g_free0 (val), _tmp30_);
													_g_free0 (_tmp29_);
													node = (_tmp31_ = (VbfConfigNode*) vbf_unresolved_config_node_new (val), _g_object_unref0 (node), _tmp31_);
												} else {
													if (val != NULL) {
														VbfConfigNode* _tmp32_;
														node = (_tmp32_ = (VbfConfigNode*) vbf_string_literal_new (val), _g_object_unref0 (node), _tmp32_);
													} else {
														VbfConfigNode* _tmp33_;
														g_critical ("vbfautotools.vala:419: %s is null", rh);
														node = (_tmp33_ = (VbfConfigNode*) vbf_string_literal_new (""), _g_object_unref0 (node), _tmp33_);
													}
												}
												vbf_config_node_list_add_value (items, node);
												_g_free0 (val);
												_g_object_unref0 (node);
											}
											_g_free0 (rh);
										}
									}
								}
								data = (_tmp34_ = _g_object_ref0 ((VbfConfigNode*) items), _g_object_unref0 (data), _tmp34_);
								_g_object_unref0 (items);
							}
							variable->data = (_tmp35_ = _g_object_ref0 (data), _g_object_unref0 (variable->data), _tmp35_);
							if (group != NULL) {
								vbf_group_add_variable (group, variable);
							} else {
								vbf_project_add_variable (project, variable);
							}
							_g_object_unref0 (data);
							_g_object_unref0 (variable);
							_g_free0 (name);
							_g_free0 (lh);
						}
					}
				}
				tmp = (_tmp36_ = NULL, _g_free0 (tmp), _tmp36_);
				rhs = (_vala_array_free (rhs, rhs_length1, (GDestroyNotify) g_free), NULL);
				lhs = (_vala_array_free (lhs, lhs_length1, (GDestroyNotify) g_free), NULL);
				toks = (_vala_array_free (toks, toks_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	_g_free0 (tmp);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static VbfVariable* vbf_backends_autotools_resolve_variable (VbfBackendsAutotools* self, const char* variable_name, ValaList* variables) {
	VbfVariable* result = NULL;
	VbfVariable* variable;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable_name != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	variable = NULL;
	{
		ValaIterator* _item_it;
		_item_it = vala_iterable_iterator ((ValaIterable*) variables);
		while (TRUE) {
			VbfVariable* item;
			if (!vala_iterator_next (_item_it)) {
				break;
			}
			item = (VbfVariable*) vala_iterator_get (_item_it);
			if (_vala_strcmp0 (variable_name, item->name) == 0) {
				VbfVariable* _tmp0_;
				variable = (_tmp0_ = _g_object_ref0 (item), _g_object_unref0 (variable), _tmp0_);
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (item);
		}
		_vala_collection_object_unref0 (_item_it);
	}
	result = variable;
	return result;
}


static void vbf_backends_autotools_resolve_package_variables (VbfBackendsAutotools* self, VbfProject* project) {
	ValaList* variables;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	variables = vbf_project_get_variables (project);
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _module_it;
		_module_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_project_get_modules (project))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			VbfModule* module;
			if (!vala_iterator_next (_module_it)) {
				break;
			}
			module = (VbfModule*) vala_iterator_get (_module_it);
			{
				ValaList* _tmp2_;
				ValaIterator* _tmp3_;
				ValaIterator* _package_it;
				_package_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_module_get_packages (module))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
				while (TRUE) {
					VbfPackage* package;
					if (!vala_iterator_next (_package_it)) {
						break;
					}
					package = (VbfPackage*) vala_iterator_get (_package_it);
					if (VBF_IS_UNRESOLVED_CONFIG_NODE (package->version)) {
						char* name;
						VbfVariable* target_variable;
						name = g_strdup (VBF_UNRESOLVED_CONFIG_NODE (package->version)->name);
						target_variable = vbf_backends_autotools_resolve_variable (self, name, variables);
						if (target_variable != NULL) {
							VbfConfigNode* _tmp4_;
							package->version = (_tmp4_ = _g_object_ref0 (target_variable->data), _g_object_unref0 (package->version), _tmp4_);
						}
						_g_object_unref0 (target_variable);
						_g_free0 (name);
					}
					_g_object_unref0 (package);
				}
				_vala_collection_object_unref0 (_package_it);
			}
			_g_object_unref0 (module);
		}
		_vala_collection_object_unref0 (_module_it);
	}
	_vala_collection_object_unref0 (variables);
}


static void vbf_backends_autotools_resolve_variables (VbfBackendsAutotools* self, VbfProject* project, ValaList* variables) {
	VbfVariable* target_variable;
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (variables != NULL);
	target_variable = NULL;
	name = NULL;
	{
		ValaIterator* _variable_it;
		_variable_it = vala_iterable_iterator ((ValaIterable*) variables);
		while (TRUE) {
			VbfVariable* variable;
			if (!vala_iterator_next (_variable_it)) {
				break;
			}
			variable = (VbfVariable*) vala_iterator_get (_variable_it);
			if (VBF_IS_UNRESOLVED_CONFIG_NODE (variable->data)) {
				char* _tmp0_;
				VbfVariable* _tmp1_;
				name = (_tmp0_ = g_strdup (VBF_UNRESOLVED_CONFIG_NODE (variable->data)->name), _g_free0 (name), _tmp0_);
				target_variable = (_tmp1_ = vbf_backends_autotools_resolve_variable (self, name, variables), _g_object_unref0 (target_variable), _tmp1_);
				if (target_variable == NULL) {
					ValaList* _tmp2_;
					VbfVariable* _tmp3_;
					target_variable = (_tmp3_ = vbf_backends_autotools_resolve_variable (self, name, _tmp2_ = vbf_project_get_variables (project)), _g_object_unref0 (target_variable), _tmp3_);
					_vala_collection_object_unref0 (_tmp2_);
				}
				if (target_variable != NULL) {
					VbfConfigNode* _tmp4_;
					variable->data = (_tmp4_ = _g_object_ref0 ((VbfConfigNode*) target_variable), _g_object_unref0 (variable->data), _tmp4_);
					((VbfConfigNode*) variable)->parent = (VbfConfigNode*) target_variable;
					vbf_variable_add_child (target_variable, variable);
				}
			} else {
				if (VBF_IS_CONFIG_NODE_LIST (variable->data)) {
					VbfConfigNodeList* datas;
					ValaList* resolved_nodes;
					datas = _g_object_ref0 (VBF_CONFIG_NODE_LIST (variable->data));
					resolved_nodes = (ValaList*) vala_array_list_new (VBF_TYPE_CONFIG_NODE_PAIR, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
					{
						ValaList* _tmp5_;
						ValaIterator* _tmp6_;
						ValaIterator* _data_it;
						_data_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vbf_config_node_list_get_values (datas))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
						while (TRUE) {
							VbfConfigNode* data;
							if (!vala_iterator_next (_data_it)) {
								break;
							}
							data = (VbfConfigNode*) vala_iterator_get (_data_it);
							if (VBF_IS_UNRESOLVED_CONFIG_NODE (data)) {
								char* _tmp7_;
								VbfVariable* _tmp8_;
								name = (_tmp7_ = g_strdup (VBF_UNRESOLVED_CONFIG_NODE (data)->name), _g_free0 (name), _tmp7_);
								target_variable = (_tmp8_ = vbf_backends_autotools_resolve_variable (self, name, variables), _g_object_unref0 (target_variable), _tmp8_);
								if (target_variable == NULL) {
									ValaList* _tmp9_;
									VbfVariable* _tmp10_;
									target_variable = (_tmp10_ = vbf_backends_autotools_resolve_variable (self, name, _tmp9_ = vbf_project_get_variables (project)), _g_object_unref0 (target_variable), _tmp10_);
									_vala_collection_object_unref0 (_tmp9_);
								}
								if (target_variable != NULL) {
									if (target_variable->data != NULL) {
										VbfVariable* child;
										VbfConfigNode* _tmp11_;
										VbfConfigNodePair* _tmp12_;
										child = vbf_variable_new (name, (VbfConfigNode*) target_variable);
										child->data = (_tmp11_ = _g_object_ref0 ((VbfConfigNode*) target_variable), _g_object_unref0 (child->data), _tmp11_);
										vbf_variable_add_child (target_variable, child);
										vala_collection_add ((ValaCollection*) resolved_nodes, _tmp12_ = vbf_config_node_pair_new (data, (VbfConfigNode*) child));
										_g_object_unref0 (_tmp12_);
										_g_object_unref0 (child);
									} else {
										VbfConfigNodePair* _tmp13_;
										vala_collection_add ((ValaCollection*) resolved_nodes, _tmp13_ = vbf_config_node_pair_new (data, NULL));
										_g_object_unref0 (_tmp13_);
									}
								}
							}
							_g_object_unref0 (data);
						}
						_vala_collection_object_unref0 (_data_it);
					}
					{
						ValaIterator* _resolved_node_it;
						_resolved_node_it = vala_iterable_iterator ((ValaIterable*) resolved_nodes);
						while (TRUE) {
							VbfConfigNodePair* resolved_node;
							if (!vala_iterator_next (_resolved_node_it)) {
								break;
							}
							resolved_node = (VbfConfigNodePair*) vala_iterator_get (_resolved_node_it);
							vbf_config_node_list_replace_config_node (datas, resolved_node->source, resolved_node->destination);
							_g_object_unref0 (resolved_node);
						}
						_vala_collection_object_unref0 (_resolved_node_it);
					}
					_vala_collection_object_unref0 (resolved_nodes);
					_g_object_unref0 (datas);
				}
			}
			_g_object_unref0 (variable);
		}
		_vala_collection_object_unref0 (_variable_it);
	}
	_g_free0 (name);
	_g_object_unref0 (target_variable);
}


static char* vbf_backends_autotools_process_include_directives (VbfBackendsAutotools* self, const char* makefile, const char* buffer, GError** error) {
	char* result = NULL;
	char* res;
	gint lines_length1;
	gint _lines_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** lines;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (makefile != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	res = g_strdup (buffer);
	lines = (_tmp1_ = _tmp0_ = g_strsplit (buffer, "\n", 0), lines_length1 = _vala_array_length (_tmp0_), _lines_size_ = lines_length1, _tmp1_);
	{
		char** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			char* line;
			line = g_strdup (line_collection[line_it]);
			{
				char* _tmp2_;
				gint tmps_length1;
				gint _tmps_size_;
				char** _tmp4_;
				char** _tmp3_;
				char** tmps;
				if (_vala_strcmp0 (line, "") == 0) {
					_g_free0 (line);
					continue;
				}
				line = (_tmp2_ = vbf_backends_autotools_normalize_string (self, line), _g_free0 (line), _tmp2_);
				tmps = (_tmp4_ = _tmp3_ = g_strsplit (line, " ", 2), tmps_length1 = _vala_array_length (_tmp3_), _tmps_size_ = tmps_length1, _tmp4_);
				if (_vala_strcmp0 (tmps[0], "include") == 0) {
					char* filename;
					char* include_filename;
					char* included_file;
					char* _tmp5_ = NULL;
					gboolean _tmp6_;
					char* _tmp7_;
					gboolean _tmp8_;
					filename = vbf_backends_autotools_normalize_string (self, tmps[1]);
					include_filename = string_replace (makefile, "Makefile.am", filename);
					included_file = NULL;
					_tmp8_ = (_tmp6_ = g_file_get_contents (include_filename, &_tmp5_, NULL, &_inner_error_), included_file = (_tmp7_ = _tmp5_, _g_free0 (included_file), _tmp7_), _tmp6_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (included_file);
						_g_free0 (include_filename);
						_g_free0 (filename);
						tmps = (_vala_array_free (tmps, tmps_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (res);
						return NULL;
					}
					if (_tmp8_) {
						char* _tmp9_;
						char* _tmp10_;
						res = (_tmp10_ = string_replace (res, _tmp9_ = g_strdup_printf ("include %s", filename), included_file), _g_free0 (res), _tmp10_);
						_g_free0 (_tmp9_);
					}
					_g_free0 (included_file);
					_g_free0 (include_filename);
					_g_free0 (filename);
				}
				tmps = (_vala_array_free (tmps, tmps_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	result = res;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vbf_backends_autotools_parse_makefile (VbfBackendsAutotools* self, VbfProject* project, const char* project_file, const char* makefile, GError** error) {
	char* buffer;
	char* _tmp0_;
	char* _tmp1_;
	char* file;
	char* _tmp2_ = NULL;
	gboolean _tmp3_;
	char* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (project_file != NULL);
	g_return_if_fail (makefile != NULL);
	if (!g_str_has_suffix (makefile, "Makefile")) {
		return;
	}
	buffer = NULL;
	file = (_tmp1_ = g_strconcat (_tmp0_ = g_build_filename (project_file, makefile, NULL), ".am", NULL), _g_free0 (_tmp0_), _tmp1_);
	_tmp5_ = (_tmp3_ = g_file_get_contents (file, &_tmp2_, NULL, &_inner_error_), buffer = (_tmp4_ = _tmp2_, _g_free0 (buffer), _tmp4_), _tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (file);
		_g_free0 (buffer);
		return;
	}
	if (_tmp5_) {
		char* _tmp6_;
		VbfGroup* _tmp7_;
		VbfGroup* group;
		char* _tmp8_;
		char* _tmp9_;
		ValaList* _tmp10_;
		group = (_tmp7_ = vbf_group_new (project, _tmp6_ = string_replace (file, "Makefile.am", "")), _g_free0 (_tmp6_), _tmp7_);
		vbf_project_add_group (project, group);
		_tmp8_ = vbf_backends_autotools_process_include_directives (self, file, buffer, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (group);
			_g_free0 (file);
			_g_free0 (buffer);
			return;
		}
		buffer = (_tmp9_ = _tmp8_, _g_free0 (buffer), _tmp9_);
		vbf_backends_autotools_parse_variables (self, project, buffer, group, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (group);
			_g_free0 (file);
			_g_free0 (buffer);
			return;
		}
		vbf_backends_autotools_resolve_variables (self, project, _tmp10_ = vbf_group_get_variables (group));
		_vala_collection_object_unref0 (_tmp10_);
		vbf_backends_autotools_parse_targets (self, group);
		vbf_backends_autotools_parse_group_extended_info (self, group, buffer);
		_g_object_unref0 (group);
	}
	_g_free0 (file);
	_g_free0 (buffer);
}


static char* string_chomp (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static void vbf_backends_autotools_parse_group_extended_info (VbfBackendsAutotools* self, VbfGroup* group, const char* buffer) {
	gint lines_length1;
	gint _lines_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** lines;
	VbfTarget* target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (buffer != NULL);
	lines = (_tmp1_ = _tmp0_ = g_strsplit (buffer, "\n", 0), lines_length1 = _vala_array_length (_tmp0_), _lines_size_ = lines_length1, _tmp1_);
	target = NULL;
	{
		char** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			char* line;
			line = g_strdup (line_collection[line_it]);
			{
				char* _tmp2_;
				gint tmps_length1;
				gint _tmps_size_;
				char** _tmp27_;
				char** _tmp26_;
				char** tmps;
				gint count;
				line = (_tmp2_ = vbf_backends_autotools_normalize_string (self, line), _g_free0 (line), _tmp2_);
				if (_vala_strcmp0 (line, "") == 0) {
					if (target != NULL) {
						VbfTarget* _tmp3_;
						target = (_tmp3_ = NULL, _g_object_unref0 (target), _tmp3_);
					}
					_g_free0 (line);
					continue;
				}
				if (target == NULL) {
					gint rule_parts_length1;
					gint _rule_parts_size_;
					char** _tmp5_;
					char** _tmp4_;
					char** rule_parts;
					gboolean _tmp6_ = FALSE;
					rule_parts = (_tmp5_ = _tmp4_ = g_strsplit (line, "=", 2), rule_parts_length1 = _vala_array_length (_tmp4_), _rule_parts_size_ = rule_parts_length1, _tmp5_);
					;
					if (rule_parts_length1 >= 2) {
						char* _tmp7_;
						_tmp6_ = g_str_has_suffix (_tmp7_ = string_chomp (rule_parts[0]), "_VALAFLAGS");
						_g_free0 (_tmp7_);
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						char* target_name;
						gint target_tmp_length1;
						gint _target_tmp_size_;
						char** _tmp9_;
						char** _tmp8_;
						char** target_tmp;
						char* _tmp14_;
						const char* _tmp20_;
						target_name = g_strdup ("");
						target_tmp = (_tmp9_ = _tmp8_ = g_strsplit (rule_parts[0], "_", 0), target_tmp_length1 = _vala_array_length (_tmp8_), _target_tmp_size_ = target_tmp_length1, _tmp9_);
						{
							gint i;
							i = 0;
							{
								gboolean _tmp10_;
								_tmp10_ = TRUE;
								while (TRUE) {
									char* _tmp11_;
									if (!_tmp10_) {
										i++;
									}
									_tmp10_ = FALSE;
									if (!(i < (target_tmp_length1 - 1))) {
										break;
									}
									target_name = (_tmp11_ = g_strconcat (target_name, target_tmp[i], ".", NULL), _g_free0 (target_name), _tmp11_);
								}
							}
						}
						while (TRUE) {
							char* _tmp12_;
							if (!g_str_has_suffix (target_name, ".")) {
								break;
							}
							target_name = (_tmp12_ = string_substring (target_name, (glong) 0, string_get_length (target_name) - 1), _g_free0 (target_name), _tmp12_);
						}
						if (g_str_has_suffix (target_name, ".la")) {
							char* _tmp13_;
							target_name = (_tmp13_ = string_substring (target_name, (glong) 0, string_get_length (target_name) - 3), _g_free0 (target_name), _tmp13_);
						}
						target_name = (_tmp14_ = vbf_backends_autotools_convert_to_primary_name (self, target_name), _g_free0 (target_name), _tmp14_);
						{
							ValaList* _tmp15_;
							ValaIterator* _tmp16_;
							ValaIterator* _t_it;
							_t_it = (_tmp16_ = vala_iterable_iterator ((ValaIterable*) (_tmp15_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp15_), _tmp16_);
							while (TRUE) {
								VbfTarget* t;
								char* _tmp17_;
								gboolean _tmp18_;
								if (!vala_iterator_next (_t_it)) {
									break;
								}
								t = (VbfTarget*) vala_iterator_get (_t_it);
								if ((_tmp18_ = _vala_strcmp0 (target_name, _tmp17_ = vbf_backends_autotools_convert_to_primary_name (self, t->name)) == 0, _g_free0 (_tmp17_), _tmp18_)) {
									VbfTarget* _tmp19_;
									target = (_tmp19_ = _g_object_ref0 (t), _g_object_unref0 (target), _tmp19_);
									_g_object_unref0 (t);
									break;
								}
								_g_object_unref0 (t);
							}
							_vala_collection_object_unref0 (_t_it);
						}
						_tmp20_ = NULL;
						if (target == NULL) {
							_tmp20_ = "not found!";
						} else {
							_tmp20_ = target->name;
						}
						vbf_utils_trace ("vbfautotools.vala:677: target for: %s is %s", target_name, _tmp20_);
						target_tmp = (_vala_array_free (target_tmp, target_tmp_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (target_name);
					} else {
						char** _tmp21_;
						char** _tmp22_;
						rule_parts = (_tmp22_ = _tmp21_ = g_strsplit (line, ":", 2), rule_parts = (_vala_array_free (rule_parts, rule_parts_length1, (GDestroyNotify) g_free), NULL), rule_parts_length1 = _vala_array_length (_tmp21_), _rule_parts_size_ = rule_parts_length1, _tmp22_);
						if (rule_parts_length1 == 2) {
							gint trgs_length1;
							gint _trgs_size_;
							char** _tmp24_;
							char** _tmp23_;
							char** trgs;
							trgs = (_tmp24_ = _tmp23_ = g_strsplit (rule_parts[0], " ", 0), trgs_length1 = _vala_array_length (_tmp23_), _trgs_size_ = trgs_length1, _tmp24_);
							{
								char** trg_collection;
								int trg_collection_length1;
								int trg_it;
								trg_collection = trgs;
								trg_collection_length1 = trgs_length1;
								for (trg_it = 0; trg_it < trgs_length1; trg_it = trg_it + 1) {
									char* trg;
									trg = g_strdup (trg_collection[trg_it]);
									{
										VbfTarget* _tmp25_;
										target = (_tmp25_ = vbf_group_get_target_for_id (group, trg), _g_object_unref0 (target), _tmp25_);
										if (target != NULL) {
											_g_free0 (trg);
											break;
										}
										_g_free0 (trg);
									}
								}
							}
							trgs = (_vala_array_free (trgs, trgs_length1, (GDestroyNotify) g_free), NULL);
						}
					}
					rule_parts = (_vala_array_free (rule_parts, rule_parts_length1, (GDestroyNotify) g_free), NULL);
				}
				tmps = (_tmp27_ = _tmp26_ = g_strsplit (line, " ", 0), tmps_length1 = _vala_array_length (_tmp26_), _tmps_size_ = tmps_length1, _tmp27_);
				count = tmps_length1;
				{
					gint idx;
					idx = 0;
					{
						gboolean _tmp28_;
						_tmp28_ = TRUE;
						while (TRUE) {
							gboolean _tmp29_ = FALSE;
							if (!_tmp28_) {
								idx++;
							}
							_tmp28_ = FALSE;
							if (!(idx < count)) {
								break;
							}
							if (_vala_strcmp0 (tmps[idx], "--vapidir") == 0) {
								_tmp29_ = (idx + 1) < count;
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								char* tmp;
								tmp = g_strdup (tmps[idx + 1]);
								if (g_str_has_prefix (tmp, ".")) {
									char* _tmp30_;
									tmp = (_tmp30_ = g_build_filename (group->project->id, group->name, tmp, NULL), _g_free0 (tmp), _tmp30_);
								} else {
									if (g_str_has_prefix (tmp, "$(srcdir)")) {
										char* _tmp31_;
										char* _tmp32_;
										tmp = (_tmp32_ = string_replace (tmp, "$(srcdir)", _tmp31_ = g_build_filename (group->project->id, group->name, NULL)), _g_free0 (tmp), _tmp32_);
										_g_free0 (_tmp31_);
									} else {
										if (g_str_has_prefix (tmp, "$(top_srcdir)")) {
											char* _tmp33_;
											tmp = (_tmp33_ = string_replace (tmp, "$(top_srcdir)", group->project->id), _g_free0 (tmp), _tmp33_);
										}
									}
								}
								if (target != NULL) {
									vbf_target_add_include_dir (target, tmp);
								} else {
									vbf_group_add_include_dir (group, tmp);
								}
								idx++;
								_g_free0 (tmp);
							} else {
								gboolean _tmp34_ = FALSE;
								if (_vala_strcmp0 (tmps[idx], "--pkg") == 0) {
									_tmp34_ = (idx + 1) < count;
								} else {
									_tmp34_ = FALSE;
								}
								if (_tmp34_) {
									char* tmp;
									char* variable;
									tmp = g_strdup (tmps[idx + 1]);
									variable = g_strdup (strstr (tmp, "$"));
									if (variable != NULL) {
										char* _tmp35_;
										char* _tmp36_;
										char* _tmp37_;
										char* var_name;
										ValaList* _tmp38_;
										VbfVariable* _tmp39_;
										VbfVariable* res;
										var_name = (_tmp37_ = string_substring (_tmp36_ = string_replace (_tmp35_ = string_replace (variable, "(", ""), ")", ""), (glong) 1, -1), _g_free0 (_tmp36_), _g_free0 (_tmp35_), _tmp37_);
										res = (_tmp39_ = vbf_backends_autotools_resolve_variable (self, var_name, _tmp38_ = vbf_project_get_variables (group->project)), _vala_collection_object_unref0 (_tmp38_), _tmp39_);
										if (res != NULL) {
											VbfConfigNode* _tmp40_;
											char* _tmp41_;
											char* _tmp42_;
											tmp = (_tmp42_ = string_replace (tmp, variable, _tmp41_ = vbf_config_node_to_string (_tmp40_ = vbf_variable_get_value (res))), _g_free0 (tmp), _tmp42_);
											_g_free0 (_tmp41_);
											_g_object_unref0 (_tmp40_);
										}
										_g_object_unref0 (res);
										_g_free0 (var_name);
									}
									if (target != NULL) {
										VbfPackage* _tmp43_;
										vbf_target_add_package (target, _tmp43_ = vbf_package_new (tmp));
										_g_object_unref0 (_tmp43_);
									} else {
										VbfPackage* _tmp44_;
										g_debug ("vbfautotools.vala:725: adding to group because target is null");
										vbf_group_add_package (group, _tmp44_ = vbf_package_new (tmp));
										_g_object_unref0 (_tmp44_);
									}
									idx++;
									_g_free0 (variable);
									_g_free0 (tmp);
								} else {
									if (_vala_strcmp0 (tmps[idx], "--library") == 0) {
										char* tmp;
										tmp = g_strdup (tmps[idx + 1]);
										if (target != NULL) {
											vbf_target_add_built_library (target, tmp);
										} else {
											vbf_group_add_built_library (group, tmp);
										}
										idx++;
										_g_free0 (tmp);
									}
								}
							}
						}
					}
				}
				tmps = (_vala_array_free (tmps, tmps_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	_g_object_unref0 (target);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static char* vbf_backends_autotools_normalize_string (VbfBackendsAutotools* self, const char* data) {
	char* result = NULL;
	char* res;
	char* _tmp0_;
	char* old;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (data == NULL) {
		result = NULL;
		return result;
	}
	res = string_replace (data, "\n", " ");
	res = (_tmp0_ = string_replace (res, "\t", " "), _g_free0 (res), _tmp0_);
	old = NULL;
	while (TRUE) {
		char* _tmp1_;
		char* _tmp2_;
		if (!(_vala_strcmp0 (old, res) != 0)) {
			break;
		}
		old = (_tmp1_ = g_strdup (res), _g_free0 (old), _tmp1_);
		res = (_tmp2_ = string_replace (res, "  ", " "), _g_free0 (res), _tmp2_);
	}
	res = (_tmp3_ = string_strip (res), _g_free0 (res), _tmp3_);
	if (g_str_has_prefix (res, "[")) {
		char* _tmp4_;
		res = (_tmp4_ = string_substring (res, (glong) 1, string_get_length (res) - 1), _g_free0 (res), _tmp4_);
	}
	if (g_str_has_suffix (res, "]")) {
		char* _tmp5_;
		res = (_tmp5_ = string_substring (res, (glong) 0, string_get_length (res) - 1), _g_free0 (res), _tmp5_);
	}
	result = res;
	_g_free0 (old);
	return result;
}


static char* vbf_backends_autotools_convert_to_primary_name (VbfBackendsAutotools* self, const char* data) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	result = (_tmp1_ = string_replace (_tmp0_ = string_replace (data, ".", "_"), "-", "_"), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static void _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	vbf_backends_autotools_on_project_file_changed (self, _sender, file, other_file, event_type);
}


static void vbf_backends_autotools_setup_file_monitors (VbfBackendsAutotools* self, VbfProject* project) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	{
		char* fname;
		GFile* file;
		GFileMonitor* file_mon;
		char* _tmp6_;
		GFile* _tmp7_;
		GFileMonitor* _tmp8_;
		GFileMonitor* _tmp9_;
		fname = NULL;
		file = NULL;
		file_mon = NULL;
		{
			ValaList* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _group_it;
			_group_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_project_get_groups (project))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				VbfGroup* group;
				char* _tmp2_;
				GFile* _tmp3_;
				GFileMonitor* _tmp4_;
				GFileMonitor* _tmp5_;
				if (!vala_iterator_next (_group_it)) {
					break;
				}
				group = (VbfGroup*) vala_iterator_get (_group_it);
				fname = (_tmp2_ = g_build_filename (group->id, "Makefile.am", NULL), _g_free0 (fname), _tmp2_);
				vbf_utils_trace ("vbfautotools.vala:779: setup_file_monitors for: %s", fname);
				file = (_tmp3_ = g_file_new_for_path (fname), _g_object_unref0 (file), _tmp3_);
				_tmp4_ = g_file_monitor_file (file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (group);
					_vala_collection_object_unref0 (_group_it);
					_g_object_unref0 (file_mon);
					_g_object_unref0 (file);
					_g_free0 (fname);
					goto __catch7_g_error;
				}
				file_mon = (_tmp5_ = _tmp4_, _g_object_unref0 (file_mon), _tmp5_);
				g_signal_connect_object (file_mon, "changed", (GCallback) _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed, self, 0);
				vala_collection_add ((ValaCollection*) self->priv->file_mons, file_mon);
				_g_object_unref0 (group);
			}
			_vala_collection_object_unref0 (_group_it);
		}
		fname = (_tmp6_ = g_build_filename (project->id, "configure.ac", NULL), _g_free0 (fname), _tmp6_);
		file = (_tmp7_ = g_file_new_for_path (fname), _g_object_unref0 (file), _tmp7_);
		_tmp8_ = g_file_monitor_file (file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file_mon);
			_g_object_unref0 (file);
			_g_free0 (fname);
			goto __catch7_g_error;
		}
		file_mon = (_tmp9_ = _tmp8_, _g_object_unref0 (file_mon), _tmp9_);
		g_signal_connect_object (file_mon, "changed", (GCallback) _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed, self, 0);
		vala_collection_add ((ValaCollection*) self->priv->file_mons, file_mon);
		_g_object_unref0 (file_mon);
		_g_object_unref0 (file);
		_g_free0 (fname);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vbfautotools.vala:792: setup_file_monitors error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_autotools_cleanup_file_monitors (VbfBackendsAutotools* self) {
	g_return_if_fail (self != NULL);
	{
		ValaIterator* _file_mon_it;
		_file_mon_it = vala_iterable_iterator ((ValaIterable*) self->priv->file_mons);
		while (TRUE) {
			GFileMonitor* file_mon;
			guint _tmp0_;
			if (!vala_iterator_next (_file_mon_it)) {
				break;
			}
			file_mon = (GFileMonitor*) vala_iterator_get (_file_mon_it);
			g_signal_parse_name ("changed", G_TYPE_FILE_MONITOR, &_tmp0_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (file_mon, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed, self);
			g_file_monitor_cancel (file_mon);
			_g_object_unref0 (file_mon);
		}
		_vala_collection_object_unref0 (_file_mon_it);
	}
	vala_collection_clear ((ValaCollection*) self->priv->file_mons);
}


static void vbf_backends_autotools_on_project_file_changed (VbfBackendsAutotools* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (file != NULL);
	if (!g_file_monitor_is_cancelled (sender)) {
		if (event_type == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
			vbf_project_update (self->priv->_project);
		}
	}
}


VbfBackendsAutotools* vbf_backends_autotools_construct (GType object_type) {
	VbfBackendsAutotools * self;
	self = (VbfBackendsAutotools*) g_object_new (object_type, NULL);
	return self;
}


VbfBackendsAutotools* vbf_backends_autotools_new (void) {
	return vbf_backends_autotools_construct (VBF_BACKENDS_TYPE_AUTOTOOLS);
}


static char* vbf_backends_autotools_real_get_configure_command (VbfIProjectBackend* base) {
	char* result;
	VbfBackendsAutotools* self;
	char* _result_;
	gboolean _tmp0_ = FALSE;
	self = (VbfBackendsAutotools*) base;
	_result_ = NULL;
	if (self->priv->_project != NULL) {
		_tmp0_ = self->priv->_project->working_dir != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			char** _tmp1_ = NULL;
			char** item_collection;
			int item_collection_length1;
			int item_it;
			item_collection = (_tmp1_ = g_new0 (char*, 2 + 1), _tmp1_[0] = g_strdup ("./configure"), _tmp1_[1] = g_strdup ("./autogen.sh"), _tmp1_);
			item_collection_length1 = 2;
			for (item_it = 0; item_it < 2; item_it = item_it + 1) {
				char* item;
				item = g_strdup (item_collection[item_it]);
				{
					char* file;
					file = g_build_filename (self->priv->_project->working_dir, item, NULL);
					if (g_file_test (file, G_FILE_TEST_EXISTS)) {
						char* _tmp2_;
						_result_ = (_tmp2_ = g_strdup (item), _g_free0 (_result_), _tmp2_);
						_g_free0 (file);
						_g_free0 (item);
						break;
					}
					_g_free0 (file);
					_g_free0 (item);
				}
			}
			item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = _result_;
	return result;
}


static char* vbf_backends_autotools_real_get_build_command (VbfIProjectBackend* base) {
	char* result;
	VbfBackendsAutotools* self;
	self = (VbfBackendsAutotools*) base;
	result = g_strdup ("make");
	return result;
}


static char* vbf_backends_autotools_real_get_clean_command (VbfIProjectBackend* base) {
	char* result;
	VbfBackendsAutotools* self;
	self = (VbfBackendsAutotools*) base;
	result = g_strdup ("make clean");
	return result;
}


static void vbf_backends_autotools_class_init (VbfBackendsAutotoolsClass * klass) {
	vbf_backends_autotools_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VbfBackendsAutotoolsPrivate));
	G_OBJECT_CLASS (klass)->get_property = vbf_backends_autotools_get_property;
	G_OBJECT_CLASS (klass)->finalize = vbf_backends_autotools_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_AUTOTOOLS_CONFIGURE_COMMAND, "configure-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_AUTOTOOLS_BUILD_COMMAND, "build-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_AUTOTOOLS_CLEAN_COMMAND, "clean-command");
}


static void vbf_backends_autotools_vbf_iproject_backend_interface_init (VbfIProjectBackendIface * iface) {
	vbf_backends_autotools_vbf_iproject_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->probe = vbf_backends_autotools_real_probe;
	iface->open = vbf_backends_autotools_real_open;
	iface->refresh = vbf_backends_autotools_real_refresh;
	iface->get_configure_command = vbf_backends_autotools_real_get_configure_command;
	iface->get_build_command = vbf_backends_autotools_real_get_build_command;
	iface->get_clean_command = vbf_backends_autotools_real_get_clean_command;
}


static void vbf_backends_autotools_instance_init (VbfBackendsAutotools * self) {
	self->priv = VBF_BACKENDS_AUTOTOOLS_GET_PRIVATE (self);
	self->priv->file_mons = (ValaList*) vala_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
}


static void vbf_backends_autotools_finalize (GObject* obj) {
	VbfBackendsAutotools * self;
	self = VBF_BACKENDS_AUTOTOOLS (obj);
	_vala_collection_object_unref0 (self->priv->file_mons);
	G_OBJECT_CLASS (vbf_backends_autotools_parent_class)->finalize (obj);
}


GType vbf_backends_autotools_get_type (void) {
	static volatile gsize vbf_backends_autotools_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_backends_autotools_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfBackendsAutotoolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_backends_autotools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfBackendsAutotools), 0, (GInstanceInitFunc) vbf_backends_autotools_instance_init, NULL };
		static const GInterfaceInfo vbf_iproject_backend_info = { (GInterfaceInitFunc) vbf_backends_autotools_vbf_iproject_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vbf_backends_autotools_type_id;
		vbf_backends_autotools_type_id = g_type_register_static (G_TYPE_OBJECT, "VbfBackendsAutotools", &g_define_type_info, 0);
		g_type_add_interface_static (vbf_backends_autotools_type_id, VBF_TYPE_IPROJECT_BACKEND, &vbf_iproject_backend_info);
		g_once_init_leave (&vbf_backends_autotools_type_id__volatile, vbf_backends_autotools_type_id);
	}
	return vbf_backends_autotools_type_id__volatile;
}


static void vbf_backends_autotools_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VbfBackendsAutotools * self;
	self = VBF_BACKENDS_AUTOTOOLS (object);
	switch (property_id) {
		case VBF_BACKENDS_AUTOTOOLS_CONFIGURE_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_configure_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_AUTOTOOLS_BUILD_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_build_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_AUTOTOOLS_CLEAN_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_clean_command ((VbfIProjectBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




