/* pointer.vala
 *
 * Copyright (C) 2008  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

using Gee;
using Valadoc.Content;


/**
 * Represents a pointer declaration.
 */
public class Valadoc.Api.Pointer : Item {
	private Vala.PointerType vtype;

	/**
	 * The type the pointer is referring to.
	 */
	public Item data_type {
		private set;
		get;
	}

	public Pointer (Vala.PointerType vtyperef, Item parent) {
		this.vtype = vtyperef;
		this.parent = parent;

		Vala.DataType vntype = vtype.base_type;
		if (vntype is Vala.PointerType) {
			this.data_type = new Pointer ((Vala.PointerType) vntype, this);
		} else if (vntype is Vala.ArrayType) {
			this.data_type = new Array ((Vala.ArrayType) vntype, this);
		} else {
			this.data_type = new TypeReference (vntype, this);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	internal override void resolve_type_references (Tree root) {
		Api.Item type = this.data_type;
		if (type == null) {
			;
		} else if (type is Array) {
			((Array) type).resolve_type_references (root);
		} else if (type is Pointer) {
			((Pointer) type ).resolve_type_references (root);
		} else {
			((TypeReference) type).resolve_type_references (root);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	protected override Inline build_signature () {
		return new SignatureBuilder ()
			.append_content (data_type.signature)
			.append ("*", false)
			.get ();
	}
}
