/* valaclass.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACLASS_H__
#define __VALA_VALACLASS_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClassPrivate ValaClassPrivate;

/**
 * Represents a class declaration in the source code.
 */
struct _ValaClass {
	ValaTypesymbol parent_instance;
	ValaClassPrivate * priv;
};
struct _ValaClassClass {
	ValaTypesymbolClass parent_class;
};

ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference);
void vala_class_add_base_type (ValaClass* self, ValaDataType* type);
GeeCollection* vala_class_get_base_types (ValaClass* self);
void vala_class_add_type_parameter (ValaClass* self, ValaTypeParameter* p);
GeeCollection* vala_class_get_type_parameters (ValaClass* self);
void vala_class_add_constant (ValaClass* self, ValaConstant* c);
void vala_class_add_field (ValaClass* self, ValaField* f);
GeeCollection* vala_class_get_fields (ValaClass* self);
void vala_class_add_method (ValaClass* self, ValaMethod* m);
GeeCollection* vala_class_get_methods (ValaClass* self);
void vala_class_add_property (ValaClass* self, ValaProperty* prop, gboolean no_field);
GeeCollection* vala_class_get_properties (ValaClass* self);
void vala_class_add_signal (ValaClass* self, ValaSignal* sig);
GeeCollection* vala_class_get_signals (ValaClass* self);
void vala_class_add_class (ValaClass* self, ValaClass* cl);
void vala_class_add_struct (ValaClass* self, ValaStruct* st);
char* vala_class_get_default_cname (ValaClass* self);
void vala_class_set_cname (ValaClass* self, const char* cname);
void vala_class_process_attributes (ValaClass* self);
void vala_class_set_type_id (ValaClass* self, const char* type_id);
void vala_class_set_ref_function (ValaClass* self, const char* name);
void vala_class_set_unref_function (ValaClass* self, const char* name);
void vala_class_set_dup_function (ValaClass* self, const char* name);
char* vala_class_get_default_free_function (ValaClass* self);
void vala_class_set_free_function (ValaClass* self, const char* name);
ValaClass* vala_class_get_base_class (ValaClass* self);
void vala_class_set_base_class (ValaClass* self, ValaClass* value);
gboolean vala_class_get_is_abstract (ValaClass* self);
void vala_class_set_is_abstract (ValaClass* self, gboolean value);
gboolean vala_class_get_is_static (ValaClass* self);
void vala_class_set_is_static (ValaClass* self, gboolean value);
gboolean vala_class_get_has_private_fields (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value);
ValaConstructor* vala_class_get_constructor (ValaClass* self);
void vala_class_set_constructor (ValaClass* self, ValaConstructor* value);
ValaDestructor* vala_class_get_destructor (ValaClass* self);
void vala_class_set_destructor (ValaClass* self, ValaDestructor* value);
GType vala_class_get_type (void);

G_END_DECLS

#endif
