/* valaarraytype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraytype.h>

struct _ValaArrayTypePrivate {
	ValaDataType* _element_type;
};
#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
enum  {
	VALA_ARRAY_TYPE_DUMMY_PROPERTY,
	VALA_ARRAY_TYPE_ELEMENT_TYPE
};
static gpointer vala_array_type_parent_class = NULL;
static void vala_array_type_dispose (GObject * obj);


ValaArrayType* vala_array_type_new (ValaDataType* element_type) {
	ValaArrayType * self;
	g_return_val_if_fail (element_type == NULL || VALA_IS_DATA_TYPE (element_type), NULL);
	self = g_object_newv (VALA_TYPE_ARRAY_TYPE, 0, NULL);
	vala_array_type_set_element_type (self, element_type);
	return self;
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), NULL);
	return self->priv->_element_type;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	g_return_if_fail (VALA_IS_ARRAY_TYPE (self));
	self->priv->_element_type = value;
}


static void vala_array_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (object);
	switch (property_id) {
		case VALA_ARRAY_TYPE_ELEMENT_TYPE:
		g_value_set_object (value, vala_array_type_get_element_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (object);
	switch (property_id) {
		case VALA_ARRAY_TYPE_ELEMENT_TYPE:
		vala_array_type_set_element_type (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_array_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_array_type_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_TYPE_ELEMENT_TYPE, g_param_spec_object ("element-type", "element-type", "element-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_array_type_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_dispose (GObject * obj) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (obj);
	G_OBJECT_CLASS (vala_array_type_parent_class)->dispose (obj);
}


GType vala_array_type_get_type (void) {
	static GType vala_array_type_type_id = 0;
	if (G_UNLIKELY (vala_array_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_init };
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
	}
	return vala_array_type_type_id;
}




