/* valaccodemethodbinding.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodemethodbinding.h>
#include <vala/valacodenode.h>
#include <stdlib.h>
#include <string.h>

struct _ValaCCodeMethodBindingPrivate {
	ValaMethod* _method;
};
#define VALA_CCODE_METHOD_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBindingPrivate))
enum  {
	VALA_CCODE_METHOD_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_METHOD_BINDING_METHOD,
	VALA_CCODE_METHOD_BINDING_HAS_WRAPPER
};
static void vala_ccode_method_binding_real_emit (ValaCodeBinding* base);
static gpointer vala_ccode_method_binding_parent_class = NULL;
static void vala_ccode_method_binding_dispose (GObject * obj);


ValaCCodeMethodBinding* vala_ccode_method_binding_new (ValaCodeGenerator* codegen, ValaMethod* method) {
	ValaCCodeMethodBinding * self;
	g_return_val_if_fail (codegen == NULL || VALA_IS_CODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (method == NULL || VALA_IS_METHOD (method), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_METHOD_BINDING, 0, NULL);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), VALA_CCODE_GENERATOR (codegen));
	vala_ccode_method_binding_set_method (self, method);
	return self;
}


ValaCCodeMethodBinding* vala_ccode_method_binding_get (ValaMethod* method) {
	ValaCCodeMethodBinding* _tmp0;
	g_return_val_if_fail (method == NULL || VALA_IS_METHOD (method), NULL);
	_tmp0 = NULL;
	return (_tmp0 = VALA_CCODE_METHOD_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (method))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


static void vala_ccode_method_binding_real_emit (ValaCodeBinding* base) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (base);
}


ValaMethod* vala_ccode_method_binding_get_method (ValaCCodeMethodBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	return self->priv->_method;
}


void vala_ccode_method_binding_set_method (ValaCCodeMethodBinding* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL))), _tmp2);
}


gboolean vala_ccode_method_binding_get_has_wrapper (ValaCCodeMethodBinding* self) {
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (vala_ccode_method_binding_get_method (self)), "NoWrapper")) == NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static void vala_ccode_method_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		g_value_set_object (value, vala_ccode_method_binding_get_method (self));
		break;
		case VALA_CCODE_METHOD_BINDING_HAS_WRAPPER:
		g_value_set_boolean (value, vala_ccode_method_binding_get_has_wrapper (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		vala_ccode_method_binding_set_method (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_class_init (ValaCCodeMethodBindingClass * klass) {
	vala_ccode_method_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMethodBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_method_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_method_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_method_binding_dispose;
	VALA_CODE_BINDING_CLASS (klass)->emit = vala_ccode_method_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_METHOD, g_param_spec_object ("method", "method", "method", VALA_TYPE_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_HAS_WRAPPER, g_param_spec_boolean ("has-wrapper", "has-wrapper", "has-wrapper", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vala_ccode_method_binding_init (ValaCCodeMethodBinding * self) {
	self->priv = VALA_CCODE_METHOD_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_method_binding_dispose (GObject * obj) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (obj);
	(self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL)));
	G_OBJECT_CLASS (vala_ccode_method_binding_parent_class)->dispose (obj);
}


GType vala_ccode_method_binding_get_type (void) {
	static GType vala_ccode_method_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_method_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodBinding), 0, (GInstanceInitFunc) vala_ccode_method_binding_init };
		vala_ccode_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_method_binding_type_id;
}




