# -*- Mode: Python; py-indent-offset: 2 -*-
# vim: tabstop=2 shiftwidth=2 expandtab
#
# EXTRAITS DE LA LICENCE
#    Copyright CEA, contributeurs : Damien CALISTE, (2001-2010)
#
#    Adresse mèl :
#    CALISTE, damien P caliste AT cea P fr.
#
#    Ce logiciel est un programme informatique servant à visualiser des
#    structures atomiques dans un rendu pseudo-3D. 
#
#    Ce logiciel est régi par la licence CeCILL soumise au droit français et
#    respectant les principes de diffusion des logiciels libres. Vous pouvez
#    utiliser, modifier et/ou redistribuer ce programme sous les conditions
#    de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
#    sur le site "http://www.cecill.info".
#
#    Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
#    pris connaissance de la licence CeCILL, et que vous en avez accepté les
#    termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).


# LICENCE SUM UP
#    Copyright CEA, contributors: Damien CALISTE, (2001-2010)
#
#    E-mail address:
#    CALISTE, damien P caliste AT cea P fr.
#
#    This software is a computer program whose purpose is to visualize atomic
#    configurations in 3D.
#
#    This software is governed by the CeCILL  license under French law and
#    abiding by the rules of distribution of free software.  You can  use, 
#    modify and/ or redistribute the software under the terms of the CeCILL
#    license as circulated by CEA, CNRS and INRIA at the following URL
#    "http://www.cecill.info". 
#
#    The fact that you are presently reading this means that you have had
#    knowledge of the CeCILL license and that you accept its terms. You can
#    find a copy of this licence shipped with this software at
#    Documentation/licence.en.txt.

from ..importer import modules

v_sim = modules['v_sim']

class VisuDataIter:
  def __init__(self, data, kind = v_sim.DataIterType.NODES_BY_TYPE):
    self.iter = data.iterNew()
    self.iter.type = kind

  def __iter__(self):
    return self

  def next(self):
    if not(self.iter.next()):
      raise StopIteration
    return self.iter

class VisuDataIter2:
  def __init__(self, data):
    self.iter1 = data.iterNew()
    self.iter2 = data.iterNew()

  def __iter__(self):
    return self

  def next(self):
    if not(self.iter1.next2(self.iter2)):
      raise StopIteration
    return (self.iter1, self.iter2)

def __DataIter__(data):
  return VisuDataIter(data)
def __DataIterByNumber__(data):
  return VisuDataIter(data, v_sim.DataIterType.NODES_BY_NUMBER)
def __DataIterElements__(data):
  return VisuDataIter(data, v_sim.DataIterType.ELEMENTS)
def __DataIterVisible__(data):
  return VisuDataIter(data, v_sim.DataIterType.NODES_VISIBLE)
def __DataIterOriginal__(data):
  return VisuDataIter(data, v_sim.DataIterType.NODES_ORIGINAL)
def __DataIterByPairs__(data):
  return VisuDataIter2(data)


def __DataAllNodePositions__(data):
  nodes = []
  for it in data:
    nodes.append((data.getNodeCoordinates(it.node), \
                  it.node.number, it.element.name))
  return nodes

setattr(v_sim.Data, "__iter__", __DataIter__)
setattr(v_sim.Data, "__iterByNumber__", __DataIterByNumber__)
setattr(v_sim.Data, "__iterElements__", __DataIterElements__)
setattr(v_sim.Data, "__iterVisible__", __DataIterVisible__)
setattr(v_sim.Data, "__iterOriginal__", __DataIterOriginal__)
setattr(v_sim.Data, "__iterByPairs__", __DataIterByPairs__)
setattr(v_sim.Data, "getAllNodePositions", __DataAllNodePositions__)
