-- UUAGC 0.9.5 (Patterns.ag)
module Patterns where

-- Patterns.ag imports
import UU.Scanner.Position(Pos)
import CommonTypes (Constructor,Name)
-- Pattern -----------------------------------------------------
{-
   visit 0:
      synthesized attribute:
         copy                 : SELF
   alternatives:
      alternative Alias:
         child field          : {Name}
         child attr           : {Name}
         child pat            : Pattern
         child parts          : Patterns
         visit 0:
            local copy        : _
      alternative Constr:
         child name           : {Constructor}
         child pats           : Patterns
         visit 0:
            local copy        : _
      alternative Product:
         child pos            : {Pos}
         child pats           : Patterns
         visit 0:
            local copy        : _
      alternative Underscore:
         child pos            : {Pos}
         visit 0:
            local copy        : _
-}
data Pattern = Alias (Name) (Name) (Pattern) (Patterns)
             | Constr (Constructor) (Patterns)
             | Product (Pos) (Patterns)
             | Underscore (Pos)
             deriving ( Show)
-- Patterns ----------------------------------------------------
{-
   visit 0:
      synthesized attribute:
         copy                 : SELF
   alternatives:
      alternative Cons:
         child hd             : Pattern
         child tl             : Patterns
         visit 0:
            local copy        : _
      alternative Nil:
         visit 0:
            local copy        : _
-}
type Patterns = [Pattern]
