-- UUAGC 0.9.5 (HsToken.ag)
module HsToken where

import CommonTypes
import UU.Scanner.Position(Pos)
-- HsToken -----------------------------------------------------
{-
   alternatives:
      alternative AGField:
         child field          : {Name}
         child attr           : {Name}
         child pos            : {Pos}
      alternative AGLocal:
         child var            : {Name}
         child pos            : {Pos}
      alternative CharToken:
         child value          : {String}
         child pos            : {Pos}
      alternative Err:
         child mesg           : {String}
         child pos            : {Pos}
      alternative HsToken:
         child value          : {String}
         child pos            : {Pos}
      alternative StrToken:
         child value          : {String}
         child pos            : {Pos}
-}
data HsToken = AGField (Name) (Name) (Pos)
             | AGLocal (Name) (Pos)
             | CharToken (String) (Pos)
             | Err (String) (Pos)
             | HsToken (String) (Pos)
             | StrToken (String) (Pos)
-- HsTokens ----------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : HsToken
         child tl             : HsTokens
      alternative Nil:
-}
type HsTokens = [HsToken]
-- HsTokensRoot ------------------------------------------------
{-
   alternatives:
      alternative HsTokensRoot:
         child tokens         : HsTokens
-}
data HsTokensRoot = HsTokensRoot (HsTokens)
