

-- UUAGC 0.9.37.1 (Order.ag)
module Order where
{-# LINE 9 "Order.ag" #-}

-- From uuagc
import CommonTypes
import Patterns
import ErrorMessages
import AbstractSyntax
import Code hiding (Type)
import qualified Code
import Expression
import Options
import SequentialComputation
import SequentialTypes
import CodeSyntax
import GrammarInfo
import HsToken(HsTokensRoot(HsTokensRoot))
import HsTokenScanner(lexTokens)
import SemHsTokens(sem_HsTokensRoot,wrap_HsTokensRoot, Syn_HsTokensRoot(..),Inh_HsTokensRoot(..))
-- From uulib
import qualified Data.Map as Map
import qualified Data.Set as Set
import qualified Data.Sequence as Seq
import Data.Map(Map) 
import Data.Set(Set)
import Data.Sequence(Seq, (><))
import UU.Util.Utils
import UU.Scanner.Position(Pos(..),initPos)
import Data.Foldable(toList)

-- From haskell libraries
import Control.Monad(liftM)
import qualified Data.Array as Array
import Data.Array((!),bounds,inRange)
import Data.List(elemIndex,partition,sort,mapAccumL,find,nubBy,intersperse,groupBy,transpose)
import qualified Data.Tree as Tree
import Maybe
{-# LINE 42 "../src-derived/Order.hs" #-}

{-# LINE 2 "./Patterns.ag" #-}

-- Patterns.ag imports
import UU.Scanner.Position(Pos)
import CommonTypes (ConstructorIdent,Identifier)
{-# LINE 49 "../src-derived/Order.hs" #-}

{-# LINE 2 "./Expression.ag" #-}

import UU.Scanner.Position(Pos)
import HsToken
{-# LINE 55 "../src-derived/Order.hs" #-}

{-# LINE 2 "./AbstractSyntax.ag" #-}

-- AbstractSyntax.ag imports
import Data.Set(Set)
import Data.Map(Map)
import Patterns    (Pattern(..),Patterns)
import Expression  (Expression(..))
import CommonTypes
{-# LINE 65 "../src-derived/Order.hs" #-}
{-# LINE 46 "Order.ag" #-}

-- Terminates with an error if the key is not in the map
findWithErr1 :: (Ord k, Show k) => String -> k -> Map k a -> a
findWithErr1 s k
  = Map.findWithDefault (error ("findWithErr1 " ++ s ++ ": key " ++ show k ++ " not in map.")) k

findWithErr2 :: (Ord k, Show k, Show a) => k -> Map k a -> a
findWithErr2 k m
  = Map.findWithDefault (error ("findWithErr2: key " ++ show k ++ " not in map: " ++ show m)) k m
{-# LINE 76 "../src-derived/Order.hs" #-}

{-# LINE 71 "Order.ag" #-}

startsWith :: String -> String -> Bool
startsWith k h = k == take (length k) h
{-# LINE 82 "../src-derived/Order.hs" #-}

{-# LINE 138 "Order.ag" #-}

getNtName :: Type -> NontermIdent
getNtName (NT nt _) = maybe nt id (deforestedNt nt)
getNtName _         = nullIdent
{-# LINE 89 "../src-derived/Order.hs" #-}

{-# LINE 166 "Order.ag" #-}

data AltAttr = AltAttr Identifier Identifier Bool 
               deriving (Eq, Ord, Show)
{-# LINE 95 "../src-derived/Order.hs" #-}

{-# LINE 238 "Order.ag" #-}

substSelf nt tp
  = case tp of
      NT n tps | n == _SELF -> NT nt tps
      _                     -> tp
	
haskellTupel :: [Type] -> Maybe Type
haskellTupel ts =  Just ( Haskell ( '(' : (concat (intersperse "," (map show ts))) ++ ")" ))
{-# LINE 106 "../src-derived/Order.hs" #-}

{-# LINE 687 "Order.ag" #-}

swap (a,b) = (b,a)

showPath :: Table CRule -> [Vertex] -> [String]
showPath ruleTable path
  =  let  look a | inRange (bounds ruleTable) a = [showOrigin (ruleTable ! a)]
                 | otherwise = ["Vertex " ++ show a]
          showOrigin cr  | getHasCode cr && getName (getAttr cr) /= "self" = prettyCRule cr ++ " (" ++ show (getPos (getAttr cr)) ++ ")"
                         | otherwise = prettyCRule cr
     in concatMap look path


showPathLocal :: Table CRule -> [Vertex] -> [String]
showPathLocal _ [] = []
showPathLocal ruleTable xs = showP (xs++[-1])
 where showP []         = []
       showP (v1:v2:vs) = let line  = step v1 v2
                              lines = showP vs
                          in  line:lines
       step v1 v2  = " - " ++ a1
        where r1 = ruleTable ! v1
              a1 = show (getAttr  r1)


limitTo :: Int -> [String] -> [String]
limitTo _ [] = [] 
limitTo 0 _ = ["....etcetera, etcetera...."]
limitTo n (x:xs) = x : limitTo (n-1) xs

showPathNice :: Table CRule -> [Vertex] -> [String]
showPathNice _ [] = []
showPathNice ruleTable xs = limitTo 100 (showP ((-1):xs++[-1]))
 where [maxf, maxa, maxn, maxc] = maxWidths ruleTable (take 100 xs)
       showP []         = []
       showP (v1:v2:vs) = let line  = step v1 v2
                              lines = showP vs
                          in  if null line  then lines  else line:lines
       step v1 v2  |  last &&      first    = induced
                   |  last &&     isSyn r1  = "pass up        "  ++ alignR maxf ""    ++ " " ++ alignL maxa a1 ++ " in " ++ alignR maxn n1 ++ "|" ++ c1 ++ induced
                   |  first&& not(isSyn r2) = "get from above "  ++ alignR maxf ""    ++ " " ++ alignL maxa a2 ++ " in " ++ alignR maxn n2 ++ "|" ++ c2
                   |  last                  = "pass down      "  ++ alignR maxf f1    ++ "." ++ a1                                                      ++ induced
                   |              isSyn r2  = "get from below "  ++ alignR maxf f2    ++ "." ++ alignL maxa a2 ++ " in " ++ alignR maxn n2 ++ "|" ++ c2
                   |  isLocal r1  = if head a1 == '_' 
                                         then ""
                                         else "calculate      "  ++ alignR maxf "loc" ++ "." ++ a1
                   |  otherwise             = "pass down      "  ++ alignR maxf f1    ++ "." ++ alignL maxa a1 ++ " to " ++ alignR maxn n2 ++ "|" ++ c2
          where
              first = v1<0
              last  = v2<0
              r1 = ruleTable ! v1
              r2 = ruleTable ! v2
              a1 = show (getAttr  r1)
              a2 = show (getAttr  r2)
              f1 = show (getField r1)
              f2 = show (getField r2)
              n1 = show (getLhsNt r1)
              n2 = show (getLhsNt r2)
              c1 = show (getCon   r1)
              c2 = show (getCon   r2)
              induced | v2== -2   =  " INDUCED dependency to "
                      | otherwise = ""


maxWidths ruleTable vs
  = map maximum (transpose (map getWidth vs))
  where getWidth v | v<0       = [0,0,0,0]
                   | otherwise = map (length . show . ($ (ruleTable!v))) [getField, getAttr, getLhsNt, getCon]

alignL n xs | k<n       = xs ++ replicate (n-k) ' '
            | otherwise = xs
              where k = length xs

alignR n xs | k<n       = replicate (n-k) ' ' ++ xs
            | otherwise = xs
              where k = length xs

localCycleErr :: Table CRule -> Bool -> Route -> Error
localCycleErr ruleTable o_visit (s:path)
  =  let cr = ruleTable ! s
         attr = getAttr cr
         nt = getLhsNt cr
         con = getCon cr
     in LocalCirc nt con attr o_visit (showPathLocal ruleTable path)

instCycleErr :: Table CRule -> Bool -> Route -> Error
instCycleErr ruleTable o_visit (s:path)
  =  let cr = ruleTable ! s
         attr = getAttr cr
         nt = getLhsNt cr
         con = getCon cr
     in InstCirc nt con attr o_visit (showPathLocal ruleTable path)

directCycleErrs :: Table NTAttr -> Table CRule -> Bool -> [EdgeRoutes] -> [Error]
directCycleErrs attrTable ruleTable o_visit xs
  = let getNont v = case attrTable ! v of
                      NTASyn nt _ _ -> nt
                      NTAInh nt _ _ -> nt
        getAttr v = case attrTable ! v of
                      NTASyn _ a _  -> a
                      NTAInh _ a _  -> a
        sameNont ((v1,_),_,_) ((v2,_),_,_) =  getNont v1 == getNont v2
        procCycle ((v1,v2),p1,p2) = ((getAttr v1, getAttr v2), showPathNice ruleTable p1, showPathNice ruleTable p2)
        wrapGroup gr@(((v1,_),_,_):_) = DirectCirc (getNont v1) o_visit (map procCycle gr)
    in  map wrapGroup (groupBy sameNont xs)

inducedCycleErrs :: Table NTAttr -> Table CRule -> CInterfaceMap -> [EdgeRoutes] -> [Error]
inducedCycleErrs attrTable ruleTable cim xs
  = let getNont v = case attrTable ! v of
                      NTASyn nt _ _ -> nt
                      NTAInh nt _ _ -> nt
        getAttr v = case attrTable ! v of
                      NTASyn _ a _  -> a
                      NTAInh _ a _  -> a
        sameNont ((v1,_),_,_) ((v2,_),_,_) =  getNont v1 == getNont v2
        procCycle ((v1,v2),p1,p2) = ((getAttr v1, getAttr v2), showPathNice ruleTable p1, showPathNice ruleTable p2)
        wrapGroup gr@(((v1,_),_,_):_) = InducedCirc (getNont v1) (findWithErr1 "inducedCycleErr.cinter" (getNont v1) cim) (map procCycle gr)
    in  map wrapGroup (groupBy sameNont xs)
{-# LINE 226 "../src-derived/Order.hs" #-}
-- Child -------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         attrs                : [(Identifier,Identifier)]
         con                  : Identifier
         inh                  : Attributes
         mergeMap             : Map Identifier (Identifier,[Identifier])
         nt                   : Identifier
         o_unbox              : Bool
         syn                  : Attributes
      synthesized attributes:
         attributes           : [(Identifier,Attributes,Attributes)]
         collectChildrenInhs  : Map Identifier Attributes 
         collectChildrenSyns  : Map Identifier Attributes 
         errors               : Seq Error
         field                : (Identifier,Type,Maybe (Maybe Type))
         gathAltAttrs         : [AltAttr]
         gathRules            : Seq CRule
         inhs                 : Seq (Identifier,Attributes)
         nts                  : Seq (Identifier,NontermIdent)
         singlevisits         : [CRule]
         terminals            : [Identifier]
   alternatives:
      alternative Child:
         child name           : {Identifier}
         child tp             : {Type}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child virtual        : {Maybe (Maybe Type)}
         visit 0:
            local maptolocal  : _
            local gathRules   : _
-}
-- cata
sem_Child :: Child  ->
             T_Child 
sem_Child (Child _name _tp _inh _syn _virtual )  =
    (sem_Child_Child _name _tp _inh _syn _virtual )
-- semantic domain
newtype T_Child  = T_Child (([(Identifier,Type,Maybe (Maybe Type))]) ->
                            ([Identifier]) ->
                            ([(Identifier,Identifier)]) ->
                            Identifier ->
                            Attributes ->
                            (Map Identifier (Identifier,[Identifier])) ->
                            Identifier ->
                            Bool ->
                            Attributes ->
                            ( ([(Identifier,Attributes,Attributes)]),(Map Identifier Attributes ),(Map Identifier Attributes ),(Seq Error),((Identifier,Type,Maybe (Maybe Type))),([AltAttr]),(Seq CRule),(Seq (Identifier,Attributes)),(Seq (Identifier,NontermIdent)),([CRule]),([Identifier])))
data Inh_Child  = Inh_Child {allfields_Inh_Child :: !(([(Identifier,Type,Maybe (Maybe Type))])),allnts_Inh_Child :: !(([Identifier])),attrs_Inh_Child :: !(([(Identifier,Identifier)])),con_Inh_Child :: !(Identifier),inh_Inh_Child :: !(Attributes),mergeMap_Inh_Child :: !((Map Identifier (Identifier,[Identifier]))),nt_Inh_Child :: !(Identifier),o_unbox_Inh_Child :: !(Bool),syn_Inh_Child :: !(Attributes)}
data Syn_Child  = Syn_Child {attributes_Syn_Child :: !(([(Identifier,Attributes,Attributes)])),collectChildrenInhs_Syn_Child :: !((Map Identifier Attributes )),collectChildrenSyns_Syn_Child :: !((Map Identifier Attributes )),errors_Syn_Child :: !((Seq Error)),field_Syn_Child :: !(((Identifier,Type,Maybe (Maybe Type)))),gathAltAttrs_Syn_Child :: !(([AltAttr])),gathRules_Syn_Child :: !((Seq CRule)),inhs_Syn_Child :: !((Seq (Identifier,Attributes))),nts_Syn_Child :: !((Seq (Identifier,NontermIdent))),singlevisits_Syn_Child :: !(([CRule])),terminals_Syn_Child :: !(([Identifier]))}
wrap_Child :: T_Child  ->
              Inh_Child  ->
              Syn_Child 
wrap_Child (T_Child sem ) (Inh_Child _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIinh _lhsImergeMap _lhsInt _lhsIo_unbox _lhsIsyn )  =
    (let ( _lhsOattributes,_lhsOcollectChildrenInhs,_lhsOcollectChildrenSyns,_lhsOerrors,_lhsOfield,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinhs,_lhsOnts,_lhsOsinglevisits,_lhsOterminals) = sem _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIinh _lhsImergeMap _lhsInt _lhsIo_unbox _lhsIsyn 
     in  (Syn_Child _lhsOattributes _lhsOcollectChildrenInhs _lhsOcollectChildrenSyns _lhsOerrors _lhsOfield _lhsOgathAltAttrs _lhsOgathRules _lhsOinhs _lhsOnts _lhsOsinglevisits _lhsOterminals ))
sem_Child_Child :: Identifier ->
                   Type ->
                   Attributes ->
                   Attributes ->
                   (Maybe (Maybe Type)) ->
                   T_Child 
sem_Child_Child name_ tp_ inh_ syn_ virtual_  =
    (T_Child (\ _lhsIallfields
                _lhsIallnts
                _lhsIattrs
                _lhsIcon
                _lhsIinh
                _lhsImergeMap
                _lhsInt
                _lhsIo_unbox
                _lhsIsyn ->
                  (let _lhsOgathAltAttrs :: ([AltAttr])
                       _lhsOnts :: (Seq (Identifier,NontermIdent))
                       _lhsOinhs :: (Seq (Identifier,Attributes))
                       _lhsOcollectChildrenSyns :: (Map Identifier Attributes )
                       _lhsOcollectChildrenInhs :: (Map Identifier Attributes )
                       _lhsOsinglevisits :: ([CRule])
                       _lhsOterminals :: ([Identifier])
                       _lhsOattributes :: ([(Identifier,Attributes,Attributes)])
                       _lhsOfield :: ((Identifier,Type,Maybe (Maybe Type)))
                       _lhsOerrors :: (Seq Error)
                       _lhsOgathRules :: (Seq CRule)
                       -- "Order.ag"(line 177, column 13)
                       _maptolocal =
                           ({-# LINE 177 "Order.ag" #-}
                            case tp_ of
                              NT nt _ -> Map.null syn_
                              _       -> True
                            {-# LINE 320 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 180, column 13)
                       _lhsOgathAltAttrs =
                           ({-# LINE 180 "Order.ag" #-}
                            if  _maptolocal
                                then [ AltAttr _LOC name_ True ]
                                else [ AltAttr name_ syn True | syn <- Map.keys syn_ ]
                            {-# LINE 328 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 195, column 13)
                       _lhsOnts =
                           ({-# LINE 195 "Order.ag" #-}
                            Seq.singleton (name_,getNtName tp_)
                            {-# LINE 334 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 196, column 13)
                       _lhsOinhs =
                           ({-# LINE 196 "Order.ag" #-}
                            Seq.singleton (name_,inh_)
                            {-# LINE 340 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 212, column 13)
                       _gathRules =
                           ({-# LINE 212 "Order.ag" #-}
                            if  _maptolocal
                                then Seq.singleton (cRuleTerminal name_ _lhsInt _lhsIcon tp_)
                                else Seq.fromList [ cRuleRhsSyn syn _lhsInt _lhsIcon tp name_ (getNtName tp_) | (syn,tp) <- Map.assocs syn_]
                            {-# LINE 348 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 346, column 12)
                       _lhsOcollectChildrenSyns =
                           ({-# LINE 346 "Order.ag" #-}
                            Map.singleton name_ syn_
                            {-# LINE 354 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 347, column 12)
                       _lhsOcollectChildrenInhs =
                           ({-# LINE 347 "Order.ag" #-}
                            Map.singleton name_ inh_
                            {-# LINE 360 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 613, column 11)
                       _lhsOsinglevisits =
                           ({-# LINE 613 "Order.ag" #-}
                            if  _maptolocal
                                then []
                                else [CChildVisit name_ (getNtName tp_) 0 inh_ syn_ True]
                            {-# LINE 368 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 638, column 11)
                       _lhsOterminals =
                           ({-# LINE 638 "Order.ag" #-}
                            if _maptolocal
                            then [name_]
                            else []
                            {-# LINE 376 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 667, column 11)
                       _lhsOattributes =
                           ({-# LINE 667 "Order.ag" #-}
                            [(name_, inh_, syn_)]
                            {-# LINE 382 "Order.hs" #-}
                            )
                       -- "Order.ag"(line 671, column 11)
                       _lhsOfield =
                           ({-# LINE 671 "Order.ag" #-}
                            (name_, tp_, virtual_)
                            {-# LINE 388 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 84, column 70)
                       _lhsOerrors =
                           ({-# LINE 84 "Order.ag" #-}
                            Seq.empty
                            {-# LINE 394 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 206, column 23)
                       _lhsOgathRules =
                           ({-# LINE 206 "Order.ag" #-}
                            _gathRules
                            {-# LINE 400 "Order.hs" #-}
                            )
                   in  ( _lhsOattributes,_lhsOcollectChildrenInhs,_lhsOcollectChildrenSyns,_lhsOerrors,_lhsOfield,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinhs,_lhsOnts,_lhsOsinglevisits,_lhsOterminals))) )
-- Children ----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         attrs                : [(Identifier,Identifier)]
         con                  : Identifier
         inh                  : Attributes
         mergeMap             : Map Identifier (Identifier,[Identifier])
         nt                   : Identifier
         o_unbox              : Bool
         syn                  : Attributes
      synthesized attributes:
         attributes           : [(Identifier,Attributes,Attributes)]
         collectChildrenInhs  : Map Identifier Attributes 
         collectChildrenSyns  : Map Identifier Attributes 
         errors               : Seq Error
         fields               : [(Identifier,Type,Maybe (Maybe Type))]
         gathAltAttrs         : [AltAttr]
         gathRules            : Seq CRule
         inhs                 : Seq (Identifier,Attributes)
         nts                  : Seq (Identifier,NontermIdent)
         singlevisits         : [CRule]
         terminals            : [Identifier]
   alternatives:
      alternative Cons:
         child hd             : Child 
         child tl             : Children 
      alternative Nil:
-}
-- cata
sem_Children :: Children  ->
                T_Children 
sem_Children list  =
    (Prelude.foldr sem_Children_Cons sem_Children_Nil (Prelude.map sem_Child list) )
-- semantic domain
newtype T_Children  = T_Children (([(Identifier,Type,Maybe (Maybe Type))]) ->
                                  ([Identifier]) ->
                                  ([(Identifier,Identifier)]) ->
                                  Identifier ->
                                  Attributes ->
                                  (Map Identifier (Identifier,[Identifier])) ->
                                  Identifier ->
                                  Bool ->
                                  Attributes ->
                                  ( ([(Identifier,Attributes,Attributes)]),(Map Identifier Attributes ),(Map Identifier Attributes ),(Seq Error),([(Identifier,Type,Maybe (Maybe Type))]),([AltAttr]),(Seq CRule),(Seq (Identifier,Attributes)),(Seq (Identifier,NontermIdent)),([CRule]),([Identifier])))
data Inh_Children  = Inh_Children {allfields_Inh_Children :: !(([(Identifier,Type,Maybe (Maybe Type))])),allnts_Inh_Children :: !(([Identifier])),attrs_Inh_Children :: !(([(Identifier,Identifier)])),con_Inh_Children :: !(Identifier),inh_Inh_Children :: !(Attributes),mergeMap_Inh_Children :: !((Map Identifier (Identifier,[Identifier]))),nt_Inh_Children :: !(Identifier),o_unbox_Inh_Children :: !(Bool),syn_Inh_Children :: !(Attributes)}
data Syn_Children  = Syn_Children {attributes_Syn_Children :: !(([(Identifier,Attributes,Attributes)])),collectChildrenInhs_Syn_Children :: !((Map Identifier Attributes )),collectChildrenSyns_Syn_Children :: !((Map Identifier Attributes )),errors_Syn_Children :: !((Seq Error)),fields_Syn_Children :: !(([(Identifier,Type,Maybe (Maybe Type))])),gathAltAttrs_Syn_Children :: !(([AltAttr])),gathRules_Syn_Children :: !((Seq CRule)),inhs_Syn_Children :: !((Seq (Identifier,Attributes))),nts_Syn_Children :: !((Seq (Identifier,NontermIdent))),singlevisits_Syn_Children :: !(([CRule])),terminals_Syn_Children :: !(([Identifier]))}
wrap_Children :: T_Children  ->
                 Inh_Children  ->
                 Syn_Children 
wrap_Children (T_Children sem ) (Inh_Children _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIinh _lhsImergeMap _lhsInt _lhsIo_unbox _lhsIsyn )  =
    (let ( _lhsOattributes,_lhsOcollectChildrenInhs,_lhsOcollectChildrenSyns,_lhsOerrors,_lhsOfields,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinhs,_lhsOnts,_lhsOsinglevisits,_lhsOterminals) = sem _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsIinh _lhsImergeMap _lhsInt _lhsIo_unbox _lhsIsyn 
     in  (Syn_Children _lhsOattributes _lhsOcollectChildrenInhs _lhsOcollectChildrenSyns _lhsOerrors _lhsOfields _lhsOgathAltAttrs _lhsOgathRules _lhsOinhs _lhsOnts _lhsOsinglevisits _lhsOterminals ))
sem_Children_Cons :: T_Child  ->
                     T_Children  ->
                     T_Children 
sem_Children_Cons (T_Child hd_ ) (T_Children tl_ )  =
    (T_Children (\ _lhsIallfields
                   _lhsIallnts
                   _lhsIattrs
                   _lhsIcon
                   _lhsIinh
                   _lhsImergeMap
                   _lhsInt
                   _lhsIo_unbox
                   _lhsIsyn ->
                     (let _lhsOfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                          _lhsOattributes :: ([(Identifier,Attributes,Attributes)])
                          _lhsOcollectChildrenInhs :: (Map Identifier Attributes )
                          _lhsOcollectChildrenSyns :: (Map Identifier Attributes )
                          _lhsOerrors :: (Seq Error)
                          _lhsOgathAltAttrs :: ([AltAttr])
                          _lhsOgathRules :: (Seq CRule)
                          _lhsOinhs :: (Seq (Identifier,Attributes))
                          _lhsOnts :: (Seq (Identifier,NontermIdent))
                          _lhsOsinglevisits :: ([CRule])
                          _lhsOterminals :: ([Identifier])
                          _hdOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                          _hdOallnts :: ([Identifier])
                          _hdOattrs :: ([(Identifier,Identifier)])
                          _hdOcon :: Identifier
                          _hdOinh :: Attributes
                          _hdOmergeMap :: (Map Identifier (Identifier,[Identifier]))
                          _hdOnt :: Identifier
                          _hdOo_unbox :: Bool
                          _hdOsyn :: Attributes
                          _tlOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                          _tlOallnts :: ([Identifier])
                          _tlOattrs :: ([(Identifier,Identifier)])
                          _tlOcon :: Identifier
                          _tlOinh :: Attributes
                          _tlOmergeMap :: (Map Identifier (Identifier,[Identifier]))
                          _tlOnt :: Identifier
                          _tlOo_unbox :: Bool
                          _tlOsyn :: Attributes
                          _hdIattributes :: ([(Identifier,Attributes,Attributes)])
                          _hdIcollectChildrenInhs :: (Map Identifier Attributes )
                          _hdIcollectChildrenSyns :: (Map Identifier Attributes )
                          _hdIerrors :: (Seq Error)
                          _hdIfield :: ((Identifier,Type,Maybe (Maybe Type)))
                          _hdIgathAltAttrs :: ([AltAttr])
                          _hdIgathRules :: (Seq CRule)
                          _hdIinhs :: (Seq (Identifier,Attributes))
                          _hdInts :: (Seq (Identifier,NontermIdent))
                          _hdIsinglevisits :: ([CRule])
                          _hdIterminals :: ([Identifier])
                          _tlIattributes :: ([(Identifier,Attributes,Attributes)])
                          _tlIcollectChildrenInhs :: (Map Identifier Attributes )
                          _tlIcollectChildrenSyns :: (Map Identifier Attributes )
                          _tlIerrors :: (Seq Error)
                          _tlIfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                          _tlIgathAltAttrs :: ([AltAttr])
                          _tlIgathRules :: (Seq CRule)
                          _tlIinhs :: (Seq (Identifier,Attributes))
                          _tlInts :: (Seq (Identifier,NontermIdent))
                          _tlIsinglevisits :: ([CRule])
                          _tlIterminals :: ([Identifier])
                          -- "Order.ag"(line 674, column 11)
                          _lhsOfields =
                              ({-# LINE 674 "Order.ag" #-}
                               _hdIfield : _tlIfields
                               {-# LINE 526 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 665, column 32)
                          _lhsOattributes =
                              ({-# LINE 665 "Order.ag" #-}
                               _hdIattributes ++ _tlIattributes
                               {-# LINE 532 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 344, column 68)
                          _lhsOcollectChildrenInhs =
                              ({-# LINE 344 "Order.ag" #-}
                               _hdIcollectChildrenInhs `Map.union` _tlIcollectChildrenInhs
                               {-# LINE 538 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 344, column 68)
                          _lhsOcollectChildrenSyns =
                              ({-# LINE 344 "Order.ag" #-}
                               _hdIcollectChildrenSyns `Map.union` _tlIcollectChildrenSyns
                               {-# LINE 544 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 84, column 70)
                          _lhsOerrors =
                              ({-# LINE 84 "Order.ag" #-}
                               _hdIerrors Seq.>< _tlIerrors
                               {-# LINE 550 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 170, column 68)
                          _lhsOgathAltAttrs =
                              ({-# LINE 170 "Order.ag" #-}
                               _hdIgathAltAttrs ++ _tlIgathAltAttrs
                               {-# LINE 556 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 206, column 23)
                          _lhsOgathRules =
                              ({-# LINE 206 "Order.ag" #-}
                               _hdIgathRules Seq.>< _tlIgathRules
                               {-# LINE 562 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 193, column 20)
                          _lhsOinhs =
                              ({-# LINE 193 "Order.ag" #-}
                               _hdIinhs Seq.>< _tlIinhs
                               {-# LINE 568 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 192, column 19)
                          _lhsOnts =
                              ({-# LINE 192 "Order.ag" #-}
                               _hdInts Seq.>< _tlInts
                               {-# LINE 574 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 611, column 40)
                          _lhsOsinglevisits =
                              ({-# LINE 611 "Order.ag" #-}
                               _hdIsinglevisits ++ _tlIsinglevisits
                               {-# LINE 580 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 636, column 38)
                          _lhsOterminals =
                              ({-# LINE 636 "Order.ag" #-}
                               _hdIterminals ++ _tlIterminals
                               {-# LINE 586 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOallfields =
                              ({-# LINE 654 "Order.ag" #-}
                               _lhsIallfields
                               {-# LINE 592 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOallnts =
                              ({-# LINE 647 "Order.ag" #-}
                               _lhsIallnts
                               {-# LINE 598 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOattrs =
                              ({-# LINE 654 "Order.ag" #-}
                               _lhsIattrs
                               {-# LINE 604 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOcon =
                              ({-# LINE 90 "Order.ag" #-}
                               _lhsIcon
                               {-# LINE 610 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOinh =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIinh
                               {-# LINE 616 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOmergeMap =
                              ({-# LINE 362 "Order.ag" #-}
                               _lhsImergeMap
                               {-# LINE 622 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOnt =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsInt
                               {-# LINE 628 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOo_unbox =
                              ({-# LINE 119 "Order.ag" #-}
                               _lhsIo_unbox
                               {-# LINE 634 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOsyn =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIsyn
                               {-# LINE 640 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOallfields =
                              ({-# LINE 654 "Order.ag" #-}
                               _lhsIallfields
                               {-# LINE 646 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOallnts =
                              ({-# LINE 647 "Order.ag" #-}
                               _lhsIallnts
                               {-# LINE 652 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOattrs =
                              ({-# LINE 654 "Order.ag" #-}
                               _lhsIattrs
                               {-# LINE 658 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOcon =
                              ({-# LINE 90 "Order.ag" #-}
                               _lhsIcon
                               {-# LINE 664 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOinh =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIinh
                               {-# LINE 670 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOmergeMap =
                              ({-# LINE 362 "Order.ag" #-}
                               _lhsImergeMap
                               {-# LINE 676 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOnt =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsInt
                               {-# LINE 682 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOo_unbox =
                              ({-# LINE 119 "Order.ag" #-}
                               _lhsIo_unbox
                               {-# LINE 688 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOsyn =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIsyn
                               {-# LINE 694 "Order.hs" #-}
                               )
                          ( _hdIattributes,_hdIcollectChildrenInhs,_hdIcollectChildrenSyns,_hdIerrors,_hdIfield,_hdIgathAltAttrs,_hdIgathRules,_hdIinhs,_hdInts,_hdIsinglevisits,_hdIterminals) =
                              hd_ _hdOallfields _hdOallnts _hdOattrs _hdOcon _hdOinh _hdOmergeMap _hdOnt _hdOo_unbox _hdOsyn 
                          ( _tlIattributes,_tlIcollectChildrenInhs,_tlIcollectChildrenSyns,_tlIerrors,_tlIfields,_tlIgathAltAttrs,_tlIgathRules,_tlIinhs,_tlInts,_tlIsinglevisits,_tlIterminals) =
                              tl_ _tlOallfields _tlOallnts _tlOattrs _tlOcon _tlOinh _tlOmergeMap _tlOnt _tlOo_unbox _tlOsyn 
                      in  ( _lhsOattributes,_lhsOcollectChildrenInhs,_lhsOcollectChildrenSyns,_lhsOerrors,_lhsOfields,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinhs,_lhsOnts,_lhsOsinglevisits,_lhsOterminals))) )
sem_Children_Nil :: T_Children 
sem_Children_Nil  =
    (T_Children (\ _lhsIallfields
                   _lhsIallnts
                   _lhsIattrs
                   _lhsIcon
                   _lhsIinh
                   _lhsImergeMap
                   _lhsInt
                   _lhsIo_unbox
                   _lhsIsyn ->
                     (let _lhsOfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                          _lhsOattributes :: ([(Identifier,Attributes,Attributes)])
                          _lhsOcollectChildrenInhs :: (Map Identifier Attributes )
                          _lhsOcollectChildrenSyns :: (Map Identifier Attributes )
                          _lhsOerrors :: (Seq Error)
                          _lhsOgathAltAttrs :: ([AltAttr])
                          _lhsOgathRules :: (Seq CRule)
                          _lhsOinhs :: (Seq (Identifier,Attributes))
                          _lhsOnts :: (Seq (Identifier,NontermIdent))
                          _lhsOsinglevisits :: ([CRule])
                          _lhsOterminals :: ([Identifier])
                          -- "Order.ag"(line 675, column 11)
                          _lhsOfields =
                              ({-# LINE 675 "Order.ag" #-}
                               []
                               {-# LINE 727 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 665, column 32)
                          _lhsOattributes =
                              ({-# LINE 665 "Order.ag" #-}
                               []
                               {-# LINE 733 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 344, column 68)
                          _lhsOcollectChildrenInhs =
                              ({-# LINE 344 "Order.ag" #-}
                               Map.empty
                               {-# LINE 739 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 344, column 68)
                          _lhsOcollectChildrenSyns =
                              ({-# LINE 344 "Order.ag" #-}
                               Map.empty
                               {-# LINE 745 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 84, column 70)
                          _lhsOerrors =
                              ({-# LINE 84 "Order.ag" #-}
                               Seq.empty
                               {-# LINE 751 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 170, column 68)
                          _lhsOgathAltAttrs =
                              ({-# LINE 170 "Order.ag" #-}
                               []
                               {-# LINE 757 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 206, column 23)
                          _lhsOgathRules =
                              ({-# LINE 206 "Order.ag" #-}
                               Seq.empty
                               {-# LINE 763 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 193, column 20)
                          _lhsOinhs =
                              ({-# LINE 193 "Order.ag" #-}
                               Seq.empty
                               {-# LINE 769 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 192, column 19)
                          _lhsOnts =
                              ({-# LINE 192 "Order.ag" #-}
                               Seq.empty
                               {-# LINE 775 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 611, column 40)
                          _lhsOsinglevisits =
                              ({-# LINE 611 "Order.ag" #-}
                               []
                               {-# LINE 781 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 636, column 38)
                          _lhsOterminals =
                              ({-# LINE 636 "Order.ag" #-}
                               []
                               {-# LINE 787 "Order.hs" #-}
                               )
                      in  ( _lhsOattributes,_lhsOcollectChildrenInhs,_lhsOcollectChildrenSyns,_lhsOerrors,_lhsOfields,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinhs,_lhsOnts,_lhsOsinglevisits,_lhsOterminals))) )
-- Expression --------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         attrs                : [(Identifier,Identifier)]
         con                  : Identifier
         mergeMap             : Map Identifier (Identifier,[Identifier])
         nt                   : Identifier
      synthesized attributes:
         allRhsVars           : Set (Identifier,Identifier)
         copy                 : SELF 
         errors               : Seq Error
         textLines            : [String]
         usedAttrs            : [(Identifier,Identifier)]
         usedFields           : [Identifier]
         usedLocals           : [Identifier]
   alternatives:
      alternative Expression:
         child pos            : {Pos}
         child tks            : {[HsToken]}
         visit 0:
            local _tup1       : _
            local errors      : _
            local textLines   : _
            local usedAttrs   : _
            local usedLocals  : _
            local usedFields  : _
            local copy        : _
-}
-- cata
sem_Expression :: Expression  ->
                  T_Expression 
sem_Expression (Expression _pos _tks )  =
    (sem_Expression_Expression _pos _tks )
-- semantic domain
newtype T_Expression  = T_Expression (([(Identifier,Type,Maybe (Maybe Type))]) ->
                                      ([Identifier]) ->
                                      ([(Identifier,Identifier)]) ->
                                      Identifier ->
                                      (Map Identifier (Identifier,[Identifier])) ->
                                      Identifier ->
                                      ( (Set (Identifier,Identifier)),Expression ,(Seq Error),([String]),([(Identifier,Identifier)]),([Identifier]),([Identifier])))
data Inh_Expression  = Inh_Expression {allfields_Inh_Expression :: !(([(Identifier,Type,Maybe (Maybe Type))])),allnts_Inh_Expression :: !(([Identifier])),attrs_Inh_Expression :: !(([(Identifier,Identifier)])),con_Inh_Expression :: !(Identifier),mergeMap_Inh_Expression :: !((Map Identifier (Identifier,[Identifier]))),nt_Inh_Expression :: !(Identifier)}
data Syn_Expression  = Syn_Expression {allRhsVars_Syn_Expression :: !((Set (Identifier,Identifier))),copy_Syn_Expression :: !(Expression ),errors_Syn_Expression :: !((Seq Error)),textLines_Syn_Expression :: !(([String])),usedAttrs_Syn_Expression :: !(([(Identifier,Identifier)])),usedFields_Syn_Expression :: !(([Identifier])),usedLocals_Syn_Expression :: !(([Identifier]))}
wrap_Expression :: T_Expression  ->
                   Inh_Expression  ->
                   Syn_Expression 
wrap_Expression (T_Expression sem ) (Inh_Expression _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsImergeMap _lhsInt )  =
    (let ( _lhsOallRhsVars,_lhsOcopy,_lhsOerrors,_lhsOtextLines,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals) = sem _lhsIallfields _lhsIallnts _lhsIattrs _lhsIcon _lhsImergeMap _lhsInt 
     in  (Syn_Expression _lhsOallRhsVars _lhsOcopy _lhsOerrors _lhsOtextLines _lhsOusedAttrs _lhsOusedFields _lhsOusedLocals ))
sem_Expression_Expression :: Pos ->
                             ([HsToken]) ->
                             T_Expression 
sem_Expression_Expression pos_ tks_  =
    (T_Expression (\ _lhsIallfields
                     _lhsIallnts
                     _lhsIattrs
                     _lhsIcon
                     _lhsImergeMap
                     _lhsInt ->
                       (let _lhsOallRhsVars :: (Set (Identifier,Identifier))
                            _lhsOcopy :: Expression 
                            _lhsOerrors :: (Seq Error)
                            _lhsOtextLines :: ([String])
                            _lhsOusedAttrs :: ([(Identifier,Identifier)])
                            _lhsOusedFields :: ([Identifier])
                            _lhsOusedLocals :: ([Identifier])
                            -- "Order.ag"(line 464, column 21)
                            __tup1 =
                                ({-# LINE 464 "Order.ag" #-}
                                 let mergedChildren = [ x | (_,xs) <- Map.elems _lhsImergeMap, x <- xs ]
                                     attrsIn = filter (\(fld,_) -> not (fld `elem` mergedChildren)) _lhsIattrs
                                     inherited = Inh_HsTokensRoot
                                                 { attrs_Inh_HsTokensRoot      = attrsIn
                                                 , con_Inh_HsTokensRoot        = _lhsIcon
                                                 , allfields_Inh_HsTokensRoot  = _lhsIallfields
                                                 , allnts_Inh_HsTokensRoot     = _lhsIallnts
                                                 , nt_Inh_HsTokensRoot         = _lhsInt
                                                 }
                                     synthesized = wrap_HsTokensRoot (sem_HsTokensRoot (HsTokensRoot tks_)) inherited
                                 in case synthesized of
                                      Syn_HsTokensRoot
                                       { errors_Syn_HsTokensRoot     = errors
                                       , textLines_Syn_HsTokensRoot  = textLines
                                       , usedAttrs_Syn_HsTokensRoot  = usedAttrs
                                       , usedLocals_Syn_HsTokensRoot = usedLocals
                                       , usedFields_Syn_HsTokensRoot = usedFields
                                       }  -> let extraAttrs = [ (src,attr)
                                                              | (fld,attr) <- usedAttrs, let mbMerged = Map.lookup fld _lhsImergeMap, isJust mbMerged
                                                              , let (Just (_, srcs)) = mbMerged, src <- srcs ]
                                                 usedAttrs' = usedAttrs ++ extraAttrs
                                             in (errors,textLines,usedAttrs',usedLocals,usedFields)
                                 {-# LINE 884 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 464, column 21)
                            (_errors,_,_,_,_) =
                                ({-# LINE 464 "Order.ag" #-}
                                 __tup1
                                 {-# LINE 890 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 464, column 21)
                            (_,_textLines,_,_,_) =
                                ({-# LINE 464 "Order.ag" #-}
                                 __tup1
                                 {-# LINE 896 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 464, column 21)
                            (_,_,_usedAttrs,_,_) =
                                ({-# LINE 464 "Order.ag" #-}
                                 __tup1
                                 {-# LINE 902 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 464, column 21)
                            (_,_,_,_usedLocals,_) =
                                ({-# LINE 464 "Order.ag" #-}
                                 __tup1
                                 {-# LINE 908 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 464, column 21)
                            (_,_,_,_,_usedFields) =
                                ({-# LINE 464 "Order.ag" #-}
                                 __tup1
                                 {-# LINE 914 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 488, column 17)
                            _lhsOallRhsVars =
                                ({-# LINE 488 "Order.ag" #-}
                                 Set.fromList _usedAttrs
                                 `Set.union`
                                 Set.fromList [ (_LOC, l) | l <- _usedLocals    ]
                                 `Set.union`
                                 Set.fromList [ (_FIELD, fld) | fld <- _usedFields    ]
                                 {-# LINE 924 "Order.hs" #-}
                                 )
                            -- self rule
                            _copy =
                                ({-# LINE 457 "Order.ag" #-}
                                 Expression pos_ tks_
                                 {-# LINE 930 "Order.hs" #-}
                                 )
                            -- self rule
                            _lhsOcopy =
                                ({-# LINE 457 "Order.ag" #-}
                                 _copy
                                 {-# LINE 936 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _lhsOerrors =
                                ({-# LINE 452 "Order.ag" #-}
                                 _errors
                                 {-# LINE 942 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _lhsOtextLines =
                                ({-# LINE 456 "Order.ag" #-}
                                 _textLines
                                 {-# LINE 948 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _lhsOusedAttrs =
                                ({-# LINE 454 "Order.ag" #-}
                                 _usedAttrs
                                 {-# LINE 954 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _lhsOusedFields =
                                ({-# LINE 455 "Order.ag" #-}
                                 _usedFields
                                 {-# LINE 960 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _lhsOusedLocals =
                                ({-# LINE 453 "Order.ag" #-}
                                 _usedLocals
                                 {-# LINE 966 "Order.hs" #-}
                                 )
                        in  ( _lhsOallRhsVars,_lhsOcopy,_lhsOerrors,_lhsOtextLines,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals))) )
-- Grammar -----------------------------------------------------
{-
   visit 0:
      inherited attribute:
         options              : Options
      synthesized attributes:
         errors               : Seq Error
         nAutoRules           : Int
         nExplicitRules       : Int
         output               : CGrammar
   alternatives:
      alternative Grammar:
         child typeSyns       : {TypeSyns}
         child useMap         : {UseMap}
         child derivings      : {Derivings}
         child wrappers       : {Set NontermIdent}
         child nonts          : Nonterminals 
         child pragmas        : {PragmaMap}
         child manualAttrOrderMap : {AttrOrderMap}
         child paramMap       : {ParamMap}
         child contextMap     : {ContextMap}
         child uniqueMap      : {UniqueMap}
         child augmentsMap    : {Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))}
         child aroundsMap     : {Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))}
         child mergeMap       : {Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier, [Identifier], Expression)))}
         visit 0:
            local o_dovisit   : _
            local ruleTable   : _
            local attrTable   : _
            local attrVertex  : _
            local tdpToTds    : _
            local tdsToTdp    : _
            local directDep   : _
            local instDep     : _
            local aroundDep   : _
            local mergeDep    : _
            local info        : _
            local _tup2       : _
            local cInterfaceMap : _
            local cVisitsMap  : _
            local cyclesErrors : _
            local aroundMap   : _
            local mergeMap    : _
-}
-- cata
sem_Grammar :: Grammar  ->
               T_Grammar 
sem_Grammar (Grammar _typeSyns _useMap _derivings _wrappers _nonts _pragmas _manualAttrOrderMap _paramMap _contextMap _uniqueMap _augmentsMap _aroundsMap _mergeMap )  =
    (sem_Grammar_Grammar _typeSyns _useMap _derivings _wrappers (sem_Nonterminals _nonts ) _pragmas _manualAttrOrderMap _paramMap _contextMap _uniqueMap _augmentsMap _aroundsMap _mergeMap )
-- semantic domain
newtype T_Grammar  = T_Grammar (Options ->
                                ( (Seq Error),Int,Int,CGrammar))
data Inh_Grammar  = Inh_Grammar {options_Inh_Grammar :: !(Options)}
data Syn_Grammar  = Syn_Grammar {errors_Syn_Grammar :: !((Seq Error)),nAutoRules_Syn_Grammar :: !(Int),nExplicitRules_Syn_Grammar :: !(Int),output_Syn_Grammar :: !(CGrammar)}
wrap_Grammar :: T_Grammar  ->
                Inh_Grammar  ->
                Syn_Grammar 
wrap_Grammar (T_Grammar sem ) (Inh_Grammar _lhsIoptions )  =
    (let ( _lhsOerrors,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOoutput) = sem _lhsIoptions 
     in  (Syn_Grammar _lhsOerrors _lhsOnAutoRules _lhsOnExplicitRules _lhsOoutput ))
sem_Grammar_Grammar :: TypeSyns ->
                       UseMap ->
                       Derivings ->
                       (Set NontermIdent) ->
                       T_Nonterminals  ->
                       PragmaMap ->
                       AttrOrderMap ->
                       ParamMap ->
                       ContextMap ->
                       UniqueMap ->
                       (Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))) ->
                       (Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))) ->
                       (Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier, [Identifier], Expression)))) ->
                       T_Grammar 
sem_Grammar_Grammar typeSyns_ useMap_ derivings_ wrappers_ (T_Nonterminals nonts_ ) pragmas_ manualAttrOrderMap_ paramMap_ contextMap_ uniqueMap_ augmentsMap_ aroundsMap_ mergeMap_  =
    (T_Grammar (\ _lhsIoptions ->
                    (let _nontsOo_cata :: Bool
                         _nontsOo_data :: Bool
                         _nontsOo_sig :: Bool
                         _nontsOo_sem :: Bool
                         _nontsOo_rename :: Bool
                         _nontsOo_newtypes :: Bool
                         _nontsOo_wantvisit :: Bool
                         _nontsOo_unbox :: Bool
                         _nontsOo_case :: Bool
                         _nontsOprefix :: String
                         _nontsOvcount :: Int
                         _nontsOmanualAttrDepMap :: AttrOrderMap
                         _nontsOaroundMap :: (Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression])))
                         _nontsOacount :: Int
                         _lhsOerrors :: (Seq Error)
                         _lhsOoutput :: CGrammar
                         _nontsOallnts :: ([Identifier])
                         _lhsOnAutoRules :: Int
                         _lhsOnExplicitRules :: Int
                         _nontsOcInterfaceMap :: CInterfaceMap
                         _nontsOcVisitsMap :: CVisitsMap
                         _nontsOmergeMap :: (Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))))
                         _nontsOo_dovisit :: Bool
                         _nontsIacount :: Int
                         _nontsIadditionalDep :: (Seq Edge)
                         _nontsIaranges :: (Seq (Int,Int,Int))
                         _nontsIaroundDep :: (Seq Edge)
                         _nontsIcNonterminals :: CNonterminals
                         _nontsIdirectDep :: (Seq Edge)
                         _nontsIerrors :: (Seq Error)
                         _nontsIinstDep :: (Seq Edge)
                         _nontsImergeDep :: (Seq Edge)
                         _nontsInAutoRules :: Int
                         _nontsInExplicitRules :: Int
                         _nontsInonts :: ([(NontermIdent,[ConstructorIdent])])
                         _nontsIntattrs :: (Seq (Vertex,NTAttr))
                         _nontsIrules :: (Seq (Vertex,CRule))
                         _nontsIvcount :: Int
                         -- "Order.ag"(line 123, column 17)
                         _o_dovisit =
                             ({-# LINE 123 "Order.ag" #-}
                              visit     _lhsIoptions && null _cyclesErrors
                              {-# LINE 1087 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_cata =
                             ({-# LINE 124 "Order.ag" #-}
                              folds     _lhsIoptions
                              {-# LINE 1093 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_data =
                             ({-# LINE 125 "Order.ag" #-}
                              dataTypes _lhsIoptions
                              {-# LINE 1099 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_sig =
                             ({-# LINE 126 "Order.ag" #-}
                              typeSigs  _lhsIoptions
                              {-# LINE 1105 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_sem =
                             ({-# LINE 127 "Order.ag" #-}
                              semfuns   _lhsIoptions
                              {-# LINE 1111 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_rename =
                             ({-# LINE 128 "Order.ag" #-}
                              rename    _lhsIoptions
                              {-# LINE 1117 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_newtypes =
                             ({-# LINE 129 "Order.ag" #-}
                              newtypes  _lhsIoptions
                              {-# LINE 1123 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_wantvisit =
                             ({-# LINE 130 "Order.ag" #-}
                              visit   _lhsIoptions
                              {-# LINE 1129 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_unbox =
                             ({-# LINE 131 "Order.ag" #-}
                              unbox     _lhsIoptions
                              {-# LINE 1135 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOo_case =
                             ({-# LINE 132 "Order.ag" #-}
                              cases     _lhsIoptions
                              {-# LINE 1141 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 124, column 17)
                         _nontsOprefix =
                             ({-# LINE 133 "Order.ag" #-}
                              prefix    _lhsIoptions
                              {-# LINE 1147 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 261, column 15)
                         _nontsOvcount =
                             ({-# LINE 261 "Order.ag" #-}
                              0
                              {-# LINE 1153 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 287, column 7)
                         _nontsOmanualAttrDepMap =
                             ({-# LINE 287 "Order.ag" #-}
                              manualAttrOrderMap_
                              {-# LINE 1159 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 416, column 14)
                         _nontsOaroundMap =
                             ({-# LINE 416 "Order.ag" #-}
                              aroundsMap_
                              {-# LINE 1165 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 503, column 13)
                         _nontsOacount =
                             ({-# LINE 503 "Order.ag" #-}
                              0
                              {-# LINE 1171 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 541, column 13)
                         _ruleTable =
                             ({-# LINE 541 "Order.ag" #-}
                              Array.array (0,_nontsIvcount-1) (toList _nontsIrules)
                              {-# LINE 1177 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 542, column 13)
                         _attrTable =
                             ({-# LINE 542 "Order.ag" #-}
                              Array.array (0,_nontsIacount-1) (toList _nontsIntattrs)
                              {-# LINE 1183 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 543, column 13)
                         _attrVertex =
                             ({-# LINE 543 "Order.ag" #-}
                              Map.fromList (map swap (toList _nontsIntattrs))
                              {-# LINE 1189 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 544, column 13)
                         _tdpToTds =
                             ({-# LINE 544 "Order.ag" #-}
                              [ (s, maybe (-1) (\v -> findWithErr1 "Grammar.tdpToTds" v _attrVertex) (ntattr cr))
                              | (s,cr) <- toList _nontsIrules]
                              {-# LINE 1196 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 546, column 13)
                         _tdsToTdp =
                             ({-# LINE 546 "Order.ag" #-}
                              let  eq (_,v) (_,v') = v == v'
                                   conv ((s,v):svs)  | v == -1 = Nothing
                                                     | otherwise = Just (v,s:map fst svs)
                              in mapMaybe conv (eqClasses eq _tdpToTds)
                              {-# LINE 1205 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 550, column 13)
                         _directDep =
                             ({-# LINE 550 "Order.ag" #-}
                              toList (_nontsIdirectDep Seq.>< _nontsIadditionalDep)
                              {-# LINE 1211 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 551, column 13)
                         _instDep =
                             ({-# LINE 551 "Order.ag" #-}
                              toList _nontsIinstDep
                              {-# LINE 1217 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 552, column 13)
                         _aroundDep =
                             ({-# LINE 552 "Order.ag" #-}
                              toList _nontsIaroundDep
                              {-# LINE 1223 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 553, column 13)
                         _mergeDep =
                             ({-# LINE 553 "Order.ag" #-}
                              toList _nontsImergeDep
                              {-# LINE 1229 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 554, column 13)
                         _info =
                             ({-# LINE 554 "Order.ag" #-}
                              let def [] = -1
                                  def (v:vs) = v
                               in Info { tdsToTdp   = Array.array (0,_nontsIacount-1) _tdsToTdp
                                       , tdpToTds   = Array.array (0,_nontsIvcount-1) _tdpToTds
                                       , attrTable  = _attrTable
                                       , ruleTable  = _ruleTable
                                       , lmh        = toList _nontsIaranges
                                       , nonts      = _nontsInonts
                                       , wraps      = wrappers_
                                       }
                              {-# LINE 1244 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 565, column 17)
                         __tup2 =
                             ({-# LINE 565 "Order.ag" #-}
                              case computeSequential _info _directDep (_instDep ++ _aroundDep ++ _mergeDep    ) of
                                           CycleFree    cim cvm   -> ( cim
                                                                     , cvm
                                                                     , []
                                                                     )
                                           LocalCycle   errs      -> ( error "No interfaces for AG with local cycles"
                                                                     , error "No visit sub-sequences for AG with local cycles"
                                                                     , map (localCycleErr _ruleTable (visit _lhsIoptions)) errs
                                                                     )
                                           InstCycle    errs      -> ( error "No interfaces for AG with cycles through insts"
                                                                     , error "No visit sub-sequences for AG with cycles through insts"
                                                                     , map (instCycleErr _ruleTable (visit _lhsIoptions)) errs
                                                                     )
                                           DirectCycle  errs      -> ( error "No interfaces for AG with direct cycles"
                                                                     , error "No visit sub-sequences for AG with direct cycles"
                                                                     , directCycleErrs _attrTable _ruleTable (visit _lhsIoptions) errs
                                                                     )
                                           InducedCycle cim errs ->  ( cim
                                                                     , error "No visit sub-sequences for AG with induced cycles"
                                                                     , inducedCycleErrs _attrTable _ruleTable cim errs
                                                                     )
                              {-# LINE 1270 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 565, column 17)
                         (_cInterfaceMap,_,_) =
                             ({-# LINE 565 "Order.ag" #-}
                              __tup2
                              {-# LINE 1276 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 565, column 17)
                         (_,_cVisitsMap,_) =
                             ({-# LINE 565 "Order.ag" #-}
                              __tup2
                              {-# LINE 1282 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 565, column 17)
                         (_,_,_cyclesErrors) =
                             ({-# LINE 565 "Order.ag" #-}
                              __tup2
                              {-# LINE 1288 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 587, column 13)
                         _lhsOerrors =
                             ({-# LINE 587 "Order.ag" #-}
                              (if withCycle _lhsIoptions then Seq.fromList _cyclesErrors else Seq.empty)
                              Seq.>< _nontsIerrors
                              {-# LINE 1295 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 619, column 15)
                         _lhsOoutput =
                             ({-# LINE 619 "Order.ag" #-}
                              CGrammar typeSyns_ derivings_ wrappers_ _nontsIcNonterminals pragmas_ paramMap_ contextMap_ _aroundMap     _mergeMap     _o_dovisit
                              {-# LINE 1301 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 632, column 14)
                         _aroundMap =
                             ({-# LINE 632 "Order.ag" #-}
                              Map.map (Map.map Map.keysSet) aroundsMap_
                              {-# LINE 1307 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 633, column 14)
                         _mergeMap =
                             ({-# LINE 633 "Order.ag" #-}
                              Map.map (Map.map (Map.map (\(nt,srcs,_) -> (nt,srcs)))) mergeMap_
                              {-# LINE 1313 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 650, column 13)
                         _nontsOallnts =
                             ({-# LINE 650 "Order.ag" #-}
                              map fst (_nontsInonts)
                              {-# LINE 1319 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 61, column 105)
                         _lhsOnAutoRules =
                             ({-# LINE 61 "Order.ag" #-}
                              _nontsInAutoRules
                              {-# LINE 1325 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 61, column 105)
                         _lhsOnExplicitRules =
                             ({-# LINE 61 "Order.ag" #-}
                              _nontsInExplicitRules
                              {-# LINE 1331 "Order.hs" #-}
                              )
                         -- copy rule (from local)
                         _nontsOcInterfaceMap =
                             ({-# LINE 594 "Order.ag" #-}
                              _cInterfaceMap
                              {-# LINE 1337 "Order.hs" #-}
                              )
                         -- copy rule (from local)
                         _nontsOcVisitsMap =
                             ({-# LINE 601 "Order.ag" #-}
                              _cVisitsMap
                              {-# LINE 1343 "Order.hs" #-}
                              )
                         -- copy rule (from local)
                         _nontsOmergeMap =
                             ({-# LINE 354 "Order.ag" #-}
                              _mergeMap
                              {-# LINE 1349 "Order.hs" #-}
                              )
                         -- copy rule (from local)
                         _nontsOo_dovisit =
                             ({-# LINE 116 "Order.ag" #-}
                              _o_dovisit
                              {-# LINE 1355 "Order.hs" #-}
                              )
                         ( _nontsIacount,_nontsIadditionalDep,_nontsIaranges,_nontsIaroundDep,_nontsIcNonterminals,_nontsIdirectDep,_nontsIerrors,_nontsIinstDep,_nontsImergeDep,_nontsInAutoRules,_nontsInExplicitRules,_nontsInonts,_nontsIntattrs,_nontsIrules,_nontsIvcount) =
                             nonts_ _nontsOacount _nontsOallnts _nontsOaroundMap _nontsOcInterfaceMap _nontsOcVisitsMap _nontsOmanualAttrDepMap _nontsOmergeMap _nontsOo_case _nontsOo_cata _nontsOo_data _nontsOo_dovisit _nontsOo_newtypes _nontsOo_rename _nontsOo_sem _nontsOo_sig _nontsOo_unbox _nontsOo_wantvisit _nontsOprefix _nontsOvcount 
                     in  ( _lhsOerrors,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOoutput))) )
-- Nonterminal -------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allnts               : [Identifier]
         aroundMap            : Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))
         cInterfaceMap        : CInterfaceMap
         cVisitsMap           : CVisitsMap
         manualAttrDepMap     : AttrOrderMap
         mergeMap             : Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))
         o_case               : Bool
         o_cata               : Bool
         o_data               : Bool
         o_dovisit            : Bool
         o_newtypes           : Bool
         o_rename             : Bool
         o_sem                : Bool
         o_sig                : Bool
         o_unbox              : Bool
         o_wantvisit          : Bool
         prefix               : String
      chained attributes:
         acount               : Int
         vcount               : Int
      synthesized attributes:
         additionalDep        : Seq Edge
         aranges              : Seq (Int,Int,Int)
         aroundDep            : Seq Edge
         cNonterminal         : CNonterminal
         directDep            : Seq Edge
         errors               : Seq Error
         instDep              : Seq Edge
         mergeDep             : Seq Edge
         nAutoRules           : Int
         nExplicitRules       : Int
         nonts                : [(NontermIdent,[ConstructorIdent])]
         ntattrs              : Seq (Vertex,NTAttr)
         rules                : Seq (Vertex,CRule)
   alternatives:
      alternative Nonterminal:
         child nt             : {NontermIdent}
         child params         : {[Identifier]}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child prods          : Productions 
         visit 0:
            local mergeMap    : _
            local aroundMap   : _
            local ntattrs     : _
            local cInter      : _
-}
-- cata
sem_Nonterminal :: Nonterminal  ->
                   T_Nonterminal 
sem_Nonterminal (Nonterminal _nt _params _inh _syn _prods )  =
    (sem_Nonterminal_Nonterminal _nt _params _inh _syn (sem_Productions _prods ) )
-- semantic domain
newtype T_Nonterminal  = T_Nonterminal (Int ->
                                        ([Identifier]) ->
                                        (Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))) ->
                                        CInterfaceMap ->
                                        CVisitsMap ->
                                        AttrOrderMap ->
                                        (Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))) ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        String ->
                                        Int ->
                                        ( Int,(Seq Edge),(Seq (Int,Int,Int)),(Seq Edge),CNonterminal,(Seq Edge),(Seq Error),(Seq Edge),(Seq Edge),Int,Int,([(NontermIdent,[ConstructorIdent])]),(Seq (Vertex,NTAttr)),(Seq (Vertex,CRule)),Int))
data Inh_Nonterminal  = Inh_Nonterminal {acount_Inh_Nonterminal :: !(Int),allnts_Inh_Nonterminal :: !(([Identifier])),aroundMap_Inh_Nonterminal :: !((Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression])))),cInterfaceMap_Inh_Nonterminal :: !(CInterfaceMap),cVisitsMap_Inh_Nonterminal :: !(CVisitsMap),manualAttrDepMap_Inh_Nonterminal :: !(AttrOrderMap),mergeMap_Inh_Nonterminal :: !((Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))))),o_case_Inh_Nonterminal :: !(Bool),o_cata_Inh_Nonterminal :: !(Bool),o_data_Inh_Nonterminal :: !(Bool),o_dovisit_Inh_Nonterminal :: !(Bool),o_newtypes_Inh_Nonterminal :: !(Bool),o_rename_Inh_Nonterminal :: !(Bool),o_sem_Inh_Nonterminal :: !(Bool),o_sig_Inh_Nonterminal :: !(Bool),o_unbox_Inh_Nonterminal :: !(Bool),o_wantvisit_Inh_Nonterminal :: !(Bool),prefix_Inh_Nonterminal :: !(String),vcount_Inh_Nonterminal :: !(Int)}
data Syn_Nonterminal  = Syn_Nonterminal {acount_Syn_Nonterminal :: !(Int),additionalDep_Syn_Nonterminal :: !((Seq Edge)),aranges_Syn_Nonterminal :: !((Seq (Int,Int,Int))),aroundDep_Syn_Nonterminal :: !((Seq Edge)),cNonterminal_Syn_Nonterminal :: !(CNonterminal),directDep_Syn_Nonterminal :: !((Seq Edge)),errors_Syn_Nonterminal :: !((Seq Error)),instDep_Syn_Nonterminal :: !((Seq Edge)),mergeDep_Syn_Nonterminal :: !((Seq Edge)),nAutoRules_Syn_Nonterminal :: !(Int),nExplicitRules_Syn_Nonterminal :: !(Int),nonts_Syn_Nonterminal :: !(([(NontermIdent,[ConstructorIdent])])),ntattrs_Syn_Nonterminal :: !((Seq (Vertex,NTAttr))),rules_Syn_Nonterminal :: !((Seq (Vertex,CRule))),vcount_Syn_Nonterminal :: !(Int)}
wrap_Nonterminal :: T_Nonterminal  ->
                    Inh_Nonterminal  ->
                    Syn_Nonterminal 
wrap_Nonterminal (T_Nonterminal sem ) (Inh_Nonterminal _lhsIacount _lhsIallnts _lhsIaroundMap _lhsIcInterfaceMap _lhsIcVisitsMap _lhsImanualAttrDepMap _lhsImergeMap _lhsIo_case _lhsIo_cata _lhsIo_data _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIvcount )  =
    (let ( _lhsOacount,_lhsOadditionalDep,_lhsOaranges,_lhsOaroundDep,_lhsOcNonterminal,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOnonts,_lhsOntattrs,_lhsOrules,_lhsOvcount) = sem _lhsIacount _lhsIallnts _lhsIaroundMap _lhsIcInterfaceMap _lhsIcVisitsMap _lhsImanualAttrDepMap _lhsImergeMap _lhsIo_case _lhsIo_cata _lhsIo_data _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIvcount 
     in  (Syn_Nonterminal _lhsOacount _lhsOadditionalDep _lhsOaranges _lhsOaroundDep _lhsOcNonterminal _lhsOdirectDep _lhsOerrors _lhsOinstDep _lhsOmergeDep _lhsOnAutoRules _lhsOnExplicitRules _lhsOnonts _lhsOntattrs _lhsOrules _lhsOvcount ))
sem_Nonterminal_Nonterminal :: NontermIdent ->
                               ([Identifier]) ->
                               Attributes ->
                               Attributes ->
                               T_Productions  ->
                               T_Nonterminal 
sem_Nonterminal_Nonterminal nt_ params_ inh_ syn_ (T_Productions prods_ )  =
    (T_Nonterminal (\ _lhsIacount
                      _lhsIallnts
                      _lhsIaroundMap
                      _lhsIcInterfaceMap
                      _lhsIcVisitsMap
                      _lhsImanualAttrDepMap
                      _lhsImergeMap
                      _lhsIo_case
                      _lhsIo_cata
                      _lhsIo_data
                      _lhsIo_dovisit
                      _lhsIo_newtypes
                      _lhsIo_rename
                      _lhsIo_sem
                      _lhsIo_sig
                      _lhsIo_unbox
                      _lhsIo_wantvisit
                      _lhsIprefix
                      _lhsIvcount ->
                        (let _prodsOnt :: Identifier
                             _prodsOinh :: Attributes
                             _prodsOsyn :: Attributes
                             _lhsOntattrs :: (Seq (Vertex,NTAttr))
                             _lhsOacount :: Int
                             _lhsOaranges :: (Seq (Int,Int,Int))
                             _lhsOnonts :: ([(NontermIdent,[ConstructorIdent])])
                             _lhsOcNonterminal :: CNonterminal
                             _lhsOadditionalDep :: (Seq Edge)
                             _lhsOaroundDep :: (Seq Edge)
                             _lhsOdirectDep :: (Seq Edge)
                             _lhsOerrors :: (Seq Error)
                             _lhsOinstDep :: (Seq Edge)
                             _lhsOmergeDep :: (Seq Edge)
                             _lhsOnAutoRules :: Int
                             _lhsOnExplicitRules :: Int
                             _lhsOrules :: (Seq (Vertex,CRule))
                             _lhsOvcount :: Int
                             _prodsOallnts :: ([Identifier])
                             _prodsOaroundMap :: (Map ConstructorIdent (Map Identifier [Expression]))
                             _prodsOcVisitsMap :: CVisitsMap
                             _prodsOmanualAttrDepMap :: AttrOrderMap
                             _prodsOmergeMap :: (Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))
                             _prodsOo_case :: Bool
                             _prodsOo_cata :: Bool
                             _prodsOo_dovisit :: Bool
                             _prodsOo_newtypes :: Bool
                             _prodsOo_rename :: Bool
                             _prodsOo_sem :: Bool
                             _prodsOo_sig :: Bool
                             _prodsOo_unbox :: Bool
                             _prodsOo_wantvisit :: Bool
                             _prodsOprefix :: String
                             _prodsOvcount :: Int
                             _prodsIadditionalDep :: (Seq Edge)
                             _prodsIaroundDep :: (Seq Edge)
                             _prodsIcProductions :: CProductions
                             _prodsIcons :: ([ConstructorIdent])
                             _prodsIdirectDep :: (Seq Edge)
                             _prodsIerrors :: (Seq Error)
                             _prodsIinstDep :: (Seq Edge)
                             _prodsImergeDep :: (Seq Edge)
                             _prodsInAutoRules :: Int
                             _prodsInExplicitRules :: Int
                             _prodsIrules :: (Seq (Vertex,CRule))
                             _prodsIvcount :: Int
                             -- "Order.ag"(line 97, column 17)
                             _prodsOnt =
                                 ({-# LINE 97 "Order.ag" #-}
                                  nt_
                                  {-# LINE 1521 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 100, column 17)
                             _prodsOinh =
                                 ({-# LINE 100 "Order.ag" #-}
                                  inh_
                                  {-# LINE 1527 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 101, column 17)
                             _prodsOsyn =
                                 ({-# LINE 101 "Order.ag" #-}
                                  syn_
                                  {-# LINE 1533 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 359, column 32)
                             _mergeMap =
                                 ({-# LINE 359 "Order.ag" #-}
                                  Map.findWithDefault Map.empty nt_ _lhsImergeMap
                                  {-# LINE 1539 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 412, column 32)
                             _aroundMap =
                                 ({-# LINE 412 "Order.ag" #-}
                                  Map.findWithDefault Map.empty nt_ _lhsIaroundMap
                                  {-# LINE 1545 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 506, column 17)
                             _ntattrs =
                                 ({-# LINE 506 "Order.ag" #-}
                                  [ NTAInh nt_ inh tp | (inh,tp) <- Map.assocs inh_ ]
                                  ++ [NTASyn nt_ syn tp | (syn,tp) <- Map.assocs syn_ ]
                                  {-# LINE 1552 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 508, column 17)
                             _lhsOntattrs =
                                 ({-# LINE 508 "Order.ag" #-}
                                  Seq.fromList (zip [_lhsIacount ..] _ntattrs)
                                  {-# LINE 1558 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 509, column 17)
                             _lhsOacount =
                                 ({-# LINE 509 "Order.ag" #-}
                                  _lhsIacount + Map.size inh_ + Map.size syn_
                                  {-# LINE 1564 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 510, column 17)
                             _lhsOaranges =
                                 ({-# LINE 510 "Order.ag" #-}
                                  Seq.singleton
                                   (_lhsIacount
                                   ,_lhsIacount + Map.size inh_
                                   ,_lhsIacount + Map.size syn_ + Map.size inh_ - 1)
                                  {-# LINE 1573 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 519, column 19)
                             _lhsOnonts =
                                 ({-# LINE 519 "Order.ag" #-}
                                  [(nt_,_prodsIcons)]
                                  {-# LINE 1579 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 596, column 19)
                             _cInter =
                                 ({-# LINE 596 "Order.ag" #-}
                                  if  _lhsIo_dovisit
                                         then findWithErr1 "Nonterminal.cInter" nt_ _lhsIcInterfaceMap
                                         else CInterface [CSegment inh_ syn_]
                                  {-# LINE 1587 "Order.hs" #-}
                                  )
                             -- "Order.ag"(line 624, column 19)
                             _lhsOcNonterminal =
                                 ({-# LINE 624 "Order.ag" #-}
                                  CNonterminal nt_ params_ inh_ syn_ _prodsIcProductions _cInter
                                  {-# LINE 1593 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 283, column 60)
                             _lhsOadditionalDep =
                                 ({-# LINE 283 "Order.ag" #-}
                                  _prodsIadditionalDep
                                  {-# LINE 1599 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 404, column 24)
                             _lhsOaroundDep =
                                 ({-# LINE 404 "Order.ag" #-}
                                  _prodsIaroundDep
                                  {-# LINE 1605 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 269, column 33)
                             _lhsOdirectDep =
                                 ({-# LINE 269 "Order.ag" #-}
                                  _prodsIdirectDep
                                  {-# LINE 1611 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 84, column 70)
                             _lhsOerrors =
                                 ({-# LINE 84 "Order.ag" #-}
                                  _prodsIerrors
                                  {-# LINE 1617 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 312, column 31)
                             _lhsOinstDep =
                                 ({-# LINE 312 "Order.ag" #-}
                                  _prodsIinstDep
                                  {-# LINE 1623 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 367, column 18)
                             _lhsOmergeDep =
                                 ({-# LINE 367 "Order.ag" #-}
                                  _prodsImergeDep
                                  {-# LINE 1629 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 61, column 105)
                             _lhsOnAutoRules =
                                 ({-# LINE 61 "Order.ag" #-}
                                  _prodsInAutoRules
                                  {-# LINE 1635 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 61, column 105)
                             _lhsOnExplicitRules =
                                 ({-# LINE 61 "Order.ag" #-}
                                  _prodsInExplicitRules
                                  {-# LINE 1641 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 259, column 18)
                             _lhsOrules =
                                 ({-# LINE 259 "Order.ag" #-}
                                  _prodsIrules
                                  {-# LINE 1647 "Order.hs" #-}
                                  )
                             -- copy rule (up)
                             _lhsOvcount =
                                 ({-# LINE 258 "Order.ag" #-}
                                  _prodsIvcount
                                  {-# LINE 1653 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOallnts =
                                 ({-# LINE 647 "Order.ag" #-}
                                  _lhsIallnts
                                  {-# LINE 1659 "Order.hs" #-}
                                  )
                             -- copy rule (from local)
                             _prodsOaroundMap =
                                 ({-# LINE 410 "Order.ag" #-}
                                  _aroundMap
                                  {-# LINE 1665 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOcVisitsMap =
                                 ({-# LINE 601 "Order.ag" #-}
                                  _lhsIcVisitsMap
                                  {-# LINE 1671 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOmanualAttrDepMap =
                                 ({-# LINE 283 "Order.ag" #-}
                                  _lhsImanualAttrDepMap
                                  {-# LINE 1677 "Order.hs" #-}
                                  )
                             -- copy rule (from local)
                             _prodsOmergeMap =
                                 ({-# LINE 357 "Order.ag" #-}
                                  _mergeMap
                                  {-# LINE 1683 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_case =
                                 ({-# LINE 117 "Order.ag" #-}
                                  _lhsIo_case
                                  {-# LINE 1689 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_cata =
                                 ({-# LINE 111 "Order.ag" #-}
                                  _lhsIo_cata
                                  {-# LINE 1695 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_dovisit =
                                 ({-# LINE 116 "Order.ag" #-}
                                  _lhsIo_dovisit
                                  {-# LINE 1701 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_newtypes =
                                 ({-# LINE 110 "Order.ag" #-}
                                  _lhsIo_newtypes
                                  {-# LINE 1707 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_rename =
                                 ({-# LINE 114 "Order.ag" #-}
                                  _lhsIo_rename
                                  {-# LINE 1713 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_sem =
                                 ({-# LINE 113 "Order.ag" #-}
                                  _lhsIo_sem
                                  {-# LINE 1719 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_sig =
                                 ({-# LINE 112 "Order.ag" #-}
                                  _lhsIo_sig
                                  {-# LINE 1725 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_unbox =
                                 ({-# LINE 119 "Order.ag" #-}
                                  _lhsIo_unbox
                                  {-# LINE 1731 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOo_wantvisit =
                                 ({-# LINE 115 "Order.ag" #-}
                                  _lhsIo_wantvisit
                                  {-# LINE 1737 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOprefix =
                                 ({-# LINE 118 "Order.ag" #-}
                                  _lhsIprefix
                                  {-# LINE 1743 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _prodsOvcount =
                                 ({-# LINE 258 "Order.ag" #-}
                                  _lhsIvcount
                                  {-# LINE 1749 "Order.hs" #-}
                                  )
                             ( _prodsIadditionalDep,_prodsIaroundDep,_prodsIcProductions,_prodsIcons,_prodsIdirectDep,_prodsIerrors,_prodsIinstDep,_prodsImergeDep,_prodsInAutoRules,_prodsInExplicitRules,_prodsIrules,_prodsIvcount) =
                                 prods_ _prodsOallnts _prodsOaroundMap _prodsOcVisitsMap _prodsOinh _prodsOmanualAttrDepMap _prodsOmergeMap _prodsOnt _prodsOo_case _prodsOo_cata _prodsOo_dovisit _prodsOo_newtypes _prodsOo_rename _prodsOo_sem _prodsOo_sig _prodsOo_unbox _prodsOo_wantvisit _prodsOprefix _prodsOsyn _prodsOvcount 
                         in  ( _lhsOacount,_lhsOadditionalDep,_lhsOaranges,_lhsOaroundDep,_lhsOcNonterminal,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOnonts,_lhsOntattrs,_lhsOrules,_lhsOvcount))) )
-- Nonterminals ------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allnts               : [Identifier]
         aroundMap            : Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))
         cInterfaceMap        : CInterfaceMap
         cVisitsMap           : CVisitsMap
         manualAttrDepMap     : AttrOrderMap
         mergeMap             : Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))
         o_case               : Bool
         o_cata               : Bool
         o_data               : Bool
         o_dovisit            : Bool
         o_newtypes           : Bool
         o_rename             : Bool
         o_sem                : Bool
         o_sig                : Bool
         o_unbox              : Bool
         o_wantvisit          : Bool
         prefix               : String
      chained attributes:
         acount               : Int
         vcount               : Int
      synthesized attributes:
         additionalDep        : Seq Edge
         aranges              : Seq (Int,Int,Int)
         aroundDep            : Seq Edge
         cNonterminals        : CNonterminals
         directDep            : Seq Edge
         errors               : Seq Error
         instDep              : Seq Edge
         mergeDep             : Seq Edge
         nAutoRules           : Int
         nExplicitRules       : Int
         nonts                : [(NontermIdent,[ConstructorIdent])]
         ntattrs              : Seq (Vertex,NTAttr)
         rules                : Seq (Vertex,CRule)
   alternatives:
      alternative Cons:
         child hd             : Nonterminal 
         child tl             : Nonterminals 
      alternative Nil:
-}
-- cata
sem_Nonterminals :: Nonterminals  ->
                    T_Nonterminals 
sem_Nonterminals list  =
    (Prelude.foldr sem_Nonterminals_Cons sem_Nonterminals_Nil (Prelude.map sem_Nonterminal list) )
-- semantic domain
newtype T_Nonterminals  = T_Nonterminals (Int ->
                                          ([Identifier]) ->
                                          (Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))) ->
                                          CInterfaceMap ->
                                          CVisitsMap ->
                                          AttrOrderMap ->
                                          (Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))) ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          Bool ->
                                          String ->
                                          Int ->
                                          ( Int,(Seq Edge),(Seq (Int,Int,Int)),(Seq Edge),CNonterminals,(Seq Edge),(Seq Error),(Seq Edge),(Seq Edge),Int,Int,([(NontermIdent,[ConstructorIdent])]),(Seq (Vertex,NTAttr)),(Seq (Vertex,CRule)),Int))
data Inh_Nonterminals  = Inh_Nonterminals {acount_Inh_Nonterminals :: !(Int),allnts_Inh_Nonterminals :: !(([Identifier])),aroundMap_Inh_Nonterminals :: !((Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression])))),cInterfaceMap_Inh_Nonterminals :: !(CInterfaceMap),cVisitsMap_Inh_Nonterminals :: !(CVisitsMap),manualAttrDepMap_Inh_Nonterminals :: !(AttrOrderMap),mergeMap_Inh_Nonterminals :: !((Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))))),o_case_Inh_Nonterminals :: !(Bool),o_cata_Inh_Nonterminals :: !(Bool),o_data_Inh_Nonterminals :: !(Bool),o_dovisit_Inh_Nonterminals :: !(Bool),o_newtypes_Inh_Nonterminals :: !(Bool),o_rename_Inh_Nonterminals :: !(Bool),o_sem_Inh_Nonterminals :: !(Bool),o_sig_Inh_Nonterminals :: !(Bool),o_unbox_Inh_Nonterminals :: !(Bool),o_wantvisit_Inh_Nonterminals :: !(Bool),prefix_Inh_Nonterminals :: !(String),vcount_Inh_Nonterminals :: !(Int)}
data Syn_Nonterminals  = Syn_Nonterminals {acount_Syn_Nonterminals :: !(Int),additionalDep_Syn_Nonterminals :: !((Seq Edge)),aranges_Syn_Nonterminals :: !((Seq (Int,Int,Int))),aroundDep_Syn_Nonterminals :: !((Seq Edge)),cNonterminals_Syn_Nonterminals :: !(CNonterminals),directDep_Syn_Nonterminals :: !((Seq Edge)),errors_Syn_Nonterminals :: !((Seq Error)),instDep_Syn_Nonterminals :: !((Seq Edge)),mergeDep_Syn_Nonterminals :: !((Seq Edge)),nAutoRules_Syn_Nonterminals :: !(Int),nExplicitRules_Syn_Nonterminals :: !(Int),nonts_Syn_Nonterminals :: !(([(NontermIdent,[ConstructorIdent])])),ntattrs_Syn_Nonterminals :: !((Seq (Vertex,NTAttr))),rules_Syn_Nonterminals :: !((Seq (Vertex,CRule))),vcount_Syn_Nonterminals :: !(Int)}
wrap_Nonterminals :: T_Nonterminals  ->
                     Inh_Nonterminals  ->
                     Syn_Nonterminals 
wrap_Nonterminals (T_Nonterminals sem ) (Inh_Nonterminals _lhsIacount _lhsIallnts _lhsIaroundMap _lhsIcInterfaceMap _lhsIcVisitsMap _lhsImanualAttrDepMap _lhsImergeMap _lhsIo_case _lhsIo_cata _lhsIo_data _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIvcount )  =
    (let ( _lhsOacount,_lhsOadditionalDep,_lhsOaranges,_lhsOaroundDep,_lhsOcNonterminals,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOnonts,_lhsOntattrs,_lhsOrules,_lhsOvcount) = sem _lhsIacount _lhsIallnts _lhsIaroundMap _lhsIcInterfaceMap _lhsIcVisitsMap _lhsImanualAttrDepMap _lhsImergeMap _lhsIo_case _lhsIo_cata _lhsIo_data _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIvcount 
     in  (Syn_Nonterminals _lhsOacount _lhsOadditionalDep _lhsOaranges _lhsOaroundDep _lhsOcNonterminals _lhsOdirectDep _lhsOerrors _lhsOinstDep _lhsOmergeDep _lhsOnAutoRules _lhsOnExplicitRules _lhsOnonts _lhsOntattrs _lhsOrules _lhsOvcount ))
sem_Nonterminals_Cons :: T_Nonterminal  ->
                         T_Nonterminals  ->
                         T_Nonterminals 
sem_Nonterminals_Cons (T_Nonterminal hd_ ) (T_Nonterminals tl_ )  =
    (T_Nonterminals (\ _lhsIacount
                       _lhsIallnts
                       _lhsIaroundMap
                       _lhsIcInterfaceMap
                       _lhsIcVisitsMap
                       _lhsImanualAttrDepMap
                       _lhsImergeMap
                       _lhsIo_case
                       _lhsIo_cata
                       _lhsIo_data
                       _lhsIo_dovisit
                       _lhsIo_newtypes
                       _lhsIo_rename
                       _lhsIo_sem
                       _lhsIo_sig
                       _lhsIo_unbox
                       _lhsIo_wantvisit
                       _lhsIprefix
                       _lhsIvcount ->
                         (let _lhsOcNonterminals :: CNonterminals
                              _lhsOadditionalDep :: (Seq Edge)
                              _lhsOaranges :: (Seq (Int,Int,Int))
                              _lhsOaroundDep :: (Seq Edge)
                              _lhsOdirectDep :: (Seq Edge)
                              _lhsOerrors :: (Seq Error)
                              _lhsOinstDep :: (Seq Edge)
                              _lhsOmergeDep :: (Seq Edge)
                              _lhsOnAutoRules :: Int
                              _lhsOnExplicitRules :: Int
                              _lhsOnonts :: ([(NontermIdent,[ConstructorIdent])])
                              _lhsOntattrs :: (Seq (Vertex,NTAttr))
                              _lhsOrules :: (Seq (Vertex,CRule))
                              _lhsOacount :: Int
                              _lhsOvcount :: Int
                              _hdOacount :: Int
                              _hdOallnts :: ([Identifier])
                              _hdOaroundMap :: (Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression])))
                              _hdOcInterfaceMap :: CInterfaceMap
                              _hdOcVisitsMap :: CVisitsMap
                              _hdOmanualAttrDepMap :: AttrOrderMap
                              _hdOmergeMap :: (Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))))
                              _hdOo_case :: Bool
                              _hdOo_cata :: Bool
                              _hdOo_data :: Bool
                              _hdOo_dovisit :: Bool
                              _hdOo_newtypes :: Bool
                              _hdOo_rename :: Bool
                              _hdOo_sem :: Bool
                              _hdOo_sig :: Bool
                              _hdOo_unbox :: Bool
                              _hdOo_wantvisit :: Bool
                              _hdOprefix :: String
                              _hdOvcount :: Int
                              _tlOacount :: Int
                              _tlOallnts :: ([Identifier])
                              _tlOaroundMap :: (Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression])))
                              _tlOcInterfaceMap :: CInterfaceMap
                              _tlOcVisitsMap :: CVisitsMap
                              _tlOmanualAttrDepMap :: AttrOrderMap
                              _tlOmergeMap :: (Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))))
                              _tlOo_case :: Bool
                              _tlOo_cata :: Bool
                              _tlOo_data :: Bool
                              _tlOo_dovisit :: Bool
                              _tlOo_newtypes :: Bool
                              _tlOo_rename :: Bool
                              _tlOo_sem :: Bool
                              _tlOo_sig :: Bool
                              _tlOo_unbox :: Bool
                              _tlOo_wantvisit :: Bool
                              _tlOprefix :: String
                              _tlOvcount :: Int
                              _hdIacount :: Int
                              _hdIadditionalDep :: (Seq Edge)
                              _hdIaranges :: (Seq (Int,Int,Int))
                              _hdIaroundDep :: (Seq Edge)
                              _hdIcNonterminal :: CNonterminal
                              _hdIdirectDep :: (Seq Edge)
                              _hdIerrors :: (Seq Error)
                              _hdIinstDep :: (Seq Edge)
                              _hdImergeDep :: (Seq Edge)
                              _hdInAutoRules :: Int
                              _hdInExplicitRules :: Int
                              _hdInonts :: ([(NontermIdent,[ConstructorIdent])])
                              _hdIntattrs :: (Seq (Vertex,NTAttr))
                              _hdIrules :: (Seq (Vertex,CRule))
                              _hdIvcount :: Int
                              _tlIacount :: Int
                              _tlIadditionalDep :: (Seq Edge)
                              _tlIaranges :: (Seq (Int,Int,Int))
                              _tlIaroundDep :: (Seq Edge)
                              _tlIcNonterminals :: CNonterminals
                              _tlIdirectDep :: (Seq Edge)
                              _tlIerrors :: (Seq Error)
                              _tlIinstDep :: (Seq Edge)
                              _tlImergeDep :: (Seq Edge)
                              _tlInAutoRules :: Int
                              _tlInExplicitRules :: Int
                              _tlInonts :: ([(NontermIdent,[ConstructorIdent])])
                              _tlIntattrs :: (Seq (Vertex,NTAttr))
                              _tlIrules :: (Seq (Vertex,CRule))
                              _tlIvcount :: Int
                              -- "Order.ag"(line 621, column 12)
                              _lhsOcNonterminals =
                                  ({-# LINE 621 "Order.ag" #-}
                                   _hdIcNonterminal : _tlIcNonterminals
                                   {-# LINE 1942 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 283, column 60)
                              _lhsOadditionalDep =
                                  ({-# LINE 283 "Order.ag" #-}
                                   _hdIadditionalDep Seq.>< _tlIadditionalDep
                                   {-# LINE 1948 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 500, column 36)
                              _lhsOaranges =
                                  ({-# LINE 500 "Order.ag" #-}
                                   _hdIaranges Seq.>< _tlIaranges
                                   {-# LINE 1954 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 404, column 24)
                              _lhsOaroundDep =
                                  ({-# LINE 404 "Order.ag" #-}
                                   _hdIaroundDep Seq.>< _tlIaroundDep
                                   {-# LINE 1960 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 269, column 33)
                              _lhsOdirectDep =
                                  ({-# LINE 269 "Order.ag" #-}
                                   _hdIdirectDep Seq.>< _tlIdirectDep
                                   {-# LINE 1966 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 84, column 70)
                              _lhsOerrors =
                                  ({-# LINE 84 "Order.ag" #-}
                                   _hdIerrors Seq.>< _tlIerrors
                                   {-# LINE 1972 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 312, column 31)
                              _lhsOinstDep =
                                  ({-# LINE 312 "Order.ag" #-}
                                   _hdIinstDep Seq.>< _tlIinstDep
                                   {-# LINE 1978 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 367, column 18)
                              _lhsOmergeDep =
                                  ({-# LINE 367 "Order.ag" #-}
                                   _hdImergeDep Seq.>< _tlImergeDep
                                   {-# LINE 1984 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 61, column 105)
                              _lhsOnAutoRules =
                                  ({-# LINE 61 "Order.ag" #-}
                                   _hdInAutoRules + _tlInAutoRules
                                   {-# LINE 1990 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 61, column 105)
                              _lhsOnExplicitRules =
                                  ({-# LINE 61 "Order.ag" #-}
                                   _hdInExplicitRules + _tlInExplicitRules
                                   {-# LINE 1996 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 517, column 43)
                              _lhsOnonts =
                                  ({-# LINE 517 "Order.ag" #-}
                                   _hdInonts ++ _tlInonts
                                   {-# LINE 2002 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 499, column 35)
                              _lhsOntattrs =
                                  ({-# LINE 499 "Order.ag" #-}
                                   _hdIntattrs Seq.>< _tlIntattrs
                                   {-# LINE 2008 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 259, column 18)
                              _lhsOrules =
                                  ({-# LINE 259 "Order.ag" #-}
                                   _hdIrules Seq.>< _tlIrules
                                   {-# LINE 2014 "Order.hs" #-}
                                   )
                              -- copy rule (up)
                              _lhsOacount =
                                  ({-# LINE 499 "Order.ag" #-}
                                   _tlIacount
                                   {-# LINE 2020 "Order.hs" #-}
                                   )
                              -- copy rule (up)
                              _lhsOvcount =
                                  ({-# LINE 258 "Order.ag" #-}
                                   _tlIvcount
                                   {-# LINE 2026 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOacount =
                                  ({-# LINE 499 "Order.ag" #-}
                                   _lhsIacount
                                   {-# LINE 2032 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOallnts =
                                  ({-# LINE 647 "Order.ag" #-}
                                   _lhsIallnts
                                   {-# LINE 2038 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOaroundMap =
                                  ({-# LINE 407 "Order.ag" #-}
                                   _lhsIaroundMap
                                   {-# LINE 2044 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOcInterfaceMap =
                                  ({-# LINE 594 "Order.ag" #-}
                                   _lhsIcInterfaceMap
                                   {-# LINE 2050 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOcVisitsMap =
                                  ({-# LINE 601 "Order.ag" #-}
                                   _lhsIcVisitsMap
                                   {-# LINE 2056 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOmanualAttrDepMap =
                                  ({-# LINE 283 "Order.ag" #-}
                                   _lhsImanualAttrDepMap
                                   {-# LINE 2062 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOmergeMap =
                                  ({-# LINE 354 "Order.ag" #-}
                                   _lhsImergeMap
                                   {-# LINE 2068 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_case =
                                  ({-# LINE 117 "Order.ag" #-}
                                   _lhsIo_case
                                   {-# LINE 2074 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_cata =
                                  ({-# LINE 111 "Order.ag" #-}
                                   _lhsIo_cata
                                   {-# LINE 2080 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_data =
                                  ({-# LINE 120 "Order.ag" #-}
                                   _lhsIo_data
                                   {-# LINE 2086 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_dovisit =
                                  ({-# LINE 116 "Order.ag" #-}
                                   _lhsIo_dovisit
                                   {-# LINE 2092 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_newtypes =
                                  ({-# LINE 110 "Order.ag" #-}
                                   _lhsIo_newtypes
                                   {-# LINE 2098 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_rename =
                                  ({-# LINE 114 "Order.ag" #-}
                                   _lhsIo_rename
                                   {-# LINE 2104 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_sem =
                                  ({-# LINE 113 "Order.ag" #-}
                                   _lhsIo_sem
                                   {-# LINE 2110 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_sig =
                                  ({-# LINE 112 "Order.ag" #-}
                                   _lhsIo_sig
                                   {-# LINE 2116 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_unbox =
                                  ({-# LINE 119 "Order.ag" #-}
                                   _lhsIo_unbox
                                   {-# LINE 2122 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOo_wantvisit =
                                  ({-# LINE 115 "Order.ag" #-}
                                   _lhsIo_wantvisit
                                   {-# LINE 2128 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOprefix =
                                  ({-# LINE 118 "Order.ag" #-}
                                   _lhsIprefix
                                   {-# LINE 2134 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _hdOvcount =
                                  ({-# LINE 258 "Order.ag" #-}
                                   _lhsIvcount
                                   {-# LINE 2140 "Order.hs" #-}
                                   )
                              -- copy rule (chain)
                              _tlOacount =
                                  ({-# LINE 499 "Order.ag" #-}
                                   _hdIacount
                                   {-# LINE 2146 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOallnts =
                                  ({-# LINE 647 "Order.ag" #-}
                                   _lhsIallnts
                                   {-# LINE 2152 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOaroundMap =
                                  ({-# LINE 407 "Order.ag" #-}
                                   _lhsIaroundMap
                                   {-# LINE 2158 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOcInterfaceMap =
                                  ({-# LINE 594 "Order.ag" #-}
                                   _lhsIcInterfaceMap
                                   {-# LINE 2164 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOcVisitsMap =
                                  ({-# LINE 601 "Order.ag" #-}
                                   _lhsIcVisitsMap
                                   {-# LINE 2170 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOmanualAttrDepMap =
                                  ({-# LINE 283 "Order.ag" #-}
                                   _lhsImanualAttrDepMap
                                   {-# LINE 2176 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOmergeMap =
                                  ({-# LINE 354 "Order.ag" #-}
                                   _lhsImergeMap
                                   {-# LINE 2182 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_case =
                                  ({-# LINE 117 "Order.ag" #-}
                                   _lhsIo_case
                                   {-# LINE 2188 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_cata =
                                  ({-# LINE 111 "Order.ag" #-}
                                   _lhsIo_cata
                                   {-# LINE 2194 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_data =
                                  ({-# LINE 120 "Order.ag" #-}
                                   _lhsIo_data
                                   {-# LINE 2200 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_dovisit =
                                  ({-# LINE 116 "Order.ag" #-}
                                   _lhsIo_dovisit
                                   {-# LINE 2206 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_newtypes =
                                  ({-# LINE 110 "Order.ag" #-}
                                   _lhsIo_newtypes
                                   {-# LINE 2212 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_rename =
                                  ({-# LINE 114 "Order.ag" #-}
                                   _lhsIo_rename
                                   {-# LINE 2218 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_sem =
                                  ({-# LINE 113 "Order.ag" #-}
                                   _lhsIo_sem
                                   {-# LINE 2224 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_sig =
                                  ({-# LINE 112 "Order.ag" #-}
                                   _lhsIo_sig
                                   {-# LINE 2230 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_unbox =
                                  ({-# LINE 119 "Order.ag" #-}
                                   _lhsIo_unbox
                                   {-# LINE 2236 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOo_wantvisit =
                                  ({-# LINE 115 "Order.ag" #-}
                                   _lhsIo_wantvisit
                                   {-# LINE 2242 "Order.hs" #-}
                                   )
                              -- copy rule (down)
                              _tlOprefix =
                                  ({-# LINE 118 "Order.ag" #-}
                                   _lhsIprefix
                                   {-# LINE 2248 "Order.hs" #-}
                                   )
                              -- copy rule (chain)
                              _tlOvcount =
                                  ({-# LINE 258 "Order.ag" #-}
                                   _hdIvcount
                                   {-# LINE 2254 "Order.hs" #-}
                                   )
                              ( _hdIacount,_hdIadditionalDep,_hdIaranges,_hdIaroundDep,_hdIcNonterminal,_hdIdirectDep,_hdIerrors,_hdIinstDep,_hdImergeDep,_hdInAutoRules,_hdInExplicitRules,_hdInonts,_hdIntattrs,_hdIrules,_hdIvcount) =
                                  hd_ _hdOacount _hdOallnts _hdOaroundMap _hdOcInterfaceMap _hdOcVisitsMap _hdOmanualAttrDepMap _hdOmergeMap _hdOo_case _hdOo_cata _hdOo_data _hdOo_dovisit _hdOo_newtypes _hdOo_rename _hdOo_sem _hdOo_sig _hdOo_unbox _hdOo_wantvisit _hdOprefix _hdOvcount 
                              ( _tlIacount,_tlIadditionalDep,_tlIaranges,_tlIaroundDep,_tlIcNonterminals,_tlIdirectDep,_tlIerrors,_tlIinstDep,_tlImergeDep,_tlInAutoRules,_tlInExplicitRules,_tlInonts,_tlIntattrs,_tlIrules,_tlIvcount) =
                                  tl_ _tlOacount _tlOallnts _tlOaroundMap _tlOcInterfaceMap _tlOcVisitsMap _tlOmanualAttrDepMap _tlOmergeMap _tlOo_case _tlOo_cata _tlOo_data _tlOo_dovisit _tlOo_newtypes _tlOo_rename _tlOo_sem _tlOo_sig _tlOo_unbox _tlOo_wantvisit _tlOprefix _tlOvcount 
                          in  ( _lhsOacount,_lhsOadditionalDep,_lhsOaranges,_lhsOaroundDep,_lhsOcNonterminals,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOnonts,_lhsOntattrs,_lhsOrules,_lhsOvcount))) )
sem_Nonterminals_Nil :: T_Nonterminals 
sem_Nonterminals_Nil  =
    (T_Nonterminals (\ _lhsIacount
                       _lhsIallnts
                       _lhsIaroundMap
                       _lhsIcInterfaceMap
                       _lhsIcVisitsMap
                       _lhsImanualAttrDepMap
                       _lhsImergeMap
                       _lhsIo_case
                       _lhsIo_cata
                       _lhsIo_data
                       _lhsIo_dovisit
                       _lhsIo_newtypes
                       _lhsIo_rename
                       _lhsIo_sem
                       _lhsIo_sig
                       _lhsIo_unbox
                       _lhsIo_wantvisit
                       _lhsIprefix
                       _lhsIvcount ->
                         (let _lhsOcNonterminals :: CNonterminals
                              _lhsOadditionalDep :: (Seq Edge)
                              _lhsOaranges :: (Seq (Int,Int,Int))
                              _lhsOaroundDep :: (Seq Edge)
                              _lhsOdirectDep :: (Seq Edge)
                              _lhsOerrors :: (Seq Error)
                              _lhsOinstDep :: (Seq Edge)
                              _lhsOmergeDep :: (Seq Edge)
                              _lhsOnAutoRules :: Int
                              _lhsOnExplicitRules :: Int
                              _lhsOnonts :: ([(NontermIdent,[ConstructorIdent])])
                              _lhsOntattrs :: (Seq (Vertex,NTAttr))
                              _lhsOrules :: (Seq (Vertex,CRule))
                              _lhsOacount :: Int
                              _lhsOvcount :: Int
                              -- "Order.ag"(line 622, column 12)
                              _lhsOcNonterminals =
                                  ({-# LINE 622 "Order.ag" #-}
                                   []
                                   {-# LINE 2301 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 283, column 60)
                              _lhsOadditionalDep =
                                  ({-# LINE 283 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2307 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 500, column 36)
                              _lhsOaranges =
                                  ({-# LINE 500 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2313 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 404, column 24)
                              _lhsOaroundDep =
                                  ({-# LINE 404 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2319 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 269, column 33)
                              _lhsOdirectDep =
                                  ({-# LINE 269 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2325 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 84, column 70)
                              _lhsOerrors =
                                  ({-# LINE 84 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2331 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 312, column 31)
                              _lhsOinstDep =
                                  ({-# LINE 312 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2337 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 367, column 18)
                              _lhsOmergeDep =
                                  ({-# LINE 367 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2343 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 61, column 105)
                              _lhsOnAutoRules =
                                  ({-# LINE 61 "Order.ag" #-}
                                   0
                                   {-# LINE 2349 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 61, column 105)
                              _lhsOnExplicitRules =
                                  ({-# LINE 61 "Order.ag" #-}
                                   0
                                   {-# LINE 2355 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 517, column 43)
                              _lhsOnonts =
                                  ({-# LINE 517 "Order.ag" #-}
                                   []
                                   {-# LINE 2361 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 499, column 35)
                              _lhsOntattrs =
                                  ({-# LINE 499 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2367 "Order.hs" #-}
                                   )
                              -- use rule "Order.ag"(line 259, column 18)
                              _lhsOrules =
                                  ({-# LINE 259 "Order.ag" #-}
                                   Seq.empty
                                   {-# LINE 2373 "Order.hs" #-}
                                   )
                              -- copy rule (chain)
                              _lhsOacount =
                                  ({-# LINE 499 "Order.ag" #-}
                                   _lhsIacount
                                   {-# LINE 2379 "Order.hs" #-}
                                   )
                              -- copy rule (chain)
                              _lhsOvcount =
                                  ({-# LINE 258 "Order.ag" #-}
                                   _lhsIvcount
                                   {-# LINE 2385 "Order.hs" #-}
                                   )
                          in  ( _lhsOacount,_lhsOadditionalDep,_lhsOaranges,_lhsOaroundDep,_lhsOcNonterminals,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOnonts,_lhsOntattrs,_lhsOrules,_lhsOvcount))) )
-- Pattern -----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allTypeSigs          : Map Identifier Type
         altAttrs             : Map AltAttr Vertex
         con                  : Identifier
         inh                  : Attributes
         nt                   : Identifier
         syn                  : Attributes
      synthesized attributes:
         copy                 : SELF 
         errors               : Seq Error
         gathAltAttrs         : [AltAttr]
         instVars             : [Identifier]
         locVars              : [Identifier]
         patternAttrs         : [(Identifier,Identifier,Bool,Patterns)]
   alternatives:
      alternative Alias:
         child field          : {Identifier}
         child attr           : {Identifier}
         child pat            : Pattern 
         child parts          : Patterns 
         visit 0:
            local copy        : _
      alternative Constr:
         child name           : {ConstructorIdent}
         child pats           : Patterns 
         visit 0:
            local copy        : _
      alternative Irrefutable:
         child pat            : Pattern 
         visit 0:
            local copy        : _
      alternative Product:
         child pos            : {Pos}
         child pats           : Patterns 
         visit 0:
            local copy        : _
      alternative Underscore:
         child pos            : {Pos}
         visit 0:
            local copy        : _
-}
-- cata
sem_Pattern :: Pattern  ->
               T_Pattern 
sem_Pattern (Alias _field _attr _pat _parts )  =
    (sem_Pattern_Alias _field _attr (sem_Pattern _pat ) (sem_Patterns _parts ) )
sem_Pattern (Constr _name _pats )  =
    (sem_Pattern_Constr _name (sem_Patterns _pats ) )
sem_Pattern (Irrefutable _pat )  =
    (sem_Pattern_Irrefutable (sem_Pattern _pat ) )
sem_Pattern (Product _pos _pats )  =
    (sem_Pattern_Product _pos (sem_Patterns _pats ) )
sem_Pattern (Underscore _pos )  =
    (sem_Pattern_Underscore _pos )
-- semantic domain
newtype T_Pattern  = T_Pattern ((Map Identifier Type) ->
                                (Map AltAttr Vertex) ->
                                Identifier ->
                                Attributes ->
                                Identifier ->
                                Attributes ->
                                ( Pattern ,(Seq Error),([AltAttr]),([Identifier]),([Identifier]),([(Identifier,Identifier,Bool,Patterns)])))
data Inh_Pattern  = Inh_Pattern {allTypeSigs_Inh_Pattern :: !((Map Identifier Type)),altAttrs_Inh_Pattern :: !((Map AltAttr Vertex)),con_Inh_Pattern :: !(Identifier),inh_Inh_Pattern :: !(Attributes),nt_Inh_Pattern :: !(Identifier),syn_Inh_Pattern :: !(Attributes)}
data Syn_Pattern  = Syn_Pattern {copy_Syn_Pattern :: !(Pattern ),errors_Syn_Pattern :: !((Seq Error)),gathAltAttrs_Syn_Pattern :: !(([AltAttr])),instVars_Syn_Pattern :: !(([Identifier])),locVars_Syn_Pattern :: !(([Identifier])),patternAttrs_Syn_Pattern :: !(([(Identifier,Identifier,Bool,Patterns)]))}
wrap_Pattern :: T_Pattern  ->
                Inh_Pattern  ->
                Syn_Pattern 
wrap_Pattern (T_Pattern sem ) (Inh_Pattern _lhsIallTypeSigs _lhsIaltAttrs _lhsIcon _lhsIinh _lhsInt _lhsIsyn )  =
    (let ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs) = sem _lhsIallTypeSigs _lhsIaltAttrs _lhsIcon _lhsIinh _lhsInt _lhsIsyn 
     in  (Syn_Pattern _lhsOcopy _lhsOerrors _lhsOgathAltAttrs _lhsOinstVars _lhsOlocVars _lhsOpatternAttrs ))
sem_Pattern_Alias :: Identifier ->
                     Identifier ->
                     T_Pattern  ->
                     T_Patterns  ->
                     T_Pattern 
sem_Pattern_Alias field_ attr_ (T_Pattern pat_ ) (T_Patterns parts_ )  =
    (T_Pattern (\ _lhsIallTypeSigs
                  _lhsIaltAttrs
                  _lhsIcon
                  _lhsIinh
                  _lhsInt
                  _lhsIsyn ->
                    (let _lhsOgathAltAttrs :: ([AltAttr])
                         _lhsOpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         _lhsOlocVars :: ([Identifier])
                         _lhsOinstVars :: ([Identifier])
                         _lhsOerrors :: (Seq Error)
                         _lhsOcopy :: Pattern 
                         _patOallTypeSigs :: (Map Identifier Type)
                         _patOaltAttrs :: (Map AltAttr Vertex)
                         _patOcon :: Identifier
                         _patOinh :: Attributes
                         _patOnt :: Identifier
                         _patOsyn :: Attributes
                         _partsOallTypeSigs :: (Map Identifier Type)
                         _partsOaltAttrs :: (Map AltAttr Vertex)
                         _partsOcon :: Identifier
                         _partsOinh :: Attributes
                         _partsOnt :: Identifier
                         _partsOsyn :: Attributes
                         _patIcopy :: Pattern 
                         _patIerrors :: (Seq Error)
                         _patIgathAltAttrs :: ([AltAttr])
                         _patIinstVars :: ([Identifier])
                         _patIlocVars :: ([Identifier])
                         _patIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         _partsIcopy :: Patterns 
                         _partsIerrors :: (Seq Error)
                         _partsIgathAltAttrs :: ([AltAttr])
                         _partsIinstVars :: ([Identifier])
                         _partsIlocVars :: ([Identifier])
                         _partsIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         -- "Order.ag"(line 184, column 12)
                         _lhsOgathAltAttrs =
                             ({-# LINE 184 "Order.ag" #-}
                              [AltAttr field_ attr_ (field_ == _LOC || field_ == _INST)]
                              {-# LINE 2507 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 252, column 12)
                         _lhsOpatternAttrs =
                             ({-# LINE 252 "Order.ag" #-}
                              [(field_,attr_,(field_ == _LOC || field_ == _INST),_partsIcopy)]
                              {-# LINE 2513 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 680, column 14)
                         _lhsOlocVars =
                             ({-# LINE 680 "Order.ag" #-}
                              if field_ == _LOC
                                 then [attr_]
                                 else []
                              {-# LINE 2521 "Order.hs" #-}
                              )
                         -- "Order.ag"(line 683, column 14)
                         _lhsOinstVars =
                             ({-# LINE 683 "Order.ag" #-}
                              if field_ == _INST
                                 then [attr_]
                                 else []
                              {-# LINE 2529 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 84, column 70)
                         _lhsOerrors =
                             ({-# LINE 84 "Order.ag" #-}
                              _patIerrors Seq.>< _partsIerrors
                              {-# LINE 2535 "Order.hs" #-}
                              )
                         -- self rule
                         _copy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              Alias field_ attr_ _patIcopy _partsIcopy
                              {-# LINE 2541 "Order.hs" #-}
                              )
                         -- self rule
                         _lhsOcopy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              _copy
                              {-# LINE 2547 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOallTypeSigs =
                             ({-# LINE 533 "Order.ag" #-}
                              _lhsIallTypeSigs
                              {-# LINE 2553 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOaltAttrs =
                             ({-# LINE 186 "Order.ag" #-}
                              _lhsIaltAttrs
                              {-# LINE 2559 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOcon =
                             ({-# LINE 90 "Order.ag" #-}
                              _lhsIcon
                              {-# LINE 2565 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOinh =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIinh
                              {-# LINE 2571 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOnt =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsInt
                              {-# LINE 2577 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOsyn =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIsyn
                              {-# LINE 2583 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _partsOallTypeSigs =
                             ({-# LINE 533 "Order.ag" #-}
                              _lhsIallTypeSigs
                              {-# LINE 2589 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _partsOaltAttrs =
                             ({-# LINE 186 "Order.ag" #-}
                              _lhsIaltAttrs
                              {-# LINE 2595 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _partsOcon =
                             ({-# LINE 90 "Order.ag" #-}
                              _lhsIcon
                              {-# LINE 2601 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _partsOinh =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIinh
                              {-# LINE 2607 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _partsOnt =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsInt
                              {-# LINE 2613 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _partsOsyn =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIsyn
                              {-# LINE 2619 "Order.hs" #-}
                              )
                         ( _patIcopy,_patIerrors,_patIgathAltAttrs,_patIinstVars,_patIlocVars,_patIpatternAttrs) =
                             pat_ _patOallTypeSigs _patOaltAttrs _patOcon _patOinh _patOnt _patOsyn 
                         ( _partsIcopy,_partsIerrors,_partsIgathAltAttrs,_partsIinstVars,_partsIlocVars,_partsIpatternAttrs) =
                             parts_ _partsOallTypeSigs _partsOaltAttrs _partsOcon _partsOinh _partsOnt _partsOsyn 
                     in  ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs))) )
sem_Pattern_Constr :: ConstructorIdent ->
                      T_Patterns  ->
                      T_Pattern 
sem_Pattern_Constr name_ (T_Patterns pats_ )  =
    (T_Pattern (\ _lhsIallTypeSigs
                  _lhsIaltAttrs
                  _lhsIcon
                  _lhsIinh
                  _lhsInt
                  _lhsIsyn ->
                    (let _lhsOerrors :: (Seq Error)
                         _lhsOgathAltAttrs :: ([AltAttr])
                         _lhsOinstVars :: ([Identifier])
                         _lhsOlocVars :: ([Identifier])
                         _lhsOpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         _lhsOcopy :: Pattern 
                         _patsOallTypeSigs :: (Map Identifier Type)
                         _patsOaltAttrs :: (Map AltAttr Vertex)
                         _patsOcon :: Identifier
                         _patsOinh :: Attributes
                         _patsOnt :: Identifier
                         _patsOsyn :: Attributes
                         _patsIcopy :: Patterns 
                         _patsIerrors :: (Seq Error)
                         _patsIgathAltAttrs :: ([AltAttr])
                         _patsIinstVars :: ([Identifier])
                         _patsIlocVars :: ([Identifier])
                         _patsIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         -- use rule "Order.ag"(line 84, column 70)
                         _lhsOerrors =
                             ({-# LINE 84 "Order.ag" #-}
                              _patsIerrors
                              {-# LINE 2658 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 170, column 68)
                         _lhsOgathAltAttrs =
                             ({-# LINE 170 "Order.ag" #-}
                              _patsIgathAltAttrs
                              {-# LINE 2664 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 86)
                         _lhsOinstVars =
                             ({-# LINE 677 "Order.ag" #-}
                              _patsIinstVars
                              {-# LINE 2670 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 48)
                         _lhsOlocVars =
                             ({-# LINE 677 "Order.ag" #-}
                              _patsIlocVars
                              {-# LINE 2676 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 249, column 42)
                         _lhsOpatternAttrs =
                             ({-# LINE 249 "Order.ag" #-}
                              _patsIpatternAttrs
                              {-# LINE 2682 "Order.hs" #-}
                              )
                         -- self rule
                         _copy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              Constr name_ _patsIcopy
                              {-# LINE 2688 "Order.hs" #-}
                              )
                         -- self rule
                         _lhsOcopy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              _copy
                              {-# LINE 2694 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOallTypeSigs =
                             ({-# LINE 533 "Order.ag" #-}
                              _lhsIallTypeSigs
                              {-# LINE 2700 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOaltAttrs =
                             ({-# LINE 186 "Order.ag" #-}
                              _lhsIaltAttrs
                              {-# LINE 2706 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOcon =
                             ({-# LINE 90 "Order.ag" #-}
                              _lhsIcon
                              {-# LINE 2712 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOinh =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIinh
                              {-# LINE 2718 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOnt =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsInt
                              {-# LINE 2724 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOsyn =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIsyn
                              {-# LINE 2730 "Order.hs" #-}
                              )
                         ( _patsIcopy,_patsIerrors,_patsIgathAltAttrs,_patsIinstVars,_patsIlocVars,_patsIpatternAttrs) =
                             pats_ _patsOallTypeSigs _patsOaltAttrs _patsOcon _patsOinh _patsOnt _patsOsyn 
                     in  ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs))) )
sem_Pattern_Irrefutable :: T_Pattern  ->
                           T_Pattern 
sem_Pattern_Irrefutable (T_Pattern pat_ )  =
    (T_Pattern (\ _lhsIallTypeSigs
                  _lhsIaltAttrs
                  _lhsIcon
                  _lhsIinh
                  _lhsInt
                  _lhsIsyn ->
                    (let _lhsOerrors :: (Seq Error)
                         _lhsOgathAltAttrs :: ([AltAttr])
                         _lhsOinstVars :: ([Identifier])
                         _lhsOlocVars :: ([Identifier])
                         _lhsOpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         _lhsOcopy :: Pattern 
                         _patOallTypeSigs :: (Map Identifier Type)
                         _patOaltAttrs :: (Map AltAttr Vertex)
                         _patOcon :: Identifier
                         _patOinh :: Attributes
                         _patOnt :: Identifier
                         _patOsyn :: Attributes
                         _patIcopy :: Pattern 
                         _patIerrors :: (Seq Error)
                         _patIgathAltAttrs :: ([AltAttr])
                         _patIinstVars :: ([Identifier])
                         _patIlocVars :: ([Identifier])
                         _patIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         -- use rule "Order.ag"(line 84, column 70)
                         _lhsOerrors =
                             ({-# LINE 84 "Order.ag" #-}
                              _patIerrors
                              {-# LINE 2766 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 170, column 68)
                         _lhsOgathAltAttrs =
                             ({-# LINE 170 "Order.ag" #-}
                              _patIgathAltAttrs
                              {-# LINE 2772 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 86)
                         _lhsOinstVars =
                             ({-# LINE 677 "Order.ag" #-}
                              _patIinstVars
                              {-# LINE 2778 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 48)
                         _lhsOlocVars =
                             ({-# LINE 677 "Order.ag" #-}
                              _patIlocVars
                              {-# LINE 2784 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 249, column 42)
                         _lhsOpatternAttrs =
                             ({-# LINE 249 "Order.ag" #-}
                              _patIpatternAttrs
                              {-# LINE 2790 "Order.hs" #-}
                              )
                         -- self rule
                         _copy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              Irrefutable _patIcopy
                              {-# LINE 2796 "Order.hs" #-}
                              )
                         -- self rule
                         _lhsOcopy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              _copy
                              {-# LINE 2802 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOallTypeSigs =
                             ({-# LINE 533 "Order.ag" #-}
                              _lhsIallTypeSigs
                              {-# LINE 2808 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOaltAttrs =
                             ({-# LINE 186 "Order.ag" #-}
                              _lhsIaltAttrs
                              {-# LINE 2814 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOcon =
                             ({-# LINE 90 "Order.ag" #-}
                              _lhsIcon
                              {-# LINE 2820 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOinh =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIinh
                              {-# LINE 2826 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOnt =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsInt
                              {-# LINE 2832 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patOsyn =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIsyn
                              {-# LINE 2838 "Order.hs" #-}
                              )
                         ( _patIcopy,_patIerrors,_patIgathAltAttrs,_patIinstVars,_patIlocVars,_patIpatternAttrs) =
                             pat_ _patOallTypeSigs _patOaltAttrs _patOcon _patOinh _patOnt _patOsyn 
                     in  ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs))) )
sem_Pattern_Product :: Pos ->
                       T_Patterns  ->
                       T_Pattern 
sem_Pattern_Product pos_ (T_Patterns pats_ )  =
    (T_Pattern (\ _lhsIallTypeSigs
                  _lhsIaltAttrs
                  _lhsIcon
                  _lhsIinh
                  _lhsInt
                  _lhsIsyn ->
                    (let _lhsOerrors :: (Seq Error)
                         _lhsOgathAltAttrs :: ([AltAttr])
                         _lhsOinstVars :: ([Identifier])
                         _lhsOlocVars :: ([Identifier])
                         _lhsOpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         _lhsOcopy :: Pattern 
                         _patsOallTypeSigs :: (Map Identifier Type)
                         _patsOaltAttrs :: (Map AltAttr Vertex)
                         _patsOcon :: Identifier
                         _patsOinh :: Attributes
                         _patsOnt :: Identifier
                         _patsOsyn :: Attributes
                         _patsIcopy :: Patterns 
                         _patsIerrors :: (Seq Error)
                         _patsIgathAltAttrs :: ([AltAttr])
                         _patsIinstVars :: ([Identifier])
                         _patsIlocVars :: ([Identifier])
                         _patsIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         -- use rule "Order.ag"(line 84, column 70)
                         _lhsOerrors =
                             ({-# LINE 84 "Order.ag" #-}
                              _patsIerrors
                              {-# LINE 2875 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 170, column 68)
                         _lhsOgathAltAttrs =
                             ({-# LINE 170 "Order.ag" #-}
                              _patsIgathAltAttrs
                              {-# LINE 2881 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 86)
                         _lhsOinstVars =
                             ({-# LINE 677 "Order.ag" #-}
                              _patsIinstVars
                              {-# LINE 2887 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 48)
                         _lhsOlocVars =
                             ({-# LINE 677 "Order.ag" #-}
                              _patsIlocVars
                              {-# LINE 2893 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 249, column 42)
                         _lhsOpatternAttrs =
                             ({-# LINE 249 "Order.ag" #-}
                              _patsIpatternAttrs
                              {-# LINE 2899 "Order.hs" #-}
                              )
                         -- self rule
                         _copy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              Product pos_ _patsIcopy
                              {-# LINE 2905 "Order.hs" #-}
                              )
                         -- self rule
                         _lhsOcopy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              _copy
                              {-# LINE 2911 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOallTypeSigs =
                             ({-# LINE 533 "Order.ag" #-}
                              _lhsIallTypeSigs
                              {-# LINE 2917 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOaltAttrs =
                             ({-# LINE 186 "Order.ag" #-}
                              _lhsIaltAttrs
                              {-# LINE 2923 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOcon =
                             ({-# LINE 90 "Order.ag" #-}
                              _lhsIcon
                              {-# LINE 2929 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOinh =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIinh
                              {-# LINE 2935 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOnt =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsInt
                              {-# LINE 2941 "Order.hs" #-}
                              )
                         -- copy rule (down)
                         _patsOsyn =
                             ({-# LINE 89 "Order.ag" #-}
                              _lhsIsyn
                              {-# LINE 2947 "Order.hs" #-}
                              )
                         ( _patsIcopy,_patsIerrors,_patsIgathAltAttrs,_patsIinstVars,_patsIlocVars,_patsIpatternAttrs) =
                             pats_ _patsOallTypeSigs _patsOaltAttrs _patsOcon _patsOinh _patsOnt _patsOsyn 
                     in  ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs))) )
sem_Pattern_Underscore :: Pos ->
                          T_Pattern 
sem_Pattern_Underscore pos_  =
    (T_Pattern (\ _lhsIallTypeSigs
                  _lhsIaltAttrs
                  _lhsIcon
                  _lhsIinh
                  _lhsInt
                  _lhsIsyn ->
                    (let _lhsOerrors :: (Seq Error)
                         _lhsOgathAltAttrs :: ([AltAttr])
                         _lhsOinstVars :: ([Identifier])
                         _lhsOlocVars :: ([Identifier])
                         _lhsOpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                         _lhsOcopy :: Pattern 
                         -- use rule "Order.ag"(line 84, column 70)
                         _lhsOerrors =
                             ({-# LINE 84 "Order.ag" #-}
                              Seq.empty
                              {-# LINE 2971 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 170, column 68)
                         _lhsOgathAltAttrs =
                             ({-# LINE 170 "Order.ag" #-}
                              []
                              {-# LINE 2977 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 86)
                         _lhsOinstVars =
                             ({-# LINE 677 "Order.ag" #-}
                              []
                              {-# LINE 2983 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 677, column 48)
                         _lhsOlocVars =
                             ({-# LINE 677 "Order.ag" #-}
                              []
                              {-# LINE 2989 "Order.hs" #-}
                              )
                         -- use rule "Order.ag"(line 249, column 42)
                         _lhsOpatternAttrs =
                             ({-# LINE 249 "Order.ag" #-}
                              []
                              {-# LINE 2995 "Order.hs" #-}
                              )
                         -- self rule
                         _copy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              Underscore pos_
                              {-# LINE 3001 "Order.hs" #-}
                              )
                         -- self rule
                         _lhsOcopy =
                             ({-# LINE 23 "./Patterns.ag" #-}
                              _copy
                              {-# LINE 3007 "Order.hs" #-}
                              )
                     in  ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs))) )
-- Patterns ----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allTypeSigs          : Map Identifier Type
         altAttrs             : Map AltAttr Vertex
         con                  : Identifier
         inh                  : Attributes
         nt                   : Identifier
         syn                  : Attributes
      synthesized attributes:
         copy                 : SELF 
         errors               : Seq Error
         gathAltAttrs         : [AltAttr]
         instVars             : [Identifier]
         locVars              : [Identifier]
         patternAttrs         : [(Identifier,Identifier,Bool,Patterns)]
   alternatives:
      alternative Cons:
         child hd             : Pattern 
         child tl             : Patterns 
         visit 0:
            local copy        : _
      alternative Nil:
         visit 0:
            local copy        : _
-}
-- cata
sem_Patterns :: Patterns  ->
                T_Patterns 
sem_Patterns list  =
    (Prelude.foldr sem_Patterns_Cons sem_Patterns_Nil (Prelude.map sem_Pattern list) )
-- semantic domain
newtype T_Patterns  = T_Patterns ((Map Identifier Type) ->
                                  (Map AltAttr Vertex) ->
                                  Identifier ->
                                  Attributes ->
                                  Identifier ->
                                  Attributes ->
                                  ( Patterns ,(Seq Error),([AltAttr]),([Identifier]),([Identifier]),([(Identifier,Identifier,Bool,Patterns)])))
data Inh_Patterns  = Inh_Patterns {allTypeSigs_Inh_Patterns :: !((Map Identifier Type)),altAttrs_Inh_Patterns :: !((Map AltAttr Vertex)),con_Inh_Patterns :: !(Identifier),inh_Inh_Patterns :: !(Attributes),nt_Inh_Patterns :: !(Identifier),syn_Inh_Patterns :: !(Attributes)}
data Syn_Patterns  = Syn_Patterns {copy_Syn_Patterns :: !(Patterns ),errors_Syn_Patterns :: !((Seq Error)),gathAltAttrs_Syn_Patterns :: !(([AltAttr])),instVars_Syn_Patterns :: !(([Identifier])),locVars_Syn_Patterns :: !(([Identifier])),patternAttrs_Syn_Patterns :: !(([(Identifier,Identifier,Bool,Patterns)]))}
wrap_Patterns :: T_Patterns  ->
                 Inh_Patterns  ->
                 Syn_Patterns 
wrap_Patterns (T_Patterns sem ) (Inh_Patterns _lhsIallTypeSigs _lhsIaltAttrs _lhsIcon _lhsIinh _lhsInt _lhsIsyn )  =
    (let ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs) = sem _lhsIallTypeSigs _lhsIaltAttrs _lhsIcon _lhsIinh _lhsInt _lhsIsyn 
     in  (Syn_Patterns _lhsOcopy _lhsOerrors _lhsOgathAltAttrs _lhsOinstVars _lhsOlocVars _lhsOpatternAttrs ))
sem_Patterns_Cons :: T_Pattern  ->
                     T_Patterns  ->
                     T_Patterns 
sem_Patterns_Cons (T_Pattern hd_ ) (T_Patterns tl_ )  =
    (T_Patterns (\ _lhsIallTypeSigs
                   _lhsIaltAttrs
                   _lhsIcon
                   _lhsIinh
                   _lhsInt
                   _lhsIsyn ->
                     (let _lhsOerrors :: (Seq Error)
                          _lhsOgathAltAttrs :: ([AltAttr])
                          _lhsOinstVars :: ([Identifier])
                          _lhsOlocVars :: ([Identifier])
                          _lhsOpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                          _lhsOcopy :: Patterns 
                          _hdOallTypeSigs :: (Map Identifier Type)
                          _hdOaltAttrs :: (Map AltAttr Vertex)
                          _hdOcon :: Identifier
                          _hdOinh :: Attributes
                          _hdOnt :: Identifier
                          _hdOsyn :: Attributes
                          _tlOallTypeSigs :: (Map Identifier Type)
                          _tlOaltAttrs :: (Map AltAttr Vertex)
                          _tlOcon :: Identifier
                          _tlOinh :: Attributes
                          _tlOnt :: Identifier
                          _tlOsyn :: Attributes
                          _hdIcopy :: Pattern 
                          _hdIerrors :: (Seq Error)
                          _hdIgathAltAttrs :: ([AltAttr])
                          _hdIinstVars :: ([Identifier])
                          _hdIlocVars :: ([Identifier])
                          _hdIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                          _tlIcopy :: Patterns 
                          _tlIerrors :: (Seq Error)
                          _tlIgathAltAttrs :: ([AltAttr])
                          _tlIinstVars :: ([Identifier])
                          _tlIlocVars :: ([Identifier])
                          _tlIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                          -- use rule "Order.ag"(line 84, column 70)
                          _lhsOerrors =
                              ({-# LINE 84 "Order.ag" #-}
                               _hdIerrors Seq.>< _tlIerrors
                               {-# LINE 3102 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 170, column 68)
                          _lhsOgathAltAttrs =
                              ({-# LINE 170 "Order.ag" #-}
                               _hdIgathAltAttrs ++ _tlIgathAltAttrs
                               {-# LINE 3108 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 677, column 86)
                          _lhsOinstVars =
                              ({-# LINE 677 "Order.ag" #-}
                               _hdIinstVars ++ _tlIinstVars
                               {-# LINE 3114 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 677, column 48)
                          _lhsOlocVars =
                              ({-# LINE 677 "Order.ag" #-}
                               _hdIlocVars ++ _tlIlocVars
                               {-# LINE 3120 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 249, column 42)
                          _lhsOpatternAttrs =
                              ({-# LINE 249 "Order.ag" #-}
                               _hdIpatternAttrs ++ _tlIpatternAttrs
                               {-# LINE 3126 "Order.hs" #-}
                               )
                          -- self rule
                          _copy =
                              ({-# LINE 23 "./Patterns.ag" #-}
                               (:) _hdIcopy _tlIcopy
                               {-# LINE 3132 "Order.hs" #-}
                               )
                          -- self rule
                          _lhsOcopy =
                              ({-# LINE 23 "./Patterns.ag" #-}
                               _copy
                               {-# LINE 3138 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOallTypeSigs =
                              ({-# LINE 533 "Order.ag" #-}
                               _lhsIallTypeSigs
                               {-# LINE 3144 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOaltAttrs =
                              ({-# LINE 186 "Order.ag" #-}
                               _lhsIaltAttrs
                               {-# LINE 3150 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOcon =
                              ({-# LINE 90 "Order.ag" #-}
                               _lhsIcon
                               {-# LINE 3156 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOinh =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIinh
                               {-# LINE 3162 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOnt =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsInt
                               {-# LINE 3168 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOsyn =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIsyn
                               {-# LINE 3174 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOallTypeSigs =
                              ({-# LINE 533 "Order.ag" #-}
                               _lhsIallTypeSigs
                               {-# LINE 3180 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOaltAttrs =
                              ({-# LINE 186 "Order.ag" #-}
                               _lhsIaltAttrs
                               {-# LINE 3186 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOcon =
                              ({-# LINE 90 "Order.ag" #-}
                               _lhsIcon
                               {-# LINE 3192 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOinh =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIinh
                               {-# LINE 3198 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOnt =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsInt
                               {-# LINE 3204 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _tlOsyn =
                              ({-# LINE 89 "Order.ag" #-}
                               _lhsIsyn
                               {-# LINE 3210 "Order.hs" #-}
                               )
                          ( _hdIcopy,_hdIerrors,_hdIgathAltAttrs,_hdIinstVars,_hdIlocVars,_hdIpatternAttrs) =
                              hd_ _hdOallTypeSigs _hdOaltAttrs _hdOcon _hdOinh _hdOnt _hdOsyn 
                          ( _tlIcopy,_tlIerrors,_tlIgathAltAttrs,_tlIinstVars,_tlIlocVars,_tlIpatternAttrs) =
                              tl_ _tlOallTypeSigs _tlOaltAttrs _tlOcon _tlOinh _tlOnt _tlOsyn 
                      in  ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs))) )
sem_Patterns_Nil :: T_Patterns 
sem_Patterns_Nil  =
    (T_Patterns (\ _lhsIallTypeSigs
                   _lhsIaltAttrs
                   _lhsIcon
                   _lhsIinh
                   _lhsInt
                   _lhsIsyn ->
                     (let _lhsOerrors :: (Seq Error)
                          _lhsOgathAltAttrs :: ([AltAttr])
                          _lhsOinstVars :: ([Identifier])
                          _lhsOlocVars :: ([Identifier])
                          _lhsOpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                          _lhsOcopy :: Patterns 
                          -- use rule "Order.ag"(line 84, column 70)
                          _lhsOerrors =
                              ({-# LINE 84 "Order.ag" #-}
                               Seq.empty
                               {-# LINE 3235 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 170, column 68)
                          _lhsOgathAltAttrs =
                              ({-# LINE 170 "Order.ag" #-}
                               []
                               {-# LINE 3241 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 677, column 86)
                          _lhsOinstVars =
                              ({-# LINE 677 "Order.ag" #-}
                               []
                               {-# LINE 3247 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 677, column 48)
                          _lhsOlocVars =
                              ({-# LINE 677 "Order.ag" #-}
                               []
                               {-# LINE 3253 "Order.hs" #-}
                               )
                          -- use rule "Order.ag"(line 249, column 42)
                          _lhsOpatternAttrs =
                              ({-# LINE 249 "Order.ag" #-}
                               []
                               {-# LINE 3259 "Order.hs" #-}
                               )
                          -- self rule
                          _copy =
                              ({-# LINE 23 "./Patterns.ag" #-}
                               []
                               {-# LINE 3265 "Order.hs" #-}
                               )
                          -- self rule
                          _lhsOcopy =
                              ({-# LINE 23 "./Patterns.ag" #-}
                               _copy
                               {-# LINE 3271 "Order.hs" #-}
                               )
                      in  ( _lhsOcopy,_lhsOerrors,_lhsOgathAltAttrs,_lhsOinstVars,_lhsOlocVars,_lhsOpatternAttrs))) )
-- Production --------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allnts               : [Identifier]
         aroundMap            : Map ConstructorIdent (Map Identifier [Expression])
         cVisitsMap           : CVisitsMap
         inh                  : Attributes
         manualAttrDepMap     : AttrOrderMap
         mergeMap             : Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))
         nt                   : Identifier
         o_case               : Bool
         o_cata               : Bool
         o_dovisit            : Bool
         o_newtypes           : Bool
         o_rename             : Bool
         o_sem                : Bool
         o_sig                : Bool
         o_unbox              : Bool
         o_wantvisit          : Bool
         prefix               : String
         syn                  : Attributes
      chained attribute:
         vcount               : Int
      synthesized attributes:
         additionalDep        : Seq Edge
         aroundDep            : Seq Edge
         cProduction          : CProduction
         cons                 : [ConstructorIdent]
         directDep            : Seq Edge
         errors               : Seq Error
         instDep              : Seq Edge
         mergeDep             : Seq Edge
         nAutoRules           : Int
         nExplicitRules       : Int
         rules                : Seq (Vertex,CRule)
   alternatives:
      alternative Production:
         child con            : {ConstructorIdent}
         child children       : Children 
         child rules          : Rules 
         child typeSigs       : TypeSigs 
         visit 0:
            local gathAltAttrs : _
            local altAttrs    : _
            local inhRules    : _
            local gathRules   : _
            local manualDeps  : _
            local mergeMap    : _
            local mergeDep1   : _
            local mergeDep2   : _
            local aroundMap   : _
            local aroundDep1  : _
            local aroundDep2  : _
            local cVisits     : _
            local allfields   : _
            local attrs       : _
            local inhnames    : _
            local synnames    : _
-}
-- cata
sem_Production :: Production  ->
                  T_Production 
sem_Production (Production _con _children _rules _typeSigs )  =
    (sem_Production_Production _con (sem_Children _children ) (sem_Rules _rules ) (sem_TypeSigs _typeSigs ) )
-- semantic domain
newtype T_Production  = T_Production (([Identifier]) ->
                                      (Map ConstructorIdent (Map Identifier [Expression])) ->
                                      CVisitsMap ->
                                      Attributes ->
                                      AttrOrderMap ->
                                      (Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))) ->
                                      Identifier ->
                                      Bool ->
                                      Bool ->
                                      Bool ->
                                      Bool ->
                                      Bool ->
                                      Bool ->
                                      Bool ->
                                      Bool ->
                                      Bool ->
                                      String ->
                                      Attributes ->
                                      Int ->
                                      ( (Seq Edge),(Seq Edge),CProduction,([ConstructorIdent]),(Seq Edge),(Seq Error),(Seq Edge),(Seq Edge),Int,Int,(Seq (Vertex,CRule)),Int))
data Inh_Production  = Inh_Production {allnts_Inh_Production :: !(([Identifier])),aroundMap_Inh_Production :: !((Map ConstructorIdent (Map Identifier [Expression]))),cVisitsMap_Inh_Production :: !(CVisitsMap),inh_Inh_Production :: !(Attributes),manualAttrDepMap_Inh_Production :: !(AttrOrderMap),mergeMap_Inh_Production :: !((Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))),nt_Inh_Production :: !(Identifier),o_case_Inh_Production :: !(Bool),o_cata_Inh_Production :: !(Bool),o_dovisit_Inh_Production :: !(Bool),o_newtypes_Inh_Production :: !(Bool),o_rename_Inh_Production :: !(Bool),o_sem_Inh_Production :: !(Bool),o_sig_Inh_Production :: !(Bool),o_unbox_Inh_Production :: !(Bool),o_wantvisit_Inh_Production :: !(Bool),prefix_Inh_Production :: !(String),syn_Inh_Production :: !(Attributes),vcount_Inh_Production :: !(Int)}
data Syn_Production  = Syn_Production {additionalDep_Syn_Production :: !((Seq Edge)),aroundDep_Syn_Production :: !((Seq Edge)),cProduction_Syn_Production :: !(CProduction),cons_Syn_Production :: !(([ConstructorIdent])),directDep_Syn_Production :: !((Seq Edge)),errors_Syn_Production :: !((Seq Error)),instDep_Syn_Production :: !((Seq Edge)),mergeDep_Syn_Production :: !((Seq Edge)),nAutoRules_Syn_Production :: !(Int),nExplicitRules_Syn_Production :: !(Int),rules_Syn_Production :: !((Seq (Vertex,CRule))),vcount_Syn_Production :: !(Int)}
wrap_Production :: T_Production  ->
                   Inh_Production  ->
                   Syn_Production 
wrap_Production (T_Production sem ) (Inh_Production _lhsIallnts _lhsIaroundMap _lhsIcVisitsMap _lhsIinh _lhsImanualAttrDepMap _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIvcount )  =
    (let ( _lhsOadditionalDep,_lhsOaroundDep,_lhsOcProduction,_lhsOcons,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOrules,_lhsOvcount) = sem _lhsIallnts _lhsIaroundMap _lhsIcVisitsMap _lhsIinh _lhsImanualAttrDepMap _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIvcount 
     in  (Syn_Production _lhsOadditionalDep _lhsOaroundDep _lhsOcProduction _lhsOcons _lhsOdirectDep _lhsOerrors _lhsOinstDep _lhsOmergeDep _lhsOnAutoRules _lhsOnExplicitRules _lhsOrules _lhsOvcount ))
sem_Production_Production :: ConstructorIdent ->
                             T_Children  ->
                             T_Rules  ->
                             T_TypeSigs  ->
                             T_Production 
sem_Production_Production con_ (T_Children children_ ) (T_Rules rules_ ) (T_TypeSigs typeSigs_ )  =
    (T_Production (\ _lhsIallnts
                     _lhsIaroundMap
                     _lhsIcVisitsMap
                     _lhsIinh
                     _lhsImanualAttrDepMap
                     _lhsImergeMap
                     _lhsInt
                     _lhsIo_case
                     _lhsIo_cata
                     _lhsIo_dovisit
                     _lhsIo_newtypes
                     _lhsIo_rename
                     _lhsIo_sem
                     _lhsIo_sig
                     _lhsIo_unbox
                     _lhsIo_wantvisit
                     _lhsIprefix
                     _lhsIsyn
                     _lhsIvcount ->
                       (let _childrenOcon :: Identifier
                            _rulesOcon :: Identifier
                            _rulesOchildNts :: (Map Identifier NontermIdent)
                            _rulesOchildInhs :: (Map Identifier Attributes)
                            _lhsOrules :: (Seq (Vertex,CRule))
                            _lhsOvcount :: Int
                            _lhsOadditionalDep :: (Seq Edge)
                            _rulesOsynsOfChildren :: (Map Identifier Attributes)
                            _rulesOinhsOfChildren :: (Map Identifier Attributes)
                            _lhsOmergeDep :: (Seq Edge)
                            _lhsOaroundDep :: (Seq Edge)
                            _lhsOcons :: ([ConstructorIdent])
                            _typeSigsOtypeSigs :: (Map Identifier Type)
                            _rulesOallTypeSigs :: (Map Identifier Type)
                            _lhsOcProduction :: CProduction
                            _lhsOdirectDep :: (Seq Edge)
                            _lhsOerrors :: (Seq Error)
                            _lhsOinstDep :: (Seq Edge)
                            _lhsOnAutoRules :: Int
                            _lhsOnExplicitRules :: Int
                            _childrenOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                            _childrenOallnts :: ([Identifier])
                            _childrenOattrs :: ([(Identifier,Identifier)])
                            _childrenOinh :: Attributes
                            _childrenOmergeMap :: (Map Identifier (Identifier,[Identifier]))
                            _childrenOnt :: Identifier
                            _childrenOo_unbox :: Bool
                            _childrenOsyn :: Attributes
                            _rulesOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                            _rulesOallnts :: ([Identifier])
                            _rulesOaltAttrs :: (Map AltAttr Vertex)
                            _rulesOattrs :: ([(Identifier,Identifier)])
                            _rulesOinh :: Attributes
                            _rulesOmergeMap :: (Map Identifier (Identifier,[Identifier]))
                            _rulesOnt :: Identifier
                            _rulesOo_case :: Bool
                            _rulesOo_cata :: Bool
                            _rulesOo_dovisit :: Bool
                            _rulesOo_newtypes :: Bool
                            _rulesOo_rename :: Bool
                            _rulesOo_sem :: Bool
                            _rulesOo_sig :: Bool
                            _rulesOo_wantvisit :: Bool
                            _rulesOprefix :: String
                            _rulesOsyn :: Attributes
                            _childrenIattributes :: ([(Identifier,Attributes,Attributes)])
                            _childrenIcollectChildrenInhs :: (Map Identifier Attributes )
                            _childrenIcollectChildrenSyns :: (Map Identifier Attributes )
                            _childrenIerrors :: (Seq Error)
                            _childrenIfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                            _childrenIgathAltAttrs :: ([AltAttr])
                            _childrenIgathRules :: (Seq CRule)
                            _childrenIinhs :: (Seq (Identifier,Attributes))
                            _childrenInts :: (Seq (Identifier,NontermIdent))
                            _childrenIsinglevisits :: ([CRule])
                            _childrenIterminals :: ([Identifier])
                            _rulesIdirectDep :: (Seq Edge)
                            _rulesIerrors :: (Seq Error)
                            _rulesIgathAltAttrs :: ([AltAttr])
                            _rulesIgathRules :: (Seq CRule)
                            _rulesIinstDep :: (Seq Edge)
                            _rulesIinstVars :: ([Identifier])
                            _rulesIlocVars :: ([Identifier])
                            _rulesInAutoRules :: Int
                            _rulesInExplicitRules :: Int
                            _typeSigsItypeSigs :: (Map Identifier Type)
                            -- "Order.ag"(line 93, column 16)
                            _childrenOcon =
                                ({-# LINE 93 "Order.ag" #-}
                                 con_
                                 {-# LINE 3463 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 95, column 16)
                            _rulesOcon =
                                ({-# LINE 95 "Order.ag" #-}
                                 con_
                                 {-# LINE 3469 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 172, column 18)
                            _gathAltAttrs =
                                ({-# LINE 172 "Order.ag" #-}
                                 [ AltAttr _LHS inh True | inh <- Map.keys _lhsIinh ]
                                  ++ _childrenIgathAltAttrs
                                  ++ _rulesIgathAltAttrs
                                 {-# LINE 3477 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 188, column 17)
                            _altAttrs =
                                ({-# LINE 188 "Order.ag" #-}
                                 Map.fromList (zip _gathAltAttrs [_lhsIvcount..])
                                 {-# LINE 3483 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 201, column 18)
                            _rulesOchildNts =
                                ({-# LINE 201 "Order.ag" #-}
                                 Map.fromList (toList _childrenInts)
                                 {-# LINE 3489 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 202, column 19)
                            _rulesOchildInhs =
                                ({-# LINE 202 "Order.ag" #-}
                                 Map.fromList (toList _childrenIinhs)
                                 {-# LINE 3495 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 208, column 18)
                            _inhRules =
                                ({-# LINE 208 "Order.ag" #-}
                                 [ cRuleLhsInh inh _lhsInt con_ tp | (inh,tp) <- Map.assocs _lhsIinh ]
                                 {-# LINE 3501 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 209, column 19)
                            _gathRules =
                                ({-# LINE 209 "Order.ag" #-}
                                 _inhRules ++ toList (_childrenIgathRules Seq.>< _rulesIgathRules)
                                 {-# LINE 3507 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 263, column 18)
                            _lhsOrules =
                                ({-# LINE 263 "Order.ag" #-}
                                 Seq.fromList (zip [_lhsIvcount..] _gathRules)
                                 {-# LINE 3513 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 264, column 19)
                            _lhsOvcount =
                                ({-# LINE 264 "Order.ag" #-}
                                 _lhsIvcount + length _gathRules
                                 {-# LINE 3519 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 291, column 7)
                            _manualDeps =
                                ({-# LINE 291 "Order.ag" #-}
                                 Set.toList $ Map.findWithDefault Set.empty con_ $ Map.findWithDefault Map.empty _lhsInt _lhsImanualAttrDepMap
                                 {-# LINE 3525 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 294, column 7)
                            _lhsOadditionalDep =
                                ({-# LINE 294 "Order.ag" #-}
                                 Seq.fromList [ (vertex True occA, vertex False occB)
                                              | Dependency occA occB <- _manualDeps
                                              , let vertex inout (OccAttr child nm)
                                                      | child == _LOC = findWithErr2 (AltAttr _LOC nm True) _altAttrs
                                                      | otherwise     = findWithErr2 (AltAttr child nm inout) _altAttrs
                                                    vertex _ (OccRule nm)
                                                      = findWithErr2 (AltAttr _LOC (Ident ("_rule_" ++ show nm) (getPos nm)) True) _altAttrs
                                              ]
                                 {-# LINE 3538 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 341, column 17)
                            _rulesOsynsOfChildren =
                                ({-# LINE 341 "Order.ag" #-}
                                 _childrenIcollectChildrenSyns
                                 {-# LINE 3544 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 342, column 17)
                            _rulesOinhsOfChildren =
                                ({-# LINE 342 "Order.ag" #-}
                                 _childrenIcollectChildrenInhs
                                 {-# LINE 3550 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 360, column 32)
                            _mergeMap =
                                ({-# LINE 360 "Order.ag" #-}
                                 Map.findWithDefault Map.empty con_ _lhsImergeMap
                                 {-# LINE 3556 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 371, column 7)
                            _lhsOmergeDep =
                                ({-# LINE 371 "Order.ag" #-}
                                 _mergeDep1     Seq.>< _mergeDep2
                                 {-# LINE 3562 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 372, column 7)
                            _mergeDep1 =
                                ({-# LINE 372 "Order.ag" #-}
                                 Seq.fromList $
                                    [ (childVert, synVert)
                                    | childNm <- Map.keys _mergeMap
                                    , synNm <- Map.keys (findWithErr2 childNm _childrenIcollectChildrenSyns)
                                    , let childNm' = Ident (show childNm ++ "_merge") (getPos childNm)
                                          childAttr = AltAttr _LOC childNm' True
                                          synAttr  = AltAttr childNm synNm True
                                          childVert = findWithErr2 childAttr _altAttrs
                                          synVert  = findWithErr2 synAttr _altAttrs
                                    ]
                                 {-# LINE 3577 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 383, column 7)
                            _mergeDep2 =
                                ({-# LINE 383 "Order.ag" #-}
                                 Seq.fromList $
                                    [ (mergedVert, sourceVert)
                                    | (childNm, (_,cs)) <- Map.assocs _mergeMap
                                    , c <- cs
                                    , synNm <- Map.keys (findWithErr2 childNm _childrenIcollectChildrenSyns)
                                    , let sourceAttr = AltAttr childNm synNm True
                                          mergedAttr = AltAttr c synNm True
                                          sourceVert = findWithErr2 sourceAttr _altAttrs
                                          mergedVert = findWithErr2 mergedAttr _altAttrs
                                    ]
                                 {-# LINE 3592 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 413, column 32)
                            _aroundMap =
                                ({-# LINE 413 "Order.ag" #-}
                                 Map.findWithDefault Map.empty con_ _lhsIaroundMap
                                 {-# LINE 3598 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 420, column 6)
                            _aroundDep1 =
                                ({-# LINE 420 "Order.ag" #-}
                                 Seq.fromList $
                                   [ (childVert, synVert)
                                   | childNm <- Map.keys _aroundMap
                                   , synNm <- Map.keys (findWithErr2 childNm _childrenIcollectChildrenSyns)
                                   , let childNm' = Ident (show childNm ++ "_around") (getPos childNm)
                                         childAttr = AltAttr _LOC childNm' True
                                         synAttr  = AltAttr childNm synNm True
                                         childVert = findWithErr2 childAttr _altAttrs
                                         synVert  = findWithErr2 synAttr _altAttrs
                                   ]
                                 {-# LINE 3613 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 431, column 6)
                            _aroundDep2 =
                                ({-# LINE 431 "Order.ag" #-}
                                 Seq.fromList $
                                   [ (childVert, inhVert)
                                   | childNm <- Map.keys _aroundMap
                                   , inhNm <- Map.keys (findWithErr2 childNm _childrenIcollectChildrenInhs)
                                   , let childNm'  = Ident (show childNm ++ "_around") (getPos childNm)
                                         childAttr = AltAttr _LOC childNm' True
                                         inhAttr   = AltAttr childNm inhNm False
                                         childVert = findWithErr2 childAttr _altAttrs
                                         inhVert   = findWithErr2 inhAttr _altAttrs
                                   ]
                                 {-# LINE 3628 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 442, column 6)
                            _lhsOaroundDep =
                                ({-# LINE 442 "Order.ag" #-}
                                 _aroundDep1     Seq.>< _aroundDep2
                                 {-# LINE 3634 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 522, column 18)
                            _lhsOcons =
                                ({-# LINE 522 "Order.ag" #-}
                                 [con_]
                                 {-# LINE 3640 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 529, column 16)
                            _typeSigsOtypeSigs =
                                ({-# LINE 529 "Order.ag" #-}
                                 Map.empty
                                 {-# LINE 3646 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 535, column 17)
                            _rulesOallTypeSigs =
                                ({-# LINE 535 "Order.ag" #-}
                                 _typeSigsItypeSigs
                                 {-# LINE 3652 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 603, column 17)
                            _cVisits =
                                ({-# LINE 603 "Order.ag" #-}
                                 if  _lhsIo_dovisit
                                      then let prodsVisitsMap = findWithErr1 "Production.cVisits.nt" _lhsInt _lhsIcVisitsMap
                                               visits = findWithErr1 "Production.cVisits.con" con_ prodsVisitsMap
                                            in visits
                                      else  let  vss = nubBy eqCRuleDefines _gathRules ++ _childrenIsinglevisits
                                            in  [CVisit _lhsIinh _lhsIsyn vss [] False]
                                 {-# LINE 3663 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 629, column 18)
                            _lhsOcProduction =
                                ({-# LINE 629 "Order.ag" #-}
                                 CProduction con_ _cVisits _childrenIfields _childrenIterminals
                                 {-# LINE 3669 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 657, column 16)
                            _allfields =
                                ({-# LINE 657 "Order.ag" #-}
                                 _childrenIfields
                                 {-# LINE 3675 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 657, column 16)
                            _attrs =
                                ({-# LINE 658 "Order.ag" #-}
                                 map ((,) _LOC)  _rulesIlocVars ++
                                 map ((,) _INST) _rulesIinstVars ++
                                 map ((,) _LHS)  _inhnames ++
                                 concat [map ((,) nm) (Map.keys as) | (nm,_,as) <- _childrenIattributes]
                                 {-# LINE 3684 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 657, column 16)
                            _inhnames =
                                ({-# LINE 662 "Order.ag" #-}
                                 Map.keys _lhsIinh
                                 {-# LINE 3690 "Order.hs" #-}
                                 )
                            -- "Order.ag"(line 657, column 16)
                            _synnames =
                                ({-# LINE 663 "Order.ag" #-}
                                 Map.keys _lhsIsyn
                                 {-# LINE 3696 "Order.hs" #-}
                                 )
                            -- use rule "Order.ag"(line 269, column 33)
                            _lhsOdirectDep =
                                ({-# LINE 269 "Order.ag" #-}
                                 _rulesIdirectDep
                                 {-# LINE 3702 "Order.hs" #-}
                                 )
                            -- use rule "Order.ag"(line 84, column 70)
                            _lhsOerrors =
                                ({-# LINE 84 "Order.ag" #-}
                                 _childrenIerrors Seq.>< _rulesIerrors
                                 {-# LINE 3708 "Order.hs" #-}
                                 )
                            -- use rule "Order.ag"(line 312, column 31)
                            _lhsOinstDep =
                                ({-# LINE 312 "Order.ag" #-}
                                 _rulesIinstDep
                                 {-# LINE 3714 "Order.hs" #-}
                                 )
                            -- use rule "Order.ag"(line 61, column 105)
                            _lhsOnAutoRules =
                                ({-# LINE 61 "Order.ag" #-}
                                 _rulesInAutoRules
                                 {-# LINE 3720 "Order.hs" #-}
                                 )
                            -- use rule "Order.ag"(line 61, column 105)
                            _lhsOnExplicitRules =
                                ({-# LINE 61 "Order.ag" #-}
                                 _rulesInExplicitRules
                                 {-# LINE 3726 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _childrenOallfields =
                                ({-# LINE 654 "Order.ag" #-}
                                 _allfields
                                 {-# LINE 3732 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _childrenOallnts =
                                ({-# LINE 647 "Order.ag" #-}
                                 _lhsIallnts
                                 {-# LINE 3738 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _childrenOattrs =
                                ({-# LINE 654 "Order.ag" #-}
                                 _attrs
                                 {-# LINE 3744 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _childrenOinh =
                                ({-# LINE 89 "Order.ag" #-}
                                 _lhsIinh
                                 {-# LINE 3750 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _childrenOmergeMap =
                                ({-# LINE 362 "Order.ag" #-}
                                 _mergeMap
                                 {-# LINE 3756 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _childrenOnt =
                                ({-# LINE 89 "Order.ag" #-}
                                 _lhsInt
                                 {-# LINE 3762 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _childrenOo_unbox =
                                ({-# LINE 119 "Order.ag" #-}
                                 _lhsIo_unbox
                                 {-# LINE 3768 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _childrenOsyn =
                                ({-# LINE 89 "Order.ag" #-}
                                 _lhsIsyn
                                 {-# LINE 3774 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _rulesOallfields =
                                ({-# LINE 654 "Order.ag" #-}
                                 _allfields
                                 {-# LINE 3780 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOallnts =
                                ({-# LINE 647 "Order.ag" #-}
                                 _lhsIallnts
                                 {-# LINE 3786 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _rulesOaltAttrs =
                                ({-# LINE 186 "Order.ag" #-}
                                 _altAttrs
                                 {-# LINE 3792 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _rulesOattrs =
                                ({-# LINE 654 "Order.ag" #-}
                                 _attrs
                                 {-# LINE 3798 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOinh =
                                ({-# LINE 89 "Order.ag" #-}
                                 _lhsIinh
                                 {-# LINE 3804 "Order.hs" #-}
                                 )
                            -- copy rule (from local)
                            _rulesOmergeMap =
                                ({-# LINE 362 "Order.ag" #-}
                                 _mergeMap
                                 {-# LINE 3810 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOnt =
                                ({-# LINE 89 "Order.ag" #-}
                                 _lhsInt
                                 {-# LINE 3816 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_case =
                                ({-# LINE 117 "Order.ag" #-}
                                 _lhsIo_case
                                 {-# LINE 3822 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_cata =
                                ({-# LINE 111 "Order.ag" #-}
                                 _lhsIo_cata
                                 {-# LINE 3828 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_dovisit =
                                ({-# LINE 116 "Order.ag" #-}
                                 _lhsIo_dovisit
                                 {-# LINE 3834 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_newtypes =
                                ({-# LINE 110 "Order.ag" #-}
                                 _lhsIo_newtypes
                                 {-# LINE 3840 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_rename =
                                ({-# LINE 114 "Order.ag" #-}
                                 _lhsIo_rename
                                 {-# LINE 3846 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_sem =
                                ({-# LINE 113 "Order.ag" #-}
                                 _lhsIo_sem
                                 {-# LINE 3852 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_sig =
                                ({-# LINE 112 "Order.ag" #-}
                                 _lhsIo_sig
                                 {-# LINE 3858 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOo_wantvisit =
                                ({-# LINE 115 "Order.ag" #-}
                                 _lhsIo_wantvisit
                                 {-# LINE 3864 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOprefix =
                                ({-# LINE 118 "Order.ag" #-}
                                 _lhsIprefix
                                 {-# LINE 3870 "Order.hs" #-}
                                 )
                            -- copy rule (down)
                            _rulesOsyn =
                                ({-# LINE 89 "Order.ag" #-}
                                 _lhsIsyn
                                 {-# LINE 3876 "Order.hs" #-}
                                 )
                            ( _childrenIattributes,_childrenIcollectChildrenInhs,_childrenIcollectChildrenSyns,_childrenIerrors,_childrenIfields,_childrenIgathAltAttrs,_childrenIgathRules,_childrenIinhs,_childrenInts,_childrenIsinglevisits,_childrenIterminals) =
                                children_ _childrenOallfields _childrenOallnts _childrenOattrs _childrenOcon _childrenOinh _childrenOmergeMap _childrenOnt _childrenOo_unbox _childrenOsyn 
                            ( _rulesIdirectDep,_rulesIerrors,_rulesIgathAltAttrs,_rulesIgathRules,_rulesIinstDep,_rulesIinstVars,_rulesIlocVars,_rulesInAutoRules,_rulesInExplicitRules) =
                                rules_ _rulesOallTypeSigs _rulesOallfields _rulesOallnts _rulesOaltAttrs _rulesOattrs _rulesOchildInhs _rulesOchildNts _rulesOcon _rulesOinh _rulesOinhsOfChildren _rulesOmergeMap _rulesOnt _rulesOo_case _rulesOo_cata _rulesOo_dovisit _rulesOo_newtypes _rulesOo_rename _rulesOo_sem _rulesOo_sig _rulesOo_wantvisit _rulesOprefix _rulesOsyn _rulesOsynsOfChildren 
                            ( _typeSigsItypeSigs) =
                                typeSigs_ _typeSigsOtypeSigs 
                        in  ( _lhsOadditionalDep,_lhsOaroundDep,_lhsOcProduction,_lhsOcons,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOrules,_lhsOvcount))) )
-- Productions -------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allnts               : [Identifier]
         aroundMap            : Map ConstructorIdent (Map Identifier [Expression])
         cVisitsMap           : CVisitsMap
         inh                  : Attributes
         manualAttrDepMap     : AttrOrderMap
         mergeMap             : Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))
         nt                   : Identifier
         o_case               : Bool
         o_cata               : Bool
         o_dovisit            : Bool
         o_newtypes           : Bool
         o_rename             : Bool
         o_sem                : Bool
         o_sig                : Bool
         o_unbox              : Bool
         o_wantvisit          : Bool
         prefix               : String
         syn                  : Attributes
      chained attribute:
         vcount               : Int
      synthesized attributes:
         additionalDep        : Seq Edge
         aroundDep            : Seq Edge
         cProductions         : CProductions
         cons                 : [ConstructorIdent]
         directDep            : Seq Edge
         errors               : Seq Error
         instDep              : Seq Edge
         mergeDep             : Seq Edge
         nAutoRules           : Int
         nExplicitRules       : Int
         rules                : Seq (Vertex,CRule)
   alternatives:
      alternative Cons:
         child hd             : Production 
         child tl             : Productions 
      alternative Nil:
-}
-- cata
sem_Productions :: Productions  ->
                   T_Productions 
sem_Productions list  =
    (Prelude.foldr sem_Productions_Cons sem_Productions_Nil (Prelude.map sem_Production list) )
-- semantic domain
newtype T_Productions  = T_Productions (([Identifier]) ->
                                        (Map ConstructorIdent (Map Identifier [Expression])) ->
                                        CVisitsMap ->
                                        Attributes ->
                                        AttrOrderMap ->
                                        (Map ConstructorIdent (Map Identifier (Identifier,[Identifier]))) ->
                                        Identifier ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        Bool ->
                                        String ->
                                        Attributes ->
                                        Int ->
                                        ( (Seq Edge),(Seq Edge),CProductions,([ConstructorIdent]),(Seq Edge),(Seq Error),(Seq Edge),(Seq Edge),Int,Int,(Seq (Vertex,CRule)),Int))
data Inh_Productions  = Inh_Productions {allnts_Inh_Productions :: !(([Identifier])),aroundMap_Inh_Productions :: !((Map ConstructorIdent (Map Identifier [Expression]))),cVisitsMap_Inh_Productions :: !(CVisitsMap),inh_Inh_Productions :: !(Attributes),manualAttrDepMap_Inh_Productions :: !(AttrOrderMap),mergeMap_Inh_Productions :: !((Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))),nt_Inh_Productions :: !(Identifier),o_case_Inh_Productions :: !(Bool),o_cata_Inh_Productions :: !(Bool),o_dovisit_Inh_Productions :: !(Bool),o_newtypes_Inh_Productions :: !(Bool),o_rename_Inh_Productions :: !(Bool),o_sem_Inh_Productions :: !(Bool),o_sig_Inh_Productions :: !(Bool),o_unbox_Inh_Productions :: !(Bool),o_wantvisit_Inh_Productions :: !(Bool),prefix_Inh_Productions :: !(String),syn_Inh_Productions :: !(Attributes),vcount_Inh_Productions :: !(Int)}
data Syn_Productions  = Syn_Productions {additionalDep_Syn_Productions :: !((Seq Edge)),aroundDep_Syn_Productions :: !((Seq Edge)),cProductions_Syn_Productions :: !(CProductions),cons_Syn_Productions :: !(([ConstructorIdent])),directDep_Syn_Productions :: !((Seq Edge)),errors_Syn_Productions :: !((Seq Error)),instDep_Syn_Productions :: !((Seq Edge)),mergeDep_Syn_Productions :: !((Seq Edge)),nAutoRules_Syn_Productions :: !(Int),nExplicitRules_Syn_Productions :: !(Int),rules_Syn_Productions :: !((Seq (Vertex,CRule))),vcount_Syn_Productions :: !(Int)}
wrap_Productions :: T_Productions  ->
                    Inh_Productions  ->
                    Syn_Productions 
wrap_Productions (T_Productions sem ) (Inh_Productions _lhsIallnts _lhsIaroundMap _lhsIcVisitsMap _lhsIinh _lhsImanualAttrDepMap _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIvcount )  =
    (let ( _lhsOadditionalDep,_lhsOaroundDep,_lhsOcProductions,_lhsOcons,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOrules,_lhsOvcount) = sem _lhsIallnts _lhsIaroundMap _lhsIcVisitsMap _lhsIinh _lhsImanualAttrDepMap _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_unbox _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIvcount 
     in  (Syn_Productions _lhsOadditionalDep _lhsOaroundDep _lhsOcProductions _lhsOcons _lhsOdirectDep _lhsOerrors _lhsOinstDep _lhsOmergeDep _lhsOnAutoRules _lhsOnExplicitRules _lhsOrules _lhsOvcount ))
sem_Productions_Cons :: T_Production  ->
                        T_Productions  ->
                        T_Productions 
sem_Productions_Cons (T_Production hd_ ) (T_Productions tl_ )  =
    (T_Productions (\ _lhsIallnts
                      _lhsIaroundMap
                      _lhsIcVisitsMap
                      _lhsIinh
                      _lhsImanualAttrDepMap
                      _lhsImergeMap
                      _lhsInt
                      _lhsIo_case
                      _lhsIo_cata
                      _lhsIo_dovisit
                      _lhsIo_newtypes
                      _lhsIo_rename
                      _lhsIo_sem
                      _lhsIo_sig
                      _lhsIo_unbox
                      _lhsIo_wantvisit
                      _lhsIprefix
                      _lhsIsyn
                      _lhsIvcount ->
                        (let _lhsOcProductions :: CProductions
                             _lhsOadditionalDep :: (Seq Edge)
                             _lhsOaroundDep :: (Seq Edge)
                             _lhsOcons :: ([ConstructorIdent])
                             _lhsOdirectDep :: (Seq Edge)
                             _lhsOerrors :: (Seq Error)
                             _lhsOinstDep :: (Seq Edge)
                             _lhsOmergeDep :: (Seq Edge)
                             _lhsOnAutoRules :: Int
                             _lhsOnExplicitRules :: Int
                             _lhsOrules :: (Seq (Vertex,CRule))
                             _lhsOvcount :: Int
                             _hdOallnts :: ([Identifier])
                             _hdOaroundMap :: (Map ConstructorIdent (Map Identifier [Expression]))
                             _hdOcVisitsMap :: CVisitsMap
                             _hdOinh :: Attributes
                             _hdOmanualAttrDepMap :: AttrOrderMap
                             _hdOmergeMap :: (Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))
                             _hdOnt :: Identifier
                             _hdOo_case :: Bool
                             _hdOo_cata :: Bool
                             _hdOo_dovisit :: Bool
                             _hdOo_newtypes :: Bool
                             _hdOo_rename :: Bool
                             _hdOo_sem :: Bool
                             _hdOo_sig :: Bool
                             _hdOo_unbox :: Bool
                             _hdOo_wantvisit :: Bool
                             _hdOprefix :: String
                             _hdOsyn :: Attributes
                             _hdOvcount :: Int
                             _tlOallnts :: ([Identifier])
                             _tlOaroundMap :: (Map ConstructorIdent (Map Identifier [Expression]))
                             _tlOcVisitsMap :: CVisitsMap
                             _tlOinh :: Attributes
                             _tlOmanualAttrDepMap :: AttrOrderMap
                             _tlOmergeMap :: (Map ConstructorIdent (Map Identifier (Identifier,[Identifier])))
                             _tlOnt :: Identifier
                             _tlOo_case :: Bool
                             _tlOo_cata :: Bool
                             _tlOo_dovisit :: Bool
                             _tlOo_newtypes :: Bool
                             _tlOo_rename :: Bool
                             _tlOo_sem :: Bool
                             _tlOo_sig :: Bool
                             _tlOo_unbox :: Bool
                             _tlOo_wantvisit :: Bool
                             _tlOprefix :: String
                             _tlOsyn :: Attributes
                             _tlOvcount :: Int
                             _hdIadditionalDep :: (Seq Edge)
                             _hdIaroundDep :: (Seq Edge)
                             _hdIcProduction :: CProduction
                             _hdIcons :: ([ConstructorIdent])
                             _hdIdirectDep :: (Seq Edge)
                             _hdIerrors :: (Seq Error)
                             _hdIinstDep :: (Seq Edge)
                             _hdImergeDep :: (Seq Edge)
                             _hdInAutoRules :: Int
                             _hdInExplicitRules :: Int
                             _hdIrules :: (Seq (Vertex,CRule))
                             _hdIvcount :: Int
                             _tlIadditionalDep :: (Seq Edge)
                             _tlIaroundDep :: (Seq Edge)
                             _tlIcProductions :: CProductions
                             _tlIcons :: ([ConstructorIdent])
                             _tlIdirectDep :: (Seq Edge)
                             _tlIerrors :: (Seq Error)
                             _tlIinstDep :: (Seq Edge)
                             _tlImergeDep :: (Seq Edge)
                             _tlInAutoRules :: Int
                             _tlInExplicitRules :: Int
                             _tlIrules :: (Seq (Vertex,CRule))
                             _tlIvcount :: Int
                             -- "Order.ag"(line 626, column 12)
                             _lhsOcProductions =
                                 ({-# LINE 626 "Order.ag" #-}
                                  _hdIcProduction : _tlIcProductions
                                  {-# LINE 4062 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 283, column 60)
                             _lhsOadditionalDep =
                                 ({-# LINE 283 "Order.ag" #-}
                                  _hdIadditionalDep Seq.>< _tlIadditionalDep
                                  {-# LINE 4068 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 404, column 24)
                             _lhsOaroundDep =
                                 ({-# LINE 404 "Order.ag" #-}
                                  _hdIaroundDep Seq.>< _tlIaroundDep
                                  {-# LINE 4074 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 520, column 40)
                             _lhsOcons =
                                 ({-# LINE 520 "Order.ag" #-}
                                  _hdIcons ++ _tlIcons
                                  {-# LINE 4080 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 269, column 33)
                             _lhsOdirectDep =
                                 ({-# LINE 269 "Order.ag" #-}
                                  _hdIdirectDep Seq.>< _tlIdirectDep
                                  {-# LINE 4086 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 84, column 70)
                             _lhsOerrors =
                                 ({-# LINE 84 "Order.ag" #-}
                                  _hdIerrors Seq.>< _tlIerrors
                                  {-# LINE 4092 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 312, column 31)
                             _lhsOinstDep =
                                 ({-# LINE 312 "Order.ag" #-}
                                  _hdIinstDep Seq.>< _tlIinstDep
                                  {-# LINE 4098 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 367, column 18)
                             _lhsOmergeDep =
                                 ({-# LINE 367 "Order.ag" #-}
                                  _hdImergeDep Seq.>< _tlImergeDep
                                  {-# LINE 4104 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 61, column 105)
                             _lhsOnAutoRules =
                                 ({-# LINE 61 "Order.ag" #-}
                                  _hdInAutoRules + _tlInAutoRules
                                  {-# LINE 4110 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 61, column 105)
                             _lhsOnExplicitRules =
                                 ({-# LINE 61 "Order.ag" #-}
                                  _hdInExplicitRules + _tlInExplicitRules
                                  {-# LINE 4116 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 259, column 18)
                             _lhsOrules =
                                 ({-# LINE 259 "Order.ag" #-}
                                  _hdIrules Seq.>< _tlIrules
                                  {-# LINE 4122 "Order.hs" #-}
                                  )
                             -- copy rule (up)
                             _lhsOvcount =
                                 ({-# LINE 258 "Order.ag" #-}
                                  _tlIvcount
                                  {-# LINE 4128 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOallnts =
                                 ({-# LINE 647 "Order.ag" #-}
                                  _lhsIallnts
                                  {-# LINE 4134 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOaroundMap =
                                 ({-# LINE 410 "Order.ag" #-}
                                  _lhsIaroundMap
                                  {-# LINE 4140 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOcVisitsMap =
                                 ({-# LINE 601 "Order.ag" #-}
                                  _lhsIcVisitsMap
                                  {-# LINE 4146 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOinh =
                                 ({-# LINE 89 "Order.ag" #-}
                                  _lhsIinh
                                  {-# LINE 4152 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOmanualAttrDepMap =
                                 ({-# LINE 283 "Order.ag" #-}
                                  _lhsImanualAttrDepMap
                                  {-# LINE 4158 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOmergeMap =
                                 ({-# LINE 357 "Order.ag" #-}
                                  _lhsImergeMap
                                  {-# LINE 4164 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOnt =
                                 ({-# LINE 89 "Order.ag" #-}
                                  _lhsInt
                                  {-# LINE 4170 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_case =
                                 ({-# LINE 117 "Order.ag" #-}
                                  _lhsIo_case
                                  {-# LINE 4176 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_cata =
                                 ({-# LINE 111 "Order.ag" #-}
                                  _lhsIo_cata
                                  {-# LINE 4182 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_dovisit =
                                 ({-# LINE 116 "Order.ag" #-}
                                  _lhsIo_dovisit
                                  {-# LINE 4188 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_newtypes =
                                 ({-# LINE 110 "Order.ag" #-}
                                  _lhsIo_newtypes
                                  {-# LINE 4194 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_rename =
                                 ({-# LINE 114 "Order.ag" #-}
                                  _lhsIo_rename
                                  {-# LINE 4200 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_sem =
                                 ({-# LINE 113 "Order.ag" #-}
                                  _lhsIo_sem
                                  {-# LINE 4206 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_sig =
                                 ({-# LINE 112 "Order.ag" #-}
                                  _lhsIo_sig
                                  {-# LINE 4212 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_unbox =
                                 ({-# LINE 119 "Order.ag" #-}
                                  _lhsIo_unbox
                                  {-# LINE 4218 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOo_wantvisit =
                                 ({-# LINE 115 "Order.ag" #-}
                                  _lhsIo_wantvisit
                                  {-# LINE 4224 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOprefix =
                                 ({-# LINE 118 "Order.ag" #-}
                                  _lhsIprefix
                                  {-# LINE 4230 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOsyn =
                                 ({-# LINE 89 "Order.ag" #-}
                                  _lhsIsyn
                                  {-# LINE 4236 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _hdOvcount =
                                 ({-# LINE 258 "Order.ag" #-}
                                  _lhsIvcount
                                  {-# LINE 4242 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOallnts =
                                 ({-# LINE 647 "Order.ag" #-}
                                  _lhsIallnts
                                  {-# LINE 4248 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOaroundMap =
                                 ({-# LINE 410 "Order.ag" #-}
                                  _lhsIaroundMap
                                  {-# LINE 4254 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOcVisitsMap =
                                 ({-# LINE 601 "Order.ag" #-}
                                  _lhsIcVisitsMap
                                  {-# LINE 4260 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOinh =
                                 ({-# LINE 89 "Order.ag" #-}
                                  _lhsIinh
                                  {-# LINE 4266 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOmanualAttrDepMap =
                                 ({-# LINE 283 "Order.ag" #-}
                                  _lhsImanualAttrDepMap
                                  {-# LINE 4272 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOmergeMap =
                                 ({-# LINE 357 "Order.ag" #-}
                                  _lhsImergeMap
                                  {-# LINE 4278 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOnt =
                                 ({-# LINE 89 "Order.ag" #-}
                                  _lhsInt
                                  {-# LINE 4284 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_case =
                                 ({-# LINE 117 "Order.ag" #-}
                                  _lhsIo_case
                                  {-# LINE 4290 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_cata =
                                 ({-# LINE 111 "Order.ag" #-}
                                  _lhsIo_cata
                                  {-# LINE 4296 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_dovisit =
                                 ({-# LINE 116 "Order.ag" #-}
                                  _lhsIo_dovisit
                                  {-# LINE 4302 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_newtypes =
                                 ({-# LINE 110 "Order.ag" #-}
                                  _lhsIo_newtypes
                                  {-# LINE 4308 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_rename =
                                 ({-# LINE 114 "Order.ag" #-}
                                  _lhsIo_rename
                                  {-# LINE 4314 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_sem =
                                 ({-# LINE 113 "Order.ag" #-}
                                  _lhsIo_sem
                                  {-# LINE 4320 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_sig =
                                 ({-# LINE 112 "Order.ag" #-}
                                  _lhsIo_sig
                                  {-# LINE 4326 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_unbox =
                                 ({-# LINE 119 "Order.ag" #-}
                                  _lhsIo_unbox
                                  {-# LINE 4332 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOo_wantvisit =
                                 ({-# LINE 115 "Order.ag" #-}
                                  _lhsIo_wantvisit
                                  {-# LINE 4338 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOprefix =
                                 ({-# LINE 118 "Order.ag" #-}
                                  _lhsIprefix
                                  {-# LINE 4344 "Order.hs" #-}
                                  )
                             -- copy rule (down)
                             _tlOsyn =
                                 ({-# LINE 89 "Order.ag" #-}
                                  _lhsIsyn
                                  {-# LINE 4350 "Order.hs" #-}
                                  )
                             -- copy rule (chain)
                             _tlOvcount =
                                 ({-# LINE 258 "Order.ag" #-}
                                  _hdIvcount
                                  {-# LINE 4356 "Order.hs" #-}
                                  )
                             ( _hdIadditionalDep,_hdIaroundDep,_hdIcProduction,_hdIcons,_hdIdirectDep,_hdIerrors,_hdIinstDep,_hdImergeDep,_hdInAutoRules,_hdInExplicitRules,_hdIrules,_hdIvcount) =
                                 hd_ _hdOallnts _hdOaroundMap _hdOcVisitsMap _hdOinh _hdOmanualAttrDepMap _hdOmergeMap _hdOnt _hdOo_case _hdOo_cata _hdOo_dovisit _hdOo_newtypes _hdOo_rename _hdOo_sem _hdOo_sig _hdOo_unbox _hdOo_wantvisit _hdOprefix _hdOsyn _hdOvcount 
                             ( _tlIadditionalDep,_tlIaroundDep,_tlIcProductions,_tlIcons,_tlIdirectDep,_tlIerrors,_tlIinstDep,_tlImergeDep,_tlInAutoRules,_tlInExplicitRules,_tlIrules,_tlIvcount) =
                                 tl_ _tlOallnts _tlOaroundMap _tlOcVisitsMap _tlOinh _tlOmanualAttrDepMap _tlOmergeMap _tlOnt _tlOo_case _tlOo_cata _tlOo_dovisit _tlOo_newtypes _tlOo_rename _tlOo_sem _tlOo_sig _tlOo_unbox _tlOo_wantvisit _tlOprefix _tlOsyn _tlOvcount 
                         in  ( _lhsOadditionalDep,_lhsOaroundDep,_lhsOcProductions,_lhsOcons,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOrules,_lhsOvcount))) )
sem_Productions_Nil :: T_Productions 
sem_Productions_Nil  =
    (T_Productions (\ _lhsIallnts
                      _lhsIaroundMap
                      _lhsIcVisitsMap
                      _lhsIinh
                      _lhsImanualAttrDepMap
                      _lhsImergeMap
                      _lhsInt
                      _lhsIo_case
                      _lhsIo_cata
                      _lhsIo_dovisit
                      _lhsIo_newtypes
                      _lhsIo_rename
                      _lhsIo_sem
                      _lhsIo_sig
                      _lhsIo_unbox
                      _lhsIo_wantvisit
                      _lhsIprefix
                      _lhsIsyn
                      _lhsIvcount ->
                        (let _lhsOcProductions :: CProductions
                             _lhsOadditionalDep :: (Seq Edge)
                             _lhsOaroundDep :: (Seq Edge)
                             _lhsOcons :: ([ConstructorIdent])
                             _lhsOdirectDep :: (Seq Edge)
                             _lhsOerrors :: (Seq Error)
                             _lhsOinstDep :: (Seq Edge)
                             _lhsOmergeDep :: (Seq Edge)
                             _lhsOnAutoRules :: Int
                             _lhsOnExplicitRules :: Int
                             _lhsOrules :: (Seq (Vertex,CRule))
                             _lhsOvcount :: Int
                             -- "Order.ag"(line 627, column 12)
                             _lhsOcProductions =
                                 ({-# LINE 627 "Order.ag" #-}
                                  []
                                  {-# LINE 4400 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 283, column 60)
                             _lhsOadditionalDep =
                                 ({-# LINE 283 "Order.ag" #-}
                                  Seq.empty
                                  {-# LINE 4406 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 404, column 24)
                             _lhsOaroundDep =
                                 ({-# LINE 404 "Order.ag" #-}
                                  Seq.empty
                                  {-# LINE 4412 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 520, column 40)
                             _lhsOcons =
                                 ({-# LINE 520 "Order.ag" #-}
                                  []
                                  {-# LINE 4418 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 269, column 33)
                             _lhsOdirectDep =
                                 ({-# LINE 269 "Order.ag" #-}
                                  Seq.empty
                                  {-# LINE 4424 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 84, column 70)
                             _lhsOerrors =
                                 ({-# LINE 84 "Order.ag" #-}
                                  Seq.empty
                                  {-# LINE 4430 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 312, column 31)
                             _lhsOinstDep =
                                 ({-# LINE 312 "Order.ag" #-}
                                  Seq.empty
                                  {-# LINE 4436 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 367, column 18)
                             _lhsOmergeDep =
                                 ({-# LINE 367 "Order.ag" #-}
                                  Seq.empty
                                  {-# LINE 4442 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 61, column 105)
                             _lhsOnAutoRules =
                                 ({-# LINE 61 "Order.ag" #-}
                                  0
                                  {-# LINE 4448 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 61, column 105)
                             _lhsOnExplicitRules =
                                 ({-# LINE 61 "Order.ag" #-}
                                  0
                                  {-# LINE 4454 "Order.hs" #-}
                                  )
                             -- use rule "Order.ag"(line 259, column 18)
                             _lhsOrules =
                                 ({-# LINE 259 "Order.ag" #-}
                                  Seq.empty
                                  {-# LINE 4460 "Order.hs" #-}
                                  )
                             -- copy rule (chain)
                             _lhsOvcount =
                                 ({-# LINE 258 "Order.ag" #-}
                                  _lhsIvcount
                                  {-# LINE 4466 "Order.hs" #-}
                                  )
                         in  ( _lhsOadditionalDep,_lhsOaroundDep,_lhsOcProductions,_lhsOcons,_lhsOdirectDep,_lhsOerrors,_lhsOinstDep,_lhsOmergeDep,_lhsOnAutoRules,_lhsOnExplicitRules,_lhsOrules,_lhsOvcount))) )
-- Rule --------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allTypeSigs          : Map Identifier Type
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         altAttrs             : Map AltAttr Vertex
         attrs                : [(Identifier,Identifier)]
         childInhs            : Map Identifier Attributes
         childNts             : Map Identifier NontermIdent
         con                  : Identifier
         inh                  : Attributes
         inhsOfChildren       : Map Identifier Attributes
         mergeMap             : Map Identifier (Identifier,[Identifier])
         nt                   : Identifier
         o_case               : Bool
         o_cata               : Bool
         o_dovisit            : Bool
         o_newtypes           : Bool
         o_rename             : Bool
         o_sem                : Bool
         o_sig                : Bool
         o_wantvisit          : Bool
         prefix               : String
         syn                  : Attributes
         synsOfChildren       : Map Identifier Attributes
      synthesized attributes:
         directDep            : Seq Edge
         errors               : Seq Error
         gathAltAttrs         : [AltAttr]
         gathRules            : Seq CRule
         instDep              : Seq Edge
         instVars             : [Identifier]
         locVars              : [Identifier]
         nAutoRules           : Int
         nExplicitRules       : Int
   alternatives:
      alternative Rule:
         child mbName         : {Maybe Identifier}
         child pattern        : Pattern 
         child rhs            : Expression 
         child owrt           : {Bool}
         child origin         : {String}
         child explicit       : {Bool}
         visit 0:
            local defines     : _
            local gathRules   : _
            local instDep1    : _
            local instDep2    : _
-}
-- cata
sem_Rule :: Rule  ->
            T_Rule 
sem_Rule (Rule _mbName _pattern _rhs _owrt _origin _explicit )  =
    (sem_Rule_Rule _mbName (sem_Pattern _pattern ) (sem_Expression _rhs ) _owrt _origin _explicit )
-- semantic domain
newtype T_Rule  = T_Rule ((Map Identifier Type) ->
                          ([(Identifier,Type,Maybe (Maybe Type))]) ->
                          ([Identifier]) ->
                          (Map AltAttr Vertex) ->
                          ([(Identifier,Identifier)]) ->
                          (Map Identifier Attributes) ->
                          (Map Identifier NontermIdent) ->
                          Identifier ->
                          Attributes ->
                          (Map Identifier Attributes) ->
                          (Map Identifier (Identifier,[Identifier])) ->
                          Identifier ->
                          Bool ->
                          Bool ->
                          Bool ->
                          Bool ->
                          Bool ->
                          Bool ->
                          Bool ->
                          Bool ->
                          String ->
                          Attributes ->
                          (Map Identifier Attributes) ->
                          ( (Seq Edge),(Seq Error),([AltAttr]),(Seq CRule),(Seq Edge),([Identifier]),([Identifier]),Int,Int))
data Inh_Rule  = Inh_Rule {allTypeSigs_Inh_Rule :: !((Map Identifier Type)),allfields_Inh_Rule :: !(([(Identifier,Type,Maybe (Maybe Type))])),allnts_Inh_Rule :: !(([Identifier])),altAttrs_Inh_Rule :: !((Map AltAttr Vertex)),attrs_Inh_Rule :: !(([(Identifier,Identifier)])),childInhs_Inh_Rule :: !((Map Identifier Attributes)),childNts_Inh_Rule :: !((Map Identifier NontermIdent)),con_Inh_Rule :: !(Identifier),inh_Inh_Rule :: !(Attributes),inhsOfChildren_Inh_Rule :: !((Map Identifier Attributes)),mergeMap_Inh_Rule :: !((Map Identifier (Identifier,[Identifier]))),nt_Inh_Rule :: !(Identifier),o_case_Inh_Rule :: !(Bool),o_cata_Inh_Rule :: !(Bool),o_dovisit_Inh_Rule :: !(Bool),o_newtypes_Inh_Rule :: !(Bool),o_rename_Inh_Rule :: !(Bool),o_sem_Inh_Rule :: !(Bool),o_sig_Inh_Rule :: !(Bool),o_wantvisit_Inh_Rule :: !(Bool),prefix_Inh_Rule :: !(String),syn_Inh_Rule :: !(Attributes),synsOfChildren_Inh_Rule :: !((Map Identifier Attributes))}
data Syn_Rule  = Syn_Rule {directDep_Syn_Rule :: !((Seq Edge)),errors_Syn_Rule :: !((Seq Error)),gathAltAttrs_Syn_Rule :: !(([AltAttr])),gathRules_Syn_Rule :: !((Seq CRule)),instDep_Syn_Rule :: !((Seq Edge)),instVars_Syn_Rule :: !(([Identifier])),locVars_Syn_Rule :: !(([Identifier])),nAutoRules_Syn_Rule :: !(Int),nExplicitRules_Syn_Rule :: !(Int)}
wrap_Rule :: T_Rule  ->
             Inh_Rule  ->
             Syn_Rule 
wrap_Rule (T_Rule sem ) (Inh_Rule _lhsIallTypeSigs _lhsIallfields _lhsIallnts _lhsIaltAttrs _lhsIattrs _lhsIchildInhs _lhsIchildNts _lhsIcon _lhsIinh _lhsIinhsOfChildren _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIsynsOfChildren )  =
    (let ( _lhsOdirectDep,_lhsOerrors,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinstDep,_lhsOinstVars,_lhsOlocVars,_lhsOnAutoRules,_lhsOnExplicitRules) = sem _lhsIallTypeSigs _lhsIallfields _lhsIallnts _lhsIaltAttrs _lhsIattrs _lhsIchildInhs _lhsIchildNts _lhsIcon _lhsIinh _lhsIinhsOfChildren _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIsynsOfChildren 
     in  (Syn_Rule _lhsOdirectDep _lhsOerrors _lhsOgathAltAttrs _lhsOgathRules _lhsOinstDep _lhsOinstVars _lhsOlocVars _lhsOnAutoRules _lhsOnExplicitRules ))
sem_Rule_Rule :: (Maybe Identifier) ->
                 T_Pattern  ->
                 T_Expression  ->
                 Bool ->
                 String ->
                 Bool ->
                 T_Rule 
sem_Rule_Rule mbName_ (T_Pattern pattern_ ) (T_Expression rhs_ ) owrt_ origin_ explicit_  =
    (T_Rule (\ _lhsIallTypeSigs
               _lhsIallfields
               _lhsIallnts
               _lhsIaltAttrs
               _lhsIattrs
               _lhsIchildInhs
               _lhsIchildNts
               _lhsIcon
               _lhsIinh
               _lhsIinhsOfChildren
               _lhsImergeMap
               _lhsInt
               _lhsIo_case
               _lhsIo_cata
               _lhsIo_dovisit
               _lhsIo_newtypes
               _lhsIo_rename
               _lhsIo_sem
               _lhsIo_sig
               _lhsIo_wantvisit
               _lhsIprefix
               _lhsIsyn
               _lhsIsynsOfChildren ->
                 (let _lhsOnExplicitRules :: Int
                      _lhsOnAutoRules :: Int
                      _lhsOdirectDep :: (Seq Edge)
                      _lhsOinstDep :: (Seq Edge)
                      _lhsOerrors :: (Seq Error)
                      _lhsOgathAltAttrs :: ([AltAttr])
                      _lhsOgathRules :: (Seq CRule)
                      _lhsOinstVars :: ([Identifier])
                      _lhsOlocVars :: ([Identifier])
                      _patternOallTypeSigs :: (Map Identifier Type)
                      _patternOaltAttrs :: (Map AltAttr Vertex)
                      _patternOcon :: Identifier
                      _patternOinh :: Attributes
                      _patternOnt :: Identifier
                      _patternOsyn :: Attributes
                      _rhsOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                      _rhsOallnts :: ([Identifier])
                      _rhsOattrs :: ([(Identifier,Identifier)])
                      _rhsOcon :: Identifier
                      _rhsOmergeMap :: (Map Identifier (Identifier,[Identifier]))
                      _rhsOnt :: Identifier
                      _patternIcopy :: Pattern 
                      _patternIerrors :: (Seq Error)
                      _patternIgathAltAttrs :: ([AltAttr])
                      _patternIinstVars :: ([Identifier])
                      _patternIlocVars :: ([Identifier])
                      _patternIpatternAttrs :: ([(Identifier,Identifier,Bool,Patterns)])
                      _rhsIallRhsVars :: (Set (Identifier,Identifier))
                      _rhsIcopy :: Expression 
                      _rhsIerrors :: (Seq Error)
                      _rhsItextLines :: ([String])
                      _rhsIusedAttrs :: ([(Identifier,Identifier)])
                      _rhsIusedFields :: ([Identifier])
                      _rhsIusedLocals :: ([Identifier])
                      -- "Order.ag"(line 64, column 11)
                      _lhsOnExplicitRules =
                          ({-# LINE 64 "Order.ag" #-}
                           if explicit_
                           then 1
                           else 0
                           {-# LINE 4629 "Order.hs" #-}
                           )
                      -- "Order.ag"(line 67, column 11)
                      _lhsOnAutoRules =
                          ({-# LINE 67 "Order.ag" #-}
                           if startsWith "use rule" origin_ || startsWith "copy rule" origin_
                           then 1
                           else 0
                           {-# LINE 4637 "Order.hs" #-}
                           )
                      -- "Order.ag"(line 217, column 12)
                      _defines =
                          ({-# LINE 217 "Order.ag" #-}
                           let  tp field attr parts | field == _LOC || field == _INST
                                                                    = case parts of
                                                                        [] -> Map.lookup attr _lhsIallTypeSigs
                                                                        _  -> (sequence (map typ parts)) >>= (haskellTupel . map (substSelf _lhsInt))
                                                    | field == _LHS = Map.lookup attr _lhsIsyn
                                                    | otherwise     = Map.lookup attr (findWithErr1 "Rule.defines.tp" field _lhsIchildInhs)
                                typ :: Pattern -> Maybe Type
                                typ (Alias field attr _ parts) = tp field attr parts
                                typ (Underscore _)             = Nothing
                                typ _                          = Nothing
                           in Map.fromList  [ (findWithErr1 "Rule.defines" aa _lhsIaltAttrs, (field,attr,(tp field attr parts)))
                                            | (field,attr,isLocalOrInst,parts) <- _patternIpatternAttrs
                                            , let aa = AltAttr field attr isLocalOrInst
                                            ]
                           {-# LINE 4656 "Order.hs" #-}
                           )
                      -- "Order.ag"(line 233, column 12)
                      _gathRules =
                          ({-# LINE 233 "Order.ag" #-}
                           let childnt field = Map.lookup field _lhsIchildNts
                           in Seq.fromList [ CRule attr False True _lhsInt _lhsIcon field (childnt field) tp _patternIcopy _rhsItextLines _defines owrt_ origin_ _rhsIallRhsVars explicit_ mbName_
                                           | (field,attr,tp) <- Map.elems _defines
                                           ]
                           {-# LINE 4665 "Order.hs" #-}
                           )
                      -- "Order.ag"(line 271, column 12)
                      _lhsOdirectDep =
                          ({-# LINE 271 "Order.ag" #-}
                           let  defined = Map.keys _defines
                                used =  [ Map.lookup (AltAttr field attr True) _lhsIaltAttrs | (field,attr) <- _rhsIusedAttrs]
                                        ++ [ Map.lookup (AltAttr _LOC attr True) _lhsIaltAttrs | attr <- _rhsIusedLocals ++ _rhsIusedFields ]
                           in Seq.fromList [ (x,y) | Just x <- used, y <- defined ]
                           {-# LINE 4674 "Order.hs" #-}
                           )
                      -- "Order.ag"(line 315, column 6)
                      _instDep1 =
                          ({-# LINE 315 "Order.ag" #-}
                           Seq.fromList $
                             [ (instVert, synVert)
                             | (field,instNm,_) <- Map.elems _defines
                             , field == _INST
                             , synNm <- Map.keys (findWithErr2 instNm _lhsIsynsOfChildren)
                             , let instAttr = AltAttr _INST instNm True
                                   synAttr  = AltAttr instNm synNm True
                                   instVert = findWithErr2 instAttr _lhsIaltAttrs
                                   synVert  = findWithErr2 synAttr _lhsIaltAttrs
                             ]
                           {-# LINE 4689 "Order.hs" #-}
                           )
                      -- "Order.ag"(line 326, column 6)
                      _instDep2 =
                          ({-# LINE 326 "Order.ag" #-}
                           Seq.fromList $
                             [ (instVert, inhVert)
                             | (field,instNm,_) <- Map.elems _defines
                             , field == _INST
                             , inhNm <- Map.keys (findWithErr2 instNm _lhsIinhsOfChildren)
                             , let instAttr = AltAttr _INST instNm True
                                   inhAttr  = AltAttr instNm inhNm False
                                   instVert = findWithErr2 instAttr _lhsIaltAttrs
                                   inhVert  = findWithErr2 inhAttr _lhsIaltAttrs
                             ]
                           {-# LINE 4704 "Order.hs" #-}
                           )
                      -- "Order.ag"(line 337, column 6)
                      _lhsOinstDep =
                          ({-# LINE 337 "Order.ag" #-}
                           _instDep1     Seq.>< _instDep2
                           {-# LINE 4710 "Order.hs" #-}
                           )
                      -- use rule "Order.ag"(line 84, column 70)
                      _lhsOerrors =
                          ({-# LINE 84 "Order.ag" #-}
                           _patternIerrors Seq.>< _rhsIerrors
                           {-# LINE 4716 "Order.hs" #-}
                           )
                      -- use rule "Order.ag"(line 170, column 68)
                      _lhsOgathAltAttrs =
                          ({-# LINE 170 "Order.ag" #-}
                           _patternIgathAltAttrs
                           {-# LINE 4722 "Order.hs" #-}
                           )
                      -- use rule "Order.ag"(line 206, column 23)
                      _lhsOgathRules =
                          ({-# LINE 206 "Order.ag" #-}
                           _gathRules
                           {-# LINE 4728 "Order.hs" #-}
                           )
                      -- use rule "Order.ag"(line 677, column 86)
                      _lhsOinstVars =
                          ({-# LINE 677 "Order.ag" #-}
                           _patternIinstVars
                           {-# LINE 4734 "Order.hs" #-}
                           )
                      -- use rule "Order.ag"(line 677, column 48)
                      _lhsOlocVars =
                          ({-# LINE 677 "Order.ag" #-}
                           _patternIlocVars
                           {-# LINE 4740 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _patternOallTypeSigs =
                          ({-# LINE 533 "Order.ag" #-}
                           _lhsIallTypeSigs
                           {-# LINE 4746 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _patternOaltAttrs =
                          ({-# LINE 186 "Order.ag" #-}
                           _lhsIaltAttrs
                           {-# LINE 4752 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _patternOcon =
                          ({-# LINE 90 "Order.ag" #-}
                           _lhsIcon
                           {-# LINE 4758 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _patternOinh =
                          ({-# LINE 89 "Order.ag" #-}
                           _lhsIinh
                           {-# LINE 4764 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _patternOnt =
                          ({-# LINE 89 "Order.ag" #-}
                           _lhsInt
                           {-# LINE 4770 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _patternOsyn =
                          ({-# LINE 89 "Order.ag" #-}
                           _lhsIsyn
                           {-# LINE 4776 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _rhsOallfields =
                          ({-# LINE 448 "Order.ag" #-}
                           _lhsIallfields
                           {-# LINE 4782 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _rhsOallnts =
                          ({-# LINE 449 "Order.ag" #-}
                           _lhsIallnts
                           {-# LINE 4788 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _rhsOattrs =
                          ({-# LINE 450 "Order.ag" #-}
                           _lhsIattrs
                           {-# LINE 4794 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _rhsOcon =
                          ({-# LINE 447 "Order.ag" #-}
                           _lhsIcon
                           {-# LINE 4800 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _rhsOmergeMap =
                          ({-# LINE 362 "Order.ag" #-}
                           _lhsImergeMap
                           {-# LINE 4806 "Order.hs" #-}
                           )
                      -- copy rule (down)
                      _rhsOnt =
                          ({-# LINE 447 "Order.ag" #-}
                           _lhsInt
                           {-# LINE 4812 "Order.hs" #-}
                           )
                      ( _patternIcopy,_patternIerrors,_patternIgathAltAttrs,_patternIinstVars,_patternIlocVars,_patternIpatternAttrs) =
                          pattern_ _patternOallTypeSigs _patternOaltAttrs _patternOcon _patternOinh _patternOnt _patternOsyn 
                      ( _rhsIallRhsVars,_rhsIcopy,_rhsIerrors,_rhsItextLines,_rhsIusedAttrs,_rhsIusedFields,_rhsIusedLocals) =
                          rhs_ _rhsOallfields _rhsOallnts _rhsOattrs _rhsOcon _rhsOmergeMap _rhsOnt 
                  in  ( _lhsOdirectDep,_lhsOerrors,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinstDep,_lhsOinstVars,_lhsOlocVars,_lhsOnAutoRules,_lhsOnExplicitRules))) )
-- Rules -------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allTypeSigs          : Map Identifier Type
         allfields            : [(Identifier,Type,Maybe (Maybe Type))]
         allnts               : [Identifier]
         altAttrs             : Map AltAttr Vertex
         attrs                : [(Identifier,Identifier)]
         childInhs            : Map Identifier Attributes
         childNts             : Map Identifier NontermIdent
         con                  : Identifier
         inh                  : Attributes
         inhsOfChildren       : Map Identifier Attributes
         mergeMap             : Map Identifier (Identifier,[Identifier])
         nt                   : Identifier
         o_case               : Bool
         o_cata               : Bool
         o_dovisit            : Bool
         o_newtypes           : Bool
         o_rename             : Bool
         o_sem                : Bool
         o_sig                : Bool
         o_wantvisit          : Bool
         prefix               : String
         syn                  : Attributes
         synsOfChildren       : Map Identifier Attributes
      synthesized attributes:
         directDep            : Seq Edge
         errors               : Seq Error
         gathAltAttrs         : [AltAttr]
         gathRules            : Seq CRule
         instDep              : Seq Edge
         instVars             : [Identifier]
         locVars              : [Identifier]
         nAutoRules           : Int
         nExplicitRules       : Int
   alternatives:
      alternative Cons:
         child hd             : Rule 
         child tl             : Rules 
      alternative Nil:
-}
-- cata
sem_Rules :: Rules  ->
             T_Rules 
sem_Rules list  =
    (Prelude.foldr sem_Rules_Cons sem_Rules_Nil (Prelude.map sem_Rule list) )
-- semantic domain
newtype T_Rules  = T_Rules ((Map Identifier Type) ->
                            ([(Identifier,Type,Maybe (Maybe Type))]) ->
                            ([Identifier]) ->
                            (Map AltAttr Vertex) ->
                            ([(Identifier,Identifier)]) ->
                            (Map Identifier Attributes) ->
                            (Map Identifier NontermIdent) ->
                            Identifier ->
                            Attributes ->
                            (Map Identifier Attributes) ->
                            (Map Identifier (Identifier,[Identifier])) ->
                            Identifier ->
                            Bool ->
                            Bool ->
                            Bool ->
                            Bool ->
                            Bool ->
                            Bool ->
                            Bool ->
                            Bool ->
                            String ->
                            Attributes ->
                            (Map Identifier Attributes) ->
                            ( (Seq Edge),(Seq Error),([AltAttr]),(Seq CRule),(Seq Edge),([Identifier]),([Identifier]),Int,Int))
data Inh_Rules  = Inh_Rules {allTypeSigs_Inh_Rules :: !((Map Identifier Type)),allfields_Inh_Rules :: !(([(Identifier,Type,Maybe (Maybe Type))])),allnts_Inh_Rules :: !(([Identifier])),altAttrs_Inh_Rules :: !((Map AltAttr Vertex)),attrs_Inh_Rules :: !(([(Identifier,Identifier)])),childInhs_Inh_Rules :: !((Map Identifier Attributes)),childNts_Inh_Rules :: !((Map Identifier NontermIdent)),con_Inh_Rules :: !(Identifier),inh_Inh_Rules :: !(Attributes),inhsOfChildren_Inh_Rules :: !((Map Identifier Attributes)),mergeMap_Inh_Rules :: !((Map Identifier (Identifier,[Identifier]))),nt_Inh_Rules :: !(Identifier),o_case_Inh_Rules :: !(Bool),o_cata_Inh_Rules :: !(Bool),o_dovisit_Inh_Rules :: !(Bool),o_newtypes_Inh_Rules :: !(Bool),o_rename_Inh_Rules :: !(Bool),o_sem_Inh_Rules :: !(Bool),o_sig_Inh_Rules :: !(Bool),o_wantvisit_Inh_Rules :: !(Bool),prefix_Inh_Rules :: !(String),syn_Inh_Rules :: !(Attributes),synsOfChildren_Inh_Rules :: !((Map Identifier Attributes))}
data Syn_Rules  = Syn_Rules {directDep_Syn_Rules :: !((Seq Edge)),errors_Syn_Rules :: !((Seq Error)),gathAltAttrs_Syn_Rules :: !(([AltAttr])),gathRules_Syn_Rules :: !((Seq CRule)),instDep_Syn_Rules :: !((Seq Edge)),instVars_Syn_Rules :: !(([Identifier])),locVars_Syn_Rules :: !(([Identifier])),nAutoRules_Syn_Rules :: !(Int),nExplicitRules_Syn_Rules :: !(Int)}
wrap_Rules :: T_Rules  ->
              Inh_Rules  ->
              Syn_Rules 
wrap_Rules (T_Rules sem ) (Inh_Rules _lhsIallTypeSigs _lhsIallfields _lhsIallnts _lhsIaltAttrs _lhsIattrs _lhsIchildInhs _lhsIchildNts _lhsIcon _lhsIinh _lhsIinhsOfChildren _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIsynsOfChildren )  =
    (let ( _lhsOdirectDep,_lhsOerrors,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinstDep,_lhsOinstVars,_lhsOlocVars,_lhsOnAutoRules,_lhsOnExplicitRules) = sem _lhsIallTypeSigs _lhsIallfields _lhsIallnts _lhsIaltAttrs _lhsIattrs _lhsIchildInhs _lhsIchildNts _lhsIcon _lhsIinh _lhsIinhsOfChildren _lhsImergeMap _lhsInt _lhsIo_case _lhsIo_cata _lhsIo_dovisit _lhsIo_newtypes _lhsIo_rename _lhsIo_sem _lhsIo_sig _lhsIo_wantvisit _lhsIprefix _lhsIsyn _lhsIsynsOfChildren 
     in  (Syn_Rules _lhsOdirectDep _lhsOerrors _lhsOgathAltAttrs _lhsOgathRules _lhsOinstDep _lhsOinstVars _lhsOlocVars _lhsOnAutoRules _lhsOnExplicitRules ))
sem_Rules_Cons :: T_Rule  ->
                  T_Rules  ->
                  T_Rules 
sem_Rules_Cons (T_Rule hd_ ) (T_Rules tl_ )  =
    (T_Rules (\ _lhsIallTypeSigs
                _lhsIallfields
                _lhsIallnts
                _lhsIaltAttrs
                _lhsIattrs
                _lhsIchildInhs
                _lhsIchildNts
                _lhsIcon
                _lhsIinh
                _lhsIinhsOfChildren
                _lhsImergeMap
                _lhsInt
                _lhsIo_case
                _lhsIo_cata
                _lhsIo_dovisit
                _lhsIo_newtypes
                _lhsIo_rename
                _lhsIo_sem
                _lhsIo_sig
                _lhsIo_wantvisit
                _lhsIprefix
                _lhsIsyn
                _lhsIsynsOfChildren ->
                  (let _lhsOdirectDep :: (Seq Edge)
                       _lhsOerrors :: (Seq Error)
                       _lhsOgathAltAttrs :: ([AltAttr])
                       _lhsOgathRules :: (Seq CRule)
                       _lhsOinstDep :: (Seq Edge)
                       _lhsOinstVars :: ([Identifier])
                       _lhsOlocVars :: ([Identifier])
                       _lhsOnAutoRules :: Int
                       _lhsOnExplicitRules :: Int
                       _hdOallTypeSigs :: (Map Identifier Type)
                       _hdOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                       _hdOallnts :: ([Identifier])
                       _hdOaltAttrs :: (Map AltAttr Vertex)
                       _hdOattrs :: ([(Identifier,Identifier)])
                       _hdOchildInhs :: (Map Identifier Attributes)
                       _hdOchildNts :: (Map Identifier NontermIdent)
                       _hdOcon :: Identifier
                       _hdOinh :: Attributes
                       _hdOinhsOfChildren :: (Map Identifier Attributes)
                       _hdOmergeMap :: (Map Identifier (Identifier,[Identifier]))
                       _hdOnt :: Identifier
                       _hdOo_case :: Bool
                       _hdOo_cata :: Bool
                       _hdOo_dovisit :: Bool
                       _hdOo_newtypes :: Bool
                       _hdOo_rename :: Bool
                       _hdOo_sem :: Bool
                       _hdOo_sig :: Bool
                       _hdOo_wantvisit :: Bool
                       _hdOprefix :: String
                       _hdOsyn :: Attributes
                       _hdOsynsOfChildren :: (Map Identifier Attributes)
                       _tlOallTypeSigs :: (Map Identifier Type)
                       _tlOallfields :: ([(Identifier,Type,Maybe (Maybe Type))])
                       _tlOallnts :: ([Identifier])
                       _tlOaltAttrs :: (Map AltAttr Vertex)
                       _tlOattrs :: ([(Identifier,Identifier)])
                       _tlOchildInhs :: (Map Identifier Attributes)
                       _tlOchildNts :: (Map Identifier NontermIdent)
                       _tlOcon :: Identifier
                       _tlOinh :: Attributes
                       _tlOinhsOfChildren :: (Map Identifier Attributes)
                       _tlOmergeMap :: (Map Identifier (Identifier,[Identifier]))
                       _tlOnt :: Identifier
                       _tlOo_case :: Bool
                       _tlOo_cata :: Bool
                       _tlOo_dovisit :: Bool
                       _tlOo_newtypes :: Bool
                       _tlOo_rename :: Bool
                       _tlOo_sem :: Bool
                       _tlOo_sig :: Bool
                       _tlOo_wantvisit :: Bool
                       _tlOprefix :: String
                       _tlOsyn :: Attributes
                       _tlOsynsOfChildren :: (Map Identifier Attributes)
                       _hdIdirectDep :: (Seq Edge)
                       _hdIerrors :: (Seq Error)
                       _hdIgathAltAttrs :: ([AltAttr])
                       _hdIgathRules :: (Seq CRule)
                       _hdIinstDep :: (Seq Edge)
                       _hdIinstVars :: ([Identifier])
                       _hdIlocVars :: ([Identifier])
                       _hdInAutoRules :: Int
                       _hdInExplicitRules :: Int
                       _tlIdirectDep :: (Seq Edge)
                       _tlIerrors :: (Seq Error)
                       _tlIgathAltAttrs :: ([AltAttr])
                       _tlIgathRules :: (Seq CRule)
                       _tlIinstDep :: (Seq Edge)
                       _tlIinstVars :: ([Identifier])
                       _tlIlocVars :: ([Identifier])
                       _tlInAutoRules :: Int
                       _tlInExplicitRules :: Int
                       -- use rule "Order.ag"(line 269, column 33)
                       _lhsOdirectDep =
                           ({-# LINE 269 "Order.ag" #-}
                            _hdIdirectDep Seq.>< _tlIdirectDep
                            {-# LINE 5004 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 84, column 70)
                       _lhsOerrors =
                           ({-# LINE 84 "Order.ag" #-}
                            _hdIerrors Seq.>< _tlIerrors
                            {-# LINE 5010 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 170, column 68)
                       _lhsOgathAltAttrs =
                           ({-# LINE 170 "Order.ag" #-}
                            _hdIgathAltAttrs ++ _tlIgathAltAttrs
                            {-# LINE 5016 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 206, column 23)
                       _lhsOgathRules =
                           ({-# LINE 206 "Order.ag" #-}
                            _hdIgathRules Seq.>< _tlIgathRules
                            {-# LINE 5022 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 312, column 31)
                       _lhsOinstDep =
                           ({-# LINE 312 "Order.ag" #-}
                            _hdIinstDep Seq.>< _tlIinstDep
                            {-# LINE 5028 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 677, column 86)
                       _lhsOinstVars =
                           ({-# LINE 677 "Order.ag" #-}
                            _hdIinstVars ++ _tlIinstVars
                            {-# LINE 5034 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 677, column 48)
                       _lhsOlocVars =
                           ({-# LINE 677 "Order.ag" #-}
                            _hdIlocVars ++ _tlIlocVars
                            {-# LINE 5040 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 61, column 105)
                       _lhsOnAutoRules =
                           ({-# LINE 61 "Order.ag" #-}
                            _hdInAutoRules + _tlInAutoRules
                            {-# LINE 5046 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 61, column 105)
                       _lhsOnExplicitRules =
                           ({-# LINE 61 "Order.ag" #-}
                            _hdInExplicitRules + _tlInExplicitRules
                            {-# LINE 5052 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOallTypeSigs =
                           ({-# LINE 533 "Order.ag" #-}
                            _lhsIallTypeSigs
                            {-# LINE 5058 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOallfields =
                           ({-# LINE 654 "Order.ag" #-}
                            _lhsIallfields
                            {-# LINE 5064 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOallnts =
                           ({-# LINE 647 "Order.ag" #-}
                            _lhsIallnts
                            {-# LINE 5070 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOaltAttrs =
                           ({-# LINE 186 "Order.ag" #-}
                            _lhsIaltAttrs
                            {-# LINE 5076 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOattrs =
                           ({-# LINE 654 "Order.ag" #-}
                            _lhsIattrs
                            {-# LINE 5082 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOchildInhs =
                           ({-# LINE 199 "Order.ag" #-}
                            _lhsIchildInhs
                            {-# LINE 5088 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOchildNts =
                           ({-# LINE 198 "Order.ag" #-}
                            _lhsIchildNts
                            {-# LINE 5094 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOcon =
                           ({-# LINE 90 "Order.ag" #-}
                            _lhsIcon
                            {-# LINE 5100 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOinh =
                           ({-# LINE 89 "Order.ag" #-}
                            _lhsIinh
                            {-# LINE 5106 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOinhsOfChildren =
                           ({-# LINE 339 "Order.ag" #-}
                            _lhsIinhsOfChildren
                            {-# LINE 5112 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOmergeMap =
                           ({-# LINE 362 "Order.ag" #-}
                            _lhsImergeMap
                            {-# LINE 5118 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOnt =
                           ({-# LINE 89 "Order.ag" #-}
                            _lhsInt
                            {-# LINE 5124 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_case =
                           ({-# LINE 117 "Order.ag" #-}
                            _lhsIo_case
                            {-# LINE 5130 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_cata =
                           ({-# LINE 111 "Order.ag" #-}
                            _lhsIo_cata
                            {-# LINE 5136 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_dovisit =
                           ({-# LINE 116 "Order.ag" #-}
                            _lhsIo_dovisit
                            {-# LINE 5142 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_newtypes =
                           ({-# LINE 110 "Order.ag" #-}
                            _lhsIo_newtypes
                            {-# LINE 5148 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_rename =
                           ({-# LINE 114 "Order.ag" #-}
                            _lhsIo_rename
                            {-# LINE 5154 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_sem =
                           ({-# LINE 113 "Order.ag" #-}
                            _lhsIo_sem
                            {-# LINE 5160 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_sig =
                           ({-# LINE 112 "Order.ag" #-}
                            _lhsIo_sig
                            {-# LINE 5166 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOo_wantvisit =
                           ({-# LINE 115 "Order.ag" #-}
                            _lhsIo_wantvisit
                            {-# LINE 5172 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOprefix =
                           ({-# LINE 118 "Order.ag" #-}
                            _lhsIprefix
                            {-# LINE 5178 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOsyn =
                           ({-# LINE 89 "Order.ag" #-}
                            _lhsIsyn
                            {-# LINE 5184 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOsynsOfChildren =
                           ({-# LINE 339 "Order.ag" #-}
                            _lhsIsynsOfChildren
                            {-# LINE 5190 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOallTypeSigs =
                           ({-# LINE 533 "Order.ag" #-}
                            _lhsIallTypeSigs
                            {-# LINE 5196 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOallfields =
                           ({-# LINE 654 "Order.ag" #-}
                            _lhsIallfields
                            {-# LINE 5202 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOallnts =
                           ({-# LINE 647 "Order.ag" #-}
                            _lhsIallnts
                            {-# LINE 5208 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOaltAttrs =
                           ({-# LINE 186 "Order.ag" #-}
                            _lhsIaltAttrs
                            {-# LINE 5214 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOattrs =
                           ({-# LINE 654 "Order.ag" #-}
                            _lhsIattrs
                            {-# LINE 5220 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOchildInhs =
                           ({-# LINE 199 "Order.ag" #-}
                            _lhsIchildInhs
                            {-# LINE 5226 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOchildNts =
                           ({-# LINE 198 "Order.ag" #-}
                            _lhsIchildNts
                            {-# LINE 5232 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOcon =
                           ({-# LINE 90 "Order.ag" #-}
                            _lhsIcon
                            {-# LINE 5238 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOinh =
                           ({-# LINE 89 "Order.ag" #-}
                            _lhsIinh
                            {-# LINE 5244 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOinhsOfChildren =
                           ({-# LINE 339 "Order.ag" #-}
                            _lhsIinhsOfChildren
                            {-# LINE 5250 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOmergeMap =
                           ({-# LINE 362 "Order.ag" #-}
                            _lhsImergeMap
                            {-# LINE 5256 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOnt =
                           ({-# LINE 89 "Order.ag" #-}
                            _lhsInt
                            {-# LINE 5262 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_case =
                           ({-# LINE 117 "Order.ag" #-}
                            _lhsIo_case
                            {-# LINE 5268 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_cata =
                           ({-# LINE 111 "Order.ag" #-}
                            _lhsIo_cata
                            {-# LINE 5274 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_dovisit =
                           ({-# LINE 116 "Order.ag" #-}
                            _lhsIo_dovisit
                            {-# LINE 5280 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_newtypes =
                           ({-# LINE 110 "Order.ag" #-}
                            _lhsIo_newtypes
                            {-# LINE 5286 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_rename =
                           ({-# LINE 114 "Order.ag" #-}
                            _lhsIo_rename
                            {-# LINE 5292 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_sem =
                           ({-# LINE 113 "Order.ag" #-}
                            _lhsIo_sem
                            {-# LINE 5298 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_sig =
                           ({-# LINE 112 "Order.ag" #-}
                            _lhsIo_sig
                            {-# LINE 5304 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOo_wantvisit =
                           ({-# LINE 115 "Order.ag" #-}
                            _lhsIo_wantvisit
                            {-# LINE 5310 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOprefix =
                           ({-# LINE 118 "Order.ag" #-}
                            _lhsIprefix
                            {-# LINE 5316 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOsyn =
                           ({-# LINE 89 "Order.ag" #-}
                            _lhsIsyn
                            {-# LINE 5322 "Order.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOsynsOfChildren =
                           ({-# LINE 339 "Order.ag" #-}
                            _lhsIsynsOfChildren
                            {-# LINE 5328 "Order.hs" #-}
                            )
                       ( _hdIdirectDep,_hdIerrors,_hdIgathAltAttrs,_hdIgathRules,_hdIinstDep,_hdIinstVars,_hdIlocVars,_hdInAutoRules,_hdInExplicitRules) =
                           hd_ _hdOallTypeSigs _hdOallfields _hdOallnts _hdOaltAttrs _hdOattrs _hdOchildInhs _hdOchildNts _hdOcon _hdOinh _hdOinhsOfChildren _hdOmergeMap _hdOnt _hdOo_case _hdOo_cata _hdOo_dovisit _hdOo_newtypes _hdOo_rename _hdOo_sem _hdOo_sig _hdOo_wantvisit _hdOprefix _hdOsyn _hdOsynsOfChildren 
                       ( _tlIdirectDep,_tlIerrors,_tlIgathAltAttrs,_tlIgathRules,_tlIinstDep,_tlIinstVars,_tlIlocVars,_tlInAutoRules,_tlInExplicitRules) =
                           tl_ _tlOallTypeSigs _tlOallfields _tlOallnts _tlOaltAttrs _tlOattrs _tlOchildInhs _tlOchildNts _tlOcon _tlOinh _tlOinhsOfChildren _tlOmergeMap _tlOnt _tlOo_case _tlOo_cata _tlOo_dovisit _tlOo_newtypes _tlOo_rename _tlOo_sem _tlOo_sig _tlOo_wantvisit _tlOprefix _tlOsyn _tlOsynsOfChildren 
                   in  ( _lhsOdirectDep,_lhsOerrors,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinstDep,_lhsOinstVars,_lhsOlocVars,_lhsOnAutoRules,_lhsOnExplicitRules))) )
sem_Rules_Nil :: T_Rules 
sem_Rules_Nil  =
    (T_Rules (\ _lhsIallTypeSigs
                _lhsIallfields
                _lhsIallnts
                _lhsIaltAttrs
                _lhsIattrs
                _lhsIchildInhs
                _lhsIchildNts
                _lhsIcon
                _lhsIinh
                _lhsIinhsOfChildren
                _lhsImergeMap
                _lhsInt
                _lhsIo_case
                _lhsIo_cata
                _lhsIo_dovisit
                _lhsIo_newtypes
                _lhsIo_rename
                _lhsIo_sem
                _lhsIo_sig
                _lhsIo_wantvisit
                _lhsIprefix
                _lhsIsyn
                _lhsIsynsOfChildren ->
                  (let _lhsOdirectDep :: (Seq Edge)
                       _lhsOerrors :: (Seq Error)
                       _lhsOgathAltAttrs :: ([AltAttr])
                       _lhsOgathRules :: (Seq CRule)
                       _lhsOinstDep :: (Seq Edge)
                       _lhsOinstVars :: ([Identifier])
                       _lhsOlocVars :: ([Identifier])
                       _lhsOnAutoRules :: Int
                       _lhsOnExplicitRules :: Int
                       -- use rule "Order.ag"(line 269, column 33)
                       _lhsOdirectDep =
                           ({-# LINE 269 "Order.ag" #-}
                            Seq.empty
                            {-# LINE 5373 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 84, column 70)
                       _lhsOerrors =
                           ({-# LINE 84 "Order.ag" #-}
                            Seq.empty
                            {-# LINE 5379 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 170, column 68)
                       _lhsOgathAltAttrs =
                           ({-# LINE 170 "Order.ag" #-}
                            []
                            {-# LINE 5385 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 206, column 23)
                       _lhsOgathRules =
                           ({-# LINE 206 "Order.ag" #-}
                            Seq.empty
                            {-# LINE 5391 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 312, column 31)
                       _lhsOinstDep =
                           ({-# LINE 312 "Order.ag" #-}
                            Seq.empty
                            {-# LINE 5397 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 677, column 86)
                       _lhsOinstVars =
                           ({-# LINE 677 "Order.ag" #-}
                            []
                            {-# LINE 5403 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 677, column 48)
                       _lhsOlocVars =
                           ({-# LINE 677 "Order.ag" #-}
                            []
                            {-# LINE 5409 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 61, column 105)
                       _lhsOnAutoRules =
                           ({-# LINE 61 "Order.ag" #-}
                            0
                            {-# LINE 5415 "Order.hs" #-}
                            )
                       -- use rule "Order.ag"(line 61, column 105)
                       _lhsOnExplicitRules =
                           ({-# LINE 61 "Order.ag" #-}
                            0
                            {-# LINE 5421 "Order.hs" #-}
                            )
                   in  ( _lhsOdirectDep,_lhsOerrors,_lhsOgathAltAttrs,_lhsOgathRules,_lhsOinstDep,_lhsOinstVars,_lhsOlocVars,_lhsOnAutoRules,_lhsOnExplicitRules))) )
-- TypeSig -----------------------------------------------------
{-
   visit 0:
      chained attribute:
         typeSigs             : Map Identifier Type
   alternatives:
      alternative TypeSig:
         child name           : {Identifier}
         child tp             : {Type}
-}
-- cata
sem_TypeSig :: TypeSig  ->
               T_TypeSig 
sem_TypeSig (TypeSig _name _tp )  =
    (sem_TypeSig_TypeSig _name _tp )
-- semantic domain
newtype T_TypeSig  = T_TypeSig ((Map Identifier Type) ->
                                ( (Map Identifier Type)))
data Inh_TypeSig  = Inh_TypeSig {typeSigs_Inh_TypeSig :: !((Map Identifier Type))}
data Syn_TypeSig  = Syn_TypeSig {typeSigs_Syn_TypeSig :: !((Map Identifier Type))}
wrap_TypeSig :: T_TypeSig  ->
                Inh_TypeSig  ->
                Syn_TypeSig 
wrap_TypeSig (T_TypeSig sem ) (Inh_TypeSig _lhsItypeSigs )  =
    (let ( _lhsOtypeSigs) = sem _lhsItypeSigs 
     in  (Syn_TypeSig _lhsOtypeSigs ))
sem_TypeSig_TypeSig :: Identifier ->
                       Type ->
                       T_TypeSig 
sem_TypeSig_TypeSig name_ tp_  =
    (T_TypeSig (\ _lhsItypeSigs ->
                    (let _lhsOtypeSigs :: (Map Identifier Type)
                         -- "Order.ag"(line 531, column 13)
                         _lhsOtypeSigs =
                             ({-# LINE 531 "Order.ag" #-}
                              Map.insert name_ tp_ _lhsItypeSigs
                              {-# LINE 5460 "Order.hs" #-}
                              )
                     in  ( _lhsOtypeSigs))) )
-- TypeSigs ----------------------------------------------------
{-
   visit 0:
      chained attribute:
         typeSigs             : Map Identifier Type
   alternatives:
      alternative Cons:
         child hd             : TypeSig 
         child tl             : TypeSigs 
      alternative Nil:
-}
-- cata
sem_TypeSigs :: TypeSigs  ->
                T_TypeSigs 
sem_TypeSigs list  =
    (Prelude.foldr sem_TypeSigs_Cons sem_TypeSigs_Nil (Prelude.map sem_TypeSig list) )
-- semantic domain
newtype T_TypeSigs  = T_TypeSigs ((Map Identifier Type) ->
                                  ( (Map Identifier Type)))
data Inh_TypeSigs  = Inh_TypeSigs {typeSigs_Inh_TypeSigs :: !((Map Identifier Type))}
data Syn_TypeSigs  = Syn_TypeSigs {typeSigs_Syn_TypeSigs :: !((Map Identifier Type))}
wrap_TypeSigs :: T_TypeSigs  ->
                 Inh_TypeSigs  ->
                 Syn_TypeSigs 
wrap_TypeSigs (T_TypeSigs sem ) (Inh_TypeSigs _lhsItypeSigs )  =
    (let ( _lhsOtypeSigs) = sem _lhsItypeSigs 
     in  (Syn_TypeSigs _lhsOtypeSigs ))
sem_TypeSigs_Cons :: T_TypeSig  ->
                     T_TypeSigs  ->
                     T_TypeSigs 
sem_TypeSigs_Cons (T_TypeSig hd_ ) (T_TypeSigs tl_ )  =
    (T_TypeSigs (\ _lhsItypeSigs ->
                     (let _lhsOtypeSigs :: (Map Identifier Type)
                          _hdOtypeSigs :: (Map Identifier Type)
                          _tlOtypeSigs :: (Map Identifier Type)
                          _hdItypeSigs :: (Map Identifier Type)
                          _tlItypeSigs :: (Map Identifier Type)
                          -- copy rule (up)
                          _lhsOtypeSigs =
                              ({-# LINE 527 "Order.ag" #-}
                               _tlItypeSigs
                               {-# LINE 5504 "Order.hs" #-}
                               )
                          -- copy rule (down)
                          _hdOtypeSigs =
                              ({-# LINE 527 "Order.ag" #-}
                               _lhsItypeSigs
                               {-# LINE 5510 "Order.hs" #-}
                               )
                          -- copy rule (chain)
                          _tlOtypeSigs =
                              ({-# LINE 527 "Order.ag" #-}
                               _hdItypeSigs
                               {-# LINE 5516 "Order.hs" #-}
                               )
                          ( _hdItypeSigs) =
                              hd_ _hdOtypeSigs 
                          ( _tlItypeSigs) =
                              tl_ _tlOtypeSigs 
                      in  ( _lhsOtypeSigs))) )
sem_TypeSigs_Nil :: T_TypeSigs 
sem_TypeSigs_Nil  =
    (T_TypeSigs (\ _lhsItypeSigs ->
                     (let _lhsOtypeSigs :: (Map Identifier Type)
                          -- copy rule (chain)
                          _lhsOtypeSigs =
                              ({-# LINE 527 "Order.ag" #-}
                               _lhsItypeSigs
                               {-# LINE 5531 "Order.hs" #-}
                               )
                      in  ( _lhsOtypeSigs))) )