.\" $Id: ui.man,v 1.5 2002/10/30 19:40:26 bjk Exp $
.\"
.\" Copyright (C) 2001-2002  Ben Kibbey <bjk@arbornet.org>
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
.
.Dd January 15, 2006
.Os
.Dt UI 1
.
.Sh NAME
.
.Nm ui
.Nd show information about local users
.
.Sh SYNOPSIS
.
.Nm ui
.Op Fl hvVF
.Op Fl D Ar separator
.Op Fl j Ar format
.Ar options
.Ar user
|
.Fl f Ar filename
.Ar [...]
.
.Sh DESCRIPTION
.
.Nm ui
outputs as much information about a local user as possible. Multiple
usernames or filenames (see 
.Fl f )
may be specified. If no arguments are given or a username or filename is
.Sq \- ,
then arguments are read via standard input.
.
.Pp
The following command line options are divided into major modes. The
order of the major mode options
.Fl P , 
.Fl M ,
.Fl L
and 
.Fl A 
is specified at compile time and may be seen with
.Fl h .
Output options can be specified more than once but are only output once.
Options which are noted to use 
.Xr strftime 3
to format time values can specify an alternate format with the
.Fl j
option.
.
.Bl -tag -width
.It Fl A
Output all available information. This is the same as specifying all output
options or major modes
.Fl PML .
.It Fl j Ar format
Specify an alternate time format for time values. See the
.Xr strftime 3
manual page for 
.Ar format
syntax.
.It Fl D Ar separator
Alternate character used to separate fields. Standard escape sequences
are supported.
.It Fl f Ar filename
Get information for the owners of the specified files. This option must be the
last on the command line.
.It Fl F
If the
.Fl f
option is specified and the file is a symbolic link, get owner
information for the file the link points to and not the link itself.
.It Fl v
Output group names with group id's, and filenames.
.It Fl h
Show program help text.
.It Fl V
Version information.
.El
.
.Sh PASSWORD FILE OPTIONS
.
.Bl -tag -width
.It Fl P
Major mode option to output all available password and group information.
.It Fl l
Login name.
.It Fl p
Encrypted password (must be root).
.It Fl u
User ID (UID).
.It Fl g
Group ID (GID).
.It Fl c
The number of days until the user must change his password (must be root).
.It Fl k
The number of days until the users password expires (must be root).
.It Fl i Ar nowha
This option shows the gecos information from the 
.Xr passwd 5
file and needs one or more of the following sub-options: 
[n]ame, [o]ffice, [w]ork phone, [h]ome phone, [a]ll.
.It Fl d
Users home directory.
.It Fl s
Users shell.
.It Fl m
Users home directory permission mode in octal.
.El
.
.Sh MAIL OPTIONS
.
.Bl -tag -width
.It Fl M
Major mode option to output all available mail information.
.It Fl z
The size of the users mail spool file in bytes.
.It Fl w
Display the users mail spool last modification time in
.Xr strftime 3
format.
.It Fl r
Show the users mail spool file last access time in
.Xr strftime 3
format.
.It Fl o
Display any mail forwarding addresses for the user. This option tries to
open the
.Xr forward 5
file in the users home directory.
.It Fl a
Show any mail 
.Xr aliases 5
for the user.
.El
.
.Sh LOGIN OPTIONS
.
.Bl -tag -width
.It Fl L
Major mode option to output all available login information.
.It Fl C
Parent process ID (PPID). This will normally display the process id of the
login shell, but not always.
.It Fl b
If the user is logged in, the number of minutes since logged in.
.It Fl q
If the user is logged in, show how long a user has been idle (not doing
anything).
.It Fl e
Message status for user. This option checks to see if a users tty is group or
world writeable.
.It Fl y
If the user is logged in, the name of the tty issued.
.It Fl x
If the user is logged in, the users hostname or IP address.
.It Fl t
If the user is logged in, a 
.Xr strftime 3
time when logged in.
.It Fl n Ar yhta
This option reads the
.Xr lastlog 5
file to determine information about when the user was last logged in. This
option needs one or more of the following sub-options: 
tt[y], [h]ostname, [t]ime, [a]ll. Note that this never reads
.Xr wtmp 5 .
.El
.
.Sh RETURN VALUE
.
Returns 1 if passed a single or multiple arguments and a filename or user is
invalid, and 0 otherwise.
.
.Sh SEE ALSO
.
.Xr strftime 3 ,
.Xr passwd 5 ,
.Xr aliases 5 ,
.Xr forward 5 ,
.Xr utmp 5 ,
.Xr lastlog 5
.
.Sh BUGS
.
In an mail alias file, included files, subgroups and user@localhost aliases
aren't considered.
.
.Sh AUTHORS
.An "Ben Kibbey" Aq bjk@arbornet.org
