// ==UserScript==
// @include       http://apps.facebook.com/*/*
// @include       https://apps.facebook.com/*/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    if (!document.getElementById('pagelet_canvas_nav_content')) {
        return false;
    }
    return true;
}

function urlToAppName(url) {
    var tmp = 'apps.facebook.com/';
    tmp = url.substr(url.indexOf(tmp) + tmp.length);
    return tmp.substr(0, tmp.indexOf('/'));
}

function registerApp() {
    var i, appName = window.location.pathname;
    appName = appName.substr(1, appName.indexOf('/', 1) - 1);

    var snapshot = document.evaluate('//div[@id="pagelet_canvas_nav_content"]/div/div/table/tbody/tr/td/div/div[@class="bookmark"]/a',
                                     document, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);
    var name, img, printableName;
    for (i = 0; i < snapshot.snapshotLength; i++) {
        var node = snapshot.snapshotItem(i);
        name = urlToAppName(node.href);

        if (name === appName) {
            img = node.lastChild.src;
            printableName = node.getAttribute('data-appname');
            if (!img) {
                return false;
            } else {
                break;
            }
        }
    }

    if (img && printableName) {
        Unity.init({ name: printableName,
                     iconUrl: img,
		     crop: true,
                     domain: 'apps.facebook.com',
                     homepage: 'http://apps.facebook.com/' + appName + '/',
                     onInit: null });

        return true;
    }
    return false;
}

if (isCorrectPage()) {
    setTimeout(wrapCallback(function retry() {
        if (!registerApp()) {
            setTimeout(retry, 10000);
        }
    }), 1000);
}
