#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
Setup file to build the Lens & Scopes
"""

from distutils.core import setup
from DistUtilsExtra.command import *

setup(name="unity-lens-help",
      version="1.7",
      author="Mark Tully",
      author_email="markjtully@gmail.com",
      url="http://launchpad.net/askubuntu-lens/",
      license="GNU General Public License (GPL)",
      scripts=[
        'scopes/yelp/unity-lens-help-daemon',
        'scopes/askubuntu/unity-askubuntu-daemon',
        'scopes/manpages/unity-manpages-daemon',
        'scopes/sumo/unity-sumo-daemon',
        'scopes/asklibreoffice/unity-asklibreoffice-daemon',
      ],
      data_files=[
        ('/usr/share/unity/lenses/help', ['scopes/yelp/help.lens',
                                          'scopes/askubuntu/unity-scope-askubuntu.scope',
                                          'scopes/manpages/unity-scope-manpages.scope',
                                          'scopes/sumo/unity-scope-sumo.scope',
                                          'scopes/asklibreoffice/unity-scope-asklibreoffice.scope']),
        ('/usr/share/dbus-1/services', ['scopes/yelp/unity-lens-help.service',
                                   'scopes/askubuntu/unity-scope-askubuntu.service',
                                   'scopes/manpages/unity-scope-manpages.service',
                                   'scopes/sumo/unity-scope-sumo.service',
                                   'scopes/asklibreoffice/unity-scope-asklibreoffice.service']),
        ('/usr/lib/unity-lens-help', ['scopes/askubuntu/askubuntu_bridge.py']),
        ('/usr/lib/unity-lens-help/icons', ['icons/askubuntu-logo.svg',
                                            'icons/help-question.svg',
                                            'icons/help-answer.svg',
                                            'icons/askubuntu-question-coloured.svg',
                                            'icons/askubuntu-unsolved-coloured.svg',
                                            'icons/askubuntu-answer-coloured.svg', ]),
      ],
      cmdclass={"build": build_extra.build_extra, 
                "build_i18n": build_i18n.build_i18n,}
)
